package br.com.centralit.citsmart.rest.operation;

import javax.xml.bind.JAXBException;

import br.com.centralit.citcorpore.negocio.SolicitacaoServicoService;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citsmart.rest.bean.RestOperationDTO;
import br.com.centralit.citsmart.rest.bean.RestSessionDTO;
import br.com.centralit.citsmart.rest.schema.ObterCPF;
import br.com.centralit.citsmart.rest.schema.ObterCPFResp;
import br.com.centralit.citsmart.rest.util.RestBICitsmartOperationUtil;
import br.com.centralit.citsmart.rest.util.RestEnum;
import br.com.centralit.citsmart.rest.util.RestUtil;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;

/**
 * Responsvel por Executar as Operaes da Classe RestBICitsmartResource.
 *
 * @author gilberto.nery
 * @since 07.06.2016
 */
public class RestCitsmartTelefonia implements IRestOperation<ObterCPF, ObterCPFResp> {

	private SolicitacaoServicoService solicitacaoServicoService; 
	
    @Override
    public ObterCPFResp execute(final RestSessionDTO session, final RestOperationDTO operation, final ObterCPF message) throws JAXBException {

    	String locale = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.IDIOMAPADRAO, "en");
    	
    	final ObterCPFResp resp = new ObterCPFResp();

        if (session.getUser() == null || session.getUser().getLogin() == null || session.getUser().getLogin().trim().equals("")) {
            resp.setError(RestBICitsmartOperationUtil.buildError(RestEnum.INPUT_ERROR, UtilI18N.internacionaliza(locale, "rest.service.mobile.login.not.identified")));
            return resp;
        }

        try {
        	
        	resp.setQtdSolicitacoes(getSolicitacaoServicoService(session).getQtdSolicitacoesEmAndamentoPorCpf(message.getCpf()));
        	resp.setCpf(message.getCpf());
        	
            return resp;
        } catch (final Exception e) {
            e.printStackTrace();
        }
        
        return new ObterCPFResp();
    }
    
    private SolicitacaoServicoService getSolicitacaoServicoService(final RestSessionDTO restSession) throws Exception {
        if (solicitacaoServicoService == null) {
			solicitacaoServicoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, RestUtil.getUsuarioSistema(restSession));
        }
        return solicitacaoServicoService;
    }
    
}