package br.com.centralit.citsmart.rest.resource;

import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBException;

import br.com.centralit.citajax.framework.AjaxReverse;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.negocio.SolicitacaoServicoService;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.ServiceRequestStatus;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;

@Path("/services")
public class RestTelefoniaResources {

	private SolicitacaoServicoService solicitacaoServicoService;

    @Context
    protected HttpServletRequest httpRequest;

    private SolicitacaoServicoService getSolicitacaoServicoService() throws Exception {
        if (solicitacaoServicoService == null) {
			solicitacaoServicoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, null);
        }
        return solicitacaoServicoService;
    }

    @POST
    @Path("/obterQtdeSolicitacoes")
    @Produces({MediaType.TEXT_PLAIN})
    public String obterQtdeSolicitacoes(@QueryParam("cpf") String cpf) throws JAXBException {
    	if(ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.ATIVAR_WEBSERVICE_TELEFONIA, "N").equalsIgnoreCase("N")){
    		return "";
    	}
    	try {
	    	if(cpf == null || cpf.trim().length() <= 0){
	    		return "";
	    	}
	    	Long qtdeSolicitacoes = getSolicitacaoServicoService().getQtdSolicitacoesEmAndamentoPorCpf(cpf);
	    	String retorno = null;
	    	if (qtdeSolicitacoes!=null) {
	    		if (qtdeSolicitacoes.longValue()==1L){
	    			ArrayList<SolicitacaoServicoDTO> listaSolicitacoes = getSolicitacaoServicoService().obterSolicitacoesDeServicoEmAndamentoPorCpf(cpf);
	    			if (listaSolicitacoes!=null&&listaSolicitacoes.size()>0){
	    				retorno = qtdeSolicitacoes.toString()+"?"+listaSolicitacoes.get(0).getIdSolicitacaoServico();
	    			} else {
	    				retorno = qtdeSolicitacoes.toString();
	    			}
	    		} else {
	    			retorno = qtdeSolicitacoes.toString();
	    		}
	    	}
        	return retorno;
        } catch (final Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @POST
    @Path("/obterDadosSolicitacao")
    @Produces({MediaType.TEXT_PLAIN})
    public String obterDadosSolicitacao(@QueryParam("idsolicitacaoservico") Integer idSolicitacaoServico, @QueryParam("cpf") String cpf) throws JAXBException {

    	if(ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.ATIVAR_WEBSERVICE_TELEFONIA, "N").equalsIgnoreCase("N")){
    		return null;
    	}

    	try {

    		String locale = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.IDIOMAPADRAO, "en");
	    	if(idSolicitacaoServico == null){
	    		return UtilI18N.internacionaliza(locale, "");
	    	}
        	SolicitacaoServicoDTO solicitacaoDto = getSolicitacaoServicoService().getSolicitacaoDeServicoEmAndamentoPorCpf(idSolicitacaoServico, cpf);
        	solicitacaoDto = getSolicitacaoServicoService().verificaSituacaoSLA(solicitacaoDto);

        	if (solicitacaoDto!=null){
        		StringBuilder response = new StringBuilder();
        		response.append("idsolicitacaoservico:").append(solicitacaoDto.getIdSolicitacaoServico()).append("?");
        		response.append("datahorasolicitacao:").append(solicitacaoDto.obterDataHoraSolicitacaoStrWithLanguage(locale)).append("?");

        		response.append("datahoralimite:").append(solicitacaoDto.getPrazoHH() != null && solicitacaoDto.getPrazoHH().equals(0) &&
        				solicitacaoDto.getPrazoMM().equals(0) && solicitacaoDto.getPrazoMM() != null ? "" : solicitacaoDto.obterDataHoraLimiteStrWithLanguage(locale)
        				).append("?");

				response.append("situacao:").append(UtilI18N.internacionaliza(locale, ServiceRequestStatus.getChaveFromId(solicitacaoDto.getIdStatus()))).append("?");
				response.append("prazosla:").append(solicitacaoDto.getAtrasoSLA() > 0 && !ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoDto.getIdStatus()) ? 
        				UtilI18N.internacionaliza(locale, "solicitacaoservico.prazovencido") : UtilI18N.internacionaliza(locale, "painel.noPrazo"));

        		return response.toString();
        	}

        } catch (final Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    @POST
    @Path("/novaSolicitacao")
    @Produces({MediaType.TEXT_PLAIN})
    public void novaSolicitacao(@QueryParam("cpf") String cpf, @QueryParam("ramal") String ramal) throws JAXBException {

    	if(ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.ATIVAR_WEBSERVICE_TELEFONIA, "N").equalsIgnoreCase("N")){
    		return;
    	}

    	try {

    		if(cpf == null || cpf.trim().length() <= 0 || ramal == null || ramal.trim().length() <= 0){
	    		return ;
	    	}

    		AjaxReverse.executarAjaxReverseWithAllSessions("wsExibirNovaSolicitacao",cpf,ramal);

        } catch (final Exception e) {
            e.printStackTrace();
        }
    }

    @POST
    @Path("/visualizarSolicitacao")
    @Produces({MediaType.TEXT_PLAIN})
    public void visualizarSolicitacao(@QueryParam("idsolicitacaoservico") Integer idSolicitacaoServico, @QueryParam("ramal") String ramal) throws JAXBException {

    	if(ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.ATIVAR_WEBSERVICE_TELEFONIA, "N").equalsIgnoreCase("N")){
    		return;
    	}

    	try {

    		if(idSolicitacaoServico == null || idSolicitacaoServico <= 0 || ramal == null || ramal.trim().length() <= 0){
	    		return ;
	    	}

    		// Chama a visualizacao da solicitacao
    		AjaxReverse.executarAjaxReverseWithAllSessions("wsVisualizarSolicitacao",idSolicitacaoServico,ramal);

        } catch (final Exception e) {
            e.printStackTrace();
        }
    }
}