/*****************************************************************************
 * Services.java -
 *
 * Copyright (c) 2014 Projeto citsmart (Contact: adenir.gomes@centralit.com.br)
 *
 * License:
 *****************************************************************************/
package br.com.centralit.citsmart.rest.schema;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Class Services is the main class for obtain all columns of table "services"
 * from a Livestatus TCP-socket/file status.dat.
 *
 * @author Adenir Ribeiro Gomes
 */

public class Event {

    /**
     * An optional display name (not used by Nagios standard web pages)
     *
     */
    @JsonProperty
    public String display_name;

    /**
     * Whether the service already has been checked (0/1)
     *
     */
    @JsonProperty
    public int has_been_checked;

    /**
     * Optional notes about the service
     *
     */
    @JsonProperty
    public String notes;

    /**
     * The current state of the service (0: OK, 1: WARN, 2: CRITICAL, 3:
     * UNKNOWN)
     *
     */
    @JsonProperty
    public int state;

    @Override
    public String toString() {
        return "Display_name = " + display_name + "\n" + "has_been_checked = " + has_been_checked + "\n" + "notes = " + notes + "\n" + "state = " + state;
    }

}
