package br.com.centralit.citsmart.rest.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

import br.com.citframework.excecao.LogicException;


/**
 * Classe utilitaria para realizar conexo com o mongodb.
 * 
 * @author rodrigo.acorse
 *
 */
public class RestConnection {
	private String user;
	private String password;
	private String url;
	private String requestMethod;
	private String contentType;
	private String data;

	/**
	 * Envia a requisio utilizando os parmetros setados.
	 * 
	 * @param user
	 * @param password
	 * @param url
	 * @param requestMethod
	 * @param contentType
	 * @param data
	 * @return String
	 * @throws LogicException
	 */
	public String send(String user, String password, String url, String requestMethod, String contentType, String data) throws LogicException {
		this.setUser(user);
		this.setPassword(password);
		this.setUrl(url);
		this.setRequestMethod(requestMethod);
		this.setContentType(contentType);
		this.setData(data);

		return send();
	}

	@SuppressWarnings("restriction")
	public String send() throws LogicException {
		if (getUrl() == null || getRequestMethod() == null || getContentType() == null) {
			throw new LogicException("Citsmart > (RestConnection) Informe todos os parametros antes de enviar a requisicao.");
		}

		URL url;
		try {
			url = new URL(getUrl());
		} catch (MalformedURLException e) {
			throw new LogicException("Citsmart > (RestConnection) Nao foi possivel formar a URL de conexao.");
		}

		HttpURLConnection connection;
		try {
			connection = (HttpURLConnection) url.openConnection();

			if (getUser() != null && getPassword() != null) {
				String params = getUser() + ":" + getPassword();
				connection.setRequestProperty("Authorization", "Basic " + new sun.misc.BASE64Encoder().encode(params.getBytes()));
			}

			connection.setRequestMethod(getRequestMethod());
			connection.setRequestProperty("Content-Type", getContentType());

			connection.setDoOutput(true);
			connection.setInstanceFollowRedirects(false);

			if (getData() != null) {
				OutputStream os = connection.getOutputStream();
				os.write(getData().getBytes());
				os.flush();
			}

			String result = "";
			String output;
			BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));

			while ((output = br.readLine()) != null) {
				result += output;
			}

			connection.disconnect();

			return result;
		} catch (IOException e) {
			throw new LogicException("Citsmart > (RestConnection) Nao foi possivel abrir a conexao.");
		}
	}

	public String getUser() {
		return user;
	}

	public void setUser(String user) {
		this.user = user;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getRequestMethod() {
		return requestMethod;
	}

	public void setRequestMethod(String requestMethod) {
		this.requestMethod = requestMethod;
	}

	public String getContentType() {
		return contentType;
	}

	public void setContentType(String contentType) {
		this.contentType = contentType;
	}

	public String getData() {
		return data;
	}

	public void setData(String data) {
		this.data = data;
	}

}
