package br.com.centralit.citsmart.rest.v2.resource;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.json.JSONArray;
import org.json.JSONObject;

import br.com.centralit.bpm.dto.ItemTrabalhoFluxoDTO;
import br.com.centralit.bpm.integracao.ItemTrabalhoFluxoDao;
import br.com.centralit.bpm.negocio.ItemTrabalho;
import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.centralit.citcorpore.bean.ExecucaoSolicitacaoDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.JustificativaSolicitacaoDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoEquipeMobileDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.integracao.ExecucaoSolicitacaoDao;
import br.com.centralit.citcorpore.negocio.EmpregadoService;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.JustificativaSolicitacaoService;
import br.com.centralit.citcorpore.negocio.SolicitacaoEquipeMobileService;
import br.com.centralit.citcorpore.negocio.SolicitacaoServicoService;
import br.com.centralit.citcorpore.util.Enumerados.ServiceRequestStatus;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citsmart.rest.bean.RestSessionDTO;
import br.com.centralit.citsmart.rest.resource.RestMobileResources;
import br.com.centralit.citsmart.rest.schema.CtAtribuicaoEquipeSolicitacao;
import br.com.centralit.citsmart.rest.schema.CtAtribuicoesEquipesSolicitacoes;
import br.com.centralit.citsmart.rest.schema.CtAtualizaInformacoesSolicitacoesResp;
import br.com.centralit.citsmart.rest.schema.CtError;
import br.com.centralit.citsmart.rest.schema.CtGetGruposLiderados;
import br.com.centralit.citsmart.rest.schema.CtInformacaoSolicitacao;
import br.com.centralit.citsmart.rest.schema.CtInformacoesSolicitacoes;
import br.com.centralit.citsmart.rest.schema.CtNotificationGetById;
import br.com.centralit.citsmart.rest.schema.CtNotificationGetByUser;
import br.com.centralit.citsmart.rest.schema.CtNotificationGetColaborador;
import br.com.centralit.citsmart.rest.schema.CtNotificationGetEquipeColaborador;
import br.com.centralit.citsmart.rest.util.RestEnum;
import br.com.centralit.citsmart.rest.util.RestOperationUtil;
import br.com.centralit.citsmart.rest.util.RestUtil;
import br.com.centralit.citsmart.rest.v2.schema.CTNotificationAttendRequest;
import br.com.centralit.citsmart.rest.v2.schema.CTNotificationAttendantLocation;
import br.com.centralit.citsmart.rest.v2.schema.CTNotificationBuscaSolicitacao;
import br.com.centralit.citsmart.rest.v2.schema.CTNotificationCheckin;
import br.com.centralit.citsmart.rest.v2.schema.CTNotificationCheckinDenied;
import br.com.centralit.citsmart.rest.v2.schema.CTNotificationCheckout;
import br.com.centralit.citsmart.rest.v2.schema.CTNotificationGetByCoordinates;
import br.com.centralit.citsmart.rest.v2.schema.CTNotificationGetNewest;
import br.com.centralit.citsmart.rest.v2.schema.CTNotificationGetOldest;
import br.com.centralit.citsmart.rest.v2.schema.CTNotificationUpdate;
import br.com.centralit.citsmart.rest.v2.util.RESTOperations;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;

/**
 * Endpoints REST da verso V2 dos servios oferecidos ao Mobile
 *
 * @author bruno.ribeiro -
 *         <a href="mailto:bruno.ribeiro@centrait.com.br">bruno.ribeiro@centrait
 *         .com.br</a>
 * @since 22/09/2014
 *
 */
@Path("/mobile/v2/notification")
public class RESTMobileResources extends RestMobileResources {

	private static final Logger LOGGER = Logger.getLogger(RESTMobileResources.class.getName());

	private final String CALL_MESSAGE = "Service handling at '%s' called with parameters '%s'";

	private static final String ATTENDREQUEST = "/attendRequest";
	private static final String ATTENDANTLOCATION = "/location";
	private static final String CHECKIN = "/checkin";
	private static final String CHECKINDENIED = CHECKIN + "/denied";
	private static final String CHECKOUT = "/checkout";
	private static final String GETBYCOORDINATES = "/getByCoordinates";
	private static final String GETNEWEST = "/getNewest";
	private static final String GETGRUPOSLIDERADOS = "/getGruposLiderados";
	private static final String GETCOLABORADOR = "/getColaborador";
	private static final String GETEQUIPECOLABORADOR = "/getEquipeColaborador";
	private static final String GETOLDEST = "/getOldest";
	private static final String UPDATENOTIFICATION = "/update";
    private static final String BUSCA_SOLICITACAO = "/buscaSolicitacao";
	private static final String ATUALIZAINFORMACOESSOLICITACOES = "/atualizaInformacoesSolicitacoes";
	private static final String ATRIBUICOESEQUIPESSOLICITACOES = "/atribuicoesEquipesSolicitacoes";
	private static final String GETJUSTIFICATIVAS = "/getJustificativas";

	@Context
	private HttpServletRequest request;

	@POST
	@Path(ATTENDANTLOCATION)
	public Response attendantLocation(final CTNotificationAttendantLocation input) {
		LOGGER.log(Level.FINE, String.format(CALL_MESSAGE, ATTENDANTLOCATION, ReflectionToStringBuilder.toString(input)));
		input.setMessageID(RESTOperations.ATTENDANT_LOCATION.getMessageID());
		return RestOperationUtil.execute(input);
	}

	@POST
	@Path(ATTENDREQUEST)
	public Response attendRequest(final CTNotificationAttendRequest input) {
		LOGGER.log(Level.FINE, String.format(CALL_MESSAGE, ATTENDREQUEST, ReflectionToStringBuilder.toString(input)));
		input.setMessageID(RESTOperations.ATTEND_REQUEST.getMessageID());
		return RestOperationUtil.execute(input);
	}

	@POST
	@Path(CHECKIN)
	public Response checkin(final CTNotificationCheckin input) {
		LOGGER.log(Level.FINE, String.format(CALL_MESSAGE, CHECKIN, ReflectionToStringBuilder.toString(input)));
		input.setMessageID(RESTOperations.CHECK_IN.getMessageID());
		return RestOperationUtil.execute(input);
	}

	@POST
	@Path(CHECKINDENIED)
	public Response checkinDenied(final CTNotificationCheckinDenied input) {
		LOGGER.log(Level.FINE, String.format(CALL_MESSAGE, CHECKINDENIED, ReflectionToStringBuilder.toString(input)));
		input.setMessageID(RESTOperations.CHECK_IN_DENIED.getMessageID());
		return RestOperationUtil.execute(input);
	}

	@POST
	@Path(CHECKOUT)
	public Response checkout(final CTNotificationCheckout input) {
		LOGGER.log(Level.FINE, String.format(CALL_MESSAGE, CHECKOUT, ReflectionToStringBuilder.toString(input)));
		input.setMessageID(RESTOperations.CHECK_OUT.getMessageID());
		return RestOperationUtil.execute(input);
	}

	@POST
	@Path(GETBYCOORDINATES)
	public Response getByCoordinates(final CTNotificationGetByCoordinates input) {
		LOGGER.log(Level.FINE, String.format(CALL_MESSAGE, GETBYCOORDINATES, ReflectionToStringBuilder.toString(input)));
		input.setMessageID(RESTOperations.GET_BY_COORDINATES.getMessageID());
		return RestOperationUtil.execute(input);
	}

	@Override
	@POST
	@Path(GETBYID)
	public Response getNotificationById(final CtNotificationGetById input) {
		LOGGER.log(Level.FINE, String.format(CALL_MESSAGE, GETBYID, ReflectionToStringBuilder.toString(input)));
		input.setMessageID(RESTOperations.GET_BY_ID_V2.getMessageID());
		return RestOperationUtil.execute(input);
	}

	@POST
	@Override
	@Path(GETBYUSER)
	public Response getNotificationByUser(final CtNotificationGetByUser input) {
		LOGGER.log(Level.FINE, String.format(CALL_MESSAGE, GETBYUSER, ReflectionToStringBuilder.toString(input)));
		input.setMessageID(RESTOperations.GET_BY_USER.getMessageID());
		return RestOperationUtil.execute(input);
	}

	@POST
	@Path(GETNEWEST)
	public Response getNewest(final CTNotificationGetNewest input) {
		LOGGER.log(Level.FINE, String.format(CALL_MESSAGE, GETNEWEST, ReflectionToStringBuilder.toString(input)));
		input.setMessageID(RESTOperations.GET_NEWEST.getMessageID());
		return RestOperationUtil.execute(input);
	}

	@POST
	@Path(GETGRUPOSLIDERADOS)
	@Produces(MediaType.APPLICATION_JSON)
	public Response getGruposLiderados(final CtGetGruposLiderados input) {
		Collection<GrupoDTO> grupos = null;
		JSONObject jsonPrincipal = new JSONObject();
		try {
			GrupoService grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);

			final RestSessionDTO restSession = RestUtil.getRestSessionService(null).getSession(input.getSessionID());
			if (restSession.getUser() != null && restSession.getUser().getIdEmpregado() != null) {
				grupos = grupoService.getGruposByLiderEmpregado(restSession.getUser().getIdEmpregado());

			}

			JSONArray jsonGrupos = new JSONArray();

			if (grupos != null && !grupos.isEmpty()) {
				for (GrupoDTO grupo : grupos) {
					JSONObject jsonGrupo = new JSONObject();

					jsonGrupo.put("id", grupo.getIdGrupo().toString());
					jsonGrupo.put("nomeEquipe", grupo.getNome());

					jsonGrupos.put(jsonGrupo);
				}
			}
			jsonPrincipal.put("equipe", jsonGrupos);

		} catch (Exception e) {

		}
		return Response.status(Status.OK).entity(jsonPrincipal.toString()).build();
	}

	@POST
	@Path(GETCOLABORADOR)
	@Produces(MediaType.APPLICATION_JSON)
	public Response getColaborador(final CtNotificationGetColaborador input) {
		LOGGER.log(Level.FINE, String.format(CALL_MESSAGE, GETCOLABORADOR, ReflectionToStringBuilder.toString(input)));
		input.setMessageID(input.getMessageID());

		JSONObject jsonPrincipal = new JSONObject();
		try {
			EmpregadoService empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);
			Collection<EmpregadoDTO> empregados = empregadoService.listEmpregadosAtivos();

			JSONArray jsonEmpregados = new JSONArray();

			if (empregados != null && !empregados.isEmpty()) {
				for (EmpregadoDTO empregado : empregados) {
					JSONObject jsonEmpregado = new JSONObject();

					jsonEmpregado.put("id", empregado.getIdEmpregado().toString());
					jsonEmpregado.put("nomeColaborador", empregado.getNome());

					jsonEmpregados.put(jsonEmpregado);
				}
			}
			jsonPrincipal.put("colaborador", jsonEmpregados);

		} catch (Exception e) {

		}

		return Response.status(Status.OK).entity(jsonPrincipal.toString()).build();
	}

	@POST
	@Path(GETEQUIPECOLABORADOR)
	@Produces(MediaType.APPLICATION_JSON)
	public Response getEquipeColaborador(final CtNotificationGetEquipeColaborador input) {
		Collection<GrupoDTO> grupos = null;
		JSONObject jsonPrincipal = new JSONObject();
		try {
			GrupoService grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
			EmpregadoService empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);

			final RestSessionDTO restSession = RestUtil.getRestSessionService(null).getSession(input.getSessionID());
			if (restSession.getUser() != null && restSession.getUser().getIdEmpregado() != null) {
				grupos = grupoService.getGruposByLiderEmpregado(restSession.getUser().getIdEmpregado());

			}

			JSONArray jsonGrupos = new JSONArray();

			if (grupos != null && !grupos.isEmpty()) {
				for (GrupoDTO grupo : grupos) {
					JSONObject jsonGrupo = new JSONObject();

					jsonGrupo.put("idEquipe", grupo.getIdGrupo());
					JSONArray jsonIdEmpregados = new JSONArray();
					Collection<EmpregadoDTO> empregados = empregadoService.listEmpregadosGrupo(grupo.getIdGrupo());
					if (empregados != null && !empregados.isEmpty()) {
						for (EmpregadoDTO empregado : empregados) {
							jsonIdEmpregados.put(empregado.getIdEmpregado());
						}
					}

					jsonGrupo.put("idsColaboradores", jsonIdEmpregados);
					jsonGrupo.put("sePadrao", true);

					jsonGrupos.put(jsonGrupo);
				}
			}
			jsonPrincipal.put("equipeColaborador", jsonGrupos);

		} catch (Exception e) {

		}

		return Response.status(Status.OK).entity(jsonPrincipal.toString()).build();
	}

	@POST
	@Path(GETOLDEST)
	public Response getOldest(final CTNotificationGetOldest input) {
		LOGGER.log(Level.FINE, String.format(CALL_MESSAGE, GETOLDEST, ReflectionToStringBuilder.toString(input)));
		input.setMessageID(RESTOperations.GET_OLDEST.getMessageID());
		return RestOperationUtil.execute(input);
	}

	@POST
	@Path(UPDATENOTIFICATION)
	public Response updateNotification(final CTNotificationUpdate input) {
		LOGGER.log(Level.FINE, String.format(CALL_MESSAGE, UPDATENOTIFICATION, ReflectionToStringBuilder.toString(input)));
		input.setMessageID(RESTOperations.UPDATE_NOTIFCATION.getMessageID());
		return RestOperationUtil.execute(input);
	}

	@GET
	@Path(GETJUSTIFICATIVAS)
	public Response getJustificativas() {
		Collection<JustificativaSolicitacaoDTO> justificativas = null;
		try {
			final JustificativaSolicitacaoService justificativaSolicitacaoService = (JustificativaSolicitacaoService) ServiceLocator.getInstance().getService(JustificativaSolicitacaoService.class,
					null);

			justificativas = justificativaSolicitacaoService.listAtivasParaSuspensao();

		} catch (Exception e) {
			e.printStackTrace();
		}
		return Response.status(Status.OK).entity(justificativas).build();
	}

	@POST
	@Path(ATUALIZAINFORMACOESSOLICITACOES)
	public Response atualizaInformacoesSolicitacoes(final CtInformacoesSolicitacoes input) {
		final CtAtualizaInformacoesSolicitacoesResp resp = new CtAtualizaInformacoesSolicitacoesResp();
		final RestSessionDTO restSession = RestUtil.getRestSessionService(null).getSession(input.getSessionID());
		SolicitacaoServicoDTO solicitacao = null;

		if (!RestUtil.isValidSession(restSession)) {
			final CtError error = RestOperationUtil.buildError(RestEnum.SESSION_ERROR, restSession != null && restSession.getUser() != null && restSession.getUser().getLocale() != null ? RestUtil.i18nMessage(restSession, "rest.service.sessaoNaoExisteOuExpirada") : "Session does not exist or is expired");
			resp.setError(error);
			return Response.status(Status.PRECONDITION_FAILED).entity(resp).build();
		}

		try {

			final SolicitacaoServicoService solicitacaoServicoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class,
					RestUtil.getUsuarioSistema(restSession));

			for (CtInformacaoSolicitacao informacaoSolicitacao : input.getResult()) {

				// INICIO - DEFINIR A DATA E HORA REAL DA OCORRENCIA, E NAO A HORA DA SINCRONIZACAO.
				// informacaoSolicitacao.getDataInicial() precisa estar no padrao: dd/MM/yyyy HH:mm:ss
				UtilDatas.setDataHoraDefinidaManualmente(UtilDatas.convertStringToDate(TipoDate.TIMESTAMP_WITH_SECONDS, informacaoSolicitacao.getDataInicial(), UtilI18N.getLocale()));
				// FIM

				solicitacao = solicitacaoServicoService.restoreAll(informacaoSolicitacao.getIdSolicitacao());

				if (solicitacao == null) {
					resp.setError(RestOperationUtil.buildError(RestEnum.INPUT_ERROR, RestUtil.i18nMessage(restSession, "rest.service.mobile.service.solicitation.notfound")));
				}

				if (informacaoSolicitacao.getFaseAtual() != null) {
					if (informacaoSolicitacao.getFaseAtual().equals("Suspensa")) {
						solicitacao.setIdJustificativa(informacaoSolicitacao.getIdJustificativa());
						solicitacao.setComplementoJustificativa(informacaoSolicitacao.getComplementoJustificativa());
						solicitacaoServicoService.suspende(restSession.getUser(), solicitacao);
					} else if (informacaoSolicitacao.getFaseAtual().equals("Reativada")) {
						solicitacaoServicoService.reativa(restSession.getUser(), solicitacao);
					} else if (!informacaoSolicitacao.getFaseAtual().equals(informacaoSolicitacao.getStatusAnterior())) {
						solicitacao.setAcaoFluxo(br.com.centralit.bpm.util.Enumerated.ACTION_EXECUTE);
						if (informacaoSolicitacao.getFaseAtual().equals("Fechada")) {
							solicitacao.setIdStatus(ServiceRequestStatus.SOLVED.getId());
							if (informacaoSolicitacao.getProdutividade() != null) {
								solicitacao.setResposta("Finalizao pelo mobile: Produtividade: " + informacaoSolicitacao.getProdutividade());
							}
						}

						Collection<ExecucaoSolicitacaoDTO> colExecucao = new ExecucaoSolicitacaoDao().listByIdSolicitacao(informacaoSolicitacao.getIdSolicitacao());
						if (colExecucao != null) {
							for (ExecucaoSolicitacaoDTO execucaoSolicitacaoDto : colExecucao) {
								execucaoSolicitacaoDto.getIdInstanciaFluxo();
								ItemTrabalhoFluxoDao itemTrabalhoFluxoDao = new ItemTrabalhoFluxoDao();
								Collection<ItemTrabalhoFluxoDTO> colItens = itemTrabalhoFluxoDao.findDisponiveisByIdInstancia(execucaoSolicitacaoDto.getIdInstanciaFluxo());
								if (colItens != null) {
									for (ItemTrabalhoFluxoDTO itemTrabalhoFluxoDto : colItens) {
										ItemTrabalho itemTrabalho = ItemTrabalho.getItemTrabalho(itemTrabalhoFluxoDto.getIdItemTrabalho());
										solicitacao.setIdTarefa(itemTrabalho.getIdItemTrabalho());
									}
								}
							}
						}

						solicitacao.setUsuarioDto(restSession.getUser());
						solicitacao = (SolicitacaoServicoDTO) solicitacaoServicoService.updateInfo(solicitacao);
					}
				}

			}

		} catch (final Exception e) {
			LOGGER.log(Level.WARNING, e.getMessage(), e);
			resp.setError(RestOperationUtil.buildError(e));
		} finally {
			// INICIO - DEFINIR A DATA E HORA REAL DA OCORRENCIA, E NAO A HORA DA SINCRONIZACAO.
			UtilDatas.setDataHoraDefinidaManualmente(null);
			// FIM
		}

		return Response.status(Status.OK).entity(true).build();
	}

	@POST
	@Path(ATRIBUICOESEQUIPESSOLICITACOES)
	public Response atribuicoesEquipesSolicitacoes(final CtAtribuicoesEquipesSolicitacoes input) {
		final CtAtualizaInformacoesSolicitacoesResp resp = new CtAtualizaInformacoesSolicitacoesResp();
		final RestSessionDTO restSession = RestUtil.getRestSessionService(null).getSession(input.getSessionID());

		if (!RestUtil.isValidSession(restSession)) {
			final CtError error = RestOperationUtil.buildError(RestEnum.SESSION_ERROR, restSession != null && restSession.getUser() != null && restSession.getUser().getLocale() != null ? RestUtil.i18nMessage(restSession, "rest.service.sessaoNaoExisteOuExpirada") : "Session does not exist or is expired");
			resp.setError(error);
			return Response.status(Status.PRECONDITION_FAILED).entity(resp).build();
		}

		try {

			final SolicitacaoEquipeMobileService solicitacaoEquipeMobileService = (SolicitacaoEquipeMobileService) ServiceLocator.getInstance().getService(SolicitacaoEquipeMobileService.class,
					RestUtil.getUsuarioSistema(restSession));

			for (CtAtribuicaoEquipeSolicitacao atribuicaoEquipeSolicitacao : input.getResult()) {
				if (atribuicaoEquipeSolicitacao != null && atribuicaoEquipeSolicitacao.getIdEquipe() != null && atribuicaoEquipeSolicitacao.getIdSolicitacao() != null) {

					SolicitacaoEquipeMobileDTO solicitacaoEquipeMobileDTO = solicitacaoEquipeMobileService.buscaAtribuicaoPorIdSolicitacao(atribuicaoEquipeSolicitacao.getIdSolicitacao());

					if (solicitacaoEquipeMobileDTO != null && solicitacaoEquipeMobileDTO.getIdSolicitacaoEquipeMobile() != null
							&& solicitacaoEquipeMobileDTO.getIdSolicitacaoEquipeMobile().intValue() > 0) {
						solicitacaoEquipeMobileDTO.setIdEquipe(atribuicaoEquipeSolicitacao.getIdEquipe());
						solicitacaoEquipeMobileService.update(solicitacaoEquipeMobileDTO);
					} else {
						solicitacaoEquipeMobileDTO = new SolicitacaoEquipeMobileDTO();
						solicitacaoEquipeMobileDTO.setIdEquipe(atribuicaoEquipeSolicitacao.getIdEquipe());
						solicitacaoEquipeMobileDTO.setIdSolicitacao(atribuicaoEquipeSolicitacao.getIdSolicitacao());
						solicitacaoEquipeMobileService.create(solicitacaoEquipeMobileDTO);
					}
				}
			}

		} catch (final Exception e) {
			LOGGER.log(Level.WARNING, e.getMessage(), e);
			resp.setError(RestOperationUtil.buildError(e));
		}

		return Response.status(Status.OK).entity(true).build();
	}

	@POST
	@Path(BUSCA_SOLICITACAO)
	public Response buscaSolicitacao(final CTNotificationBuscaSolicitacao input) {
		LOGGER.log(Level.FINE, String.format(CALL_MESSAGE, BUSCA_SOLICITACAO, ReflectionToStringBuilder.toString(input)));
		input.setMessageID(RESTOperations.BUSCA_SOLICITACAO.getMessageID());
		return RestOperationUtil.execute(input);
	}

}
