package br.com.centralit.citsmart.rest.v3.operation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.bind.JAXBException;

import br.com.centralit.citsmart.rest.bean.RestDomainDTO;
import br.com.centralit.citsmart.rest.bean.RestOperationDTO;
import br.com.centralit.citsmart.rest.bean.RestSessionDTO;
import br.com.centralit.citsmart.rest.operation.IRestOperation;
import br.com.centralit.citsmart.rest.schema.CtMessage;
import br.com.centralit.citsmart.rest.schema.CtMessageResp;
import br.com.centralit.citsmart.rest.util.RestEnum;
import br.com.centralit.citsmart.rest.util.RestOperationUtil;
import br.com.centralit.citsmart.rest.util.RestUtil;
import br.com.centralit.citsmart.rest.v3.schema.CtDataQuery;
import br.com.centralit.citsmart.rest.v3.schema.CtDataQueryResp;
import br.com.centralit.citsmart.rest.v3.util.DataQueryUtil;
import br.com.citframework.integracao.TransactionControler;
import br.com.citframework.integracao.TransactionControlerImpl;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilStrings;

/**
 * Implementao das operaos que respondem em {@code /service} da verso V3
 * REST
 *
 * @author carlos.alberto -
 *         <a href="mailto:carlos.alberto@centrait.com.br">carlos.
 *         alberto@centrait.com.br</a>
 * @since 08/03/2016
 *
 */
public class RESTDataQuery implements IRestOperation<CtMessage, CtMessageResp> {
	
    private static final Logger LOGGER = Logger.getLogger(RESTDataQuery.class.getName());
    @Override
    public CtMessageResp execute(final RestSessionDTO restSessionDto, final RestOperationDTO restOperationDto, final CtMessage message) throws JAXBException {
        return RestUtil.execute(this, restSessionDto, restOperationDto, message);
    }

	protected CtDataQueryResp dataQuery(final RestSessionDTO restSession, final CtDataQuery message, final RestOperationDTO restOperation) {
        final CtDataQueryResp resp = new CtDataQueryResp();

        final Map<String, RestDomainDTO> mapParam = RestUtil.getRestParameterService(restSession).findParameters(restSession, restOperation);
        if (mapParam == null || mapParam.isEmpty()) {
			resp.setError(RestOperationUtil.buildError(RestEnum.PARAM_ERROR, RestUtil.i18nMessage(restSession, "rest.service.mobile.operation.params.not.registered")));
            return resp;
        }

        if (UtilStrings.isNullOrEmpty(message.getQueryName())) {
			resp.setError(RestOperationUtil.buildError(RestEnum.PARAM_ERROR, RestUtil.i18nMessage(restSession, "rest.service.query.not.found")));
            return resp;
        }
        
        final String query = RestUtil.getRestParameterService(restSession).getParamValue(mapParam, message.getQueryName());
        if (UtilStrings.isNullOrEmpty(query)) {
			resp.setError(RestOperationUtil.buildError(RestEnum.PARAM_ERROR, RestUtil.i18nMessage(restSession, "rest.service.query.not.found")));
            return resp;
        }
        
        HashMap<String, Object> parameters = message.getParameters();
        if (parameters == null) {
        	parameters = new HashMap<String, Object>();
        }
        
        TransactionControler tc = new TransactionControlerImpl(Constantes.getValue("DATABASE_ALIAS"));
        
        try {
			List<HashMap<String, Object>> result = DataQueryUtil.executeQuery(tc.getConnection(), query, parameters);
			
			resp.setResult(result);
		} catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            resp.setError(RestOperationUtil.buildSimpleError(e));
            return resp;
		} finally {
			try {
				tc.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
        
        return resp;
    }
	
}