package br.com.centralit.citsmart.rest.v3.schema;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

import br.com.centralit.citsmart.rest.v3.util.ConvertUtil;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CtQueryParameter")
public class CtQueryParameter {
	
    @XmlElement(name = "Name", required = true)
    protected String name;

    @XmlElement(name = "Type", required = true)
    protected StQueryParameterType type;

    @XmlElement(name = "Value", required = false)
    protected Object value;

    @XmlElement(name = "DBValue", required = false)
    protected Object DBValue;

    public CtQueryParameter() {
    	
    }
    
    public CtQueryParameter(String name, StQueryParameterType type, Object value) {
    	this.name = name;
    	this.type = type;
    	this.value = value;
    	this.setDBValue(value);
    }

    public StQueryParameterType getType() {
		return type;
	}

	public void setType(StQueryParameterType type) {
		this.type = type;
	}

	public Object getValue() {
		return value;
	}

	public void setValue(Object value) {
		this.value = value;
	}
	
	public void setDBValue(Object value) {
		switch (this.getType()) {
			case INTEGER:
				this.DBValue = ConvertUtil.convertInteger(value);
				break;
			case LONG:
				this.DBValue = ConvertUtil.convertLong(value);
				break;
			case SHORT:
				this.DBValue = ConvertUtil.convertInteger(value);
				break;
			case FLOAT:
				this.DBValue = ConvertUtil.convertDouble(value);
				break;
			case DOUBLE:
				this.DBValue = ConvertUtil.convertDouble(value);
				break;
			case BYTE:
				this.DBValue = value;
				break;
			case BINARY:
				this.DBValue = value;
				break;
			case BOOLEAN:
				this.DBValue = ConvertUtil.convertBoolean(value);
				break;
			case DATE:
				this.DBValue = ConvertUtil.convertDate(value);
				break;
			case CALENDAR:
				this.DBValue = ConvertUtil.convertCalendar(value);
				break;
			case TIMESTAMP:
				this.DBValue = ConvertUtil.convertTimestamp(value);
				break;
			case BIG_DECIMAL:
				this.DBValue = ConvertUtil.convertDouble(value);
				break;
			case BIG_INTEGER:
				this.DBValue = ConvertUtil.convertInteger(value);
				break;
			case CURRENCY:
				this.DBValue = ConvertUtil.convertDouble(value);
				break;
			default:
				this.DBValue = ConvertUtil.stringValue(value);
				break;
		}
	}

	public Object getDBValue() {
		return DBValue;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
    
}
