package br.com.centralit.citsmart.rest.v3.schema;

import java.util.Calendar;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CtTask")
public class CtTask {

    @XmlElement(name = "Number", required = true)
    protected Long number;

    @XmlElement(name = "ElementNumber", required = false)
    protected Long elementId;

    @XmlElement(name = "Name", required = true)
    protected String name;

    @XmlSchemaType(name = "dateTime")
    @XmlElement(name = "StartDateTime", required = false)
    protected Calendar startDateTime;

    @XmlSchemaType(name = "dateTime")
    @XmlElement(name = "EndDateTime", required = false, nillable = true)
    protected Calendar endDateTime;

    @XmlElement(name = "GroupId", required = false, nillable = true)
    protected String groupId;

    @XmlElement(name = "UserId", required = false, nillable = true)
    protected String userId;
    
    @XmlElement(name = "Status", required = false, nillable=true)
    protected CtStatus status;
    
    @XmlElement(name = "Approval", required = false)
    protected CtApproval approval;

	public Long getNumber() {
		return number;
	}

	public void setNumber(Long number) {
		this.number = number;
	}

	public Calendar getStartDateTime() {
		return startDateTime;
	}

	public void setStartDateTime(Calendar startDateTime) {
		this.startDateTime = startDateTime;
	}

	public Calendar getEndDateTime() {
		return endDateTime;
	}

	public void setEndDateTime(Calendar endDateTime) {
		this.endDateTime = endDateTime;
	}

	public String getGroupId() {
		return groupId;
	}

	public void setGroupId(String groupId) {
		this.groupId = groupId;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public CtStatus getStatus() {
		return status;
	}

	public void setStatus(CtStatus status) {
		this.status = status;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Long getElementId() {
		return elementId;
	}

	public void setElementId(Long elementId) {
		this.elementId = elementId;
	}

	public CtApproval getApproval() {
		return approval;
	}

	public void setApproval(CtApproval approval) {
		this.approval = approval;
	}
    
}
