package br.com.centralit.citsmart.rest.v3.schema;

public enum StQueryParameterType {
	INTEGER("Integer","java.lang.Integer", "numeric"),
	LONG("Long","java.lang.Long", "numeric"),
	SHORT("Short","java.lang.Short", "numeric"),
	FLOAT("Float","java.lang.Float", "numeric"),
	DOUBLE("Double","java.lang.Double", "numeric"),
	CHARACTER("Character","java.lang.Character", "string"),
	BYTE("Byte","java.lang.Byte", "numeric"),
	BOOLEAN("Boolean","java.lang.Boolean", "boolean"),
	STRING("String","java.lang.String", "string"),
	DATE("Date","java.util.Date", "date"),
	CALENDAR("Calendar","java.util.Calendar", "date"),
	BIG_DECIMAL("Big Decimal","java.math.BigDecimal", "numeric"),
	BIG_INTEGER("Big Integer","java.math.BigInteger", "numeric"),
	CURRENCY("Currency","java.util.Currency", "money"),
	BINARY("Byte[]","byte[]", "string"),
	TIMESTAMP("Timestamp","java.sql.Timestamp", "timestamp");

	private String id;
	private String description;
	private String javaClass;	
	private String searchType;

	private StQueryParameterType(String description, String javaClass, String searchType) {
		this.id = name();
		this.description = description;
		this.javaClass = javaClass;
		this.searchType = searchType;
	}

	public static StQueryParameterType parse(String value) {
		for (StQueryParameterType item : StQueryParameterType.values()) {
			if (item.id.equals(value)) {
				return item;
			}
		}
		return null;
	}

	public String getId() {
		return this.id;
	}
	
	public String getDescription() {
		return description;
	}

	public String getJavaClass() {
		return javaClass;
	}

	public void setJavaClass(String javaClass) {
		this.javaClass = javaClass;
	}

	public String getSearchType() {
		return searchType;
	}
};