package br.com.centralit.citsmart.rest.v3.util;

import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import br.com.citframework.util.UtilStrings;


/**
 * Utilitário para criação de SQLs para DataObject
 *
 * @author carlos.alberto - <a href="mailto:carlos.alberto@centrait.com.br">carlos.alberto@centrait.com.br</a>
 * @since 06/02/2016
 *
 */
public final class ConvertUtil {
	
    public ConvertUtil() {}
	
	public static boolean isJsonDate(final String str) {
		if (UtilStrings.isNullOrEmpty(str))
			return false;
		return str.length() == 24 && str.charAt(4) == '-' && str.charAt(7) == '-' && str.charAt(10) == 'T' && str.charAt(13) == ':';
	}
	
	/**
	 * @param value
	 * @return
	 */
	public static Boolean convertBoolean(Object value) {
		if (value instanceof Boolean) {
			return (Boolean) value;
		}else if (value instanceof String) {
			String strValue = stringValue(value);
			return strValue.equalsIgnoreCase("true") 
					|| strValue.equalsIgnoreCase("sim")
					|| strValue.equalsIgnoreCase("s")
					|| strValue.equalsIgnoreCase("yes")
					|| strValue.equalsIgnoreCase("y");
		}else{
			return null;
		}
	}
	
	/**
	 * @param value
	 * @return
	 */
	public static Calendar convertCalendar(Object value) {
		Calendar result = null;
		String strValue = stringValue(value);
		if (value instanceof Calendar) {
			result = (Calendar) value;
		}else if (value instanceof Date) {
			result = UtilDate.dateToCalendar((Date) value);
		}else if (value instanceof Timestamp) {
			result = UtilDate.timestampToCalendar((Timestamp) value);
		}else if (value instanceof String && !UtilStrings.isNullOrEmpty((String) value)) {
			if (isJsonDate((String) value)) {
				result = UtilDate.stringJsonToCalendar((String) value);
			}else{
				result = UtilDate.dateToCalendar(UtilDate.getData(strValue));
			}
		}
		return result;
	}
		
	/**
	 * @param value
	 * @return
	 */
	public static Date convertDate(Object value) {
		Date result = null;
		String strValue = stringValue(value);
		if (value instanceof Calendar) {
			result = UtilDate.calendarToDate((Calendar) value);
		}else if (value instanceof Date) {
			result = (Date) value;
		}else if (value instanceof Timestamp) {
			result = UtilDate.timestampToDate((Timestamp) value);
		}else if (value instanceof String && !UtilStrings.isNullOrEmpty((String) value)) {
			if (isJsonDate((String) value)) {
				result = UtilDate.jsonToDate((String) value);
			}else{
				result = UtilDate.getData(strValue);
			}
		}
		return result;
	}
	
	/**
	 * @param value
	 * @return
	 */
	public static Integer convertInteger(Object value) {
		String strValue = stringValue(value);

		if (value instanceof Integer) {
			return (Integer) value;
		}else if (value instanceof Long) {
			return Integer.parseInt(value.toString());
		}else if (value instanceof Double) {
			return new Integer(((Double) value).intValue());
		}else if (value instanceof Float) {
			return new Integer(((Float) value).intValue());
		}else if (value instanceof BigInteger) {
			return new Integer(((BigInteger) value).intValue());
		}else if (value instanceof String && !UtilStrings.isNullOrEmpty((String) value)) {
			return new Integer(strValue);
		}else{
			return null;
		}
	}

	/**
	 * @param value
	 * @return
	 */
	public static Long convertLong(Object value) {
		String strValue = stringValue(value);
		
		if (value instanceof Long) {
			return (Long) value;
		}else if (value instanceof Integer) {
			return new Long(((Integer) value).longValue());
		}else if (value instanceof Double) {
			return new Long(((Double) value).longValue());
		}else if (value instanceof Float) {
			return new Long(((Float) value).longValue());
		}else if (value instanceof BigInteger) {
			return new Long(((BigInteger) value).longValue());
		}else if (value instanceof String && !UtilStrings.isNullOrEmpty((String) value)) {
			return new Long(strValue);
		}else{
			return null;
		}
	}

	/**
	 * @param value
	 * @return
	 */
	public static Double convertDouble(Object value) {
		String strValue = stringValue(value);

		if (value instanceof Double) {
			return (Double) value;
		}else if (value instanceof Float) {
			return new Double(((Float) value).doubleValue());
		}else if (value instanceof Integer) {
			return new Double(((Integer) value).doubleValue());
		}else if (value instanceof Long) {
			return new Double(((Long) value).doubleValue());
		}else if (value instanceof String && !UtilStrings.isNullOrEmpty((String) value)) {
			return new Double(strValue);
		}else{
			return null;
		}
	}

	
	/**
	 * @param value
	 * @return
	 */
	public static String stringValue(Object value) {
		if (value instanceof String) {
			return (String) value;
		}else if (value instanceof Boolean || value instanceof Long || value instanceof Integer || value instanceof Double || value instanceof Float) {
			return value.toString();
		}else if (value instanceof Calendar) {
			SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
	        return dateFormat.format(((Calendar) value).getTime());
		}else if (value instanceof Date) {
			SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
	        return dateFormat.format(((Date) value).getTime());
		}else{
			return null;
		}
	}

	public static Timestamp convertTimestamp(Object value) {
		Timestamp result = null;
		String strValue = stringValue(value);
		if (value instanceof Calendar) {
			result = UtilDate.calendarToTimestamp((Calendar) value);
		}else if (value instanceof Date) {
			result = UtilDate.dateToTimestamp(((Date) value));
		}else if (value instanceof Timestamp) {
			result = (Timestamp) value;
		}else if (value instanceof String && !UtilStrings.isNullOrEmpty((String) value)) {
			result = Timestamp.valueOf(strValue);
		}
		return result;
	}

}
