package br.com.centralit.citsmart.rest.v3.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import br.com.centralit.citsmart.rest.v3.schema.CtQueryParameter;
import br.com.centralit.citsmart.rest.v3.schema.StQueryParameterType;


/**
 * Utilitário para criação de SQLs para DataObject
 *
 * @author carlos.alberto - <a href="mailto:carlos.alberto@centrait.com.br">carlos.alberto@centrait.com.br</a>
 * @since 06/02/2016
 *
 */
public final class DataQueryUtil {
	
    public DataQueryUtil() {}
    
	public static List<HashMap<String, Object>> executeQuery(final Connection connection, final String query, HashMap<String, Object> parameterMap) throws SQLException {
		List<HashMap<String, Object>> result = null;
		PreparedStatement ps = getPreparedStatement(connection, query, parameterMap);
		ResultSet resultSet = ps.executeQuery();
		if (resultSet != null) {
			result = generateOutput(resultSet);
			try{
				resultSet.close();
			}catch(Exception e){}
			resultSet = null;
		}
		try{
			ps.close();
		}catch(Exception e){}
		ps = null;
		return result;
	}
	
    public static PreparedStatement getPreparedStatement(final Connection connection, final String query, HashMap<String, Object> parameterMap) throws SQLException {
        if (connection == null || connection.isClosed()) {
            throw new IllegalArgumentException("A conexo no existe ou est fechada.");
        }

        List<CtQueryParameter> parameters = buildParameters(query, parameterMap);
        String sql = replaceParameters(query);
        
        PreparedStatement ps = null;

        ps = connection.prepareStatement(sql);

        if (parameters != null) {
            String sAux;
        	int i = 0;
        	
            for (CtQueryParameter column : parameters) {
                try {
                    if (column.getValue() == null) {
                        ps.setObject(i + 1, null);
                    } else {
                    	Object valor = column.getDBValue();
                        if (valor instanceof Integer) {
                            ps.setInt(i + 1, ((Integer) valor).intValue());
                        } else if (valor instanceof Timestamp) {  
                        	Timestamp ts = (Timestamp) valor;
                        	ps.setTimestamp(i + 1, ts);
                        } else if (valor instanceof String) {
                            sAux = (String) valor;
                            ps.setString(i + 1, sAux);
                        } else if (valor instanceof Date) {
                        	ps.setDate(i + 1, new java.sql.Date(((Date) valor).getTime()));
                        } else {
                            ps.setObject(i + 1, valor);
                        }
                    }
                } catch (final Exception e) {
                    final String message = "Wrong Parameter " + (i + 1) + ". SQL: " + sql + " " + e.getMessage();
                    throw new RuntimeException(message);
                }
                
                i++;
            }
        }

        return ps;
    }
	
	public static List<CtQueryParameter> buildParameters(final String query, HashMap<String, Object> parameterMap) throws SQLException {
		List<CtQueryParameter> result = new ArrayList<CtQueryParameter>();
		
		int startPos = query.indexOf("${");
		while (startPos >= 0) {
			int endPos = query.indexOf("}", startPos);
			if (endPos > startPos) {
				String name = query.substring(startPos, endPos+1);
				String arg = name.substring(2, name.length()-1);
				
				startPos = query.indexOf("${", endPos);
				StQueryParameterType type = StQueryParameterType.STRING;
				if (arg.indexOf(":") > 0) {
					String[] argArray = arg.split(":");
					arg = argArray[0];
					type = StQueryParameterType.valueOf(argArray[1].toUpperCase());
				}
				
				result.add(new CtQueryParameter(arg, type, parameterMap.get(arg)));
			}else{
				startPos = -1;
			}
		}
		
		return result;
	}
	

	public static List<HashMap<String, Object>> generateOutput(ResultSet result) throws SQLException {
		List<HashMap<String, Object>> map = new ArrayList<HashMap<String, Object>>(); 
		
		ResultSetMetaData metaData = result.getMetaData();
		int columnCount = metaData.getColumnCount();

		while (result.next()) {
			HashMap<String, Object> line = new HashMap<String, Object>();
			
			for (int i = 1; i <= columnCount; i++) {
				line.put(metaData.getColumnLabel(i), result.getObject(i));
			}
			map.add(line);
		}
		
		return map;
	}
	
	public static String replaceParameters(String sql) {
		String result = sql;
		
		int startPos = result.indexOf("${");
		while (startPos >= 0) {
			int endPos = result.indexOf("}", startPos);
			if (endPos > startPos) {
				String name = result.substring(startPos, endPos+1);
				result = result.replace(name, "?");
			}				

			startPos = result.indexOf("${");
		}
		
		return result;
	}

}
