package br.com.centralit.mongodb;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.bson.Document;

import com.mongodb.client.AggregateIterable;

import br.com.centralit.util.JSONConverter;

public class MongoDBUtils extends MongoDB {
	protected MongoDBUtils() {
		super();
	}

	public static MongoDBUtils getInstance() {
		if (instance == null) {
			instance = new MongoDBUtils();
		}
		return instance;
	}

	private static MongoDBUtils instance = null;
	public static final Logger LOGGER = Logger.getLogger(MongoDBUtils.class);

	@Override
	public <T> List<T> query(List<Document> aggregates, String collection, Class<T> cls) {
		try {
			AggregateIterable<Document> result = getMongoDatabase().getCollection(collection).aggregate(aggregates).allowDiskUse(true);

			ArrayList<T> r = new ArrayList<>();

			if (result != null) {
				for (Document doc : result) {
					doc.put("id", doc.get("_id").toString());
					r.add(JSONConverter.fromJson(retiraNumberLong(doc.toJson()), cls));
				}
			}

			return r;
		} catch (Exception e) {
			LOGGER.debug(String.format("Citsmart ITSM > (MongoDB) Nao foi possivel realizar a query. Mensagem: %s.", (e.getMessage() != null && !e.getMessage().isEmpty() ? e.getMessage() : "Nao informada")));
		}

		return new ArrayList<T>();
	}
}
