package br.com.centralit.websocket.jboss.as.websockets.servlet;


import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import br.com.centralit.websocket.jboss.as.websockets.WebSocket;
import br.com.centralit.websocket.jboss.websockets.Frame;
import br.com.centralit.websocket.jboss.websockets.oio.OioWebSocket;

/**
 * @author <a href="mailto:bill@burkecentral.com">Bill Burke</a>
 * @version $Revision: 1 $
 */
class WebSocketDelegate implements WebSocket {
  protected HttpServletRequest request;
  protected OioWebSocket delegate;

  public WebSocketDelegate(HttpServletRequest request, OioWebSocket delegate) {
    this.request = request;
    this.delegate = delegate;
  }

  @Override
public HttpSession getHttpSession() {
    return request.getSession();
  }

  @Override
public HttpServletRequest getServletRequest() {
    return request;
  }

  @Override
public String getSocketID() {
    return delegate.getSocketID();
  }

  @Override
public Frame readFrame() throws IOException {
    return delegate.readFrame();
  }

  @Override
public void writeFrame(Frame frame) throws IOException {
    delegate.writeFrame(frame);
  }

  @Override
public void closeSocket() throws IOException {
    delegate.closeSocket();
  }
}
