package br.com.centralit.websocket.server;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;

import org.json.JSONArray;
import org.json.JSONObject;

import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoServicosDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.negocio.ContratoService;
import br.com.centralit.citcorpore.negocio.SolicitacaoServicoService;
import br.com.centralit.citcorpore.util.Enumerados.ServiceRequestStatus;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.centralit.websocket.jboss.as.websockets.WebSocket;
import br.com.centralit.websocket.jboss.as.websockets.servlet.WebSocketServlet;
import br.com.centralit.websocket.jboss.websockets.frame.TextFrame;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;

@SuppressWarnings("serial")
@WebServlet("/websocket/dashboardSolicitacoes")
public class DashboardSolicitacoesWebSocketServlet extends WebSocketServlet {
	public static Map<String, WebSocket> sockets = new HashMap<String, WebSocket>();

	private static SolicitacaoServicoService solicitacaoServicoService;
	private static ContratoService contratoService;

	@Override
	protected void onSocketOpened(WebSocket socket) throws IOException {
		DashboardSolicitacoesWebSocketServlet.sockets.put(socket.getSocketID(), socket);
	}

	@Override
	protected void onSocketClosed(WebSocket socket) {
		DashboardSolicitacoesWebSocketServlet.sockets.remove(socket.getSocketID());
	}

	public static void sendAll(HttpServletRequest request) throws Exception {
		JSONArray data = new JSONArray();

		GerenciamentoServicosDTO gerenciamentoServicosDTO = new GerenciamentoServicosDTO();
		gerenciamentoServicosDTO.setIdStatus(ServiceRequestStatus.IN_PROGRESS.getId());

		UsuarioDTO usuarioDTO = WebUtil.getUsuario(request);

		String COLABORADORES_VINC_CONTRATOS = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.COLABORADORES_VINC_CONTRATOS, "N");

		if (COLABORADORES_VINC_CONTRATOS == null) {
			COLABORADORES_VINC_CONTRATOS = "N";
		}

		Collection<ContratoDTO> listContratoUsuarioLogado = null;

		if (COLABORADORES_VINC_CONTRATOS != null && COLABORADORES_VINC_CONTRATOS.equalsIgnoreCase("S")) {
			listContratoUsuarioLogado = DashboardSolicitacoesWebSocketServlet.getContratoService().findAtivosByIdEmpregado(usuarioDTO.getIdEmpregado());
		} else {
			listContratoUsuarioLogado = DashboardSolicitacoesWebSocketServlet.getContratoService().listAtivos();
		}

		List<SolicitacaoServicoDTO> listSolicitacaoServicoDTO = DashboardSolicitacoesWebSocketServlet.getSolicitacaoServicoService(request).recuperaSolicitacoesPorUsuarioComFiltro(usuarioDTO, listContratoUsuarioLogado, gerenciamentoServicosDTO);
		Map<String, Integer> mapTipoSolicitacaoServico = DashboardSolicitacoesWebSocketServlet.getSolicitacaoServicoService(request).resumoTipoDemandaServico(listSolicitacaoServicoDTO);

		for (Map.Entry<String, Integer> tipoSolicitacaoServico : mapTipoSolicitacaoServico.entrySet()) {
			JSONObject tipo = new JSONObject();
			tipo.put("tipo", UtilI18N.internacionaliza(request, tipoSolicitacaoServico.getKey()));
			tipo.put("quantidade", tipoSolicitacaoServico.getValue());

			data.put(tipo);
		}

		for (Map.Entry<String, WebSocket> entry : sockets.entrySet()) {
			try {
				entry.getValue().writeFrame(TextFrame.from(data.toString()));
			} catch (Exception e) {
				System.out.println("Issue writing frame: " + e.getMessage());
			}
		}
	}

	public static SolicitacaoServicoService getSolicitacaoServicoService(HttpServletRequest request) throws Exception {
		if (solicitacaoServicoService == null) {
			if (request == null) {
				solicitacaoServicoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, null);
			} else {
				solicitacaoServicoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, WebUtil.getUsuarioSistema(request));
			}
		}
		return solicitacaoServicoService;
	}

	public static ContratoService getContratoService() throws Exception {
		if (contratoService == null) {
			contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		}
		return contratoService;
	}
}
