package br.com.citframework.build;

import ro.isdc.wro.extensions.manager.standalone.ExtensionsStandaloneManagerFactory;
import ro.isdc.wro.extensions.processor.css.LessCssProcessor;
import ro.isdc.wro.extensions.processor.js.GoogleClosureCompressorProcessor;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.model.resource.processor.factory.SimpleProcessorsFactory;
import ro.isdc.wro.model.resource.processor.impl.css.CssImportPreProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssUrlRewritingProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssVariablesProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.JawrCssMinifierProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.LessCssImportPreProcessor;
import ro.isdc.wro.model.resource.processor.impl.js.SemicolonAppenderPreProcessor;

import com.google.javascript.jscomp.CompilationLevel;

/**
 * Extende {@link ExtensionsStandaloneManagerFactory}, retirando {@link CssUrlRewritingProcessor},
 * que altera os caminhos relativos de resources no CSS, como imagens de cones
 * <p />
 * Tambm, adiciona suporte a <a href="http://lesscss.org/" target="_blank">less</a> CSS
 *
 * @author bruno.ribeiro
 * @created 23/04/2013
 */
public class CITWro4jStandaloneManagerFactory extends ExtensionsStandaloneManagerFactory {

    @Override
    protected ProcessorsFactory newProcessorsFactory() {
        final SimpleProcessorsFactory factory = new SimpleProcessorsFactory();

        // less css support
        factory.addPreProcessor(new LessCssImportPreProcessor());
        factory.addPostProcessor(new LessCssProcessor());

        factory.addPreProcessor(new CssImportPreProcessor());
        factory.addPreProcessor(new SemicolonAppenderPreProcessor());
        factory.addPreProcessor(new GoogleClosureCompressorProcessor(CompilationLevel.ADVANCED_OPTIMIZATIONS));
        factory.addPreProcessor(new JawrCssMinifierProcessor());

        factory.addPostProcessor(new CssVariablesProcessor());

        return factory;
    }

}
