package br.com.citframework.integracao;

import java.io.Serializable;

public class Condition implements Serializable{

	private static final long serialVersionUID = -94317735780450660L;
	
	/** Operators **/
	public static final int AND =1;
	public static final int OR =2;
	
	/** Comparators **/
	public static final String EQUALS = "=";
	public static final String NOT_EQUALS = "<>";
	public static final String IS = "is";
	public static final String IS_NOT = "is not";
	public static final String LIKE = "like";
	public static final String NOT_LIKE = "not like";
	public static final String GT = ">";
	public static final String GTE = ">=";
	public static final String LT = "<";
	public static final String LTE = "<=";
	
	private String fieldClass;
	private String comparator = EQUALS;
	private Object value;
	private int operator = AND;
	
	public Condition(int operator, String fieldClass, String comparator, Object value) {
		super();
		this.operator = operator;
		this.fieldClass = fieldClass;
		this.comparator = comparator;
		this.value = value;
	}
	
	public Condition(String fieldClass, String comparator, Object value) {
		super();
		this.fieldClass = fieldClass;
		this.comparator = comparator;
		this.value = value;
	}
	
	public Condition(String fieldClass, Object value) {
		super();
		this.fieldClass = fieldClass;
		this.value = value;
	}

	public String getFieldClass() {
		return fieldClass;
	}
	
	public void setFieldClass(String campo) {
		this.fieldClass = campo;
	}
	
	public String getComparator() {
		return comparator;
	}
	
	public void setComparator(String comparacao) {
		this.comparator = comparacao;
	}
	
	public int getOperator() {
		return operator;
	}
	
	public void setOperator(int operador) {
		this.operator = operador;
	}
	
	public Object getValue() {
		return value;
	}
	
	public void setValue(Object valor) {
		this.value = valor;
	}
}
