package br.com.citframework.integracao;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.citframework.dto.IDto;
import br.com.citframework.dto.LogDados;
import br.com.citframework.dto.Usuario;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.integracao.core.DataBase;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.PageImpl;
import br.com.citframework.integracao.core.Pageable;
import br.com.citframework.integracao.core.PagingQueryUtil;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.SQLConfig;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilNumbersAndDecimals;

@SuppressWarnings({"rawtypes", "unchecked"})
public class LogDadosDao extends CrudDaoDefaultImpl {

    private static final String TABLE_NAME = "logdados";

    @Override
    public synchronized IDto create(final IDto obj) throws PersistenceException {
        LogDados logDados = new LogDados();

        if (obj != null) {

            logDados = (LogDados) obj;

            final StringBuilder sql = new StringBuilder();

            final List parametro = new ArrayList<>();

            sql.append("INSERT INTO logdados (dtatualizacao, operacao, dados, idusuario, localorigem, nometabela, datalog) VALUES (?, ?, ?, ?, ?, ?, ?)");

            parametro.add(UtilDatas.getDataAtual());
            parametro.add(logDados.getOperacao());
            parametro.add(logDados.getDados());
            parametro.add(logDados.getIdUsuario());
            parametro.add(logDados.getLocalOrigem());
            parametro.add(logDados.getNomeTabela());
            parametro.add(logDados.getDataLog());

            this.execUpdate(sql.toString(), parametro.toArray());
        }

        return logDados;
    }

    @Override
    public synchronized IDto createWithID(final IDto obj) throws PersistenceException {
        return super.createWithID(obj);
    }

    private static final Integer LIMIT = 50;

    public LogDadosDao(final Usuario usuario) {
        super(Constantes.getValue("DATABASE_ALIAS"), usuario);
    }

    @Override
    public Collection find(final IDto dto) throws PersistenceException {
        return null;
    }

    @Override
    public Collection<Field> getFields() {
        final List<Field> lista = new ArrayList<>();
        lista.add(new Field("idlog", "idlog", true, true, false, false));
        lista.add(new Field("dtAtualizacao", "dtAtualizacao", false, false, false, false));
        lista.add(new Field("operacao", "operacao", false, false, false, false));
        lista.add(new Field("dados", "dados", false, false, false, false));
        lista.add(new Field("idUsuario", "idUsuario", false, false, false, false));
        lista.add(new Field("localOrigem", "localOrigem", false, false, false, false));
        lista.add(new Field("nomeTabela", "nomeTabela", false, false, false, false));
        lista.add(new Field("dataLog", "dataLog", false, false, false, false));
        return lista;
    }

    @Override
    public String getTableName() {
        return TABLE_NAME;
    }

    @Override
    public Collection list() throws PersistenceException {
        final List<Order> ordenacao = new ArrayList<>();
        ordenacao.add(new Order("dtAtualizacao"));
        return this.list(ordenacao);
    }

    public Collection<LogDados> listAllLogs() throws Exception {
        final StringBuilder sql = new StringBuilder();
        final List parametro = new ArrayList<>();
        final List fields = new ArrayList<>();
        List list = new ArrayList<>();
        String orderBy = "";
        orderBy = "order by idlog DESC ";
        if (CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.SQLSERVER)) {

            sql.append(" select nome, nometabela, operacao, dados, datalog from (select ROW_NUMBER() OVER(" + orderBy + ") as RowNum, ");
            sql.append(" usuario.nome, logdados.nometabela, logdados.operacao, logdados.dados, logdados.datalog " + "FROM  " + this.getTableName() + " ");
            sql.append(" logdados INNER JOIN usuario usuario ON usuario.idUsuario = logdados.idUsuario " + "WHERE dtAtualizacao BETWEEN ? AND ? ");

            sql.append(")  as table2 where table2.RowNum between 0 and " + LIMIT + " ");
        } else {
            sql.append("SELECT usuario.nome, logdados.nometabela, logdados.operacao, logdados.dados, logdados.datalog " + "FROM  " + this.getTableName()
                    + " logdados INNER JOIN usuario usuario ON usuario.idUsuario = logdados.idUsuario " + "WHERE dtAtualizacao BETWEEN ? AND ? ");
        }

        if (CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.ORACLE)) {
            sql.append(" AND ROWNUM <= " + LIMIT + " " + orderBy + "");
        } else {
            if (!CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.SQLSERVER)) {
                sql.append(" " + orderBy + " LIMIT " + LIMIT);
            }
        }

        list = this.execSQL(sql.toString(), parametro.toArray());
        fields.add("nomeUsuario");
        fields.add("nomeTabela");
        fields.add("operacao");
        fields.add("dados");
        fields.add("dataLog");
        if (list != null && !list.isEmpty()) {
            return this.listConvertion(this.getBean(), list, fields);
        } else {
            return null;
        }
    }

    public Collection<LogDados> listLogs(final LogDados log) throws Exception {

		final List parametros = new ArrayList<>();

		// Consulta sql
		StringBuilder sql = new StringBuilder(getSQLLogDados());
		StringBuilder from = new StringBuilder(" FROM ").append(this.getTableName()).append(" logdados ")
				.append("INNER JOIN usuario usuario ON usuario.idUsuario = logdados.idUsuario ");
		StringBuilder where = new StringBuilder(" WHERE dtAtualizacao BETWEEN ? AND ? ");

		if (!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(log.getIdUsuario())) {
			where.append(" AND logdados.idUsuario = " + log.getIdUsuario());
		}
		if (log.getNomeTabela() != null && !log.getNomeTabela().equals("")) {
			where.append(" AND upper(nomeTabela) = '" + log.getNomeTabela().trim() + "'");
		}

		parametros.add(log.getDataInicio());

		if (CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.ORACLE)) {
			parametros.add(log.getDataFim());
		} else {
			// As linhas abaixo foram necessarias para a hora nao ser
			// considerada String no banco de dados PostgreSQL.
			final String DATA = log.getDataFim().toString() + " 23:59:59";
			final String pattern = "yyyy-MM-dd hh:mm:ss";
			final SimpleDateFormat sdf = new SimpleDateFormat(pattern);
			final java.util.Date d = sdf.parse(DATA);
			final java.sql.Timestamp sqlDate = new java.sql.Timestamp(d.getTime());
			parametros.add(sqlDate);
		}

		String orderBy = " order by idlog DESC ";

		List<LogDados> result = new ArrayList<LogDados>();

		List<LogDados> lista = this.execSQL(sql.append(from).append(where).append(orderBy).toString(), parametros.toArray());

		if (lista != null && !lista.isEmpty()) {

			List fields = new ArrayList<>();

			fields.add("nomeUsuario");
			fields.add("nomeTabela");
			fields.add("operacao");
			fields.add("dados");
			fields.add("dataLog");

			result = engine.listConvertion(LogDados.class, lista, fields);

		} else {
			return null;
		}

		return result;

	}

	public Collection<LogDados> listLogsWithPagination(final LogDados log) throws Exception {

		String limite = (log.getPaginaAtual() - 1) * log.getQuantidadeLogsPorPagina() + ", "
				+ log.getQuantidadeLogsPorPagina();
		final List parametro = new ArrayList<>();
		final List fields = new ArrayList<>();
		List list = new ArrayList<>();
		final StringBuilder sql = new StringBuilder();
		String orderBy = "";
		orderBy = "order by idlog DESC ";
		if (CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.SQLSERVER)) {
			sql.append(" select nome, nometabela, operacao, dados, datalog from (select ROW_NUMBER() OVER(" + orderBy + ") as RowNum, ");
			sql.append(" usuario.nome, logdados.nometabela, logdados.operacao, logdados.dados, logdados.datalog " + "FROM  " + this.getTableName() + " ");
			sql.append(" logdados INNER JOIN usuario usuario ON usuario.idUsuario = logdados.idUsuario " + "WHERE dtAtualizacao BETWEEN ? AND ? ");
			if (!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(log.getIdUsuario())) {
				sql.append(" AND logdados.idUsuario = " + log.getIdUsuario());
			}
			sql.append(")  as table2 where table2.RowNum between "
					+ (log.getPaginaAtual() - 1) * log.getQuantidadeLogsPorPagina() + " and "
					+ log.getQuantidadeLogsPorPagina());
		} else {
			sql.append("SELECT usuario.nome, logdados.nometabela, logdados.operacao, logdados.dados, logdados.datalog " + "FROM  " + this.getTableName()
					+ " logdados INNER JOIN usuario usuario ON usuario.idUsuario = logdados.idUsuario " + "WHERE dtAtualizacao BETWEEN ? AND ? ");
		}

		if (log.getNomeTabela() != null && !log.getNomeTabela().equals("")) {
			sql.append(" AND upper(nomeTabela) = '" + log.getNomeTabela().trim() + "'");
		}

		if (!CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.SQLSERVER)) {
			if (log.getIdUsuario() != null) {
				sql.append(" AND logdados.idUsuario = " + log.getIdUsuario());
			}

		}
		if (CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.ORACLE)) {
			sql.append(" AND ROWNUM <= " + limite + " " + orderBy + "");
		} else {
			if (!CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.SQLSERVER)) {
				sql.append(" " + orderBy + " LIMIT " + limite);
			}

		}

		parametro.add(log.getDataInicio());
		if (CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.ORACLE)) {
			parametro.add(log.getDataFim());
		} else {
			// As linhas abaixo foram necessarias para a hora nao ser considerada String no banco de dados PostgreSQL.
			final String DATA = log.getDataFim().toString() + " 23:59:59";
			final String pattern = "yyyy-MM-dd hh:mm:ss";
			final SimpleDateFormat sdf = new SimpleDateFormat(pattern);
			final java.util.Date d = sdf.parse(DATA);
			final java.sql.Timestamp sqlDate = new java.sql.Timestamp(d.getTime());
			parametro.add(sqlDate);
		}
		list = this.execSQL(sql.toString(), parametro.toArray());
		fields.add("nomeUsuario");
		fields.add("nomeTabela");
		fields.add("operacao");
		fields.add("dados");
		fields.add("dataLog");
		if (list != null && !list.isEmpty()) {
			return this.listConvertion(this.getBean(), list, fields);
		} else {
			return null;
		}
	}

	public Page<LogDados> listarLogsPaginados(final LogDados log, Pageable pageable)
			throws Exception {

		Page<LogDados> taskPage;
		final List parametros = new ArrayList<>();

		// Consulta sql
		StringBuilder sql = new StringBuilder(getSQLLogDados());
		StringBuilder from = new StringBuilder(" FROM ").append(this.getTableName()).append(" logdados ")
				.append("INNER JOIN usuario usuario ON usuario.idUsuario = logdados.idUsuario ");
		StringBuilder where = new StringBuilder(" WHERE dtAtualizacao BETWEEN ? AND ? ");

		if (!UtilNumbersAndDecimals.isNullOrZeroOrEmpty(log.getIdUsuario())) {
			where.append(" AND logdados.idUsuario = " + log.getIdUsuario());
		}
		if (log.getNomeTabela() != null && !log.getNomeTabela().equals("")) {
			where.append(" AND upper(nomeTabela) = '" + log.getNomeTabela().trim() + "'");
		}

		parametros.add(log.getDataInicio());

		if (CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.ORACLE)) {
			parametros.add(log.getDataFim());
		} else {
			// As linhas abaixo foram necessarias para a hora nao ser
			// considerada String no banco de dados PostgreSQL.
			final String DATA = log.getDataFim().toString() + " 23:59:59";
			final String pattern = "yyyy-MM-dd hh:mm:ss";
			final SimpleDateFormat sdf = new SimpleDateFormat(pattern);
			final java.util.Date d = sdf.parse(DATA);
			final java.sql.Timestamp sqlDate = new java.sql.Timestamp(d.getTime());
			parametros.add(sqlDate);
		}

		String orderBy = " order by idlog DESC ";

		StringBuilder whereTotalizador = new StringBuilder();
		whereTotalizador.append(" FROM ").append(getTableName()).append(where);
		final StringBuilder sqlCount = this.countQueryPiece(whereTotalizador);
		final Long totalElements = this.countElements(sqlCount.toString(), parametros.toArray());

		List<LogDados> result = new ArrayList<LogDados>();

		taskPage = this.makePage(result, pageable, totalElements);

		String query;
		if (MAIN_SGBD.equals(DataBase.MSSQLSERVER)) {
			query = PagingQueryUtil.constructsSQLServerPagingPiece(pageable, sql.toString(), orderBy,
					from.append(where).toString());
		} else {
			sql.append(from);
			sql.append(where);
			sql.append(orderBy);
			query = PagingQueryUtil.concatPagingPieceOnQuery(pageable, sql.toString(), MAIN_SGBD);
		}

		final List<LogDados> lista = this.execSQL(query, parametros.toArray());

		if (lista != null && !lista.isEmpty()) {

			List fields = new ArrayList<>();

			fields.add("nomeUsuario");
			fields.add("nomeTabela");
			fields.add("operacao");
			fields.add("dados");
			fields.add("dataLog");

			result = engine.listConvertion(LogDados.class, lista, fields);
			taskPage = new PageImpl<LogDados>(result, pageable, taskPage.getTotalElements());

		} else {
			return null;
		}

	return taskPage;

	}

    public Collection<LogDados> listNomeTabela() throws Exception {
        final List parametro = new ArrayList<>();
        final List fields = new ArrayList<>();
        List list = new ArrayList<>();
        final StringBuilder sql = new StringBuilder();

        if (CITCorporeUtil.SGBD_PRINCIPAL.toUpperCase().equals(SQLConfig.ORACLE)) {
            sql.append("SELECT DISTINCT UPPER(NOMETABELA) FROM " + this.getTableName() + " ORDER BY UPPER(NOMETABELA)");
        } else {
            sql.append("SELECT DISTINCT UPPER(nometabela) FROM " + this.getTableName() + " ORDER BY UPPER(nomeTabela) ASC");
        }
        list = this.execSQL(sql.toString(), parametro.toArray());
        fields.add("nomeTabela");
        if (list != null && !list.isEmpty()) {
            return this.listConvertion(this.getBean(), list, fields);
        } else {
            return null;
        }
    }

	public Collection<LogDados> listNomeTabelaObjetoNegocio() throws Exception {
		final List parametro = new ArrayList<>();
		final List fields = new ArrayList<>();
		List list = new ArrayList<>();
		final StringBuilder sql = new StringBuilder();

		sql.append("SELECT nometabeladb FROM objetonegocio where situacao like 'A' ORDER BY nometabeladb ");

		list = this.execSQL(sql.toString(), parametro.toArray());
		fields.add("nomeTabela");
		if (list != null && !list.isEmpty()) {
			return this.listConvertion(this.getBean(), list, fields);
		} else {
			return null;
		}
	}

    @Override
    public Class<LogDados> getBean() {
        return LogDados.class;
    }

	private String getSQLLogDados() {

		StringBuilder sql = new StringBuilder();
		sql.append("SELECT usuario.nome, logdados.nometabela, logdados.operacao, logdados.dados, logdados.datalog");

		return sql.toString();

	}
}