package br.com.citframework.integracao;

import java.math.BigDecimal;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.citframework.dto.LookupDTO;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.util.Campo;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.FindFieldUtil;
import br.com.citframework.util.SQLConfig;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilFormatacao;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilStrings;
import br.com.centralit.citcorpore.util.WebUtil;

/**
 * @author euler.ramos
 * @since 12.09.2016
 * Refatorao - Para simplificar a manuteno, facilitando o entendimento do objetivo de cada comando.
 */
public class LookupProcessBaseConhecimentoDAO extends LookupProcessDefaultDao {

	@SuppressWarnings("rawtypes")
	@Override
	public List processLookup(LookupDTO lookupObject, HttpServletRequest request) throws LogicException, Exception {

		UsuarioDTO usuarioLogado = WebUtil.getUsuario(request);
		if (usuarioLogado == null) {
			return null;
		}
		
		if (strSGBDPrincipal == null) {
			strSGBDPrincipal = CITCorporeUtil.SGBD_PRINCIPAL;
			strSGBDPrincipal = UtilStrings.nullToVazio(strSGBDPrincipal).trim();
		}
		FindFieldUtil findField = new FindFieldUtil();

		Campo campoFiltroIdPasta = new Campo();
		Collection<Campo> listaCamposRetorno = findField.getCamposRetorno(lookupObject.getNomeLookup());
		StringBuilder clausulaWhere = this.gerarClausulaWhere(lookupObject, findField, campoFiltroIdPasta);
		StringBuilder corpoSQL = this.gerarCorpoSQL(campoFiltroIdPasta, this.tratarCamposRetorno(listaCamposRetorno), clausulaWhere, lookupObject, findField, usuarioLogado);

		Integer[] paginacao = this.configurarPaginacao(this.obterTotalItens(corpoSQL), lookupObject, request);
		Integer paginaAtual = paginacao[0];
		Integer quantidadeItensPorPagina = paginacao[1];
		
		StringBuilder sql = this.gerarSQL(paginaAtual, quantidadeItensPorPagina, corpoSQL,
				this.gerarClausulaOrder(lookupObject, findField), lookupObject, findField);
		List lista = execSQL(sql.toString(), null);

		List result = this.processaResultado(listaCamposRetorno, lista, request);

		TransactionControler tc = this.getTransactionControler();
		if (tc != null) {
			tc.close();
		}
		return result;
	}

	@SuppressWarnings("rawtypes")
	private List processaResultado(Collection<Campo> listaCamposRetorno, List lista, HttpServletRequest request) {
		List<ArrayList<Campo>> resultado = null;
		if (lista != null && lista.size() > 0) {
			resultado = new ArrayList<ArrayList<Campo>>();
			ArrayList<Campo> listaCampos;
			Object valor;
			int i;
			for (Object row : lista) {
				i = 0;
				listaCampos = new ArrayList<Campo>();
				for (Campo campo : listaCamposRetorno) {
					valor = ((Object[]) row)[i];
					if (campo.getType().equalsIgnoreCase(Constantes.getValue(FIELDTYPE_TEXT).trim()) || campo.getType().equalsIgnoreCase(Constantes.getValue(FIELDTYPE_TEXTAREA).trim())) {
						campo.setObjValue(this.processaResultadoText(valor,campo,request));
					} else if (campo.getType().equalsIgnoreCase(Constantes.getValue(FIELDTYPE_DATE).trim())) {
						campo.setObjValue(this.processaResultadoDate(valor,campo,request));
					} else if (campo.getType().equalsIgnoreCase(Constantes.getValue(FIELDTYPE_MOEDA).trim())) {
						campo.setObjValue(this.processaResultadoMoeda(valor,campo,request));
					}
					listaCampos.add(new Campo(campo.getNomeFisico(), campo.getDescricao(), campo.isObrigatorio(), campo.getType(), campo.getTamanho(), campo.getObjValue()));
					i++;
				}
				resultado.add(listaCampos);
			}
		}
		return resultado;
	}

	private String processaResultadoMoeda(Object valor, Campo campo, HttpServletRequest request) {
		String resultado = new String("");
		if (valor != null) {
			if (valor instanceof Double) {
				resultado = UtilFormatacao.formatBigDecimal(new BigDecimal(((Double) valor).doubleValue()), 2);
			} else if (valor instanceof BigDecimal) {
				resultado = UtilFormatacao.formatBigDecimal((BigDecimal) valor, 2);
			} else {
				resultado = valor.toString();
			}
		}
		return resultado;
	}

	private String processaResultadoDate(Object valor, Campo campo, HttpServletRequest request) {
		String resultado = new String("");
		if (valor != null) {
			if (valor instanceof java.sql.Date) {
				resultado = UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, (java.sql.Date) valor, WebUtil.getLanguage(request));
			} else if (valor instanceof java.sql.Timestamp) {
				resultado = UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, (java.sql.Date) valor, WebUtil.getLanguage(request));
			} else {
				resultado = valor.toString();
			}
		}
		return resultado;		
	}

	private String processaResultadoText(Object valor, Campo campo, HttpServletRequest request) {
		String resultado = new String("");
		if (valor != null) {
			resultado = new String(valor.toString());
			if (campo.getNomeFisico().equalsIgnoreCase("baseconhecimento.status")) {
				if(resultado.equals("S") || resultado.equals("Y")){
					resultado = br.com.centralit.citcorpore.util.Enumerados.SimNao.SIM.getChave();
				}else if(resultado.equals("N")){
					resultado = br.com.centralit.citcorpore.util.Enumerados.SimNao.NAO.getChave();
				}
				resultado = UtilI18N.internacionaliza(request, resultado);
			}
			if (campo.getNomeFisico().equalsIgnoreCase("baseconhecimento.arquivado")) {
				if(resultado.equals("S")){
					resultado = br.com.centralit.citcorpore.util.Enumerados.SimNao.SIM.getChave();
				}else if(resultado.equals("N")){
					resultado = br.com.centralit.citcorpore.util.Enumerados.SimNao.NAO.getChave();
				}
				resultado = UtilI18N.internacionaliza(request, resultado);
			}
			resultado = resultado.replaceAll("\"", "&quot;").replaceAll("'", "&#180;");
		}
		return resultado;
	}

	private StringBuilder gerarSQL(Integer paginaAtual, Integer quantidadeItensPorPagina, StringBuilder corpoSQL,
			StringBuilder clausulaOrder, LookupDTO lookupObject, FindFieldUtil findField) {
		StringBuilder sql = new StringBuilder();

		if (SQLConfig.isOracleSGBDPrincipal()) {
			sql.append("select * from (select a.*, rowNum AS rnum from ( ");
		} else if (SQLConfig.isSqlServerSGBDPrincipal()) {
			sql.append("select * from (select *, ROW_NUMBER() OVER (").append(clausulaOrder.toString())
					.append(") AS Row from (");
		}

		sql.append(corpoSQL.toString());

		if (SQLConfig.isSqlServerSGBDPrincipal()) {
			sql.append(") a) b WHERE Row > ").append(quantidadeItensPorPagina * (paginaAtual - 1))
					.append(" and Row <= ").append(quantidadeItensPorPagina * paginaAtual);
		} else {
			sql.append(clausulaOrder.toString());
		}

		if (SQLConfig.isOracleSGBDPrincipal()) {
			sql.append(") a " + "WHERE rowNum <=" + paginaAtual * quantidadeItensPorPagina + " " + ") WHERE rnum > "
					+ (paginaAtual - 1) * quantidadeItensPorPagina + " ");
		}

		if (SQLConfig.isMySqlSGBDPrincipal() || SQLConfig.isPostgresSGBDPrincipal()) {
			sql.append(" LIMIT ").append(quantidadeItensPorPagina).append(" OFFSET ")
					.append(quantidadeItensPorPagina * (paginaAtual - 1)).append(" ");
		}

		return sql;
	}

	@SuppressWarnings("rawtypes")
	private Integer obterTotalItens(StringBuilder corpoSQL) throws PersistenceException {
		List lista = new ArrayList();
		StringBuilder sqlCount = new StringBuilder("select count(*) from (");
		sqlCount.append(corpoSQL);
		sqlCount.append(") q");
		lista = execSQL(sqlCount.toString(), null);
		if (lista != null && !lista.isEmpty() && lista.get(0) != null) {
			if (CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.SQLSERVER)) {
				return ((Integer) ((Object[]) lista.get(0))[0]).intValue();
			} else if (CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.ORACLE)) {
				return ((BigDecimal) ((Object[]) lista.get(0))[0]).intValue();
			} else {
				return ((Long) ((Object[]) lista.get(0))[0]).intValue();
			}
		} else {
			return 0;
		}
	}

	private Integer[] configurarPaginacao(Integer totalItens, LookupDTO lookupObject, HttpServletRequest request) {
		Integer totalPag = 1;
		Integer paginaAtual;
		Integer quantidadeItensPorPagina = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANT_RETORNO_PESQUISA, "10"));
		
		if ((totalItens != null)&&(totalItens.intValue()>0)) {
			request.getSession(true).setAttribute("totalItens_" + lookupObject.getNomeLookup(), totalItens);
			if (totalItens > quantidadeItensPorPagina) {
				totalPag = totalItens / quantidadeItensPorPagina;
				if (totalItens % quantidadeItensPorPagina != 0) {
					totalPag = totalPag + 1;
				}
			} else {
				totalPag = 1;
			}
		}
		request.getSession(true).setAttribute("totalPag_" + lookupObject.getNomeLookup(), totalPag);

		Integer acaoPaginacao = new Integer(lookupObject.getPaginacao()); 
		switch (acaoPaginacao) {
		case 0:
			paginaAtual = 1;
			break;
		case -1:
			paginaAtual = new Integer(request.getSession(true).getAttribute("pagAtualAux_" + lookupObject.getNomeLookup()).toString())-1;
			break;
		case 1:
			paginaAtual = new Integer(request.getSession(true).getAttribute("pagAtualAux_" + lookupObject.getNomeLookup()).toString())+1;
			break;
		default:
			paginaAtual = totalPag;
			break;
		}
		if ((paginaAtual<1)||(paginaAtual>totalPag)) {
			paginaAtual = 1;
		}
		
		request.getSession(true).setAttribute("pagAtual_" + lookupObject.getNomeLookup(), paginaAtual);
		request.getSession(true).setAttribute("pagAtualAux_" + lookupObject.getNomeLookup(), paginaAtual); //TODO lixo que deve ser removido numa ocasio oportuna. 

		Integer[] paginacao = new Integer[2];
		paginacao[0] = paginaAtual;
		paginacao[1] = quantidadeItensPorPagina;
		return paginacao;
	}

	private StringBuilder gerarClausulaOrder(LookupDTO lookupObject, FindFieldUtil findField) {
		StringBuilder clausulaOrder = new StringBuilder(" ORDER BY ");
		Collection<Campo> listaCamposOrdem = findField.getCamposOrdenacao(lookupObject.getNomeLookup());

		for (Campo campo : listaCamposOrdem) {
			if (clausulaOrder.length() > 10) {
				clausulaOrder.append(",");
			}
			clausulaOrder.append(campo.getNomeFisico());
		}
		return clausulaOrder;
	}

	private StringBuilder gerarClausulaWhere(LookupDTO lookupObject, FindFieldUtil findField, Campo campoFiltroIdPasta) {
		StringBuilder where = new StringBuilder(" ");

		// Lookup Where Conditions
		String lookupWhereCondition = findField.getWhere(lookupObject.getNomeLookup());
		if (UtilStrings.isNotVazio(lookupWhereCondition)) {
			where.append("WHERE (").append(lookupWhereCondition).append(")");
		}
		lookupWhereCondition = lookupObject.getWhereDinamico();
		if ((UtilStrings.isNotVazio(lookupWhereCondition)) && (!lookupWhereCondition.equalsIgnoreCase("undefined"))) {
			if (where.length() > 1) {
				where.append(" AND (");
			} else {
				where.append("WHERE (");
			}
			where.append(lookupWhereCondition).append(")");
		}

		// Screen's Condition Filters
		Collection<Campo> listaCamposPesquisa = findField.getCamposPesquisa(lookupObject.getNomeLookup());
		if ((listaCamposPesquisa != null) && (listaCamposPesquisa.size() > 0)) {
			int count = 1;
			int qtdeCampos = 0;
			String valor = null;
			for (Campo campo : listaCamposPesquisa) {
				valor = UtilStrings.fixEncoding(this.getValueParmLookup(lookupObject, count));
				if (UtilStrings.isNotVazio(valor)) {
					if (campo.getNomeFisico().equals("idpasta")){
						//O valor ser usado para adicionar a funo recursiva na clusula From da SQL de consulta.
						campoFiltroIdPasta.setNomeFisico(campo.getNomeFisico());
						campoFiltroIdPasta.setObjValue(valor);
					} else {
						if (where.length() > 1) {
							if (qtdeCampos > 0) {
								where.append(" AND ");
							} else {
								where.append("AND (");
							}
						} else {
							where.append("WHERE (");
						}
						if (campo.isSomenteBusca()) {
							valor = Normalizer.normalize(valor.trim().toUpperCase(), Normalizer.Form.NFD);
							valor = valor.replaceAll("[^\\p{ASCII}]", "");
						}
						where.append(this.construirCampoFiltro(campo, valor));
						qtdeCampos++;
					}
				}
				count++;
			}
			where.append(")");
		}
		return where;
	}

	private String construirCampoFiltro(Campo campo, String valor) {
		String resultado = "";
		if (campo.getType().equalsIgnoreCase(Constantes.getValue(FIELDTYPE_TEXT).trim())
				|| campo.getType().equalsIgnoreCase(Constantes.getValue(FIELDTYPE_TEXTAREA).trim())) {
			resultado = constroiCampoTexto(campo, valor);
		} else if (campo.getType().equalsIgnoreCase(Constantes.getValue(FIELDTYPE_COMBO).trim())) {
			resultado = constroiCampoCombo(campo, valor);
		} else if (campo.getType().equalsIgnoreCase("DATE")) {
			resultado = constroiCampoDate(campo, valor);
		} else {
			resultado = constroiCampoComum(campo, valor);
		}
		return resultado;
	}

	private String constroiCampoComum(Campo campo, String valor) {
		StringBuilder resultado = new StringBuilder(campo.getNomeFisico());
		resultado.append(" ");
		if (campo.isNegacao()) {
			resultado.append("!");
		}
		resultado.append("= ");
		resultado.append(valor);
		return resultado.toString();
	}

	private String constroiCampoDate(Campo campo, String valor) {
		StringBuilder resultado = new StringBuilder(campo.getNomeFisico());
		resultado.append(" ");
		if (campo.isNegacao()) {
			resultado.append("!");
		}
		resultado.append("= ");
		if (strSGBDPrincipal.equalsIgnoreCase("ORACLE")) {
			resultado.append("to_date('").append(valor).append("')");
		} else {
			try {
				resultado.append(UtilDatas.strToSQLDate(valor).toString());
			} catch (LogicException e) {
				e.printStackTrace();
			}
		}
		return resultado.toString();
	}

	private String constroiCampoCombo(Campo campo, String valor) {
		StringBuilder resultado = new StringBuilder(campo.getNomeFisico());
		resultado.append(" ");
		if (campo.isNegacao()) {
			resultado.append("NOT ");
		}
		resultado.append("IN (");
		resultado.append(valor);
		resultado.append(")");
		return resultado.toString();
	}

	private String constroiCampoTexto(Campo campo, String valor) {
		StringBuilder resultado = new StringBuilder();
		String func = Constantes.getValue("FUNCAO_CONVERTE_MAIUSCULO").trim();
		if (UtilStrings.isNotVazio(func)) {
			resultado.append(func).append("(");
		}
		if (strSGBDPrincipal.equalsIgnoreCase("SQLSERVER")){
			resultado.append("dbo.");
		}
		resultado.append("remove_acento").append("(");
		resultado.append(campo.getNomeFisico());
		resultado.append(")");
		if (UtilStrings.isNotVazio(func)) {
			resultado.append(")");
		}
		resultado.append(" ");
		if (campo.isNegacao()) {
			resultado.append("NOT");
		}
		resultado.append("LIKE ");

		if (UtilStrings.isNotVazio(func)) {
			resultado.append(func).append("(");
		}
		if (strSGBDPrincipal.equalsIgnoreCase("SQLSERVER")){
			resultado.append("dbo.");
		}
		resultado.append("remove_acento").append("(");
		resultado.append("'%");
		resultado.append(valor);
		resultado.append("%'");
		resultado.append(")");
		if (UtilStrings.isNotVazio(func)) {
			resultado.append(")");
		}
		return resultado.toString();
	}

	private StringBuilder gerarCorpoSQL(Campo campoFiltroIdPasta, StringBuilder camposRetornoSQL, StringBuilder clausulaWhere,
			LookupDTO lookupObject, FindFieldUtil findField, UsuarioDTO usuarioLogado) {
		StringBuilder sql = new StringBuilder();
		sql.append("SELECT ");
		if (UtilStrings.isNotVazio(lookupObject.getDistinct())
				&& lookupObject.getDistinct().equalsIgnoreCase(Boolean.TRUE.toString())) {
			sql.append("DISTINCT ");
		}
		sql.append(camposRetornoSQL.toString());
		sql.append(" FROM ");
		sql.append(findField.getTabela(lookupObject.getNomeLookup()));
		
		//Filtrando somente as pastas que o usurio tem permisso de acesso.
		if ((usuarioLogado!=null)&&(usuarioLogado.getIdUsuario()!=null)){
			sql.append(" join ");
			if (CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.ORACLE)){
				sql.append("table(");
			}
			sql.append("f_pastas_permitidas(").append(usuarioLogado.getIdUsuario().toString()).append(")");
			if (CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.ORACLE)){
				sql.append(")");
			}
			sql.append(" pastaspermitidas on pastaspermitidas.idpasta = baseconhecimento.idpasta ");
		}
		
		//Filtro que permite retornar as bases de conhecimento que esto na rvore de hierarquia da pasta selecionada
		if ((campoFiltroIdPasta!=null)&&(campoFiltroIdPasta.getObjValue()!=null)&&(Integer.parseInt(campoFiltroIdPasta.getObjValue().toString())>0)){
			sql.append(" join ");
			if (CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.ORACLE)){
				sql.append("table(");
			}
			sql.append("f_arvore_pastas(").append(campoFiltroIdPasta.getObjValue().toString()).append(",0,1000)");
			if (CITCorporeUtil.SGBD_PRINCIPAL.trim().toUpperCase().equalsIgnoreCase(SQLConfig.ORACLE)){
				sql.append(")");
			}
			sql.append(" f ON f.idpasta = baseconhecimento.idpasta ");
		}
		
		sql.append(clausulaWhere.toString());
		return sql;
	}

	private StringBuilder tratarCamposRetorno(Collection<Campo> listaCamposRetorno) {
		StringBuilder camposRetorno = new StringBuilder("");
		for (Campo campo : listaCamposRetorno) {
			if (camposRetorno.length() > 0) {
				camposRetorno.append(",");
			}
			if (strSGBDPrincipal.equalsIgnoreCase("SQLSERVER") || strSGBDPrincipal.equalsIgnoreCase("ORACLE")) {
				camposRetorno.append(campo.getNomeFisico().trim().replaceAll("(.+)(?<=\\.)", ""));
			} else {
				camposRetorno.append(campo.getNomeFisico());
			}
		}
		return camposRetorno;
	}
}