package br.com.citframework.service;

import java.util.Collection;

import br.com.citframework.dto.LogDados;
import br.com.citframework.integracao.LogDadosDao;
import br.com.citframework.integracao.core.Page;
import br.com.citframework.integracao.core.Pageable;

/**
 * @author karem.ricarte
 *
 */
@SuppressWarnings("unchecked")
public class LogDadosServiceBean extends CrudServiceImpl implements LogDadosService {

    private LogDadosDao dao;

    @Override
    protected LogDadosDao getDao() {
        if (dao == null) {
            dao = new LogDadosDao(usuario);
        }
        return dao;
    }

    @Override
    public Collection<LogDados> listAllLogs() throws Exception {
        return this.getDao().listAllLogs();
    }

    @Override
    public Collection<LogDados> listLogs(final LogDados log) throws Exception {
        return this.getDao().listLogs(log);
    }

	@Override
	public Collection<LogDados> listLogsWithPagination(final LogDados log) throws Exception {
		return this.getDao().listLogsWithPagination(log);
	}

	@Override
	public Page<LogDados> listarLogsPaginado(final LogDados log, Pageable pageable)
			throws Exception {
		return this.getDao().listarLogsPaginados(log, pageable);
	}

    @Override
    public Collection<LogDados> listNomeTabela() throws Exception {
        return this.getDao().listNomeTabela();
    }

	@Override
	public Collection<LogDados> listNomeTabelaObjetoNegocio() throws Exception {
		return this.getDao().listNomeTabelaObjetoNegocio();
	}

}
