package br.com.citframework.tld;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;

import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilI18N;

public class JanelaAguarde extends BodyTagSupport {

	private static final long serialVersionUID = -6496792382410987252L;
	private String id;
	private String style;
	private String title;

	@Override
	public int doStartTag() throws JspException {
		try {
			pageContext.getOut().println("<script type=\"text/javascript\">\n");

			pageContext.getOut().println("function " + this.getId() + "() { }");

			pageContext.getOut().println("" + this.getId() + ".setTitle = function(titulo) {\n");
			pageContext.getOut().println("    document.getElementById('" + this.getId() + "_titulo').innerHTML = '<b>' + titulo + '</b>';");
			pageContext.getOut().println("}\n\n");

			pageContext.getOut().println("" + this.getId() + ".show = function() {\n");
			pageContext.getOut().println("   document.getElementById('" + this.getId() + "').style.display='block';\n");
			pageContext.getOut().println("   document.getElementById('divBloqueiaTela_" + this.getId() + "').style.display='block';\n");
			pageContext.getOut().println("}\n\n");

			pageContext.getOut().println("" + this.getId() + ".hide = function() {\n");
			pageContext.getOut().println("   document.getElementById('" + this.getId() + "').style.display='none';\n");
			pageContext.getOut().println("   document.getElementById('divBloqueiaTela_" + this.getId() + "').style.display='none';\n");
			pageContext.getOut().println("}\n\n");

			pageContext.getOut().println("</script>\n");

			pageContext.getOut().println("<div id='" + this.getId() + "' style='z-index:999991010;display:none;position: fixed;top: 50%;left: 50%;margin-top: -50px;margin-left: -100px;'>\n");
			pageContext.getOut().println("	<div style='background-color: #fff;border-radius: 5px;padding: 20px;border: 1px solid #d8d8d8;' id='divIntJanelaAguarde_" + this.getId() + "'>\n");
			pageContext.getOut().println("		<table width='100%' bgcolor='#CCCCCC'>\n");
			pageContext.getOut().println("			<tr>\n");
			pageContext.getOut().println("				<td width='100%' id='" + this.getId() + "_titulo' style='text-align:center; backgroundcollor: #CCCCCC;'>" + this.getTitle() + "</td>\n");
			pageContext.getOut().println("			</tr>\n");
			pageContext.getOut().println("		</table>\n");

			pageContext.getOut().println("		<div id='divCorpoJanelaAguarde_" + this.getId() + "'>");
		} catch (final IOException e) {
			throw new JspException(e);
		}
		return EVAL_BODY_INCLUDE;
	}

	@Override
	public int doEndTag() throws JspException {
		try {
			pageContext.getOut().println("			<table width='100%'>");
			pageContext.getOut().println("				<tr>");
			pageContext.getOut().println("					<td style='text-align:center'>");

			final HttpServletRequest request = (HttpServletRequest) pageContext.getRequest();
			pageContext.getOut().println("						<img src='" + Constantes.getValue("SERVER_ADDRESS") + Constantes.getValue("CONTEXTO_APLICACAO") + "/novoLayout/common/include/imagens/ajax-loader.gif' border='0'>&nbsp;&nbsp;" + UtilI18N.internacionaliza(request, "citcorpore.comum.aguarde"));

			pageContext.getOut().println("					</td>");
			pageContext.getOut().println("				</tr>");
			pageContext.getOut().println("			</table>");
			pageContext.getOut().println("		</div>\n");
			pageContext.getOut().println("	</div>\n");
			pageContext.getOut().println("</div>\n");

			// Gera a DIV de Bloqueio da Tela.
			pageContext.getOut().println("<div id='divBloqueiaTela_" + this.getId() + "' style='z-index: 9999910;display: none;position: fixed;cursor: wait;opacity: 0.25;left: 0px;top: 0px;width: 100%;height: 100%;background-color: gray;'></div>");
		} catch (final IOException e) {
			throw new JspException(e);
		}
		return super.doEndTag();
	}

	@Override
	public String getId() {
		return id;
	}

	@Override
	public void setId(final String id) {
		this.id = id;
	}

	public String getStyle() {
		return style;
	}

	public void setStyle(final String style) {
		this.style = style;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(final String title) {
		this.title = title;
	}

}
