package br.com.citframework.util;

import java.io.Serializable;
import java.util.Collection;

import br.com.citframework.dto.ItemValorDescricaoDTO;

public class Campo implements Serializable {

	private static final long serialVersionUID = -3859065156813835430L;

	private String nomeFisico;
	private String descricao;
	private boolean obrigatorio;
	private String type;
	private int tamanho;
	private boolean somenteBusca;
	private String scriptLostFocus;
	private String mesmalinha;
	private String strValue;
	private int intValue;
	private Object objValue;
	private Collection<ItemValorDescricaoDTO> colValores;
	private boolean negacao;
	private String enumClass;
	private String enumMethod;
	private Integer enumParameterType;

	public Campo(){

	}

	public Campo(String nome, String desc, boolean obr, String type, int tam){
		this.setNomeFisico(nome);
		this.setDescricao(desc);
		this.setObrigatorio(obr);
		this.setType(type);
		this.setTamanho(tam);
		this.setMesmalinha(null);
		this.setScriptLostFocus(null);
		this.setColValores(null);
	}
	
	public Campo(String nome, String desc, boolean obr, String type, int tam, Object objValue){
		this.setNomeFisico(nome);
		this.setDescricao(desc);
		this.setObrigatorio(obr);
		this.setType(type);
		this.setTamanho(tam);
		this.setMesmalinha(null);
		this.setObjValue(objValue);
		this.setScriptLostFocus(null);
		this.setColValores(null);
	}

	public String getDescricao() {
		return descricao;
	}

	public void setDescricao(String descricao) {
		this.descricao = descricao;
	}

	public String getNomeFisico() {
		return nomeFisico;
	}

	public void setNomeFisico(String nomeFisico) {
		this.nomeFisico = nomeFisico;
	}

	public boolean isObrigatorio() {
		return obrigatorio;
	}

	public void setObrigatorio(boolean obrigatorio) {
		this.obrigatorio = obrigatorio;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public int getTamanho() {
		return tamanho;
	}

	public void setTamanho(int tamanho) {
		this.tamanho = tamanho;
	}

	public int getIntValue() {
		return intValue;
	}

	public void setIntValue(int intValue) {
		this.intValue = intValue;
	}

	public String getStrValue() {
		return strValue;
	}

	public void setStrValue(String strValue) {
		this.strValue = strValue;
	}

	public Object getObjValue() {
		return objValue;
	}

	public void setObjValue(Object objValue) {
		this.objValue = objValue;
	}

	public boolean isSomenteBusca() {
		return somenteBusca;
	}

	public void setSomenteBusca(boolean somenteBusca) {
		this.somenteBusca = somenteBusca;
	}

	public String getScriptLostFocus() {
		return scriptLostFocus;
	}

	public void setScriptLostFocus(String scriptLostFocus) {
		this.scriptLostFocus = scriptLostFocus;
	}

	public String getMesmalinha() {
		if (mesmalinha == null) {
			return "";
		}
		return mesmalinha;
	}

	public void setMesmalinha(String mesmalinha) {
		this.mesmalinha = mesmalinha;
	}

	public Collection<ItemValorDescricaoDTO> getColValores() {
		return colValores;
	}

	public void setColValores(Collection<ItemValorDescricaoDTO> colValores) {
		this.colValores = colValores;
	}

	public boolean isNegacao() {
		return negacao;
	}

	public void setNegacao(boolean negacao) {
		this.negacao = negacao;
	}

	public String getEnumClass() {
		return enumClass;
	}

	public void setEnumClass(String enumClass) {
		this.enumClass = enumClass;
	}

	public String getEnumMethod() {
		return enumMethod;
	}

	public void setEnumMethod(String enumMethod) {
		this.enumMethod = enumMethod;
	}

	public Integer getEnumParameterType() {
		return enumParameterType;
	}

	public void setEnumParameterType(Integer enumParameterType) {
		this.enumParameterType = enumParameterType;
	}
}
