package br.com.citframework.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import org.apache.log4j.Logger;

import br.com.centralit.citcorpore.util.CITCorporeUtil;

public final class Configuracoes {
	private static final Logger LOGGER = Logger.getLogger(Configuracoes.class);

	private static Configuracoes instance;

	private static Properties prop = new Properties();

	private Configuracoes() {
	}

	private static String arquivoConfiguracao;

	private static void inicializarVariaveis() {

		String serverConf = System.getProperty("jboss.server.config.dir");
		try (InputStream input = new FileInputStream(serverConf + "/" + arquivoConfiguracao)) {

			prop.load(input);

		} catch (final IOException e) {
			LOGGER.error(e.getMessage(), e);

		}

	}

	public String obterPropriedade(final String propriedade) {
		return getProperty(propriedade);
	}

	private String getProperty(final String propriedade) {
		return prop.getProperty(propriedade);
	}


	public static Configuracoes getInstance(String novoArquivoConfiguracao) {
		if (instance == null) {
			instance = new Configuracoes();
			arquivoConfiguracao = novoArquivoConfiguracao;
			inicializarVariaveis();
		}
		return instance;
	}

	public static String getCaminhoComContexto(String caminho) {
		return CITCorporeUtil.CONTEXTO_APLICACAO.concat(caminho);
	}
}
