package br.com.citframework.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import br.com.centralit.citcorpore.bean.PastaDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.negocio.PastaService;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.dto.ItemValorDescricaoDTO;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.tld.FindField;

public class FindFieldUtil {
	private XmlReadLookup xml;
	private LookupInfo lookupInfo;

	private static Properties props;
	private static String habilitaPesquisa;

	public FindFieldUtil() {
		xml = XmlReadLookup.getInstance();
		lookupInfo = null;
	}

	public StringBuilder generate(ServletRequest request, FindField findField) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException {
		return generate(request, findField.getLockupName(), findField.getId(), findField.getHeigth(), findField.getFormName(),
 findField.getJavascriptCode(), findField.getHtmlCode(),
				findField.getCheckbox(), findField.getFormCheckbox(), findField.getDistinct());
	}

	private StringBuilder generate(ServletRequest request, String lockupName, String id, int height, String formName, String javascriptCode,
			String htmlCode, String checkbox, String formCheckbox, String distinct) throws SecurityException, 
			NoSuchMethodException, IllegalArgumentException, IllegalAccessException {
		Collection<Campo> colCamposPesq = getCamposPesquisa(lockupName);
		Iterator<Campo> itCamposPesq = colCamposPesq.iterator();
		Campo cp;
		String separaCampos = "N";
		String nomeLookupExec = lockupName;
		if (id != null) { // Caso venha com ID, o nome fisico  do ID, caso contrario fica com o do LookupName.
			lockupName = id;
		}

		HttpSession session = ((HttpServletRequest) request).getSession();
		if (session.getAttribute("locale") != null) {
			getProperties(new Locale(session.getAttribute("locale").toString()));
		} else {
			getProperties(new Locale("pt"));
		}

		String idAux = id;
		if (idAux == null) {
			idAux = "";
		}

		if (checkbox == null || checkbox.equals("")) {
			checkbox = "false";
		}

		if (UtilStrings.stringVazia(distinct) || distinct.equalsIgnoreCase(Boolean.FALSE.toString())) {
			distinct = "false";
		} else {
			distinct = "true";
		}

		StringBuilder strBuffer = new StringBuilder();
		if (lookupInfo != null) {
			if (lookupInfo.getColScriptRef() != null) {
				Iterator<String> itScriptRef = lookupInfo.getColScriptRef().iterator();
				String strScriptRef = "";
				while (itScriptRef.hasNext()) {
					strScriptRef = itScriptRef.next();
					strBuffer.append("<script type='text/javascript' src='").append(strScriptRef).append("'></script>\n");
				}
			}
			if (lookupInfo.getScript() != null) {
				String strScript = geraScript(lookupInfo.getScript(), colCamposPesq, lockupName, null);
				strBuffer.append("<script type=\"text/javascript\">");
				strBuffer.append(strScript.replaceAll("\\{id=LOOKUPNAME\\}", lockupName));
				strBuffer.append("</script>");
			}
			separaCampos = lookupInfo.getSeparaCampos();
		}
		if (javascriptCode.equalsIgnoreCase("true")) {
			strBuffer.append("<script type=\"text/javascript\">\n");
			strBuffer.append("var req").append(lockupName).append(";\n");
			strBuffer.append("var url").append(lockupName).append(";\n");
			strBuffer.append("function mostrar_").append(lockupName).append("() {\n");
			cp = itCamposPesq.next();
			strBuffer.append("   ").append(lockupName).append("_ajustaDivResultado(document.getElementById('retPesq").append(lockupName).append("'));\n");
			strBuffer.append("} \n");
			strBuffer.append("function ").append(lockupName).append("_ajustaDivResultado (dvResult) {\n");
			strBuffer.append("   if (isMozilla){\n");
			strBuffer.append("   	var dvResultTop = dvResult.offsetTop;\n");
			strBuffer.append("  	var dvLookup = document.getElementById('divInt").append(lockupName).append("');\n");
			strBuffer.append("   	var h = dvResultTop + 2;\n");
			strBuffer.append("   	dvResult.style.height = ").append(height).append("- h;\n");
			strBuffer.append("   }else{\n");
			strBuffer.append("   	var dvResultTop = dvResult.offsetTop;\n");
			strBuffer.append("  	var dvLookup = document.getElementById('divInt").append(lockupName).append("');\n");
			strBuffer.append("   	var h = dvResultTop + 2;\n");
			strBuffer.append("   	dvResult.style.height = ").append(height).append("- h;\n");
			strBuffer.append("   }\n");
			strBuffer.append("} \n");
			strBuffer.append("addEvent(window, \"load\", mostrar_").append(lockupName).append(", false);");
			strBuffer.append("</script>\n");
		}

		int i = 1;
		StringBuilder nomeFisicoAux = new StringBuilder("");
		if (htmlCode.equalsIgnoreCase("true")) {
			strBuffer.append("<div class='lockupEstrutura' id='divInt").append(lockupName).append("'>");
			strBuffer.append("<table width=\"50%\">");
			itCamposPesq = colCamposPesq.iterator();
			String asteristica = "";
			while (itCamposPesq.hasNext()) {
				cp = itCamposPesq.next();
				if(i == 1){
					nomeFisicoAux.append(cp.getNomeFisico());
					String[] trataNome = nomeFisicoAux.toString().split("\\.");
					if (trataNome.length > 1) {
						nomeFisicoAux.delete(0, nomeFisicoAux.length());
						nomeFisicoAux.append(trataNome[0]).append("_").append(trataNome[1]);
					}
					i++;
				}
				if (!cp.getMesmalinha().equalsIgnoreCase("fim") && !cp.getMesmalinha().equalsIgnoreCase("meio")) {
					strBuffer.append("<tr>");
					strBuffer.append("<td style=\"font-weight:bold\">");
				}
				strBuffer.append("<label class='pesqLockupDesc'><strong>");
				if (cp.getType().equalsIgnoreCase("HIDDEN")) {
					strBuffer.append("");
				} else {
					strBuffer.append(cp.getDescricao());
				}

				if (cp.isObrigatorio()) {
					asteristica = "<font color='red'>*</font>";
					strBuffer.append(asteristica);
				}
				if (cp.getType().equalsIgnoreCase("HIDDEN")) {
					strBuffer.append("");
				} else {
					strBuffer.append(":");
				}

				strBuffer.append("</strong></label>");
				if (!cp.getMesmalinha().equalsIgnoreCase("fim") && !cp.getMesmalinha().equalsIgnoreCase("meio")) {
					strBuffer.append("</td>");
					strBuffer.append("<td style=\"font-weight:bold\">");
				}
				habilitaPesquisa = (String)((HttpServletRequest)request).getSession().getAttribute("habilitaPesquisa");
				strBuffer.append(geraCampo(cp.getType(), cp.getTamanho(), cp.getNomeFisico(), cp.getScriptLostFocus(), lockupName,
						colCamposPesq, cp.getColValores(), cp.isObrigatorio(), cp.getDescricao(),(HttpServletRequest)request));
				if (!cp.getMesmalinha().equalsIgnoreCase("inicio") && !cp.getMesmalinha().equalsIgnoreCase("meio")) {
					strBuffer.append("</td>");
					strBuffer.append("</tr>");
				}
				asteristica = "";
			}
			((HttpServletRequest)request).getSession().setAttribute("habilitaPesquisa", "");
			habilitaPesquisa = "";
			strBuffer.append("</table>");
			strBuffer.append("<hr />");
			strBuffer.append("<div class='lockupCampoBotoes'>");
			strBuffer.append("<input title='").append(UtilI18N.internacionaliza((HttpServletRequest) request, "citcorpore.ui.botao.rotulo.Pesquisar")).append("' type='button' name='btn").append(lockupName)
			                                  .append( "' id='btnPesquisar' class='ui-button ui-widget ui-corner-all ui-button-text-only btn btn-primary' value='")
			                                  .append(UtilI18N.internacionaliza((HttpServletRequest) request, "citcorpore.ui.botao.rotulo.Pesquisar")).append("' onclick='pesq_").append(lockupName).append("()' />");
			strBuffer.append("<input title='").append(UtilI18N.internacionaliza((HttpServletRequest) request, "citcorpore.ui.botao.rotulo.Limpar")).append("' type='button' name='btnLimpar").append(lockupName)
											  .append("'  id='btnLimpar' class='ui-button ui-widget ui-corner-all ui-button-text-only btn btn-primary' value='")
											  .append(UtilI18N.internacionaliza((HttpServletRequest) request, "citcorpore.ui.botao.rotulo.Limpar")).append("' onclick='limpar_").append(lockupName).append("()' />");
			// caso seja checkbox aparece o boto de enviar checkados
			if (checkbox != null && checkbox.equals("true")){
				strBuffer.append("<input type='button' name='btnEnviar' id='btnEnviar' class='ui-button ui-widget ui-corner-all ui-button-text-only btn btn-primary' value='").append(getInternacionalizado("citSmart.comum.enviar"))
						 .append("' title='").append(getInternacionalizado("citSmart.comum.enviar")).append("' onclick='addAllTabela").append(lockupName).append("();'/>");
			}
			strBuffer.append("</div>");
			strBuffer.append("<div class='ui-dialog-content ui-widget-content ui-corner-all lockupResPesq' style='overflow: auto' id='retPesq").append(lockupName).append("' >");
			strBuffer.append("</div>");
			strBuffer.append("</div>");
		}

		if (javascriptCode.equalsIgnoreCase("true")) {
			strBuffer.append("<script>\n");
			strBuffer.append("function limpar_").append(lockupName).append("(){\n");
			strBuffer.append("   HTMLUtils.clearFormExceptHidden(document.").append(formName).append(");\n");
			strBuffer.append("   if(document.getElementById('retPesq").append(lockupName).append("') != null){\n");
			strBuffer.append("        document.getElementById('retPesq").append(lockupName).append("').innerHTML = '&nbsp;';\n");
			strBuffer.append("   }\n");
			strBuffer.append("   document.").append(formName).append(".pesqLockup").append(lockupName).append("_").append(nomeFisicoAux.toString()).append(".focus();\n");
			strBuffer.append("}\n");

			strBuffer.append("function pesqTodos_").append(lockupName).append(" (){");
			strBuffer.append("  limpar_").append(lockupName).append("();");
			strBuffer.append("  document.getElementById('retPesq").append(lockupName).append("').innerHTML = '").append(getInternacionalizado("citcorpore.comum.processando_pesquisa")).append("'; ");
			strBuffer.append("  pesq_").append(lockupName).append("();");
			strBuffer.append("}\n");
			strBuffer.append("var dadosUrl = '';\n");
			strBuffer.append("function pesq_").append(lockupName).append("(){\n");

			strBuffer.append("if (document.").append(formName).append(".validate()){\n");

			strBuffer.append("document.getElementById('retPesq").append(lockupName).append("').innerHTML = '").append(getInternacionalizado("citcorpore.comum.processando_pesquisa")).append("'; ");
			strBuffer.append("req").append(lockupName).append(" = AjaxUtils.defineBrowserAJAX(); ");
			strBuffer.append("req").append(lockupName).append(".onreadystatechange = process_").append(lockupName).append("; ");
			// Processa os campos de pesquisa e atribui os valores p/ chamar o Action
			int count = 1;
			itCamposPesq = colCamposPesq.iterator();
			while (itCamposPesq.hasNext()) {
				cp = itCamposPesq.next();
				if (cp.getType().equalsIgnoreCase(Constantes.getValue("FIELDTYPE_TEXT").trim()) || cp.getType().equalsIgnoreCase(Constantes.getValue("FIELDTYPE_TEXTAREA").trim())
						|| cp.getType().equalsIgnoreCase(Constantes.getValue("FIELDTYPE_COMBO").trim()) || cp.getType().equalsIgnoreCase("NUMBER") || cp.getType().equalsIgnoreCase("DATE")
						|| cp.getType().equalsIgnoreCase(Constantes.getValue("FIELDTYPE_COMBO_PASTAS_CONHECIMENTO").trim())
						|| cp.getType().equalsIgnoreCase("HIDDEN")) {
					strBuffer.append("var valor").append(lockupName).append(count).append(" = ")
												 .append("processaCaracteresEspeciais(")
												 .append("document.").append(formName).append(".").append(geraNomeCampo(cp.getType(), cp.getNomeFisico(), lockupName)).append(".value").append(");");
				}
				count++;
			}

			strBuffer.append("  var nocache").append(lockupName).append(" = new Date();");
			strBuffer.append("	var url").append(lockupName).append(" = 'ProcessarLookup.find?acao=process&paginacao=0&nomeLookup=").append(nomeLookupExec).append("&id=").append(idAux).append("&checkbox=").append(checkbox).append("&distinct=").append(distinct);
			strBuffer.append("&whereDinamico='+encodeURIComponent(document.").append(formName).append(".whereDinamico)+'");
			for (int iAux = 1; iAux < count; iAux++) {
				strBuffer.append("&parm").append(iAux).append("='+encodeURIComponent(valor").append(lockupName).append(iAux).append(")+'");
			}
			int icAux = count - 1;
			strBuffer.append("&parmCount=").append(icAux);
			strBuffer.append("&nocache=' + nocache").append(lockupName).append("; \n");
			strBuffer.append("	req").append(lockupName).append(".open('GET', url").append(lockupName).append(", true); ");
			strBuffer.append("	req").append(lockupName).append(".setRequestHeader('Cache-Control', 'no-store, no-cache, must-revalidate'); ");
			strBuffer.append("	req").append(lockupName).append(".setRequestHeader('Cache-Control', 'post-check=0, pre-check=0'); ");
			strBuffer.append("	req").append(lockupName).append(".setRequestHeader('Pragma', 'no-cache'); ");
			strBuffer.append("  req").append(lockupName).append(".send(''); ");
			strBuffer.append("} \n");
			strBuffer.append("} \n");
			strBuffer.append("</script>\n");

			strBuffer.append("<script>\n");
			strBuffer.append("function process_").append(lockupName).append(" (){\n");
			strBuffer.append("	if (req").append(lockupName).append(".readyState == 4){\n");
			strBuffer.append("		if (req").append(lockupName).append(".status == 200){\n");
			strBuffer.append("			document.getElementById('retPesq").append(lockupName).append("').innerHTML = req").append(lockupName).append(".responseText;\n");
			// chamar a funo de verificao de checkados aps a consulta do paginao chegar ao estado 4(completa)
			strBuffer.append("			memorizarCheckados").append(lockupName).append("();\n" );
			strBuffer.append("		}\n");
			strBuffer.append("	}\n");
			strBuffer.append("} \n");
			strBuffer.append("function semAspas(ie, ff) { if (ie) { tecla = ie; } else { tecla = ff;} \n");
			strBuffer.append("if (tecla != 13) { return true; }else { return false; }} \n");
			strBuffer.append("</script>\n");

			// funcao paginacao
			strBuffer.append("<script>\n");
			strBuffer.append("function paginacao").append(lockupName).append("(pag){\n");
			strBuffer.append("document.getElementById('retPesq").append(lockupName).append("').innerHTML = '").append(getInternacionalizado("citcorpore.comum.processando_paginacao")).append("'; ");
			strBuffer.append("req").append(lockupName).append(" = AjaxUtils.defineBrowserAJAX(); ");
			strBuffer.append("req").append(lockupName).append(".onreadystatechange = process_").append(lockupName).append("; ");
			count = 1;
			itCamposPesq = colCamposPesq.iterator();
			while (itCamposPesq.hasNext()) {
				cp = itCamposPesq.next();
				if (cp.getType().equalsIgnoreCase(Constantes.getValue("FIELDTYPE_TEXT").trim()) || cp.getType().equalsIgnoreCase(Constantes.getValue("FIELDTYPE_TEXTAREA").trim())
						|| cp.getType().equalsIgnoreCase(Constantes.getValue("FIELDTYPE_COMBO").trim())
						|| cp.getType().equalsIgnoreCase(Constantes.getValue("FIELDTYPE_COMBO_PASTAS_CONHECIMENTO").trim())
						|| cp.getType().equalsIgnoreCase("NUMBER") || cp.getType().equalsIgnoreCase("DATE")
						|| cp.getType().equalsIgnoreCase("HIDDEN")) {
					strBuffer.append("var valor").append(lockupName).append(count).append("=document.").append(formName).append(".").append(geraNomeCampo(cp.getType(), cp.getNomeFisico(), lockupName)).append(".value; ");
				}
				count++;
			}
			strBuffer.append("  var nocache").append(lockupName).append(" = new Date();");
			strBuffer.append("	var url").append(lockupName).append(" = 'ProcessarLookup.find?acao=process&paginacao='+pag+'&nomeLookup=").append(nomeLookupExec).append("&id=").append(idAux).append("&checkbox=").append(checkbox).append("&distinct=").append(distinct);
			strBuffer.append("&whereDinamico='+encodeURIComponent(document.").append(formName).append(".whereDinamico)+'");
			for (int iAux = 1; iAux < count; iAux++) {
				strBuffer.append("&parm").append(iAux).append("='+valor").append(lockupName).append(iAux).append("+'");
			}
			icAux = count - 1;
			strBuffer.append("&parmCount=").append(icAux);
			strBuffer.append("&nocache=' + nocache").append(lockupName).append("; \n");
			strBuffer.append("	req").append(lockupName).append(".open('GET', url").append(lockupName).append(", true); ");
			strBuffer.append("	req").append(lockupName).append(".setRequestHeader('Cache-Control', 'no-store, no-cache, must-revalidate'); ");
			strBuffer.append("	req").append(lockupName).append(".setRequestHeader('Cache-Control', 'post-check=0, pre-check=0'); ");
			strBuffer.append("	req").append(lockupName).append(".setRequestHeader('Pragma', 'no-cache'); ");
			strBuffer.append("  req").append(lockupName).append(".send(''); ");
			strBuffer.append("}\n");
			strBuffer.append("</script>\n");
			// montando a funo que marca todos os checkbox da poppup que tem class=check
			strBuffer.append("<script type=\"text/javascript\">");
	        strBuffer.append("function ").append(lockupName).append("_marcarTodosCheckbox(selecionado) {");
	        strBuffer.append("	var classe = 'check';");
	        strBuffer.append("	if (!$(selecionado).is(':checked')) {");
	        strBuffer.append("		$('form[name=").append(formName).append("] .' + classe).each(function() {");
	        strBuffer.append("			$(this).attr('checked', false);");
	        strBuffer.append("			concatenarValoresCheckados_").append(lockupName).append("(this);");
	        strBuffer.append("		});");
	        strBuffer.append("	}else {");
	        strBuffer.append("		$('form[name=").append(formName).append("] .' + classe).each(function() {");
	        strBuffer.append("			if ($(this).is(':checked')) return true;");
	        strBuffer.append("			$(this).attr('checked', true);");
	        strBuffer.append("			concatenarValoresCheckados_").append(lockupName).append("(this);");
	        strBuffer.append("		});");
	        strBuffer.append("		};");
	        strBuffer.append("};\n");
	        strBuffer.append("</script>");
			strBuffer.append("<script>\n");
			String retParms = "";
			// funo que concatena e desconcatena os checkbox que marcados ou desmarcados
			strBuffer.append("var checkados_").append(lockupName).append(" = '' ;\n");
			strBuffer.append("function concatenarValoresCheckados_").append(lockupName).append("(elemento) {\n");
			strBuffer.append("	if (!$(elemento).is(':checked')) {\n");
			strBuffer.append("		if($(elemento).attr('name') != 'selTodosPagina')\n");
			strBuffer.append("			$('[name=selTodosPagina]').attr('checked', false);\n");
			strBuffer.append("		checkadosArray = checkados_").append(lockupName).append(".split(\";\");\n");
			strBuffer.append("		checkados_").append(lockupName).append(" = '' \n");
			strBuffer.append("		for(var i = 0; i < checkadosArray.length; i++){\n");
			strBuffer.append("			if (checkadosArray[i] == elemento.value){\n");
			strBuffer.append("				checkadosArray[i] = '';\n");
			strBuffer.append("			}\n");
			strBuffer.append("		}\n");
			strBuffer.append("		for (var i = 0; i < checkadosArray.length; i++){\n");
			strBuffer.append("			if(checkadosArray[i] != ''){\n");
			strBuffer.append("				checkados_").append(lockupName).append(" +=checkadosArray[i]+';';\n");
			strBuffer.append("			}\n");
			strBuffer.append("		}\n");
			strBuffer.append("	}else {\n");
			strBuffer.append("		checkados_").append(lockupName).append(" += elemento.value+';';\n");
			strBuffer.append("		}\n");
			strBuffer.append("}\n");
			// Funo que enviar todos os checkbox checkados e chama um mtodo requisicaoMudanca.java
			String[] nomePopup = lockupName.split("LOOKUP");

			if (UtilStrings.stringVazia(formCheckbox)) {
				formCheckbox = "form";
			}

			strBuffer.append("addAllTabela").append(lockupName).append(" = function(){\n");
			strBuffer.append("	document.").append(formCheckbox).append(".colAll").append(lockupName).append(".value = checkados_").append(lockupName).append(";\n");
			strBuffer.append("	document.").append(formCheckbox).append(".fireEvent(\"adicionaTabela").append(lockupName).append("\");\n");
			strBuffer.append("	fecharPopup").append(nomePopup[1]).append("();\n");
			strBuffer.append(" }\n");
			strBuffer.append("function fecharPopup").append(nomePopup[1]).append("(){");
			strBuffer.append("	$('#POPUP").append(nomePopup[1]).append("').dialog('close');");
			strBuffer.append("	checkados_").append(lockupName).append("=''");
			strBuffer.append("}");
			// Funo necessria para quando o usuario mudar de pgina o checkbox continue marcado.
			strBuffer.append("function memorizarCheckados").append(lockupName).append("(){");
			strBuffer.append("	table = document.getElementById('topoRetorno');");
			strBuffer.append("	itens = document.getElementsByName('sel');");
			strBuffer.append("	checkTodosPagina = document.getElementsByName('selTodosPagina');");
			strBuffer.append("	count = 0;");
			strBuffer.append("	var ids = checkados_").append(lockupName).append(".split(';');");
			strBuffer.append("	for(i=0; i< itens.length; i++){");
			strBuffer.append("		for (y=0; y< ids.length; y++){");
			strBuffer.append("			if(itens[i].value == ids[y]){");
			strBuffer.append("				itens[i].checked = true;");
			strBuffer.append("				count += 1;");
			strBuffer.append("				break;");
			strBuffer.append("			}");
			strBuffer.append("		}");
			strBuffer.append("	}");
			strBuffer.append("	if (itens.length == count? $(checkTodosPagina).attr('checked', true) : $(checkTodosPagina).attr('checked', false));");
			strBuffer.append("}");
			if (SimNao.SIM.getValorStr().equalsIgnoreCase(separaCampos)) {
				strBuffer.append("function setRetorno_").append(lockupName).append(" (id");
				Collection<Campo> colRet = getCamposRetorno(lockupName);
				for (int x = 1; x < colRet.size(); x++) {
					retParms += ",ret" + x;
				}
				strBuffer.append(retParms);
				strBuffer.append("){\n");
			} else {
				strBuffer.append("function setRetorno_").append(lockupName).append(" (id,ret1){");
			}
			if (SimNao.SIM.getValorStr().equalsIgnoreCase(separaCampos)) {
				strBuffer.append("if (").append(lockupName).append("_select.length==2){");
				strBuffer.append(lockupName).append("_select(id,ret1);");
				strBuffer.append("}else{");
				strBuffer.append(lockupName).append("_select(id").append(retParms).append(");");
				strBuffer.append("}");
				strBuffer.append("  limpar_").append(lockupName).append("();");
			} else {
				strBuffer.append(lockupName).append("_select(id,ret1);");
				strBuffer.append("  limpar_").append(lockupName).append("();");
			}
			strBuffer.append("} ");
			strBuffer.append("</script>\n");

			/**
			 * Funo para processar caracteres na string
			 * 22/12/2014
			 * 
			 * @author thyen.chang
			 */
			strBuffer.append("<script>\n");
			strBuffer.append("function processaCaracteresEspeciais(texto){\n");
			strBuffer.append("	var aux = \"\";\n");
			strBuffer.append("	var caracteresEspeciais = \"%\";\n");
			strBuffer.append("	if(texto !== null && texto !== undefined)\n");
			strBuffer.append("		for(var i = 0; i < texto.length; i++)\n");
			strBuffer.append("			if(caracteresEspeciais.indexOf(texto[i]) > -1)\n");
			strBuffer.append("				aux += \"\\\\\" + texto[i];\n");
			strBuffer.append("			else\n");
			strBuffer.append("				aux += texto[i];\n");
			strBuffer.append("	return aux;\n");
			strBuffer.append("}\n");
			strBuffer.append("</script>\n");
		}
		return strBuffer;
	}

	public Collection<Campo> getCamposPesquisa(String nameLookup) {
		if (lookupInfo == null) {
			lookupInfo = xml.getLookup(nameLookup);
		}

		return lookupInfo.getColCamposPesquisa();
	}

	public Collection<Campo> getCamposRetorno(String nameLookup) {
		if (lookupInfo == null) {
			lookupInfo = xml.getLookup(nameLookup);
		}

		return lookupInfo.getColCamposRetorno();
	}

	public Collection<Campo> getCamposOrdenacao(String nameLookup) {
		if (lookupInfo == null) {
			lookupInfo = xml.getLookup(nameLookup);
		}

		return lookupInfo.getColCamposOrdenacao();
	}

	public Collection<Campo> getCamposChave(String nameLookup) {
		if (lookupInfo == null) {
			lookupInfo = xml.getLookup(nameLookup);
		}

		return lookupInfo.getColCamposChave();
	}

	public String getDaoProcessor(String nameLookup) {
		if (lookupInfo == null) {
			lookupInfo = xml.getLookup(nameLookup);
		}
		return lookupInfo.getDaoProcessor();
	}

	public String getTabela(String nameLookup) {
		if (lookupInfo == null) {
			lookupInfo = xml.getLookup(nameLookup);
		}
		return lookupInfo.getTabela();
	}

	public String getSeparaCampos(String nameLookup) {
		if (lookupInfo == null) {
			lookupInfo = xml.getLookup(nameLookup);
		}
		return lookupInfo.getSeparaCampos();
	}

	public String getWhere(String nameLookup) {
		if (lookupInfo == null) {
			lookupInfo = xml.getLookup(nameLookup);
		}
		return lookupInfo.getWhere();
	}

	public String geraCampo(String type, int tam, String nome, String scriptLostFocus, String nameLookup, Collection<Campo> colCamposPesq,
			Collection<ItemValorDescricaoDTO> colValores, boolean valid, String validDesc, HttpServletRequest request) {
		StringBuilder result = new StringBuilder("");
		String[] trataNome = nome.split("\\.");
		String classObrigatorio = "";
		if (trataNome.length > 1) {
			nome = trataNome[0] + "_" + trataNome[1];
		}
		if (valid) {
			classObrigatorio = " Valid[Required] Description[" + validDesc + "] ";
		}
		if (type.equalsIgnoreCase(Constantes.getValue("FIELDTYPE_TEXT").trim()) || type.equalsIgnoreCase("NUMBER") || type.equalsIgnoreCase("DATE")) {
			if (type.equalsIgnoreCase("NUMBER")) {
				classObrigatorio += " Format[numero] ";
			}
			if (type.equalsIgnoreCase("DATE")) {
				classObrigatorio += " Format[data] datepiker ";
			}
			if (scriptLostFocus == null) {
				scriptLostFocus = "";
			}

			String functionName = "";
			if (!scriptLostFocus.trim().equalsIgnoreCase("")) {
				functionName = "scriptLostFocus_" + nameLookup + "_" + nome;
				result.append("<script>");
				result.append("self.").append(functionName).append(" = function(objeto, id){");
				result.append(geraScript(scriptLostFocus, colCamposPesq, nameLookup, nome));
				result.append("}");
				result.append("</script>");
			}

			String disabled = "";
			if(habilitaPesquisa != null && habilitaPesquisa.equalsIgnoreCase(SimNao.SIM.getValorStr())){
				disabled = "disabled = 'disabled' ";
			}

			if (!functionName.equalsIgnoreCase("")) {
				result.append("<input onkeydown=\"if ( event.keyCode == 13 ) pesq_").append(nameLookup).append("();\" class='ui-widget ui-state-default texto ").append(classObrigatorio).append("' type='text' name='pesqLockup")
					  .append(nameLookup).append("_").append(nome).append("' id='pesqLockup").append(nameLookup).append("_").append(nome).append("' size='").append(tam).append("' maxlength='").append(tam)
					  .append("' onkeypress='return semAspas(event.keyCode, event.which);' onblur='").append(functionName).append("(this, \"pesqLockup").append(nameLookup).append("_").append(nome).append("\");' ").append(disabled).append(">");
			} else {
				result.append("<input onkeydown=\"if ( event.keyCode == 3 || event.keyCode == 13 ){event.keyCode = 3; pesq_").append(nameLookup).append("();}\" class='ui-widget ui-state-default texto ")
					  .append(classObrigatorio).append("' type='text' name='pesqLockup").append(nameLookup).append("_").append(nome).append("' id='pesqLockup").append(nameLookup).append("_").append(nome).append("' size='").append(tam).append("' maxlength='").append(tam)
					  .append("' onkeypress='return semAspas(event.keyCode, event.which);' ").append(disabled).append(">");
			}
			if (type.equalsIgnoreCase("DATE")) {
				result.append("\n<script>\n")
					  .append("window.setTimeout(function(){")
					  .append("addEvent(document.getElementById('pesqLockup").append(nameLookup).append("_").append(nome).append("'),\n")
					  .append("		\"keydown\",\n")
				  .append("		DEFINEALLPAGES_formataData,\n")
				  .append("		false);}, 3000);\n")
				  .append("window.setTimeout(function(){")
				  .append("addEvent(document.getElementById('pesqLockup").append(nameLookup).append("_").append(nome).append("'),\n")
				  .append("		\"blur\",\n")
				  .append("		DEFINEALLPAGES_formataData,\n")
				  .append("		false);\n")
				  .append("addEvent(document.getElementById('pesqLockup").append(nameLookup).append("_").append(nome).append("'),\n")
				  .append("		\"blur\",\n")
				  .append("		function(){ValidacaoUtils.validaData(document.getElementById('pesqLockup").append(nameLookup).append("_").append(nome).append("'), 'Campo de pesquisa: ')},\n")
				  .append("		false);\n")
				  .append("		}, 3000);\n")
				  .append("</script>\n");
			}
		} else if (type.equalsIgnoreCase("HIDDEN")) {
			result.append("<input type='hidden' name='pesqLockup").append(nameLookup).append("_").append(nome).append("' id='pesqLockup").append(nameLookup).append("_").append(nome).append("'>");
		} else if (type.equalsIgnoreCase(Constantes.getValue("FIELDTYPE_COMBO").trim())) {
			if (scriptLostFocus == null) {
				scriptLostFocus = "";
			}

			String functionName = "";
			if (!scriptLostFocus.trim().equalsIgnoreCase("")) {
				functionName = "scriptLostFocus_" + nameLookup + "_" + nome;
				result.append("<script>\n")
					  .append("function ").append(functionName).append("(objeto, id){\n")
					  .append(geraScript(scriptLostFocus, colCamposPesq, nameLookup, nome))
					  .append("\n}\n")
					  .append("</script>\n");
			}

			if (!functionName.equalsIgnoreCase("")) {
				result.append("<select class='ui-widget ui-state-default texto ").append(classObrigatorio).append("' name='pesqLockup").append(nameLookup).append("_").append(nome).append("' id='pesqLockup").append(nameLookup).append("_").append(nome)
					  .append("' onkeypress='").append(nameLookup).append("_validaEnter(this,event)' onchange='").append(functionName).append("(this, \"pesqLockup").append(nameLookup).append("_").append(nome).append("\");'>");
			} else {
				result.append("<select class='ui-widget ui-state-default texto ").append(classObrigatorio).append("' name='pesqLockup").append(nameLookup).append("_").append(nome).append("' id='pesqLockup").append(nameLookup).append("_").append(nome)
					  .append("' onkeypress='").append(nameLookup).append("_validaEnter(this,event)'>");
			}

			if (colValores != null) {
				for (Iterator<ItemValorDescricaoDTO> it = colValores.iterator(); it.hasNext();) {
					ItemValorDescricaoDTO itemValorDescricaoDTO = it.next();
					result.append("<option value=\"").append(itemValorDescricaoDTO.getValor()).append("\">").append(getInternacionalizado(itemValorDescricaoDTO.getDescricao())).append("</option>");
				}
			}
			result.append("</select>");
		} else if (type.equalsIgnoreCase(Constantes.getValue("FIELDTYPE_COMBO_PASTAS_CONHECIMENTO").trim())) {
			if (scriptLostFocus == null) {
				scriptLostFocus = "";
			}

			String functionName = "";
			if (!scriptLostFocus.trim().equalsIgnoreCase("")) {
				functionName = "scriptLostFocus_" + nameLookup + "_" + nome;
				result.append("<script>\n")
					  .append("function ").append(functionName).append("(objeto, id){\n")
					  .append(geraScript(scriptLostFocus, colCamposPesq, nameLookup, nome))
					  .append("\n}\n")
					  .append("</script>\n");
			}

			if (!functionName.equalsIgnoreCase("")) {
				result.append("<select class='ui-widget ui-state-default texto ").append(classObrigatorio).append("' name='pesqLockup").append(nameLookup).append("_").append(nome).append("' id='pesqLockup").append(nameLookup).append("_").append(nome)
					  .append("' onkeypress='").append(nameLookup).append("_validaEnter(this,event)' onchange='").append(functionName).append("(this, \"pesqLockup").append(nameLookup).append("_").append(nome).append("\");'>");
			} else {
				result.append("<select class='ui-widget ui-state-default texto ").append(classObrigatorio).append("' name='pesqLockup").append(nameLookup).append("_").append(nome).append("' id='pesqLockup").append(nameLookup).append("_").append(nome)
					  .append("' onkeypress='").append(nameLookup).append("_validaEnter(this,event)'>");
			}

			UsuarioDTO usuario = WebUtil.getUsuario(request);
			PastaService pastaService;
			try {
				pastaService = (PastaService) ServiceLocator.getInstance().getService(PastaService.class, null);
				List<PastaDTO> listaPastas =  (List<PastaDTO>) pastaService.listPastasESubpastas(usuario);
				if (listaPastas != null) {
					if (listaPastas.size()>0){
						if (listaPastas.size()>1){
							result.append("<option value=\"").append("0").append("\">").append(getInternacionalizado("citcorpore.comum.todas")).append("</option>");
						}
						for (PastaDTO pastaDTO : listaPastas) {
							result.append("<option value=\"").append(pastaDTO.getId()).append("\">").append(getInternacionalizado(pastaDTO.getNome())).append("</option>");
						}
					} else {
						result.append("<option value=\"").append("0").append("\">").append(getInternacionalizado("citcorpore.comum.todas")).append("</option>");
					}
				} else {
					result.append("<option value=\"").append("0").append("\">").append(getInternacionalizado("citcorpore.comum.todas")).append("</option>");
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
			result.append("</select>");
		}
		return result.toString();
	}

	public String geraNomeCampo(String type, String nome, String nameLookup) {
		String nomeAux = nome;
		String[] trataNome = nome.split("\\.");
		if (trataNome.length > 1) {
			nomeAux = trataNome[0] + "_" + trataNome[1];
		}

		StringBuilder result = new StringBuilder("");
		if (type.equalsIgnoreCase(Constantes.getValue("FIELDTYPE_TEXT").trim()) || type.equalsIgnoreCase(Constantes.getValue("FIELDTYPE_COMBO").trim())
				|| type.equalsIgnoreCase(Constantes.getValue("FIELDTYPE_COMBO_PASTAS_CONHECIMENTO").trim())
				|| type.equalsIgnoreCase("HIDDEN")
				|| type.equalsIgnoreCase("NUMBER") || type.equalsIgnoreCase("DATE")) {
			result.append("pesqLockup").append(nameLookup).append("_").append(nomeAux);
		}
		return result.toString();
	}

	public String geraScript(String script, Collection<Campo> colCamposPesq, String nameLookup, String nome) {
		if (colCamposPesq == null) {
			return script;
		}
		Iterator<Campo> it = colCamposPesq.iterator();
		Campo campo;
		String scriptRetorno = script;
		while (it.hasNext()) {
			campo = it.next();
			scriptRetorno = scriptRetorno.replaceAll("\\{id=" + campo.getNomeFisico() + "\\}", "'pesqLockup" + nameLookup + "_" + nome + "'");
		}
		scriptRetorno = scriptRetorno.replaceAll("\\{id=LOOKUPNAME\\}", nameLookup);
		scriptRetorno = scriptRetorno.replaceAll("SUBMITLOOKUP", "pesq_" + nameLookup + "()");
		scriptRetorno = scriptRetorno.replaceAll("\\\\n", "" + '\n');
		return scriptRetorno;
	}

	private String getInternacionalizado(String texto) {
		String traduzido = props.getProperty(texto);
		if (traduzido == null || traduzido.length() <= 0) {
			traduzido = texto;
		}
		return traduzido;
	}

	private void getProperties(Locale locale) {
		String fileName = "";
		try {

			/**
			 * @author gilberto.nery
			 * @since 18/11/2015
			 *
			 *        Se o locale contiver pt ou br (no keysensitive) ser considerado como portugues do Brasil
			 *
			 */
			if (locale != null && !locale.toString().equals("") && !locale.toString().equalsIgnoreCase("pt") && !locale.toString().equalsIgnoreCase("BR")) {
				fileName = "Mensagens_" + locale.toString() + ".properties";
			} else {
				fileName = "Mensagens.properties";
			}

			props = new Properties();
			ClassLoader load = Mensagens.class.getClassLoader();
			InputStream is = load.getResourceAsStream(fileName);
			if (is == null) {
				is = ClassLoader.getSystemResourceAsStream(fileName);
			}
			if (is == null) {
				is = ClassLoader.getSystemClassLoader().getResourceAsStream(fileName);
			}

			try {
				if (is != null) {
					props.load(is);
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		} catch (SecurityException e1) {
			e1.printStackTrace();
		}
	}

}