package br.com.citframework.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.citframework.dto.ItemValorDescricaoDTO;
import br.com.citframework.tld.Search;

public class SearchUtil {
	private XmlReadLookup xml;
	private LookupInfo lookupInfo;

	private static Properties props;
	private static String habilitaPesquisa;

	public SearchUtil() {
		xml = XmlReadLookup.getInstance();
		lookupInfo = null;
	}

	public StringBuilder generate(ServletRequest request, Search search) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException {
		return generate(request, search.getSearchName(), search.getId(), search.getHeigth(), search.getFormName(), search.getJavascriptCode(), search.getHtmlCode(), search.getCheckbox(), search.getFormCheckbox(), search.getDistinct());
	}

	private StringBuilder generate(ServletRequest request, String searchName, String id, int height, String formName, String javascriptCode, String htmlCode, String checkbox, String formCheckbox, String distinct) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException {
		Collection<Campo> colCamposPesq = getCamposPesquisa(searchName);
		Iterator<Campo> itCamposPesq = colCamposPesq.iterator();
		Campo cp;
		String separaCampos = "N";
		String nomeLookupExec = searchName;
		if (id != null) { // Caso venha com ID, o nome fisico  do ID, caso contrario fica com o do LookupName.
			searchName = id;
		}

		HttpSession session = ((HttpServletRequest) request).getSession();
		if (session.getAttribute("locale") != null) {
			getProperties(new Locale(session.getAttribute("locale").toString()));
		} else {
			getProperties(new Locale("pt"));
		}

		String idAux = id;
		if (idAux == null) {
			idAux = "";
		}

		if (checkbox == null || checkbox.equals("")) {
			checkbox = "false";
		}

		if (UtilStrings.stringVazia(distinct) || distinct.equalsIgnoreCase(Boolean.FALSE.toString())) {
			distinct = "false";
		} else {
			distinct = "true";
		}

		StringBuilder strBuffer = new StringBuilder();
		if (lookupInfo != null) {
			if (lookupInfo.getColScriptRef() != null) {
				Iterator<String> itScriptRef = lookupInfo.getColScriptRef().iterator();
				String strScriptRef = "";
				while (itScriptRef.hasNext()) {
					strScriptRef = itScriptRef.next();
					strBuffer.append("<script type='text/javascript' src='" + strScriptRef + "'></script>\n");
				}
			}
			if (lookupInfo.getScript() != null) {
				String strScript = geraScript(lookupInfo.getScript(), colCamposPesq, searchName, null);
				strBuffer.append("<script type=\"text/javascript\">");
				strBuffer.append(strScript.replaceAll("\\{id=LOOKUPNAME\\}", searchName));
				strBuffer.append("</script>");
			}
			separaCampos = lookupInfo.getSeparaCampos();
		}
		if (javascriptCode.equalsIgnoreCase("true")) {
			strBuffer.append("<script type=\"text/javascript\">\n");
			strBuffer.append("var req" + searchName + ";\n");
			strBuffer.append("var url" + searchName + ";\n");
			strBuffer.append("function mostrar_" + searchName + "() {\n");
			cp = itCamposPesq.next();
			strBuffer.append("   " + searchName + "_ajustaDivResultado(document.getElementById('retPesq" + searchName + "'));\n");
			strBuffer.append("} \n");
			strBuffer.append("function " + searchName + "_ajustaDivResultado (dvResult) {\n");
			strBuffer.append("   if (isMozilla){\n");
			strBuffer.append("   	var dvResultTop = dvResult.offsetTop;\n");
			strBuffer.append("  	var dvLookup = document.getElementById('divInt" + searchName + "');\n");
			strBuffer.append("   	var h = dvResultTop + 2;\n");
			strBuffer.append("   	dvResult.style.height = " + height + "- h;\n");
			strBuffer.append("   }else{\n");
			strBuffer.append("   	var dvResultTop = dvResult.offsetTop;\n");
			strBuffer.append("  	var dvLookup = document.getElementById('divInt" + searchName + "');\n");
			strBuffer.append("   	var h = dvResultTop + 2;\n");
			strBuffer.append("   	dvResult.style.height = " + height + "- h;\n");
			strBuffer.append("   }\n");
			strBuffer.append("} \n");
			strBuffer.append("addEvent(window, \"load\", mostrar_" + searchName + ", false);");
			strBuffer.append("</script>\n");
		}

		int i = 1;
		String nomeFisicoAux = "";

		if (htmlCode.equalsIgnoreCase("true")) {
			strBuffer.append("<div class='search-estrutura' id='divInt" + searchName + "'>");
			
			itCamposPesq = colCamposPesq.iterator();
			String asteristica = "";
			
			while (itCamposPesq.hasNext()) {
				cp = itCamposPesq.next();
				if (i == 1) {
					nomeFisicoAux = cp.getNomeFisico();
					String[] trataNome = nomeFisicoAux.split("\\.");
					if (trataNome.length > 1) {
						nomeFisicoAux = trataNome[0] + "_" + trataNome[1];
					}
					i++;
				}
				
				strBuffer.append("<div class='row row-fluid'>");
				strBuffer.append("	<div class='col-md-12 span12'>");
				
				if (!cp.getType().equalsIgnoreCase("HIDDEN")) {
					strBuffer.append("<label>" + cp.getDescricao() + (cp.isObrigatorio() ? "<i style='color: red;'>*</i>" : "") + "</label>");
				}

				habilitaPesquisa = (String) ((HttpServletRequest) request).getSession().getAttribute("habilitaPesquisa");

				strBuffer.append(geraCampo(cp.getType(), cp.getTamanho(), cp.getNomeFisico(), cp.getScriptLostFocus(), searchName, colCamposPesq, cp.getColValores(), cp.isObrigatorio(), cp.getDescricao()));
				
				strBuffer.append("	</div>");
				strBuffer.append("</div>");
			}
			
			((HttpServletRequest) request).getSession().setAttribute("habilitaPesquisa", "");
			habilitaPesquisa = "";
			
			strBuffer.append("<div style='padding: 0 0 15px;'></div>");

			strBuffer.append("<div class='row row-fluid'>");
			strBuffer.append("	<div class='col-md-12 span12'>");
			
			strBuffer.append("		<button type='button' class='btn btn-citsmart' onclick='pesq_" + searchName + "();' title='" + UtilI18N.internacionaliza((HttpServletRequest) request, "citcorpore.ui.botao.rotulo.Pesquisar") + "' style='margin-right: 5px;'>" + UtilI18N.internacionaliza((HttpServletRequest) request, "citcorpore.ui.botao.rotulo.Pesquisar") + "</button>");
			strBuffer.append("		<button type='button' class='btn btn-citsmart' onclick='limpar_" + searchName + "();' title='" + UtilI18N.internacionaliza((HttpServletRequest) request, "citcorpore.ui.botao.rotulo.Limpar") + "' style='margin-right: 5px;'>" + UtilI18N.internacionaliza((HttpServletRequest) request, "citcorpore.ui.botao.rotulo.Limpar") + "</button>");
			
			if (checkbox != null && checkbox.equals("true")) {
				strBuffer.append("		<button type='button' class='btn btn-citsmart' onclick='addAllTabela" + searchName + "();' title='" + UtilI18N.internacionaliza((HttpServletRequest) request, "citSmart.comum.enviar") + "'>" + UtilI18N.internacionaliza((HttpServletRequest) request, "citSmart.comum.enviar") + "</button>");
			}

			strBuffer.append("	</div>");
			strBuffer.append("</div>");

			strBuffer.append("<div style='padding: 0 0 15px;'></div>");

			strBuffer.append("<div class='row row-fluid'>");
			strBuffer.append("	<div id='retPesq" + searchName + "' class='col-md-12 span12'></div>");
			strBuffer.append("</div>");
			
			strBuffer.append("</div>");
		}

		if (javascriptCode.equalsIgnoreCase("true")) {
			strBuffer.append("<script>\n");
			strBuffer.append("function limpar_" + searchName + "(){\n");
			strBuffer.append("   HTMLUtils.clearFormExceptHidden(document." + formName + ");\n");
			strBuffer.append("   if(document.getElementById('retPesq" + searchName + "') != null){\n");
			strBuffer.append("        document.getElementById('retPesq" + searchName + "').innerHTML = '&nbsp;';\n");
			strBuffer.append("   }\n");
			strBuffer.append("   document." + formName + ".pesqLockup" + searchName + "_" + nomeFisicoAux + ".focus();\n");
			strBuffer.append("}\n");

			strBuffer.append("function pesqTodos_" + searchName + " (){");
			strBuffer.append("  limpar_" + searchName + "();");
			strBuffer.append("  document.getElementById('retPesq" + searchName + "').innerHTML = '" + getInternacionalizado("citcorpore.comum.processando_pesquisa") + "'; ");
			strBuffer.append("  pesq_" + searchName + "();");
			strBuffer.append("}\n");
			strBuffer.append("var dadosUrl = '';\n");
			strBuffer.append("function pesq_" + searchName + "(){\n");

			strBuffer.append("if (document." + formName + ".validate()){\n");

			strBuffer.append("document.getElementById('retPesq" + searchName + "').innerHTML = '" + getInternacionalizado("citcorpore.comum.processando_pesquisa") + "'; ");
			strBuffer.append("req" + searchName + " = AjaxUtils.defineBrowserAJAX(); ");
			strBuffer.append("req" + searchName + ".onreadystatechange = process_" + searchName + "; ");
			// Processa os campos de pesquisa e atribui os valores p/ chamar o Action
			int count = 1;
			itCamposPesq = colCamposPesq.iterator();
			while (itCamposPesq.hasNext()) {
				cp = itCamposPesq.next();
				if (cp.getType().equalsIgnoreCase(Constantes.getValue("FIELDTYPE_TEXT").trim()) || cp.getType().equalsIgnoreCase(Constantes.getValue("FIELDTYPE_TEXTAREA").trim()) || cp.getType().equalsIgnoreCase(Constantes.getValue("FIELDTYPE_COMBO").trim()) || cp.getType().equalsIgnoreCase("NUMBER") || cp.getType().equalsIgnoreCase("DATE") || cp.getType().equalsIgnoreCase("HIDDEN")) {
					strBuffer.append("var valor" + searchName + count + " = " + "processaCaracteresEspeciais(" + "document." + formName + "." + geraNomeCampo(cp.getType(), cp.getNomeFisico(), searchName) + ".value" + ");");
				}
				count++;
			}

			strBuffer.append("  var nocache" + searchName + " = new Date();");
			strBuffer.append("	var url" + searchName + " = 'ProcessarLookup.find?acao=process&paginacao=0&nomeLookup=" + nomeLookupExec + "&id=" + idAux + "&checkbox=" + checkbox + "&distinct=" + distinct);
			strBuffer.append("&whereDinamico='+encodeURIComponent(document." + formName + ".whereDinamico)+'");
			for (int iAux = 1; iAux < count; iAux++) {
				strBuffer.append("&parm" + iAux + "='+encodeURIComponent(valor" + searchName + iAux + ")+'");
			}
			int icAux = count - 1;
			strBuffer.append("&parmCount=" + icAux + "");
			strBuffer.append("&nocache=' + nocache" + searchName + "; \n");
			strBuffer.append("	req" + searchName + ".open('GET', url" + searchName + ", true); ");
			strBuffer.append("	req" + searchName + ".setRequestHeader('Cache-Control', 'no-store, no-cache, must-revalidate'); ");
			strBuffer.append("	req" + searchName + ".setRequestHeader('Cache-Control', 'post-check=0, pre-check=0'); ");
			strBuffer.append("	req" + searchName + ".setRequestHeader('Pragma', 'no-cache'); ");
			strBuffer.append("  req" + searchName + ".send(''); ");
			strBuffer.append("} \n");
			strBuffer.append("} \n");
			strBuffer.append("</script>\n");

			strBuffer.append("<script>\n");
			strBuffer.append("function process_" + searchName + " (){\n");
			strBuffer.append("	if (req" + searchName + ".readyState == 4){\n");
			strBuffer.append("		if (req" + searchName + ".status == 200){\n");
			strBuffer.append("			document.getElementById('retPesq" + searchName + "').innerHTML = req" + searchName + ".responseText;\n");
			// chamar a funo de verificao de checkados aps a consulta do paginao chegar ao estado 4(completa)
			strBuffer.append("			memorizarCheckados" + searchName + "();\n");
			strBuffer.append("		}\n");
			strBuffer.append("	}\n");
			strBuffer.append("} \n");
			strBuffer.append("function semAspas(ie, ff) { if (ie) { tecla = ie; } else { tecla = ff;} \n");
			strBuffer.append("if (tecla != 13) { return true; }else { return false; }} \n");
			strBuffer.append("</script>\n");

			// funcao paginacao
			strBuffer.append("<script>\n");
			strBuffer.append("function paginacao" + searchName + "(pag){\n");
			strBuffer.append("document.getElementById('retPesq" + searchName + "').innerHTML = '" + getInternacionalizado("citcorpore.comum.processando_paginacao") + "'; ");
			strBuffer.append("req" + searchName + " = AjaxUtils.defineBrowserAJAX(); ");
			strBuffer.append("req" + searchName + ".onreadystatechange = process_" + searchName + "; ");
			count = 1;
			itCamposPesq = colCamposPesq.iterator();
			while (itCamposPesq.hasNext()) {
				cp = itCamposPesq.next();
				if (cp.getType().equalsIgnoreCase(Constantes.getValue("FIELDTYPE_TEXT").trim()) || cp.getType().equalsIgnoreCase(Constantes.getValue("FIELDTYPE_TEXTAREA").trim()) || cp.getType().equalsIgnoreCase(Constantes.getValue("FIELDTYPE_COMBO").trim()) || cp.getType().equalsIgnoreCase("NUMBER") || cp.getType().equalsIgnoreCase("DATE") || cp.getType().equalsIgnoreCase("HIDDEN")) {
					strBuffer.append("var valor" + searchName + count + "=document." + formName + "." + geraNomeCampo(cp.getType(), cp.getNomeFisico(), searchName) + ".value; ");
				}
				count++;
			}
			strBuffer.append("  var nocache" + searchName + " = new Date();");
			strBuffer.append("	var url" + searchName + " = 'ProcessarLookup.find?acao=process&paginacao='+pag+'&nomeLookup=" + nomeLookupExec + "&id=" + idAux + "&checkbox=" + checkbox + "&distinct=" + distinct);
			strBuffer.append("&whereDinamico='+encodeURIComponent(document." + formName + ".whereDinamico)+'");
			for (int iAux = 1; iAux < count; iAux++) {
				strBuffer.append("&parm" + iAux + "='+valor" + searchName + iAux + "+'");
			}
			icAux = count - 1;
			strBuffer.append("&parmCount=" + icAux + "");
			strBuffer.append("&nocache=' + nocache" + searchName + "; \n");
			strBuffer.append("	req" + searchName + ".open('GET', url" + searchName + ", true); ");
			strBuffer.append("	req" + searchName + ".setRequestHeader('Cache-Control', 'no-store, no-cache, must-revalidate'); ");
			strBuffer.append("	req" + searchName + ".setRequestHeader('Cache-Control', 'post-check=0, pre-check=0'); ");
			strBuffer.append("	req" + searchName + ".setRequestHeader('Pragma', 'no-cache'); ");
			strBuffer.append("  req" + searchName + ".send(''); ");
			strBuffer.append("}\n");
			strBuffer.append("</script>\n");
			// montando a funo que marca todos os checkbox da poppup que tem class=check
			strBuffer.append("<script type=\"text/javascript\">");
			strBuffer.append("function " + searchName + "_marcarTodosCheckbox(selecionado) {");
			strBuffer.append("	var classe = 'check';");
			strBuffer.append("	if (!$(selecionado).is(':checked')) {");
			strBuffer.append("		$('form[name=" + formName + "] .' + classe).each(function() {");
			strBuffer.append("			$(this).attr('checked', false);");
			strBuffer.append("			concatenarValoresCheckados_" + searchName + "(this);");
			strBuffer.append("		});");
			strBuffer.append("	}else {");
			strBuffer.append("		$('form[name=" + formName + "] .' + classe).each(function() {");
			strBuffer.append("			if ($(this).is(':checked')) return true;");
			strBuffer.append("			$(this).attr('checked', true);");
			strBuffer.append("			concatenarValoresCheckados_" + searchName + "(this);");
			strBuffer.append("		});");
			strBuffer.append("		};");
			strBuffer.append("};\n");
			strBuffer.append("</script>");
			strBuffer.append("<script>\n");
			String retParms = "";
			// funo que concatena e desconcatena os checkbox que marcados ou desmarcados
			strBuffer.append("var checkados_" + searchName + " = '' ;\n");
			strBuffer.append("function concatenarValoresCheckados_" + searchName + "(elemento) {\n");
			strBuffer.append("	if (!$(elemento).is(':checked')) {\n");
			strBuffer.append("		if($(elemento).attr('name') != 'selTodosPagina')\n");
			strBuffer.append("			$('[name=selTodosPagina]').attr('checked', false);\n");
			strBuffer.append("		checkadosArray = checkados_" + searchName + ".split(\";\");\n");
			strBuffer.append("		checkados_" + searchName + " = '' \n");
			strBuffer.append("		for(var i = 0; i < checkadosArray.length; i++){\n");
			strBuffer.append("			if (checkadosArray[i] == elemento.value){\n");
			strBuffer.append("				checkadosArray[i] = '';\n");
			strBuffer.append("			}\n");
			strBuffer.append("		}\n");
			strBuffer.append("		for (var i = 0; i < checkadosArray.length; i++){\n");
			strBuffer.append("			if(checkadosArray[i] != ''){\n");
			strBuffer.append("				checkados_" + searchName + " +=checkadosArray[i]+';';\n");
			strBuffer.append("			}\n");
			strBuffer.append("		}\n");
			strBuffer.append("	}else {\n");
			strBuffer.append("		checkados_" + searchName + " += elemento.value+';';\n");
			strBuffer.append("		}\n");
			strBuffer.append("}\n");
			// Funo que enviar todos os checkbox checkados e chama um mtodo requisicaoMudanca.java
			String[] nomePopup = searchName.split("LOOKUP");

			if (UtilStrings.stringVazia(formCheckbox)) {
				formCheckbox = "form";
			}

			strBuffer.append("addAllTabela" + searchName + " = function(){\n");
			strBuffer.append("	document." + formCheckbox + ".colAll" + searchName + ".value = checkados_" + searchName + ";\n");
			strBuffer.append("	document." + formCheckbox + ".fireEvent(\"adicionaTabela" + searchName + "\");\n");
			strBuffer.append("	fecharPopup" + nomePopup[1] + "();\n");
			strBuffer.append(" }\n");
			strBuffer.append("function fecharPopup" + nomePopup[1] + "(){");
			strBuffer.append("	$('#POPUP" + nomePopup[1] + "').dialog('close');");
			strBuffer.append("	checkados_" + searchName + "=''");
			strBuffer.append("}");
			// Funo necessria para quando o usuario mudar de pgina o checkbox continue marcado.
			strBuffer.append("function memorizarCheckados" + searchName + "(){");
			strBuffer.append("	table = document.getElementById('topoRetorno');");
			strBuffer.append("	itens = document.getElementsByName('sel');");
			strBuffer.append("	checkTodosPagina = document.getElementsByName('selTodosPagina');");
			strBuffer.append("	count = 0;");
			strBuffer.append("	var ids = checkados_" + searchName + ".split(';');");
			strBuffer.append("	for(i=0; i< itens.length; i++){");
			strBuffer.append("		for (y=0; y< ids.length; y++){");
			strBuffer.append("			if(itens[i].value == ids[y]){");
			strBuffer.append("				itens[i].checked = true;");
			strBuffer.append("				count += 1;");
			strBuffer.append("				break;");
			strBuffer.append("			}");
			strBuffer.append("		}");
			strBuffer.append("	}");
			strBuffer.append("	if (itens.length == count? $(checkTodosPagina).attr('checked', true) : $(checkTodosPagina).attr('checked', false));");
			strBuffer.append("}");
			if (SimNao.SIM.getValorStr().equalsIgnoreCase(separaCampos)) {
				strBuffer.append("function setRetorno_" + searchName + " (id");
				Collection<Campo> colRet = getCamposRetorno(searchName);
				for (int x = 1; x < colRet.size(); x++) {
					retParms += ",ret" + x;
				}
				strBuffer.append(retParms);
				strBuffer.append("){\n");
			} else {
				strBuffer.append("function setRetorno_" + searchName + " (id,ret1){");
			}
			if (SimNao.SIM.getValorStr().equalsIgnoreCase(separaCampos)) {
				strBuffer.append("if (" + searchName + "_select.length==2){");
				strBuffer.append(searchName + "_select(id,ret1);");
				strBuffer.append("}else{");
				strBuffer.append(searchName + "_select(id" + retParms + ");");
				strBuffer.append("}");
				strBuffer.append("  limpar_" + searchName + "();");
			} else {
				strBuffer.append(searchName + "_select(id,ret1);");
				strBuffer.append("  limpar_" + searchName + "();");
			}
			strBuffer.append("} ");
			strBuffer.append("</script>\n");

			/**
			 * Funo para processar caracteres na string
			 * 22/12/2014
			 * 
			 * @author thyen.chang
			 */
			strBuffer.append("<script>\n");
			strBuffer.append("function processaCaracteresEspeciais(texto){\n");
			strBuffer.append("	var aux = \"\";\n");
			strBuffer.append("	var caracteresEspeciais = \"%\";\n");
			strBuffer.append("	if(texto !== null && texto !== undefined)\n");
			strBuffer.append("		for(var i = 0; i < texto.length; i++)\n");
			strBuffer.append("			if(caracteresEspeciais.indexOf(texto[i]) > -1)\n");
			strBuffer.append("				aux += \"\\\\\" + texto[i];\n");
			strBuffer.append("			else\n");
			strBuffer.append("				aux += texto[i];\n");
			strBuffer.append("	return aux;\n");
			strBuffer.append("}\n");
			strBuffer.append("</script>\n");
		}
		return strBuffer;
	}

	public Collection<Campo> getCamposPesquisa(String nameLookup) {
		if (lookupInfo == null) {
			lookupInfo = xml.getLookup(nameLookup);
		}

		return lookupInfo.getColCamposPesquisa();
	}

	public Collection<Campo> getCamposRetorno(String nameLookup) {
		if (lookupInfo == null) {
			lookupInfo = xml.getLookup(nameLookup);
		}

		return lookupInfo.getColCamposRetorno();
	}

	public Collection<Campo> getCamposOrdenacao(String nameLookup) {
		if (lookupInfo == null) {
			lookupInfo = xml.getLookup(nameLookup);
		}

		return lookupInfo.getColCamposOrdenacao();
	}

	public Collection<Campo> getCamposChave(String nameLookup) {
		if (lookupInfo == null) {
			lookupInfo = xml.getLookup(nameLookup);
		}

		return lookupInfo.getColCamposChave();
	}

	public String getDaoProcessor(String nameLookup) {
		if (lookupInfo == null) {
			lookupInfo = xml.getLookup(nameLookup);
		}
		return lookupInfo.getDaoProcessor();
	}

	public String getTabela(String nameLookup) {
		if (lookupInfo == null) {
			lookupInfo = xml.getLookup(nameLookup);
		}
		return lookupInfo.getTabela();
	}

	public String getSeparaCampos(String nameLookup) {
		if (lookupInfo == null) {
			lookupInfo = xml.getLookup(nameLookup);
		}
		return lookupInfo.getSeparaCampos();
	}

	public String getWhere(String nameLookup) {
		if (lookupInfo == null) {
			lookupInfo = xml.getLookup(nameLookup);
		}
		return lookupInfo.getWhere();
	}

	public String geraCampo(String type, int tam, String nome, String scriptLostFocus, String nameLookup, Collection<Campo> colCamposPesq, Collection<ItemValorDescricaoDTO> colValores, boolean valid, String validDesc) {
		StringBuilder result = new StringBuilder();

		String[] trataNome = nome.split("\\.");
		String classObrigatorio = "";
		if (trataNome.length > 1) {
			nome = trataNome[0] + "_" + trataNome[1];
		}
		if (valid) {
			classObrigatorio = " Valid[Required] Description[" + validDesc + "] ";
		}
		if (type.equalsIgnoreCase(Constantes.getValue("FIELDTYPE_TEXT").trim()) || type.equalsIgnoreCase("NUMBER") || type.equalsIgnoreCase("DATE")) {
			if (type.equalsIgnoreCase("NUMBER")) {
				classObrigatorio += " Format[numero] ";
			}
			if (type.equalsIgnoreCase("DATE")) {
				classObrigatorio += " Format[data] datepiker ";
			}
			if (scriptLostFocus == null) {
				scriptLostFocus = "";
			}

			String functionName = "";
			if (!scriptLostFocus.trim().equalsIgnoreCase("")) {
				functionName = "scriptLostFocus_" + nameLookup + "_" + nome;
				result.append("<script>");
				result.append("self." + functionName + " = function(objeto, id){");
				result.append(geraScript(scriptLostFocus, colCamposPesq, nameLookup, nome));
				result.append("}");
				result.append("</script>");
			}

			String disabled = "";
			if (habilitaPesquisa != null && habilitaPesquisa.equalsIgnoreCase(SimNao.SIM.getValorStr())) {
				disabled = "disabled = 'disabled' ";
			}

			if (!functionName.equalsIgnoreCase("")) {
				result.append("<input type='text' class='form-control span12 " + classObrigatorio + "' id='pesqLockup" + nameLookup + "_" + nome + "' name='pesqLockup" + nameLookup + "_" + nome + "' onkeydown=\"if ( event.keyCode == 13 ) pesq_" + nameLookup + "();\" maxlength='" + tam + "' onkeypress='return semAspas(event.keyCode, event.which);' onblur='" + functionName + "(this, \"pesqLockup"
						+ nameLookup + "_" + nome + "\");' " + disabled + " />");
			} else {
				result.append("<input type='text' class='form-control span12 " + classObrigatorio + "' id='pesqLockup" + nameLookup + "_" + nome + "' name='pesqLockup" + nameLookup + "_" + nome + "' onkeydown=\"if ( event.keyCode == 3 || event.keyCode == 13 ){event.keyCode = 3; pesq_" + nameLookup + "();}\" onkeypress='return semAspas(event.keyCode, event.which);' " + disabled + " />");
			}

			if (type.equalsIgnoreCase("DATE")) {
				result.append("\n<script>\n");
				result.append("window.setTimeout(function(){");
				result.append("addEvent(document.getElementById('pesqLockup" + nameLookup + "_" + nome + "'),\n");
				result.append("		\"keydown\",\n");
				result.append("		DEFINEALLPAGES_formataData,\n");
				result.append("		false);}, 3000);\n");
				result.append("window.setTimeout(function(){");
				result.append("addEvent(document.getElementById('pesqLockup" + nameLookup + "_" + nome + "'),\n");
				result.append("		\"blur\",\n");
				result.append("		DEFINEALLPAGES_formataData,\n");
				result.append("		false);\n");
				result.append("addEvent(document.getElementById('pesqLockup" + nameLookup + "_" + nome + "'),\n");
				result.append("		\"blur\",\n");
				result.append("		function(){ValidacaoUtils.validaData(document.getElementById('pesqLockup" + nameLookup + "_" + nome + "'), 'Campo de pesquisa: ')},\n");
				result.append("		false);\n");
				result.append("		}, 3000);\n");
				result.append("</script>\n");
			}
		} else if (type.equalsIgnoreCase("HIDDEN")) {
			result.append("<input type='hidden' name='pesqLockup" + nameLookup + "_" + nome + "' id='pesqLockup" + nameLookup + "_" + nome + "'>");
		} else if (type.equalsIgnoreCase(Constantes.getValue("FIELDTYPE_COMBO").trim())) {
			if (scriptLostFocus == null) {
				scriptLostFocus = "";
			}

			String functionName = "";
			if (!scriptLostFocus.trim().equalsIgnoreCase("")) {
				functionName = "scriptLostFocus_" + nameLookup + "_" + nome;
				result.append("<script>\n");
				result.append("function " + functionName + "(objeto, id){\n");
				result.append(geraScript(scriptLostFocus, colCamposPesq, nameLookup, nome));
				result.append("\n}\n");
				result.append("</script>\n");
			}

			if (!functionName.equalsIgnoreCase("")) {
				result.append("<select class='form-control span12 " + classObrigatorio + "' id='pesqLockup" + nameLookup + "_" + nome + "' name='pesqLockup" + nameLookup + "_" + nome + "' onkeypress='" + nameLookup + "_validaEnter(this,event)' onchange='" + functionName + "(this, \"pesqLockup" + nameLookup + "_" + nome + "\");'>");
			} else {
				result.append("<select class='form-control span12 " + classObrigatorio + "' id='pesqLockup" + nameLookup + "_" + nome + "' name='pesqLockup" + nameLookup + "_" + nome + "' onkeypress='" + nameLookup + "_validaEnter(this,event)'>");
			}

			if (colValores != null) {
				for (Iterator<ItemValorDescricaoDTO> it = colValores.iterator(); it.hasNext();) {
					ItemValorDescricaoDTO itemValorDescricaoDTO = it.next();
					result.append("<option value=\"" + itemValorDescricaoDTO.getValor() + "\">" + getInternacionalizado(itemValorDescricaoDTO.getDescricao()) + "</option>");
				}
			}

			result.append("</select>");
		}

		return result.toString();
	}

	public String geraNomeCampo(String type, String nome, String nameLookup) {
		String nomeAux = nome;
		String[] trataNome = nome.split("\\.");
		if (trataNome.length > 1) {
			nomeAux = trataNome[0] + "_" + trataNome[1];
		}

		String result = "";
		if (type.equalsIgnoreCase(Constantes.getValue("FIELDTYPE_TEXT").trim()) || type.equalsIgnoreCase(Constantes.getValue("FIELDTYPE_COMBO").trim()) || type.equalsIgnoreCase("HIDDEN") || type.equalsIgnoreCase("NUMBER") || type.equalsIgnoreCase("DATE")) {
			result = "pesqLockup" + nameLookup + "_" + nomeAux + "";
		}
		return result;
	}

	public String geraScript(String script, Collection<Campo> colCamposPesq, String nameLookup, String nome) {
		if (colCamposPesq == null) {
			return script;
		}
		Iterator<Campo> it = colCamposPesq.iterator();
		Campo campo;
		String scriptRetorno = script;
		while (it.hasNext()) {
			campo = it.next();
			scriptRetorno = scriptRetorno.replaceAll("\\{id=" + campo.getNomeFisico() + "\\}", "'pesqLockup" + nameLookup + "_" + nome + "'");
		}
		scriptRetorno = scriptRetorno.replaceAll("\\{id=LOOKUPNAME\\}", nameLookup);
		scriptRetorno = scriptRetorno.replaceAll("SUBMITLOOKUP", "pesq_" + nameLookup + "()");
		scriptRetorno = scriptRetorno.replaceAll("\\\\n", "" + '\n');
		return scriptRetorno;
	}

	private String getInternacionalizado(String texto) {
		String traduzido = props.getProperty(texto);
		if (traduzido == null || traduzido.length() <= 0) {
			traduzido = texto;
		}
		return traduzido;
	}

	private void getProperties(Locale locale) {
		String fileName = "";
		try {

			/**
			 * @author gilberto.nery
			 * @since 18/11/2015
			 *
			 *        Se o locale contiver pt ou br (no keysensitive) ser considerado como portugues do Brasil
			 *
			 */
			if (locale != null && !locale.toString().equals("") && !locale.toString().equalsIgnoreCase("pt") && !locale.toString().equalsIgnoreCase("BR")) {
				fileName = "Mensagens_" + locale.toString() + ".properties";
			} else {
				fileName = "Mensagens.properties";
			}

			props = new Properties();
			ClassLoader load = Mensagens.class.getClassLoader();
			InputStream is = load.getResourceAsStream(fileName);
			if (is == null) {
				is = ClassLoader.getSystemResourceAsStream(fileName);
			}
			if (is == null) {
				is = ClassLoader.getSystemClassLoader().getResourceAsStream(fileName);
			}

			try {
				if (is != null) {
					props.load(is);
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		} catch (SecurityException e1) {
			e1.printStackTrace();
		}
	}

}