package br.com.citframework.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import br.com.citframework.comparacao.ObjectSimpleComparator;
import br.com.citframework.excecao.CompareException;

@SuppressWarnings({"unchecked", "rawtypes"})
public class UtilListas {
	/**
	 * Ordena uma lista de beans (nao importa o tipo), atraves de uma propriedade (get).
	 * @param lst
	 * @param getProperty (exemplo: "getDataInicio") - Pode ser data, Numero, String, ...
	 * @param typeOrder ("ASC" ou "DESC") - pode ser utilizado: ObjectSimpleComparator.ASC, ObjectSimpleComparator.DESC
	 * @return A colecao ordenada pela propriedade indicada
	 * @throws CompareException
	 */
	public static Collection sortListOfBensByProperty(List lst, String getProperty, String typeOrder) throws CompareException{
		if (lst == null) return new ArrayList();
		Collections.sort(lst, new ObjectSimpleComparator(getProperty, typeOrder));
		return lst;
	}
	
	public static <E> Map<E, Integer> agrupaDuplicadosComQtde(List<E> lista) {
		Map<E, Integer> listaAgrupada = new HashMap<E, Integer>();
		Set<E> set = new HashSet<>(lista);
		for (E item : set) {
			listaAgrupada.put(item, Collections.frequency(lista, item));
		}
		return listaAgrupada;
	}
}
