package br.com.citframework.util.rest;

import java.io.Serializable;

import org.json.JSONException;
import org.json.JSONObject;

import br.com.citframework.util.UtilStrings;


public class RestOutput implements Serializable {
	
	/** Atributo serialVersionUID. */
	private static final long serialVersionUID = 1L;

	private String response;
	
	private Integer httpStatus;
	
	private String error;

	public RestOutput(String response, Integer httpStatus) {
		this.response = response;
		this.httpStatus = httpStatus;
		this.error = "";
		if (httpStatus != 200 && UtilStrings.isNotVazio(response) && response.charAt(0) == '{') {
			try {
				JSONObject resp;
				resp = new JSONObject(response);
				if (resp.has("ex")) {
					JSONObject ex = resp.getJSONObject("ex");
					error = ex.getString("message");
				}
			} catch (JSONException e) {
			}
		}		
	}
	
	/**
	 * Retorna o valor do atributo <code>response</code>
	 *
	 * @return <code>String</code>
	 */
	public String getResponse() {
	
		return response;
	}

	
	/**
	 * Define o valor do atributo <code>response</code>.
	 *
	 * @param response 
	 */
	public void setResponse(String response) {
	
		this.response = response;
	}

	
	/**
	 * Retorna o valor do atributo <code>httpStatus</code>
	 *
	 * @return <code>Integer</code>
	 */
	public Integer getHttpStatus() {
	
		return httpStatus;
	}

	
	/**
	 * Define o valor do atributo <code>httpStatus</code>.
	 *
	 * @param httpStatus 
	 */
	public void setHttpStatus(Integer httpStatus) {
	
		this.httpStatus = httpStatus;
	}

	
	/**
	 * Retorna o valor do atributo <code>exception</code>
	 *
	 * @return <code>String</code>
	 */
	public String getError() {
	
		return error;
	}

	
	/**
	 * Define o valor do atributo <code>exception</code>.
	 *
	 * @param exception 
	 */
	public void setError(String error) {
	
		this.error = error;
	}
	
}
