$(document).ready(function() {
	LAYOUT.load();
});

// #### HISTORICO ####
$('.openHistorico').click(function(e){
	$('#historico').toggle();
});

function buscaHistoricoPorVersao() {
	document.formSobre.fireEvent("buscaHistoricoPorVersao");
}
//#### HISTORICO ####

var LAYOUT = {
	load: function() {
		$('.language.' + locale).addClass('active');
		LAYOUT.menu.config();
		
		if($('#footer').length > 0) {
			$('body').addClass('footer-enable');
		}
	},
	language: {
		change: function(language) {
			$('#footer .languages .language').removeClass('active');
			$('#footer .languages .language.' + language).addClass('active');

			document.formInternacionaliza.locale.value = language;
			document.formInternacionaliza.fireEvent('internacionaliza');
		}
	},
	menu: {
		_timeout: function() {},
		config: function() {
			$('#nav li').hover(function() {
				$(this).addClass('hover');
			}, function() {
				var that = $(this);
				that.removeClass('hover');
			});

			$(window).on('resize', function() {
				if($(window).width() > 767) {
					$('#nav-container').removeClass('nav-open');
					$('#nav-container').find('ul').css('display', '');
				}
			})

			$('#nav li a').on('click', function() {
				if($(window).width() <= 767) {
					$(this).parent('li').children('ul').slideToggle();
					$(this).parent('li').toggleClass('clicked');
				}
			});

			$('#nav-button').on('click', function() {
				var navContainer = $(this).parents('#nav-container'),
					nav = navContainer.find('#nav');
				
				if(navContainer.hasClass('nav-open')) {
					navContainer.removeClass('nav-open');
					nav.stop().slideUp();
				} else {
					navContainer.addClass('nav-open');
					nav.stop().slideDown();
				}
			});

			$('#nav-container-backdrop').on('click', function() {
				var navContainer = $(this).parents('#nav-container'),
					nav = navContainer.find('#nav');

				navContainer.removeClass('nav-open');
				nav.stop().slideUp();
			});
		}
	}
};