var locale_format = locale === 'en' ? 'MM/dd/yyyy' : 'dd/MM/yyyy';

var permissaoGravar = false;
var permissaoDelete = false;
var permissaoPesquisar = false;

var hostname = "";

function defineLocale() {
	if (typeof(locale) === "undefined") locale = '';
}

/* Desenvolvedor: Fabio Amorim  Data: 02/06/2015 - Horário: 09:15  ID Citsmart: 168912  Motivo/Comentário: Alterado para possibilitar exibir texto sempre em uft-8. */
function i18n_message(lbl) {
	var l = bundle['key'][lbl];

	if (l === undefined) {
		l = lbl;
	}
	return l;
}

/** Internacionaliza chave ou array de chaves
 * @author deborah.ferreira
 * @since 03.03.2016
 */
function internacionalizaChave(chave) {
	var texto = "";
	if(chave instanceof Array) {
		for(var i = 0, len = chave.length; i < len; i++) {
			if(i > 0) {
				texto = texto.concat(" ");
			}
			texto = texto.concat(i18n_message(chave[i]));
		}
	} else {
		texto = i18n_message(chave);
	}
	return texto;
}

function internacionalizar(parametro){
	document.getElementById('locale').value = parametro;
	document.formInternacionaliza.fireEvent('internacionaliza');
}

/* Desenvolvedor: Euler.Ramos  Data: 23/10/2013 - Horário: 16h04min  ID Citsmart: 120393  Motivo/Comentário: Para evitar o erro: "...has no method fecharTelaAguarde" na tela de pesquisa da base de conhecimento. */
function fecharJanelaAguarde(){
	JANELA_AGUARDE_MENU.hide();
}

//imprime no console qualquer erro de javascript no sistema
onerror = handleErr;
function handleErr(msg, url, l) {
	var txt;
	txt += "Erro: " + msg + " - ";
	txt += "URL: " + url + " - ";
	txt += "Linha: " + l;
	console.log(txt);
	return true;
}

/* desenvolvedor: rcs (Rafael César Soyer)
 o método abaixo limpa todos os campos de uma tela
 data: 26/12/2014
*/
function limpar() {
	document.form.clear();
}

function validaData(){
	var dataInicio = document.getElementById("dataInicio").value;
	var dataFim	= document.getElementById("dataFim").value;

	if (typeof(locale) === "undefined") locale = '';

	var dtInicio = new Date();
	var dtFim = new Date();

	var dtInicioConvert = '';
	var dtFimConvert = '';
	var dtInicioSplit = dataInicio.split("/");
	var dtFimSplit = dataFim.split("/");

	if (locale == 'en') {
		dtInicioConvert = dtInicioSplit[2] + "/" + dtInicioSplit[0] + "/" + dtInicioSplit[1];
		dtFimConvert = dtFimSplit[2] + "/" + dtFimSplit[0] + "/" + dtFimSplit[1];
	} else {
		dtInicioConvert = dtInicioSplit[2] + "/" + dtInicioSplit[1] + "/" + dtInicioSplit[0];
		dtFimConvert = dtFimSplit[2] + "/" + dtFimSplit[1] + "/" + dtFimSplit[0];
	}

	dtInicio.setTime(Date.parse(dtInicioConvert)).setFullYear;
	dtFim.setTime(Date.parse(dtFimConvert)).setFullYear;

	if (dataInicio.trim() == ""){
		alert(i18n_message("citcorpore.comum.validacao.datainicio"));
		return false;
	} else if(DateTimeUtil.isValidDate(dataInicio) == false){
		alert(i18n_message("citcorpore.comum.datainvalida"));
		document.getElementById("dataInicio").value = '';
		return false;
	}

	if (dataFim.trim() == ""){
		alert(i18n_message("citcorpore.comum.validacao.datafim"));
		return false;
	} else if(DateTimeUtil.isValidDate(dataFim) == false){
		alert(i18n_message("citcorpore.comum.dataFinalInvalida"));
		document.getElementById("dataFim").value = '';
		return false;
	}

	if (dtInicio > dtFim){
		alert(i18n_message("citcorpore.comum.dataInicioMenorFinal"));
		return false;
	}
	return true;
}

/**
 * @author cristian.guedes
 * @param dataInicio
 * @param dataFim
 * @returns {Boolean}
 */
function validaDataParametrizado(dataInicio, dataFim){
	if (typeof(locale) === "undefined") locale = '';

	var dtInicio = new Date();
	var dtFim = new Date();

	var dtInicioConvert = '';
	var dtFimConvert = '';
	var dtInicioSplit = dataInicio.split("/");
	var dtFimSplit = dataFim.split("/");

	if (locale == 'en') {
		dtInicioConvert = dtInicioSplit[2] + "/" + dtInicioSplit[0] + "/" + dtInicioSplit[1];
		dtFimConvert = dtFimSplit[2] + "/" + dtFimSplit[0] + "/" + dtFimSplit[1];
	} else {
		dtInicioConvert = dtInicioSplit[2] + "/" + dtInicioSplit[1] + "/" + dtInicioSplit[0];
		dtFimConvert = dtFimSplit[2] + "/" + dtFimSplit[1] + "/" + dtFimSplit[0];
	}

	dtInicio.setTime(Date.parse(dtInicioConvert)).setFullYear;
	dtFim.setTime(Date.parse(dtFimConvert)).setFullYear;

	if (dataInicio.trim() == ""){
		alert(i18n_message("citcorpore.comum.validacao.datainicio"));
		return false;
	} else if(DateTimeUtil.isValidDate(dataInicio) == false){
		alert(i18n_message("citcorpore.comum.datainvalida"));
		document.getElementById("dataInicio").value = '';
		return false;
	}

	if (dataFim.trim() == ""){
		alert(i18n_message("citcorpore.comum.validacao.datafim"));
		return false;
	} else if(DateTimeUtil.isValidDate(dataFim) == false){
		alert(i18n_message("citcorpore.comum.dataFinalInvalida"));
		document.getElementById("dataFim").value = '';
		return false;
	}

	if (dtInicio > dtFim){
		alert(i18n_message("citcorpore.comum.dataInicioMenorFinal"));
		return false;
	}
	return true;
}

function imprimirRelatorioPeloNomeDoRelatorio(str_nomeDoRelatorio){
	if (validaData()) {
		JANELA_AGUARDE_MENU.show();
		document.form.fireEvent(str_nomeDoRelatorio);
	}
}

function imprimirRelatorio(str_tipoDoRelatorio){
	JANELA_AGUARDE_MENU.show();
	document.form.formatoArquivoRelatorio.value = str_tipoDoRelatorio;
	document.form.fireEvent("imprimirRelatorio");
}

function imprimirRelatorioPdf() {
	var tipoDoRelatorio = "pdf"

	if (validaData()) {
		imprimirRelatorio(tipoDoRelatorio);
	}
}

function imprimirRelatorioXls() {
	var tipoDoRelatorio = "xls"

	if (validaData()) {
		imprimirRelatorio(tipoDoRelatorio);
	}
}

function reportEmpty(){
	alert(i18n_message("citcorpore.comum.relatorioVazio"));
	 }

     function isDateValid(date){
        return DateTimeUtil.isValidDate(date);
     }

     function isHourValid(time){
        time = time.split(":");

        if(parseInt(time[0]) > 23){
            return false;
        }

        return true;
     }

     function isMinuteValid(time){
        time = time.split(":");

        if(parseInt(time[1]) > 59){
            return false;
        }

        return true;
     }
     
/**
 * Redimensiona a popup em tamanho compativel com o tamanho da tela
 */
function redimensionarTamhanho(identificador, tipo_variacao) {
	var h;
	var w;
	switch (tipo_variacao) {
	case "PEQUENO":
		w = parseInt($(window).width() * 0.25);
		h = parseInt($(window).height() * 0.35);
		break;
	case "MEDIO":
		w = parseInt($(window).width() * 0.5);
		h = parseInt($(window).height() * 0.6);
		break;
	case "GRANDE":
		w =  '75%';
		h =  '85%';
		break;
	case "XG":
		w = parseInt($(window).width() * 0.95);
		h = parseInt($(window).height() * 0.95);
		break;
	default:
		w = parseInt($(window).width() * 0.5);
		h = parseInt($(window).height() * 0.6);
	}

	$(identificador).dialog("option", "top", 0);
	$(identificador).dialog("option", "width", w);
	$(identificador).dialog("option", "height", h)
}


//---------Tratamento Mascara Telefone 8 e 9 digitos

/**
 * Desenvolvedor: ibimon.morais - Data: 10/09/2015 - Horário: 17:42 - ID Citsmart: 177545 -
 * Motivo/Comentário: Alteração para que o campo de controle de telefone, aceite informacoes com 8 e 9 digitos,
 * formatando com o DDD (AA) e (AAA) e adaptando tambem o "-". Foi necessario formataca manual porque o layout 
 * novo, usa um jquery especifico, e ainda existe o jquery antigo, para nao correr risco, optei por usar uma
 * forma generica que nao impacte na usabilidade do campo, caso a pessoa digite 10, 11 ou mais digitos, vai 
 * formatar para no maximo 12 caracteres, caso seja informado um telefone invalido, nao aplica a mascara
 * mantendo o que o usuario informou. No controle do "onblur", ele formata o telefone de acordo com a quantidade
 * de caracteres informados. 		 
 */

/**
 * Tratamento de mascarmascararElementoInputrpreta e determina o timeout de execução.
 * @param o - objeto
 * @param f - função que será executada apos o tempo
 */
function mascararElementoInput(o,f){
    v_obj=o;
    v_fun=f;
    setTimeout("executarMascara()",5);
}

/**
 * Execução da função indicada na hora de mascarar o valor digitado no input.
 */
function executarMascara(){
    v_obj.value = v_fun(v_obj.value)
}

/**
 * Retira o que nao e digito, caso venha nulo ou vazio, devolve um valor em branco.
 * @param valor
 * @returns valor - sem caracteres, somente com os digitos
 */
function retiraCrtFone(valor){
	return (valor != null && valor.length >0) ? valor.replace(/\D/g,"") : ''; 
}

/**
 * Devolve o elemente de acordo com o id.
 * @param el 
 * @returns element encontrato de acordo com o parametro
 */
function id( elemento ){
	return document.getElementById( elemento );
}

function aplicarMascaraNaAcaoOnKeyPress(telefone){
	var aux = retiraCrtFone(telefone);
	if(aux == null || aux == ''){
		telefone = '';
	}else{
		switch (aux.length) {
		case 1:
			telefone = '(' + telefone;
			break;
		case 3:	
			telefone = telefone + ') ';
			break;
		case 8:
			telefone = telefone + '-';
			break;
		default:
			break;
		}
	}
	return telefone;
}

function calculaEMontagemMascaraTelefone(f1){
	var ff1 = retiraCrtFone(f1.value);
	
	if(ff1 == null || ff1 == ''){
		f1.value = '';
		return;
	}
	
	if( ff1.substring(0, 1) == '0'){
		if(ff1.length == 11 ){
			f1.value =  "(" +ff1.substring(0, 3) +") "+ ff1.substring(3, 7) + "-" + ff1.substring(7, 11);
		}else if(ff1.length >= 12 ){
			f1.value =  "(" +ff1.substring(0, 3) +") "+ ff1.substring(3, 8) + "-" + ff1.substring(8, 12);
		}
	}else{
		if(ff1.length == 10 ){
			f1.value =  "(" +ff1.substring(0, 2) +") "+ ff1.substring(2, 6) + "-" + ff1.substring(6, 10);
		}else if(ff1.length == 11 ){
			f1.value = "(" +ff1.substring(0, 2) +") "+ ff1.substring(2, 7) + "-" + ff1.substring(7, 11);
		}else if(ff1.length > 11 ){
			f1.value = "(" +ff1.substring(0, 3) +") "+ ff1.substring(3, 8) + "-" + ff1.substring(8, 12);
		}
	}
}

/**
 * Adiciona uma notificação na tela usando o componente <i>gritter</i>
 * @param titulo
 * @param texto
 * @author rodrigo.guilherme
 */
function notificacao(titulo, texto){
	$.gritter.add({
		title: titulo,
		text: texto,
		sticky: false,
		time: '5000',
		before_open: function(){
			if($('.gritter-item-wrapper').length >= 3){
				$($('.gritter-item-wrapper')[0]).remove();
			}
		},
		class_name: 'gritter-primary'
	});
}

/**
 * Adiciona notificação internacionalizada recebendo as chaves do título e texto
 * utilizando o componente <i>gritter</i>
 * @param chaveTitulo
 * @param chaveTexto
 */
function notificacaoI18N(chaveTitulo, chaveTexto){
	$.gritter.add({
		title: i18n_message(chaveTitulo),
		text: i18n_message(chaveTexto),
		sticky: false,
		time: '5000',
		before_open: function(){
			if($('.gritter-item-wrapper').length >= 3){
				$($('.gritter-item-wrapper')[0]).remove();
			}
		},
		class_name: 'gritter-primary'
	});
}

/**
 * Adiciona notificação internacionalizada de erro recebendo as chaves do título e texto
 * utilizando o componente <i>gritter</i>
 * @param chaveTitulo
 * @param chaveTexto
 */
function notificacaoErro(chaveTitulo, chaveTexto){
	$.gritter.add({
		title: internacionalizaChave(chaveTitulo),
		text: internacionalizaChave(chaveTexto),
		sticky: false,
		time: '10000',
		before_open: function(){
			if($('.gritter-item-wrapper').length >= 3){
				$($('.gritter-item-wrapper')[0]).remove();
			}
		},
		class_name: 'gritter-primary gritter-error'
	});
}

/**
 * Cria um dialog com base nos parâmetros
 * @param tamanho - O tamanho do dialog, em porcentagem, seguindo a escala G(90), M(75), P(60) e PP(45)
 * @param classDialog - Identifica qual será o dialog aberto
 * @param functionBeforeClose - Função que será chamada após clicar em fechar
 * @author rodrigo.guilherme
 */
function criaDialog(tamanho, classDialog, functionBeforeClose){
	var docElement = document.documentElement;

	var porcentagem = 90;

	switch(tamanho){
		case 'G':
			porcentagem = 90;
			break;
		case 'M':
			porcentagem = 75;
			break;
		case 'P':
			porcentagem = 60;
			break;
		case 'PP':
			porcentagem = 45;
			break;
		case 'SP':
			porcentagem = 25;
			break;
	}

	$("."+classDialog).dialog({
		width : porcentagem+"%",
		height : porcentagem*(docElement.clientHeight)/100,
		modal : true,
		autoOpen : false,
		resizable : true,
		show : "fade",
		hide : "fade",
		beforeClose : functionBeforeClose
	});
}

/**
 * Filtra uma table, com base no filtro digitado no campoBusca.
 * 
 * @param campoBusca
 * @param table
 */
function filtroTableJs(campoBusca, table){
    var filtroPesquisa = campoBusca.value.toLowerCase();
	if( filtroPesquisa != ""){
		if(table != ""){
			// Esconde todos os tr's
			$("#"+table+" tbody > tr").hide();
			// Mostra apenas os que contém alguma ocorrência do filtro
            $("#"+table+" td").filter(function(){
                   return $(this).text().toLowerCase().indexOf(filtroPesquisa ) > -1;
            }).parent("tr").show();
		}
	} else {
		// Quando não há nada digitado, mostra a tabela com todos os dados
		$("#"+table+" tbody > tr").show();
	}
}

function getPathReportByTipoConsultaAndIdConsulta(tipoConsulta, idConsulta) {
	var pathReport = ctx;
	if (tipoConsulta == "C") { // Cruzado
		pathReport += "/pages/geraInfoPivotTable/geraInfoPivotTable.load?idConsulta=";
	} else if (tipoConsulta == "D") { // Data Table
		pathReport += "/pages/geraDataTable/geraDataTable.load?idConsulta=";
	} else if (tipoConsulta == "T") { // Template
		pathReport += "/pages/geraTemplateReport/geraTemplateReport.load?idConsulta=";
	} else if (tipoConsulta == "1") { // Grafico de Pizza em JavaScript
		pathReport += "/pages/geraGraficoPizzaJS/geraGraficoPizzaJS.load?idConsulta=";
	} else if (tipoConsulta == "2") { // Grafico de Pizza em JavaScript
		pathReport += "/pages/geraGraficoBarraJS/geraGraficoBarraJS.load?idConsulta=";
	} else if (tipoConsulta == "J") { // JSP
		pathReport += "/pages/geraJSP/geraJSP.load?idConsulta=";
	} else if (tipoConsulta == "X") { // XML do CITGerencial
		pathReport += "/pages/geraXML/geraXML.load?idConsulta=";
	} else if (tipoConsulta == "#") { // URL externa ou interna
		pathReport += "/pages/geraURL/geraURL.load?idConsulta=";
		JANELA_AGUARDE_MENU.hide();
	} else if (tipoConsulta == "S") { // Script
		pathReport += "/pages/geraScript/geraScript.load?idConsulta=";
	} else if (tipoConsulta == "R") { // Retorno de Classe
		pathReport += "/pages/geraRetornoClasse/geraRetornoClasse.load?idConsulta=";
	}
	
	pathReport += idConsulta;
	
	return pathReport;
}

function getPathReportEspecificoByTipoConsultaAndIdConsulta(tipoConsulta, idConsulta, idEspecifico) {
	var pathEspecifico = getPathReportByTipoConsultaAndIdConsulta(tipoConsulta, idConsulta);
	
	pathEspecifico += "&idEspecifico=" + idEspecifico;
	
	return pathEspecifico;
}

/**
 * Método responsável por carregar dinamicamente um JSP e, caso tenha, os arquivos JS e CSS.
 * 
 * @author douglas.japiassu
 * @since 06.02.2016
 */
function loadMultipleJsp(pages) {
	for(var i = 0, len = pages.length; i < len; i++) {
		loadJsp(pages[i]);
	}
}

function loadJsp(page) {
	if (page != undefined) {
		verificarUsuarioNaSessao().then(function(){
			$(page.idDiv).load(ctx + page.urlJsp, function(response, status, xhr) {
				if (status != "error") {
					carregaDefinicoesJsp().then(function() {
						carregaJsCss(page).then(function() {
							if (page.functionAfterLoad != undefined && page.functionAfterLoad != '') {
								if (typeof page.functionAfterLoad === 'string' || page.functionAfterLoad instanceof String) {
									eval(ObjectUtils.decodificaAspasApostrofe(page.functionAfterLoad));
								} else {
									page.functionAfterLoad();
								}
							}
						});
						
					});
				} else {
					if($(page.idDiv).attr("data-notificacao") == "true") {
						notificacaoErro(i18n_message("citcorpore.comum.permissaoFuncionalidade"));
					} else {
						$(page.idDiv).html("<div class='separator center'>" + i18n_message("citcorpore.comum.permissaoFuncionalidade") + "</div>");
					}
				}
			});
		});
	}
}

function verificarUsuarioNaSessao() {
	return new Promise(function(resolve) {
		DEFINEALLPAGES_validateUserInSession(resolve);
	});
}

function carregaDefinicoesJsp() {
	return new Promise(function(resolve) {
		DEFINEALLPAGES_reloadPageWithCallback(resolve);
	});
}

function carregaJsCss(page) {
	return new Promise(function (resolve) {
		if (page.urlCss != undefined && page.urlCss != '') {
			if (page.urlCss.constructor === Array) {
				for (var i = 0; i < page.urlCss.length; i++) {
					loadJsCssFile(ctx + page.urlCss[i], "css");
				}
			} else {
				loadJsCssFile(ctx + page.urlCss, "css");
			}
		}
		
		if (page.urlJs != undefined && page.urlJs != '') {
			if (page.urlJs.constructor === Array) {
				for (var i = 0; i < page.urlJs.length; i++) {
					if (i == (page.urlJs.length - 1)) {
						loadJsCssFile(ctx + page.urlJs[i], "js", resolve);
					} else {
						loadJsCssFile(ctx + page.urlJs[i], "js");
					}
				}
			} else {
				loadJsCssFile(ctx + page.urlJs, "js", resolve);
			}
		} else {
			resolve();
		}
	});
}

function loadJsCssFile(filename, filetype, resolve) {
	if (filetype == "js") { // if filename is a external JavaScript file
		var fileref = document.createElement('script');
		fileref.setAttribute("type", "text/javascript");
		fileref.setAttribute("src", filename);

		if (typeof fileref != "undefined") {
			document.getElementsByTagName('body')[0].appendChild(fileref);
		}
	} else if (filetype == "css") { // if filename is an external CSS file
		var fileref = document.createElement("link");
		fileref.setAttribute("rel", "stylesheet");
		fileref.setAttribute("type", "text/css");
		fileref.setAttribute("href", filename);

		if (typeof fileref != "undefined") {
			document.getElementsByTagName('head')[0].appendChild(fileref);
		}
	}
	
	if (ValidacaoUtils.isFunction(resolve)) {
		resolve();
	}
}

function removeJsp(page) {
	if (page != undefined) {
		$(page.idDiv).html("");
		if (page.urlJs != undefined && page.urlJs != '') {
			if (page.urlJs.constructor === Array) {
				for (var i = 0; i < page.urlJs.length; i++) {
					removeJsCssFile(ctx + page.urlJs[i], "js");
				}
			} else {
				removeJsCssFile(ctx + page.urlJs, "js");
			}
		}
		
		if (page.urlCss != undefined && page.urlCss != '') {
			if (page.urlCss.constructor === Array) {
				for (var i = 0; i < page.urlCss.length; i++) {
					removeJsCssFile(ctx + page.urlCss, "css");
				}
			} else {
				removeJsCssFile(ctx + page.urlCss, "css");
			}
		}
	}
}

function removeJsCssFile(filename, filetype) {
	var targetelement = (filetype == "js") ? "script"
			: (filetype == "css") ? "link" : "none" // determine element type to create nodelist from
	var targetattr = (filetype == "js") ? "src" : (filetype == "css") ? "href"
			: "none" // determine corresponding attribute to test for
	var allsuspects = document.getElementsByTagName(targetelement)
	for (var i = allsuspects.length; i >= 0; i--) { // search backwards within nodelist for matching elements to remove
		if (allsuspects[i]
				&& allsuspects[i].getAttribute(targetattr) != null
				&& allsuspects[i].getAttribute(targetattr).indexOf(filename) != -1)
			allsuspects[i].parentNode.removeChild(allsuspects[i]) // remove element by calling parentNode.removeChild()
	}
}

/**Executa uma função pelo nome
 * 
 * ex.: 
 * executeFunctionByName("functionNameWithoutNamespace", window, arguments);
 * executeFunctionByName("My.Namespace.functionName", window, arguments);
 * executeFunctionByName("Namespace.functionName", My, arguments);
 * 
 * @author deborah.ferreira
 * @param functionName
 * @param context
 * @param args
 * 
 */
function executeFunctionByName(functionName, context, args) {
	var args = [].slice.call(arguments).splice(2);
	var namespaces = functionName.split(".");
	var func = namespaces.pop();
	for(var i = 0; i < namespaces.length; i++) {
		context = context[namespaces[i]];
	}
	return context[func].apply(context, args);
}

function maximizaMinimizaJanela(obj) {
	if ($(obj).hasClass("resize_full")) {
		$(obj).removeClass("resize_full").addClass("resize_small");
		$("#footer, .navbar.main").fadeOut("fast", function() {
			$("#content").addClass('p0');
			$(".separator.top").css('padding', '5px 0 0');
			$(".innerLR").css('padding', '0 5px');
		});
	} else {
		$(obj).removeClass("resize_small").addClass("resize_full");
		$("#content").removeClass('p0');
		$(".separator.top").css('padding', '15px 0 0');
		$(".innerLR").css('padding', '0 15px');
		$("#footer, .navbar.main").fadeIn("fast");
	}
}

function groupBy(data, property) {
	return data.reduce(function(result, current) {
	    result[current[property]] = result[current[property]] || [];
	    result[current[property]].push(current);
	    return result;
	}, {})
}

var Modal = {
	isOpen : function(element) {
		if($("#" + element).data("modal") && $("#" + element).data("modal").isShown) {
			return true;
		}
		
		return false;
	},
	open : function(element, callback) {
		$("#" + element).modal('show');
		
		if (ValidacaoUtils.isFunction(callback)) {
			$("#" + element).on('shown', callback);
		}
	},
	close : function(element, callback) {
		$("#" + element).modal('hide', callback );
		
		if (ValidacaoUtils.isFunction(callback)) {
			$("#" + element).on('hidden', callback);
		}
	},
	onShown : function(element, fn) {
		if (ValidacaoUtils.isFunction(fn)) {
			$("#" + element).on('shown', fn);
		}
	},
	onHidden : function(element, fn) {
		if (ValidacaoUtils.isFunction(fn)) {
			$("#" + element).on('hidden', fn);
		}
	},
	oneShown : function(element, fn) {
		if (ValidacaoUtils.isFunction(fn)) {
			$("#" + element).one('shown', fn);
		}
	},
	oneHidden : function(element, fn) {
		if (ValidacaoUtils.isFunction(fn)) {
			$("#" + element).one('hidden', fn);
		}
	},
	adjust : function(element) {
		var modalOverflow = $(window).height() - 10 < $("#" + element).height();
		
		if (modalOverflow) {
			$("#" + element)
				.css('margin-top', 0)
				.addClass('modal-overflow');
		} else {
			$("#" + element)
				.css('margin-top', 0 - $("#" + element).height() / 2)
				.removeClass('modal-overflow');
		}
	},
	clear : function(element) {
		$("#" + element).find("form").find("input[type=text], input[type=hidden], textarea").val("");
	}
}

var Template = function(tpl, data) {
	var result = "";
	
	while(result = new RegExp(/{#([^#}]+)?#}/g).exec(tpl)) {
		tpl = tpl.replace(result[0], i18n_message(result[1]));
	}
	
	if (data != undefined) {
		result = "";
		while (result = new RegExp(/{{([^}}]+)?}}/g).exec(tpl)) {
			tpl = tpl.replace(result[0], (data[result[1]] != undefined ? data[result[1]] : ""));
		}
	}
	
	return tpl;
}

var GEO = {
	geolocation : "",
	update : function() {
		return new Promise(function (resolve) {
			if (navigator.geolocation) {
				var optn = {
						enableHighAccuracy : true,
						timeout : Infinity,
						maximumAge : 0
				};
				
				navigator.geolocation.getCurrentPosition(function(position) {
					//GEO.geolocation = "latitude: " + position.coords.latitude + ";longitude: " + position.coords.longitude;
					GEO.geolocation = position.coords.latitude + ";" + position.coords.longitude;
					resolve();
				}, function(error) {
					switch(error.code) {
						case error.PERMISSION_DENIED:
							GEO.geolocation = "User denied the request for Geolocation.";
							break;
						case error.POSITION_UNAVAILABLE:
							GEO.geolocation = "Location information is unavailable.";
							break;
						case error.TIMEOUT:
							GEO.geolocation = "The request to get user location timed out.";
							break;
						case error.UNKNOWN_ERROR:
							GEO.geolocation = "An unknown error occurred.";
							break;
					}
					
					resolve();
				}, optn);
			} else {
				GEO.geolocation = "Geolocation is not supported in your browser";
				resolve();
			}
		});
	}
}

var UUID = {
	random : function() {
		return UUID.s4() + UUID.s4() + '-' + UUID.s4() + UUID.s4() + '-' + UUID.s4() + UUID.s4() + '-' + UUID.s4() + UUID.s4();
	},
	s4 : function() {
		return Math.floor((1 + Math.random()) * 0x10000).toString(16).substring(1);
	}
};

function uuid() {
	  function s4() {
	    return Math.floor((1 + Math.random()) * 0x10000)
	      .toString(16)
	      .substring(1);
	  }
	  return s4() + s4() + '-' + s4() + '-' + s4() + '-' +
	    s4() + '-' + s4() + s4() + s4();
}


var toggleFullScreen = function(elementAction) {
	var body = $('body'),
		action = $(elementAction),
		container = action.parents('.fullscreen-container'),
		content = container.find('.fullscreen-content');
	
	action.toggleClass('resize_full').toggleClass('resize_small');
	
	body.toggleClass('fullscreen-actived');
	container.toggleClass('active');
};

function convertCanvasToImage(canvas) {
	var image = new Image();
	image.src = canvas.toDataURL("image/png");
	return image;
}

function setLanguageInDataTableOptions(data_table_options) {
	if(locale === 'pt') {
		data_table_options.language = {
			url: URL_SISTEMA + 'plugins/datatables/i18n/Portuguese-Brasil.json'
		};
	} else if(locale === 'es') {
		data_table_options.language = {
			url: URL_SISTEMA + 'plugins/datatables/i18n/Spanish.json'
		};
	}
}

var UtilSmartReport = {
	//Same of java enum br.com.centralit.citcorpore.util.Enumerados#TipoExibicaoRelatorio
	TipoExibicao : {
		NENHUM : 'N',
		GERAL: 'G',
		ESPECIFICO : 'E'
	},
	//Same of java enum br.com.centralit.citcorpore.util.Enumerados#QueryTypes
	QueryTypes : {
		SQL : 1,
		RHINOSCRIPT : 2,
		JSP : 3
	},
	//Same of java enum br.com.centralit.citcorpore.util.Enumerados#ReportTypes
	ReportTypes : {
		TEMPLATE : 1,
		LINE_CHART : 2,
		PIE_CHART : 3,
		BAR_CHART : 4,
		DATA_TABLES : 5,
		CROSS_REFERENCES : 6,
		HTML_RETURN : 7,
		
		getChartType : function(t) {
			var chartType = '';
			if (t == this.LINE_CHART) {
				chartType = 'line';
			} else if (t == this.PIE_CHART) {
				chartType = 'pie';
			} else if (t == this.BAR_CHART) {
				chartType = 'bar';
			}
			
			return chartType;
		}
	},
	randomColorFactor : function() {
		return Math.round(Math.random() * 255);
	},
	randomColor : function() {
		return 'rgba(' + UtilSmartReport.randomColorFactor() + ',' + UtilSmartReport.randomColorFactor() + ',' + UtilSmartReport.randomColorFactor() + ',.7)';
	},
	open : function(idSmartReport, specificID) {
		$("[name=formSmartReport]").attr("id", this.formSelector(idSmartReport));
		$(this.formSelector(idSmartReport, ".div-smart-report-params")).addClass('hidden');
		$(this.formSelector(idSmartReport, ".smart-report-content")).empty();
		$(this.formSelector(idSmartReport))
		$(this.formSelector(idSmartReport))[0].idSmartReport.value = idSmartReport;
		$(this.formSelector(idSmartReport))[0].specificID.value = specificID;
		
		$(this.formSelector(idSmartReport))[0].fireEvent("loadReport");
	},
	process : function(idSmartReport, setProgress) {
		if(!DEFINEALLPAGES_validarForm($(this.formSelector(idSmartReport))[0])) {
			return ;
		}
		
		if (setProgress != undefined && setProgress) {
			$(this.formSelector(idSmartReport, ".smart-report-content")).html('<div class="progress"><div class="progress-bar progress-bar-striped active" role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100" style="width: 100%"></div></div>');
		} else {
			$(this.formSelector(idSmartReport, ".smart-report-content")).html('<div class="mini-loading"></div>');
		}
		
		$(this.formSelector(idSmartReport, ".div-smart-report-params .body-params .btn-params")).attr('disabled', true);
		
		$(this.formSelector(idSmartReport))[0].idSmartReport.value = idSmartReport;
		
		$(this.formSelector(idSmartReport))[0].fireEvent("processReport");
	},
	cleanFilters : function(idSmartReport) {
		var specificID = $(this.formSelector(idSmartReport))[0].specificID;
		$(this.formSelector(idSmartReport))[0].clear();

		if (specificID != undefined) {
			$(this.formSelector(idSmartReport))[0].specificID.value = specificID.value;
		}
		$(this.formSelector(idSmartReport, ".smart-report-content")).html('');
	},
	afterLoadReport : function(idSmartReport) {
		if ($(this.formSelector(idSmartReport, ".params-field")).length == $(this.formSelector(idSmartReport, ".params-field .filled")).length) {
			this.process(idSmartReport);
		}
	},
	buildSample : function(idSmartReport, t, d, o) {
		try {
			var _this = this;
			if (t == "" || t == UtilSmartReport.ReportTypes.TEMPLATE) {
				$(_this.formSelector(idSmartReport, ".smart-report-content")).html(d);
			} else if (t == "" || t == UtilSmartReport.ReportTypes.CROSS_REFERENCES) {
				$(_this.formSelector(idSmartReport, ".smart-report-content")).html("<div id=\"output\"></div>");
				
				var data = JSON.parse(d);
				
				setTimeout(function() {
					google.charts.load('current', {'packages':['corechart']});
					var renderers = $.extend($.pivotUtilities.renderers, $.pivotUtilities.gchart_renderers);
					$(_this.formSelector(idSmartReport, "#output")).pivotUI(data, {
						renderers : renderers
					});
				}, 1000);
			} else if (t == UtilSmartReport.ReportTypes.HTML_RETURN) {
				$(_this.formSelector(idSmartReport, ".smart-report-content")).html(d);
			} else if (t == UtilSmartReport.ReportTypes.DATA_TABLES) {
				$(_this.formSelector(idSmartReport, ".smart-report-content")).html("<div id=\"output\"><table id=\"data_tables\" class=\"display\" cellspacing=\"0\" width=\"100%\"></table></div>");
				
				var data = JSON.parse(d);
				
				var result = [],
					columns = ['C'];
				if(data && data.result && data.result.length) {
					result = data.result;
				}
				if(data && data.columns && data.columns.length) {
					columns = data.columns;
				}
				setTimeout(function() {
					var data_table_options = {
						data : result,
						columns : columns
					};
					
					setLanguageInDataTableOptions(data_table_options);
					$(_this.formSelector(idSmartReport, "#data_tables")).dataTable(data_table_options);
				}, 1000);
			} else if (t == UtilSmartReport.ReportTypes.LINE_CHART || t == UtilSmartReport.ReportTypes.PIE_CHART || t == UtilSmartReport.ReportTypes.BAR_CHART) {
				$(_this.formSelector(idSmartReport, ".smart-report-content")).html("<canvas id=\"canvas\"></canvas>");
				
				var data = JSON.parse(d);
				var options = JSON.parse(o);
				
				$.each(data.datasets, function(i, val) {
					data.datasets[i].backgroundColor = [];
					for (var int = 0; int < data.datasets[i].data.length; int++) {
						data.datasets[i].backgroundColor.push(UtilSmartReport.randomColor());
					}
				});
				
				if (t == UtilSmartReport.ReportTypes.BAR_CHART || t == UtilSmartReport.ReportTypes.LINE_CHART) {
					options.tooltips = {
						mode : "label",
						callbacks: {
							label: function(tooltipItems, data) {
								return tooltipItems.yLabel;
							}
						}
					};
					
					if (t == UtilSmartReport.ReportTypes.LINE_CHART) {
						data.datasets[0].backgroundColor = UtilSmartReport.randomColor();
					}
				}
				
				setTimeout(function() {
					sample = new Chart(document.querySelector(_this.formSelector(idSmartReport, "#canvas")).getContext("2d"), {
						type : UtilSmartReport.ReportTypes.getChartType(t),
						data : data,
						options : options
					});
				}, 1000);
			}
			
			if ($("#modal-smart-report").length > 0) {
				Modal.open("modal-smart-report");
			}
			setTimeout(function() {
				$(_this.formSelector(idSmartReport, ".div-smart-report-params .btn-params")).attr("disabled", false);
				$(_this.formSelector(idSmartReport, ".div-smart-report-params .collapse")).collapse("toggle");
				UtilSmartReport.toggleFilter(_this.formSelector(idSmartReport, ".div-smart-report-params.filter"));
			}, 1000);
		} catch(err) {
			notificacaoErro('', i18n_message("construtorconsultas.naoFoiPossivelConstruirRelatorio") + "." + (err != undefined && err != "" ? "<br/>" + i18n_message("citcorpore.comum.erro") + ": " + err : ""));
		}
	},
	buildJSP : function(idSmartReport, url, specificID) {
		var _this = this;
		$(_this.formSelector(idSmartReport, ".div-smart-report-params")).addClass('hidden');
		if (specificID != 0) {
			url += "?specificID=" + specificID;
		}
		
		$(_this.formSelector(idSmartReport, ".smart-report-content")).html("<iframe id=\"jsp-build\" name=\"jsp-build\" class=\"iframe\" src=\"\"></iframe>");
		$(_this.formSelector(idSmartReport, "#jsp-build")).attr("src", url);
		
		var resizeIframe = function() {
			var iframeElement = $(_this.formSelector(idSmartReport, ".smart-report-content iframe"));
			if(iframeElement.contents() && iframeElement.contents().find('body')) {
				iframeElement.css('height', iframeElement.contents().find('body *:first').height() + 100);
				clearInterval(intervalResizeIframe);
			}
		};
		var intervalResizeIframe = setInterval(resizeIframe, 2000);
		
		if ($("#modal-smart-report").length > 0) {
			Modal.open("modal-smart-report");
		}
	},
	collapseWidget : function(that) {
		$(that).parent().children('.widget-body').collapse('toggle');
	},
	toggleFilter : function(that) {
		if ($(that).is(":visible")) {
			$(that).stop().slideUp();
		} else {
			$(that).stop().slideDown();
		}
	},
	reportError : function(idSmartReport, err) {
		var _this = this;
		setTimeout(function() {
			$(_this.formSelector(idSmartReport, ".div-smart-report-params .btn-params")).attr('disabled', false);
		}, 1000);
		if (err != '') {
			$(_this.formSelector(idSmartReport, ".smart-report-content")).html('<h4 class=\'center\'>' + i18n_message(err) + '</h4>');
		} else {
			$(_this.formSelector(idSmartReport, ".smart-report-content")).html('');
		}
	},
	formSelector : function(idSmartReport, querySelector) {
		if (querySelector != undefined) {
			return "#formSmartReport" + idSmartReport + " " + querySelector;
		}
		
		return "#formSmartReport" + idSmartReport;
	}
}

var Notification = {
	success : function(message) {
		if ($(".notification-container .notification").length > 0 && $(".notification-container .notification .alert.alert-success .message").text() == message) {
			return false;
		}
		
		var template = Template(Notification._template(), {
			message : message,
			type : "alert-success"
		});
		
		$(".notification-container").prepend(template);
		
		$(".notification-container > .notification").slideDown(function() {
			clearTimeout(Notification._timeout);
			Notification._timeout = window.setTimeout(function() {
				$(".notification-container > .notification").slideUp(function() {
					$(".notification-container > .notification").remove();
				});
			}, 4000);
		});
	},
	error : function(message) {
		if ($(".notification-container .notification").length > 0 && $(".notification-container .notification .alert.alert-danger .message").text() == message) {
			return false;
		}
		
		var template = Template(Notification._template(), {
			message : message,
			type : "alert-danger"
		});
		
		$(".notification-container").prepend(template);
		
		$(".notification-container > .notification").slideDown(function() {
			clearTimeout(Notification._timeout);
			Notification._timeout = window.setTimeout(function() {
				$(".notification-container > .notification").slideUp(function() {
					$(".notification-container > .notification").remove();
				});
			}, 4000);
		});
	},
	_template : function() {
		return "<div class='notification row'><div class='col-md-4 col-md-offset-8'><div class='alert {{type}} alert-dismissible' role='alert'><button type='button' class='close' data-dismiss='alert' aria-label='" + i18n_message("citcorpore.comum.fechar") + "'><span aria-hidden='true'>&times;</span></button><span class='message'>{{message}}</span></div></div></div>";
	},
	_timeout: function() {}
}
