/**
 * Utilitrios para uso de artefatos geogrficos, como formataes, converses e validaes
 *
 * @author bruno.ribeiro - <a href="mailto:bruno.ribeiro@centrait.com.br">bruno.ribeiro@centrait.com.br</a>
 * @since 12/09/2014
 */
(function( $ ) {
	"use strict";

	/**
	 * Valida se a(s) coordenada(s) (so) vlida(s), independente se  latitude ou longitude, validando apenas a quantidade de casas, nmeros, etc.
	 *
	 * @returns <code>true</code> caso seja(m) vlida(s). <code>false</code>, caso contrrio.
	 */
	$.fn.validateCoordinates = function() {
		return GeoUtils.validateCoordinatesa(arguments);
	};

	/**
	 * Verifica se latitude e longitude so ou no vlidas
	 *
	 * @param params parmetros contendo a latitude e longitude a serem validadas
	 * @returns <code>true</code> caso latitude e longitude so vlidas. <code>false</code>, caso contrrio.
	 */
	$.fn.validateCoordinates = function(params) {
		return GeoUtils.validateCoordinates(params);
	};

	/**
	 * Verifica se uma latitude  ou no vlida
	 *
	 * @param latitude latitude a ser validada
	 * @returns <code>true</code> caso latitude seja vlida. <code>false</code>, caso contrrio.
	 */
	$.fn.validLatitude = function(latitude) {
		return GeoUtils.validLatitude(latitude);
	};

	/**
	 * Verifica se uma longitude  ou no vlida
	 *
	 * @param longitude longitude a ser validada
	 * @returns <code>true</code> caso longitude seja vlida. <code>false</code>, caso contrrio.
	 */
	$.fn.validLongitude = function(longitude) {
		return GeoUtils.validLongitude(longitude);
	};

	/**
	 * Converte uma posio decimal para uma representao DMS
	 * 
	 * @param {Number} coordenada geogrfica
	 * @param {string} string que representa o ponto cardeal
	 * @return {string} 
	 */
	$.fn.decimalToDMS = function(location, hemisphere){
		return GeoUtils.decimalToDMS(location, hemisphere);
	};

	/**
	 * Converte uma latitude representada em decimal para uma representao DMS
	 * 
	 * @param {Number} latitude em decimal
	 */
	$.fn.decimalLatitudeToDMS = function(location) {
		return GeoUtils.decimalLatitudeToDMS(location);
	};

	/**
	 * Converte uma longitude representada em decimal para uma representao DMS
	 *
	 * @param {Number} longitude em decimal
	 * @return {string} longitude em DMS
	 */
	$.fn.decimalLongitudeToDMS = function(location){
		var hemisphere = (location < 0) ? west : east;  // west if negative
		return $().decimalToDMS(location, hemisphere);
	};

	var dmsPattern = /^(-?\d+(?:\.\d+)?)[:d]?\s?(?:(\d+(?:\.\d+)?)[':]?\s?(?:(\d+(?:\.\d+)?)["]?)?)?\s?([NSELWO])?/i;

	/** 
	 * Converte representao de coordenadas em DMS em representao decimal da coordenada
	 * 
	 * @param {string}  dms string contendo uma coordenada no formato DMS
	 * @return {Number} Se DMS  uma coordenada vlida, o valor decimal ser retornado. Do contrrio 'NaN' ser retornado.
	 */
	$.fn.dmsToDecimal = function(dms) {
		return GeoUtils.dmsToDecimal(dms);
	};

	/**
	 * Valida a existncia de configurao do Google
	 *
	 * @param {properties} objeto de propriedades que contenha o atributo 'key' da Google API Key
	 * @return {Boolean} 'true', caso exista a configurao do google e esta seja vlida. 'false', caso contrrio
	 */
	$.fn.hasGoogleConfiguration = function(properties) {
		return GeoUtils.hasGoogleConfiguration(properties);
	};

	/**
	 * Valida a existncia de conexo com a internet
	 *
	 * @param {onsucces} funo a ser executada no caso de falta de conexo  internet
	 * @param {onerror} funo a ser executada no caso de existncia de conexo  internet
	 */
	$.fn.hasInternetConection = function(onsucces, onerror) {
		return GeoUtils.hasInternetConection(onsucces, onerror);
	};

	/**
	 * Insere mensagem de alerta ao usurio informando sobre a no configurao da API Key do Google ou Client ID
	 *
	 * @param {params} parmetros
	 */
	$.fn.messageAPIKeyOrClientIDConfiguration = function(params) {
		var hasGoogleConfig = $().hasGoogleConfiguration(params);
		if (!hasGoogleConfig) {
			var message = i18n_message("geographic.without.google.api.config.warning");
			var warning = '<div id="no-config" class="alert no-key">{0}</div>';
			$(this).html(StringUtils.format(warning, message));
		}
	};

	/**
	 * Insere mensagem de alerta ao usurio informando sobre indisponibilidade de conexo  internet
	 */
	$.fn.messageHasInternetConection = function() {
		var message = i18n_message("geographic.without.internet.connection.error");
		var warning = '<div id="no-config" class="alert alert-error no-connection">{0}</div>';
		$(this).removeClass("map-area");
		$(this).html(StringUtils.format(warning, message));
	};

}( jQuery ));
