//	mootools.js: moo javascript tools
//	by Valerio Proietti (http://mad4milk.net) MIT-style license.

//  CREDITS:

//	Class is slightly based on Base.js : http://dean.edwards.name/weblog/2006/03/base/
//		(c) 2006 Dean Edwards, License: http://creativecommons.org/licenses/LGPL/2.1/

//	Some functions are based on those found in prototype.js : http://prototype.conio.net/
//		(c) 2005 Sam Stephenson <sam@conio.net>, MIT-style license


//moo.js : My Object Oriented javascript - has no dependancies

var Class = function(properties){
	var klass = function(){
		for (p in this) this[p]._proto_ = this;
		if (arguments[0] != 'noinit' && this.initialize) return this.initialize.apply(this, arguments);
	};
	klass.extend = this.extend;
	klass.implement = this.implement;
	klass.prototype = properties;
	return klass;
};

Class.empty = function(){};

Class.create = function(properties){
	return new Class(properties);
};

Class.prototype = {
	extend: function(properties){
		var prototype = new this('noinit');
		for (property in properties){
			var previous = prototype[property];
			var current = properties[property];
			if (previous && previous != current) current = previous.parentize(current) || current;
			prototype[property] = current;
		}
		return new Class(prototype);
	},

	implement: function(properties){
		for (property in properties) this.prototype[property] = properties[property];
	}
}

Object.extend = function(){
	var args = arguments;
	if (args[1]) args = [args[0], args[1]];
	else args = [this, args[0]];
	for (property in args[1]) args[0][property] = args[1][property];
	return args[0];
};

Object.Native = function(){
	for (var i = 0; obj = arguments[i]; i++) obj.extend = Class.prototype.implement;
};

new Object.Native(Function, Array, String);

Function.extend({
	parentize: function(current){
		var previous = this;
		return function(){
			this.parent = previous;
			return current.apply(this, arguments);
		};
	}
});

//Function.js : Function extension - Depends on Moo.js

Function.extend({

	bind: function(bind){
		var fn = this;
		return function(){
			return fn.apply(bind, arguments);
		};
	},

	bindAsEventListener: function(bind){
		return function(event){
			this.call(bind, event || window.event);
			return false;
		}.bind(this);
	},

	delay: function(ms, bind){
		return setTimeout(this.bind(bind || this._proto_ || this), ms);
	},

	periodical: function(ms, bind){
		return setInterval(this.bind(bind || this._proto_ || this), ms);
	}

});

function $clear(timer){
	clearTimeout(timer);
	clearInterval(timer);
	return null;
};

function $type(obj, types){
	if (!obj) return false;
	var type = false;
	if (obj instanceof Function) type = 'function';
	else if (obj.nodeName){
		if (obj.nodeType == 3 && !/\S/.test(obj.nodeValue)) type = 'textnode';
		else if (obj.nodeType == 1) type = 'element';
	}
	else if (obj instanceof Array) type = 'array';
	else if (typeof obj == 'object') type = 'object';
	else if (typeof obj == 'string') type = 'string';
	else if (typeof obj == 'number' && isFinite(obj)) type = 'number';
	return type;
};

function $check(obj, ret){
	if (obj) return ret || obj;
	return false;
};

var Chain = new Class({

	chain: function(fn){
		this.chains = this.chains || [];
		this.chains.push(fn);
		return this;
	},

	callChain: function(){
		if (this.chains && this.chains.length) this.chains.splice(0, 1)[0].delay(10, this);
	}

});

//Array.js : Array extension - depends on Moo.js

if (!Array.prototype.forEach){
	Array.prototype.forEach = function(fn, bind){
		for(var i = 0; obj = this[i]; i++) fn.call(bind, obj, i);
	};
}

Array.extend({

	each: Array.prototype.forEach,

	copy: function(){
		var nArray = [];
		for (var i = 0; el=this[i]; i++) nArray.push(el);
		return nArray;
	},

	remove: function(item){
		for (var i = 0; el = this[i]; i++){
			if (el == item) this.splice(i, 1);
		}
		return this;
	},

	test: function(item){
		for (var i = 0; el=this[i]; i++){
			if (el == item) return true;
		};
		return false;
	},

	extend: function(nArray){
		for (var i = 0; el = nArray[i]; i++) this.push(el);
		return this;
	}

});

function $A(array){
	return Array.prototype.copy.call(array);
};

//String.js : String extension - depends on Moo.js

String.extend({

	test: function(value, params){
		return new RegExp(value, params).exec(this);
	},

	camelCase: function(){
		return this.replace(/-\D/gi, function(match){
			return match.charAt(match.length - 1).toUpperCase();
		});
	},

	capitalize: function(){
		return this.toLowerCase().replace(/\b[a-z]/g, function(match){
			return match.toUpperCase();
		});
	},

	trim: function(){
		return this.replace(/^\s*|\s*$/g,'');
	},

	clean: function(){
		return this.replace(/\s\s/g, ' ').trim();
	},

	toHex: function(){
		var N = parseInt(this);
		if (N==0 || isNaN(N)) return "00";
		N = Math.round(Math.min(Math.max(0,N),255));
		return "0123456789ABCDEF".charAt((N-N%16)/16) + "0123456789ABCDEF".charAt(N%16);
	},

	rgbToHex: function(){
		var rgb = this.match(/[rgba]{3,4}\(([\d]{0,3}),[\s]([\d]{0,3}),[\s]([\d]{0,3})\)/);
		return rgb[1].toHex()+rgb[2].toHex()+rgb[3].toHex();
	}

});

//Element.js : Element methods - depends on Moo.js + Native Scripts

var Element = new Class({

	//creation

	initialize: function(el){
		if ($type(el) == 'string') el = document.createElement(el);
		return $(el);
	},

	//injecters

	inject: function(el, where){
		el = new Element(el);
		switch(where){
			case "before": $(el.parentNode).insertBefore(this, el); break;
			case "after": {
					if (!el.getNext()) $(el.parentNode).appendChild(this);
					else $(el.parentNode).insertBefore(this, el.getNext());
			} break;
			case "inside": el.appendChild(this); break;
		}
		return this;
	},

	injectBefore: function(el){
		return this.inject(el, 'before');
	},

	injectAfter: function(el){
		return this.inject(el, 'after');
	},

	injectInside: function(el){
		return this.inject(el, 'inside');
	},

	adopt: function(el){
		return new Element(el).injectInside(this);
	},

	//actions

	remove: function(){
		this.parentNode.removeChild(this);
	},

	clone: function(){
		return $(this.cloneNode(true));
	},

	hasClassName: function(className){
		return $check(this.className.clean().test("(^| )"+className.trim()+"($| )", "g"), true);
	},

	addClassName: function(className){
		if (!this.hasClassName(className)) this.className = (this.className+' '+className.trim()).clean();
		return this;
	},

	removeClassName: function(className){
		if (this.hasClassName(className)) this.className = this.className.replace(className.trim(), '').clean();
		return this;
	},

	toggleClassName: function(className){
		if (this.hasClassName(className)) return this.removeClassName(className);
		else return this.addClassName(className);
	},

	removeStyles: function(){
		$A(arguments).each(function(property){
			this.style[property.camelCase()] = '';
		}, this);
		return this;
	},

	//events

	addEvent: function(action, fn){
		this[action+fn] = fn.bind(this);
		if (this.addEventListener) this.addEventListener(action, fn, false);
		else this.attachEvent('on'+action, this[action+fn]);
		var el = this;
		if (this != window) Unload.functions.push(function(){
			el.removeEvent(action, fn);
			el[action+fn] = null;
		});
		return this;
	},

	removeEvent: function(action, fn){
		if (this.removeEventListener) this.removeEventListener(action, fn, false);
		else this.detachEvent('on'+action, this[action+fn]);
		return this;
	},

	//get siblings

	getBrother: function(what){
		var el = this[what+'Sibling'];
		while ($type(el) == 'textnode') el = el[what+'Sibling'];
		return el;
	},

	getPrevious: function(){
		return this.getBrother('previous');
	},

	getNext: function(){
		return this.getBrother('next');
	},

	//setters

	setStyle: function(property, value){
		if (property == 'opacity') this.setOpacity(value);
		else this.style[property.camelCase()] = value;
		return this;
	},

	setOpacity: function(opacity){
		if (opacity == 0 && this.style.visibility != "hidden") this.style.visibility = "hidden";
		else if (this.style.visibility != "visible") this.style.visibility = "visible";
		if (window.ActiveXObject) this.style.filter = "alpha(opacity=" + opacity*100 + ")";
		this.style.opacity = opacity;
		return this;
	},

	setStyles: function(source){
		for (property in source) this.setStyle(property, source[property]);
		return this;
	},

	setProperty: function(property, value){
		if (property == 'class') this.className = value;
		else if (property == 'style') this.setStyles(value);
		return this;
	},

	setProperties: function(source){
		for (property in source) this.setProperty(property, source[property]);
		return this;
	},

	setHTML: function(html){
		this.innerHTML = html;
		return this;
	},

	//getters

	getStyle: function(property){
		if (document.defaultView) return $check(document.defaultView.getComputedStyle(this,null).getPropertyValue(property));
		else if (this.currentStyle) return $check(this.currentStyle[property.camelCase()]);
	},

	getTag: function(){
		return this.tagName.toLowerCase();
	},

	getOffset: function(what){
		what = what.capitalize();
		var el = this;
		var offset = 0;
		do {
			offset += el['offset'+what] || 0;
			el = el.offsetParent;
		} while (el);
		return offset;
	},

	getTop: function(){
		return this.getOffset('top');
	},

	getLeft: function(){
		return this.getOffset('left');
	}
});

new Object.Native(Element);

function $(el){
	if ($type(el) == 'string') el = $check(document.getElementById(el));
	if (el && !el.extend){
		Unload.elements.push(el);
		el.extend = Object.extend;
		el.extend(Element.prototype);
	}
	return $check(el);
};

//garbage collector

window.addEvent = Element.prototype.addEvent;
window.removeEvent = Element.prototype.removeEvent;

var Unload = {

	elements: [], functions: [], vars: [],

	unload: function(){
		Unload.functions.each(function(fn){
			fn();
		});

		window.removeEvent('unload', window.removeFunction);

		Unload.elements.each(function(el){
			for(p in Element.prototype){
				window[p] = null;
				document[p] = null;
				el[p] = null;
			}
			el.extend = null;
		});
	}

};
window.removeFunction = Unload.unload;
window.addEvent('unload', window.removeFunction);

//Dom.js - depends on Moo.js + Native Scripts

function $$(array){
	array = $A(array);
	array.implement = Object.extend;
	array = array.implement(new Elements);
	array.each(function(el){
		el = $(el);
	});
	return array;
};

function $S(){
	var els = [];
	$A(arguments).each(function(sel){
		if ($type(sel) == 'string') els.extend(document.getElementsBySelector(sel));
		else if ($type(sel) == 'element') els.push(sel);
	});
	return $$(els);
};

function $E(selector, filter){
	return ($(filter) || document).getElement(selector);
};

Element.extend({

	getElements: function(selector){
		var params = [];
		selector.clean().split(' ').each(function(sel, i){
			params[i] = param = [];
			var bits = [];
			if (bits = /^[\w#.-]*?\[["'\s]{0,1}([\w-]*)["'\s]{0,1}([\W]{0,1}=){0,2}["'\s]{0,1}([\w-]*)["'\s]{0,1}\]$/.exec(sel)){
				param['attribute'] = bits[1];
				param['special'] = bits[2];
				param['value'] = bits[3];
			}
			if (bits = sel.test('^([a-zA-Z]*)([.#])([a-z0-9_-]*)$')){
				param['tag'] = bits[1];
				if (bits[2] == '#') param['id'] = bits[3];
				else param['class'] = bits[3];
			} else if (bits = sel.test('([a-zA-Z0-9]*)')) param['tag'] = bits[1];
		});

		var filters = [];
		params.each(function(param, k){
			if(!param['tag']) param['tag'] = '*';
			if (k == 0){
				if (param['id']){
					var el = this.getElementById(param['id']);
					if (el && (param['tag'] == '*' || el.getTag() == param['tag'])) filters = [$(el)];
					else return false;
				} else filters = $$(this.getElementsByTagName(param['tag']));
			} else {
				filters = $$(filters).getElementsByTagName(param['tag']);
				if (param['id']) filters = $$(filters).filterById(param['id']);
			}

			if (param['class']) filters = $$(filters).filterByClassName(param['class']);
			if(param['attribute']) filters = $$(filters).filterByAttribute(param['attribute'], param['value'], param['special']);
		}, this);

		return $$(filters);
	},

	getElement: function(selector){
		return this.getElementsBySelector(selector)[0];
	},

	getElementsBySelector: function(selector){
		var els = [];
		selector.split(',').each(function(sel){
			els.extend(this.getElements(sel.trim()));
		}, this);
		return $$(els);
	}

});

document.extend = Object.extend;

document.extend({

	getElementsByClassName: function(className){
		return document.getElements('.'+className);
	},
	getElement: Element.prototype.getElement,
	getElements: Element.prototype.getElements,
	getElementsBySelector: Element.prototype.getElementsBySelector

});

var Elements = new Class({

	action: function(actions){
		this.each(function(el){
			el = $(el);
			if (actions.initialize) actions.initialize.apply(el);
			for(action in actions){
				var evt = false;
				if (action.test('^on[\\w]{1,}')) el[action] = actions[action];
				else if (evt = action.test('([\\w-]{1,})event$')) el.addEvent(evt[1], actions[action]);
			}
		});
	},

	filterById: function(id){
		var found = [];
		this.each(function(el){
			if (el.id == id) found.push(el);
		});
		return found;
	},

	filterByClassName: function(className){
		var found = [];
		this.each(function(el){
			if (el.hasClassName(className)) found.push(el);
		});
		return found;
	},

	filterByAttribute: function(attribute, value, special){
		var found = [];
		this.each(function(el){
			var att = el.getAttribute(attribute);
			if(!att) return;
			if (!special) return found.push(el);

			switch(special){
				case '*=': if (att.test(value)) found.push(el); break;
				case '=': if (att == value) found.push(el); break;
				case '^=': if (att.test('^'+value)) found.push(el); break;
				case '$=': if (att.test(value+'$')) found.push(el);
			}

		});
		return found;
	},

	getElementsByTagName: function(tagName){
		var found = [];
		this.each(function(el){
			found.extend($$(el.getElementsByTagName(tagName)));
		});
		return found;
	}

});

new Object.Native(Elements);

//DragDrop.js - depends on Moo.js + Native Scripts

var Drag = new Class({

	setOptions: function(options){
		this.options = {
			handle: false,
			unit: 'px',
			onStart: Class.empty,
			onComplete: Class.empty,
			onDrag: Class.empty,
			onSnap: Class.empty,
			droppables: [],
			xMax: false,
			xMin: false,
			yMax: false,
			yMin: false,
			xModifier: 'left',
			yModifier: 'top',
			snapDistance: 8,
			snap: true,
			doSnap: true
		};
		Object.extend(this.options, options || {});
	},

	initialize: function(el, options){
		this.setOptions(options);
		this.el = $(el);
		this.options.handle = this.options.handle || el;
		if (this.options.xModifier) this.xp = this.options.xModifier.camelCase();
		if (this.options.yModifier) this.yp = this.options.yModifier.camelCase();
		this.options.handle.onmousedown = this.start.bind(this);
	},

	start: function(evt){
		evt = evt || window.event;
		this.options.onStart.delay(10, this);
		if (this.options.snap){
			this.startX = evt.clientX;
			this.startY = evt.clientY;
			document.onmousemove = this.checkAndDrag.bind(this);
		} else {
			this.set(evt);
			document.onmousemove = this.drag.bind(this);
		}
		document.onmouseup = this.end.bind(this);
		return false;
	},

	checkAndDrag: function(evt){
		evt = evt || window.event;
		var distance = Math.round(Math.sqrt(Math.pow(evt.clientX - this.startX, 2)+Math.pow(evt.clientY - this.startY, 2)));
		if (distance > this.options.snapDistance){
			this.set(evt);
			this.options.onSnap.delay(10, this);
			document.onmousemove = this.drag.bind(this);
			if (this.options.doSnap){
				if (this.xp) this.el.style[this.xp] = parseInt(this.el.getStyle(this.xp))-(this.startX-evt.clientX)+this.options.unit;
				if (this.yp) this.el.style[this.yp] = parseInt(this.el.getStyle(this.yp))-(this.startY-evt.clientY)+this.options.unit;
			}
		}
		return false;
	},

	drag: function(evt){
		evt = evt || window.event;
		this.options.onDrag.delay(10, this);
		var x = evt.clientX;
		var y = evt.clientY;
		if (this.xp && (!this.options.xMax || this.options.xMax < x) && (!this.options.xMin || this.options.xMin > x)){
			var xv = parseInt(this.el.getStyle(this.xp)) || 0;
			this.el.style[this.xp] = xv+x-this.lastMouseX+this.options.unit;
		}
		if (this.yp && (!this.options.yMax || this.options.yMax < y) && (!this.options.yMin || this.options.yMin > y)){
			var yv = parseInt(this.el.getStyle(this.yp)) || 0;
			this.el.style[this.yp] = yv+y-this.lastMouseY+this.options.unit;
		}
		this.options.droppables.each(function(drop){
			if (this.checkAgainst(x, y, drop)){
				if (drop.onOver && !drop.dropping) drop.onOver(this.el);
				drop.dropping = true;
			} else {
				if (drop.onLeave && drop.dropping) drop.onLeave(this.el);
				drop.dropping = false;
			}
		}, this);
		this.set(evt);
		return false;
	},

	set: function(evt){
		this.lastMouseX = evt.clientX;
		this.lastMouseY = evt.clientY;
		return false;
	},

	checkAgainst: function(x, y, drop){
		drop = $(drop);
		var h = drop.offsetHeight;
		var t = drop.getTop();
		var l = drop.getLeft();
		var w = drop.offsetWidth;
		if (x > l && x < l+w && y < t+h && y > t) return true;
		else return false;
	},

	end: function(){
		document.onmousemove = null;
		document.onmouseup = null;
		this.options.droppables.each(function(drop){
			if (this.checkAgainst(this.lastMouseX, this.lastMouseY, drop) && drop.onDrop) drop.onDrop(this.el);
		}, this);
		this.options.onComplete.delay(10, this);
	}

});

Element.extend({

	makeDraggable: function(options){
		return new Drag(this, options);
	},

	makeResizable: function(options){
		return new Drag(this, Object.extend({xModifier: 'width', yModifier: 'height'}, options));
	}

});