var primaryColor = '#8ec657', dangerColor = '#b55151', successColor = '#609450', warningColor = '#ab7a4b', inverseColor = '#45484d';
var themerPrimaryColor = primaryColor;

var UtilCharts = {
	utility : {
		chartColors : [ themerPrimaryColor, "#444", "#777", "#999", "#DDD", "#EEE" ],
		chartBackgroundColors : [ "transparent", "transparent" ],
		applyStyle : function(that) {
			that.options.grid.backgroundColor = {
				colors : UtilCharts.utility.chartBackgroundColors
			};
			that.options.grid.borderColor = UtilCharts.utility.chartColors[1];
			that.options.grid.color = UtilCharts.utility.chartColors[1];
		},
		randNum: function() {
			return (Math.floor( Math.random()* (1+40-20) ) ) + 20;
		}
	},
	pieChart : {
		data : [],
		plot : null,
		options : {
			series : {
				pie : {
					show : true,
					highlight : {
						opacity : 0.1
					},
					radius : 1,
					startAngle : 2,
					label : {
						show : true,
						radius : 1,
						formatter : function(label, series) {
							return '<div class="label label-inverse">' + label
									+ '&nbsp;' + series.data[0][1] + '</div>';
						}
					}
				}
			},
			grid : {
				hoverable : true,
				clickable : true,
				backgroundColor : {}
			},
			colors : [ "#96CA65", "#D1CC43", "#CC4141", "#444", "#777", "#999", "#DDD", "#EEE" ],
			tooltip : true,
			tooltipOpts : {
				content : "%s: %y.0",
				shifts : {
					x : -30,
					y : -50
				},
				defaultTheme : false
			}
		},
		init : function(idDiv) {
			UtilCharts.utility.applyStyle(this);
			this.plot = $.plot($("#" + idDiv), this.data, this.options);
		}
	},
	lineChart : {
		data : [],
		plot : null,
		options : {
			grid : {
				show : true,
				aboveData : true,
				color : "#3f3f3f",
				labelMargin : 5,
				axisMargin : 0,
				borderWidth : 0,
				borderColor : null,
				minBorderMargin : 5,
				clickable : true,
				hoverable : true,
				autoHighlight : true,
				mouseActiveRadius : 20
			},
			series : {
				grow : {
					active : false
				},
				lines : {
					show : true,
					lineWidth : 2,
					steps : false
				},
				points : {
					show : false
				}
			},
			legend : {
				position : "sw",
				backgroundColor : null,
				backgroundOpacity : 0
			},
			yaxis : {
				max : 100,
				ticks : ['0', '10', '20', '30', '40', '50', '60', '70', '80', '90', '100'],
				tickDecimals : 0
			},
			xaxis : {
				mode : "time"
			},
			colors : [ "#96CA65", "#D1CC43", "#CC4141", "#444", "#777", "#999", "#DDD", "#EEE" ],
			shadowSize : 1,
			tooltip : true,
			tooltipOpts : {
				content : "%s: %y.0",
				shifts : {
					x : -30,
					y : -50
				},
				defaultTheme : false
			}
		},
		init : function(idDiv) {
			UtilCharts.utility.applyStyle(this);
			this.plot = $.plot($("#" + idDiv), this.data, this.options);
		}
	}
}
