if(jQuery)(function($){$.minicolors={settings:{defaultSlider:'hue',letterCase:'lowercase',hideSpeed:100,showSpeed:100,animationSpeed:100,animationEasing:'swing'},init:function(){$('INPUT[data-type=minicolors]').each(function(){init($(this));});},remove:function(input){$(input).each(function(){remove($(this));});},refresh:function(){$('INPUT[data-type=minicolors]').each(function(){refresh($(this));});},show:function(input){show($(input).eq(0));},hide:function(){hide();},rgbObject:function(input){var hex=parseHex($(input).val(),true),rgb=hex2rgb(hex),opacity=input.attr('data-opacity');if(!rgb)return null;if(opacity!==undefined)$.extend(rgb,{a:parseFloat(opacity)});return rgb;},rgbString:function(input){var hex=parseHex($(input).val(),true),rgb=hex2rgb(hex),opacity=input.attr('data-opacity');if(!rgb)return null;if(opacity===undefined){return'rgb('+rgb.r+', '+rgb.g+', '+rgb.b+')';}else{return'rgba('+rgb.r+', '+rgb.g+', '+rgb.b+', '+parseFloat(opacity)+')';}}};function init(input){var minicolors=$('<span class="minicolors" />'),sliderType=input.attr('data-slider')||$.minicolors.settings.defaultSlider;if(input.data('initialized'))return;minicolors.attr('class',input.attr('data-class')).attr('style',input.attr('data-style')).toggleClass('minicolors-swatch-left',input.attr('data-swatch-position')==='left').toggleClass('minicolors-with-opacity',input.attr('data-opacity')!==undefined);if(input.attr('data-position')!==undefined){$.each(input.attr('data-position').split(' '),function(){minicolors.addClass('minicolors-position-'+this);});}
input.data('initialized',true).attr('data-default',input.attr('data-default')||'').attr('data-slider',sliderType).prop('size',7).prop('maxlength',7).wrap(minicolors).after('<span class="minicolors-panel minicolors-slider-'+sliderType+'">'+'<span class="minicolors-slider">'+'<span class="minicolors-picker"></span>'+'</span>'+'<span class="minicolors-opacity-slider">'+'<span class="minicolors-picker"></span>'+'</span>'+'<span class="minicolors-grid">'+'<span class="minicolors-grid-inner"></span>'+'<span class="minicolors-picker"><span></span></span>'+'</span>'+'</span>');input.parent().find('.minicolors-panel').on('selectstart',function(){return false;}).end();if(input.attr('data-swatch-position')==='left'){input.before('<span class="minicolors-swatch"><span></span></span>');}else{input.after('<span class="minicolors-swatch"><span></span></span>');}
if(input.attr('data-textfield')==='false')input.addClass('minicolors-hidden');if(input.attr('data-control')==='inline')input.parent().addClass('minicolors-inline');updateFromInput(input);}
function refresh(input){updateFromInput(input);}
function remove(input){var minicolors=input.parent();if(input.data('initialized')&&minicolors.hasClass('minicolors')){minicolors.remove();}}
function show(input){var minicolors=input.parent(),panel=minicolors.find('.minicolors-panel');if(!input.data('initialized')||input.prop('disabled')||minicolors.hasClass('minicolors-focus'))return;hide();minicolors.addClass('minicolors-focus');panel.stop(true,true).fadeIn($.minicolors.settings.showSpeed);}
function hide(){$('.minicolors:not(.minicolors-inline)').each(function(){var minicolors=$(this),input=minicolors.find('INPUT');minicolors.find('.minicolors-panel').fadeOut($.minicolors.settings.hideSpeed,function(){minicolors.removeClass('minicolors-focus');});});}
function move(target,event,animate){var input=target.parents('.minicolors').find('INPUT'),picker=target.find('[class$=-picker]'),offsetX=target.offset().left,offsetY=target.offset().top,x=Math.round(event.pageX-offsetX),y=Math.round(event.pageY-offsetY),duration=animate?$.minicolors.settings.animationSpeed:0,wx,wy,r,phi;if(event.originalEvent.changedTouches){x=event.originalEvent.changedTouches[0].pageX-offsetX;y=event.originalEvent.changedTouches[0].pageY-offsetY;}
if(x<0)x=0;if(y<0)y=0;if(x>target.width())x=target.width();if(y>target.height())y=target.height();if(target.parent().is('.minicolors-slider-wheel')&&picker.parent().is('.minicolors-grid')){wx=75-x;wy=75-y;r=Math.sqrt(wx*wx+wy*wy);phi=Math.atan2(wy,wx);if(phi<0)phi+=Math.PI*2;if(r>75){r=75;x=75-(75*Math.cos(phi));y=75-(75*Math.sin(phi));}
x=Math.round(x);y=Math.round(y);}
if(target.is('.minicolors-grid')){picker.stop(true).animate({top:y+'px',left:x+'px'},duration,$.minicolors.settings.animationEasing,function(){updateFromControl(input);});}else{picker.stop(true).animate({top:y+'px'},duration,$.minicolors.settings.animationEasing,function(){updateFromControl(input);});}}
function updateFromControl(input){function getCoords(picker,container){var left,top;if(!picker.length||!container)return null;left=picker.offset().left;top=picker.offset().top;return{x:left-container.offset().left+(picker.outerWidth()/2),y:top-container.offset().top+(picker.outerHeight()/2)};}
var hue,saturation,brightness,opacity,rgb,hex,x,y,r,phi,minicolors=input.parent(),panel=minicolors.find('.minicolors-panel'),swatch=minicolors.find('.minicolors-swatch'),hasOpacity=input.attr('data-opacity')!==undefined,sliderType=input.attr('data-slider'),grid=minicolors.find('.minicolors-grid'),slider=minicolors.find('.minicolors-slider'),opacitySlider=minicolors.find('.minicolors-opacity-slider'),gridPicker=grid.find('[class$=-picker]'),sliderPicker=slider.find('[class$=-picker]'),opacityPicker=opacitySlider.find('[class$=-picker]'),gridPos=getCoords(gridPicker,grid),sliderPos=getCoords(sliderPicker,slider),opacityPos=getCoords(opacityPicker,opacitySlider);switch(sliderType){case'wheel':x=(grid.width()/2)-gridPos.x;y=(grid.height()/2)-gridPos.y;r=Math.sqrt(x*x+y*y);phi=Math.atan2(y,x);if(phi<0)phi+=Math.PI*2;if(r>75){r=75;gridPos.x=69-(75*Math.cos(phi));gridPos.y=69-(75*Math.sin(phi));}
saturation=keepWithin(r/0.75,0,100);hue=keepWithin(phi*180/Math.PI,0,360);brightness=keepWithin(100-Math.floor(sliderPos.y*(100/slider.height())),0,100);hex=hsb2hex({h:hue,s:saturation,b:brightness});slider.css('backgroundColor',hsb2hex({h:hue,s:saturation,b:100}));break;case'saturation':hue=keepWithin(parseInt(gridPos.x*(360/grid.width())),0,360);saturation=keepWithin(100-Math.floor(sliderPos.y*(100/slider.height())),0,100);brightness=keepWithin(100-Math.floor(gridPos.y*(100/grid.height())),0,100);hex=hsb2hex({h:hue,s:saturation,b:brightness});slider.css('backgroundColor',hsb2hex({h:hue,s:100,b:brightness}));minicolors.find('.minicolors-grid-inner').css('opacity',saturation/100);break;case'brightness':hue=keepWithin(parseInt(gridPos.x*(360/grid.width())),0,360);saturation=keepWithin(100-Math.floor(gridPos.y*(100/grid.height())),0,100);brightness=keepWithin(100-Math.floor(sliderPos.y*(100/slider.height())),0,100);hex=hsb2hex({h:hue,s:saturation,b:brightness});slider.css('backgroundColor',hsb2hex({h:hue,s:saturation,b:100}));minicolors.find('.minicolors-grid-inner').css('opacity',1-(brightness/100));break;default:hue=keepWithin(360-parseInt(sliderPos.y*(360/slider.height())),0,360);saturation=keepWithin(Math.floor(gridPos.x*(100/grid.width())),0,100);brightness=keepWithin(100-Math.floor(gridPos.y*(100/grid.height())),0,100);hex=hsb2hex({h:hue,s:saturation,b:brightness});grid.css('backgroundColor',hsb2hex({h:hue,s:100,b:100}));break;}
if(hasOpacity){opacity=parseFloat(1-(opacityPos.y/opacitySlider.height())).toFixed(2);}else{opacity=1;}
input.val(hex);if(hasOpacity)input.attr('data-opacity',opacity);swatch.find('SPAN').css({backgroundColor:hex,opacity:opacity});if(hex+opacity!==input.data('last-change')){input.data('last-change',hex+opacity).trigger('change',input);}}
function updateFromInput(input,preserveInputValue){var hex,hsb,opacity,x,y,r,phi,minicolors=input.parent(),swatch=minicolors.find('.minicolors-swatch'),hasOpacity=input.attr('data-opacity')!==undefined,sliderType=input.attr('data-slider'),grid=minicolors.find('.minicolors-grid'),slider=minicolors.find('.minicolors-slider'),opacitySlider=minicolors.find('.minicolors-opacity-slider'),gridPicker=grid.find('[class$=-picker]'),sliderPicker=slider.find('[class$=-picker]'),opacityPicker=opacitySlider.find('[class$=-picker]');hex=convertCase(parseHex(input.val(),true));if(!hex)hex=convertCase(parseHex(input.attr('data-default'),true));hsb=hex2hsb(hex);if(!preserveInputValue)input.val(hex);if(hasOpacity){opacity=input.attr('data-opacity')===''?1:keepWithin(parseFloat(input.attr('data-opacity')).toFixed(2),0,1);input.attr('data-opacity',opacity);swatch.find('SPAN').css('opacity',opacity);y=keepWithin(opacitySlider.height()-(opacitySlider.height()*opacity),0,opacitySlider.height());opacityPicker.css('top',y+'px');}
swatch.find('SPAN').css('backgroundColor',hex);switch(sliderType){case'wheel':r=keepWithin(Math.ceil(hsb.s*0.75),0,grid.height()/2);phi=hsb.h*Math.PI/180;x=keepWithin(75-Math.cos(phi)*r,0,grid.width());y=keepWithin(75-Math.sin(phi)*r,0,grid.height());gridPicker.css({top:y+'px',left:x+'px'});y=150-(hsb.b/(100/grid.height()));if(hex==='')y=0;sliderPicker.css('top',y+'px');slider.css('backgroundColor',hsb2hex({h:hsb.h,s:hsb.s,b:100}));break;case'saturation':x=keepWithin((5*hsb.h)/12,0,150);y=keepWithin(grid.height()-Math.ceil(hsb.b/(100/grid.height())),0,grid.height());gridPicker.css({top:y+'px',left:x+'px'});y=keepWithin(slider.height()-(hsb.s*(slider.height()/100)),0,slider.height());sliderPicker.css('top',y+'px');slider.css('backgroundColor',hsb2hex({h:hsb.h,s:100,b:hsb.b}));minicolors.find('.minicolors-grid-inner').css('opacity',hsb.s/100);break;case'brightness':x=keepWithin((5*hsb.h)/12,0,150);y=keepWithin(grid.height()-Math.ceil(hsb.s/(100/grid.height())),0,grid.height());gridPicker.css({top:y+'px',left:x+'px'});y=keepWithin(slider.height()-(hsb.b*(slider.height()/100)),0,slider.height());sliderPicker.css('top',y+'px');slider.css('backgroundColor',hsb2hex({h:hsb.h,s:hsb.s,b:100}));minicolors.find('.minicolors-grid-inner').css('opacity',1-(hsb.b/100));break;default:x=keepWithin(Math.ceil(hsb.s/(100/grid.width())),0,grid.width());y=keepWithin(grid.height()-Math.ceil(hsb.b/(100/grid.height())),0,grid.height());gridPicker.css({top:y+'px',left:x+'px'});y=keepWithin(slider.height()-(hsb.h/(360/slider.height())),0,slider.height());sliderPicker.css('top',y+'px');grid.css('backgroundColor',hsb2hex({h:hsb.h,s:100,b:100}));break;}}
function convertCase(string){return $.minicolors.settings.letterCase==='uppercase'?string.toUpperCase():string.toLowerCase();}
function parseHex(string,expand){string=string.replace(/[^A-F0-9]/ig,'');if(string.length!==3&&string.length!==6)return'';if(string.length===3&&expand){string=string[0]+string[0]+string[1]+string[1]+string[2]+string[2];}
return'#'+string;}
function keepWithin(value,min,max){if(value<min)value=min;if(value>max)value=max;return value;}
function hsb2rgb(hsb){var rgb={};var h=Math.round(hsb.h);var s=Math.round(hsb.s*255/100);var v=Math.round(hsb.b*255/100);if(s===0){rgb.r=rgb.g=rgb.b=v;}else{var t1=v;var t2=(255-s)*v/255;var t3=(t1-t2)*(h%60)/60;if(h===360)h=0;if(h<60){rgb.r=t1;rgb.b=t2;rgb.g=t2+t3;}
else if(h<120){rgb.g=t1;rgb.b=t2;rgb.r=t1-t3;}
else if(h<180){rgb.g=t1;rgb.r=t2;rgb.b=t2+t3;}
else if(h<240){rgb.b=t1;rgb.r=t2;rgb.g=t1-t3;}
else if(h<300){rgb.b=t1;rgb.g=t2;rgb.r=t2+t3;}
else if(h<360){rgb.r=t1;rgb.g=t2;rgb.b=t1-t3;}
else{rgb.r=0;rgb.g=0;rgb.b=0;}}
return{r:Math.round(rgb.r),g:Math.round(rgb.g),b:Math.round(rgb.b)};}
function rgb2hex(rgb){var hex=[rgb.r.toString(16),rgb.g.toString(16),rgb.b.toString(16)];$.each(hex,function(nr,val){if(val.length===1)hex[nr]='0'+val;});return'#'+hex.join('');}
function hsb2hex(hsb){return rgb2hex(hsb2rgb(hsb));}
function hex2hsb(hex){var hsb=rgb2hsb(hex2rgb(hex));if(hsb.s===0)hsb.h=360;return hsb;}
function rgb2hsb(rgb){var hsb={h:0,s:0,b:0};var min=Math.min(rgb.r,rgb.g,rgb.b);var max=Math.max(rgb.r,rgb.g,rgb.b);var delta=max-min;hsb.b=max;hsb.s=max!==0?255*delta/max:0;if(hsb.s!==0){if(rgb.r===max){hsb.h=(rgb.g-rgb.b)/delta;}else if(rgb.g===max){hsb.h=2+(rgb.b-rgb.r)/delta;}else{hsb.h=4+(rgb.r-rgb.g)/delta;}}else{hsb.h=-1;}
hsb.h*=60;if(hsb.h<0){hsb.h+=360;}
hsb.s*=100/255;hsb.b*=100/255;return hsb;}
function hex2rgb(hex){hex=parseInt(((hex.indexOf('#')>-1)?hex.substring(1):hex),16);return{r:hex>>16,g:(hex&0x00FF00)>>8,b:(hex&0x0000FF)};}
$(window).on('load',function(){$.minicolors.init();$(document).on('mousedown touchstart',function(event){if(!$(event.target).parents().add(event.target).hasClass('minicolors')){hide();}}).on('mousedown touchstart','.minicolors-grid, .minicolors-slider, .minicolors-opacity-slider',function(event){var target=$(this);event.preventDefault();$(document).data('minicolors-target',target);move(target,event,true);}).on('mousemove touchmove',function(event){var target=$(document).data('minicolors-target');if(target)move(target,event);}).on('mouseup touchend',function(){$(this).removeData('minicolors-target');}).on('mousedown touchstart','.minicolors-swatch',function(event){var input=$(this).parent().find('INPUT'),minicolors=input.parent();if(minicolors.hasClass('minicolors-focus')){hide(input);}else{show(input);}}).on('focus','INPUT[data-type=minicolors]',function(event){var input=$(this);if(!input.data('initialized'))return;show(input);}).on('blur','INPUT[data-type=minicolors]',function(event){var input=$(this);if(!input.data('initialized'))return;input.val(convertCase(parseHex(input.val()!==''?input.val():convertCase(parseHex(input.attr('data-default'),true)),true)));hide(input);}).on('keydown','INPUT[data-type=minicolors]',function(event){var input=$(this);if(!input.data('initialized'))return;switch(event.keyCode){case 9:hide();break;case 27:hide();input.blur();break;}}).on('keyup','INPUT[data-type=minicolors]',function(event){var input=$(this);if(!input.data('initialized'))return;updateFromInput(input,true);}).on('paste','INPUT[data-type=minicolors]',function(event){var input=$(this);if(!input.data('initialized'))return;setTimeout(function(){updateFromInput(input,true);},1);});});})(jQuery);