/*
 * Atributos globais
 */

var _baseConhecimentoListWrapper = $("#base-conhecimento-list-wrapper");
var _baseConhecimentoContentWrapper = $("#base-conhecimento-content-wrapper");
var _baseConhecimentoSearchWrapper = $("#base-conhecimento-search-wrapper");

 /*
 * Self executing function
 */

(function(window, document, undefined) {
	
})(this, document);

/**
 * Métodos para controle da pesquisa de conhecimentos.
 */

 var BaseConhecimento = {
	TableOfContents : {
		Folder : {
			toggleEvent : function(_idPasta) {
				if ($("#tableOfContentsSub" + _idPasta).attr("data-loaded") == "false") {
					$('#formBaseConhecimentoView #idPasta').attr("value", _idPasta);
					document.formBaseConhecimentoView.fireEvent('loadItemTableOfContents');
				} else {
					$("#tableOfContentsSub" + _idPasta).collapse("toggle");
				}
			},
			toggle : function(_idPasta) {
				$("#tableOfContentsSub" + _idPasta).collapse("toggle");
				$("#tableOfContentsSub" + _idPasta).attr("data-loaded", "true");
			}
		},
		Item : {
			open : function(_idBaseConhecimento, _idPasta) {
				$("#formBaseConhecimentoViewContent #idBaseConhecimento").attr("value", _idBaseConhecimento);
				$("#formBaseConhecimentoViewContent #idPasta").attr("value", _idPasta);
				
				document.formBaseConhecimentoViewContent.fireEvent('restore');
				
				BaseConhecimento.Content.Loading.open();
				
				_baseConhecimentoSearchWrapper.fadeOut(function() {
					_baseConhecimentoContentWrapper.fadeIn();
				});
			}
		},
		Loading : {
			open : function() {
				_baseConhecimentoListWrapper.find(".widget-body").html("<div class=\"carregando\"></div>");
			},
			close : function() {
				_baseConhecimentoListWrapper.find(".carregando").remove();
			}
		}
	},
	Content : {
		visualizarHistoricoVersoes : function() {
			document.formBaseConhecimentoViewContent.fireEvent('visualizarHistoricoVersao');
		},
		visualizarHistoricoAlteracoes : function() {
			document.formBaseConhecimentoViewContent.fireEvent('visualizarHistoricoAlteracoes');
		},
		visualizarIncidentesRequisicoes : function() {
			document.formBaseConhecimentoViewContent.fireEvent('visualizarReferenciasIncidentesRequisicoes');
		},
		visualizarProblemas : function() {
			document.formBaseConhecimentoViewContent.fireEvent('visualizarReferenciasProblemas');
		},
		visualizarMudancas : function() {
			document.formBaseConhecimentoViewContent.fireEvent('visualizarReferenciasMudancas');
		},
		visualizarItensConfiguracao : function() {
			document.formBaseConhecimentoViewContent.fireEvent('visualizarReferenciasItensConfiguracao');
		},
		visualizarComentarios : function() {
			document.formBaseConhecimentoViewContent.fireEvent('visualizarComentarios');
		},
		enviarComentario : {
			open : function() {
				$("#formModalEnviarComentario #idBaseConhecimento").attr("value", $("#formBaseConhecimentoViewContent #idBaseConhecimento").attr("value"));
				$("#formModalEnviarComentario").find("i").text("star_border");
				Modal.open('modal-enviar-comentario');
			},
			save : function() {
				
				if ($("#formModalEnviarComentario #idBaseConhecimento").attr("value") == "") {
					alert(i18n_message("baseConhecimento.validacao.selecionebase"));
					return false;
				} else {
					if ($("#formModalEnviarComentario #nome").attr("value") == "" || $("#formModalEnviarComentario #nota").attr("value") == "" || $("#formModalEnviarComentario #email").attr("value") == "" || $("#formModalEnviarComentario #comentario").attr("value") == "") {
						alert(i18n_message("citcorpore.comum.camposObrigatorios"));
						return false;
					} else {
						if(!ValidacaoUtils.validaEmail(email,'')) return false;
						document.formModalEnviarComentario.save();
					}
				}
				
				Modal.close('modal-enviar-comentario');
			},
			clear : function() {
				$("#formModalEnviarComentario").find('input:text, input:password, input:file, select, textarea').val("");
				$("#formModalEnviarComentario").find('input:radio, input:checkbox').removeAttr('checked').removeAttr('selected');
			},
		},
		obtemAnexo : function(_path) {
			window.location = '${ctx}/pages/visualizarUploadTemp/visualizarUploadTemp.load?path=' + _path;
		},
		close : function() {
			_baseConhecimentoContentWrapper.fadeOut(function() {
				if ($("#base-conhecimento-search-body").html() != "") {
					_baseConhecimentoSearchWrapper.fadeIn();
				}
			});
		},
		Loading : {
			open : function() {
				_baseConhecimentoContentWrapper.find(".widget-body").append("<div class=\"carregando\"></div>");
			},
			close : function() {
				_baseConhecimentoContentWrapper.find(".carregando").remove();
			}
		}
	},
	Search : {
		run : function() {
			var _formPesquisa = $("#formBaseConhecimentoViewPesquisa");
			
			if (_formPesquisa.find("#termoPesquisa").attr("value") == "" && _formPesquisa.find("#idUsuarioAutorPesquisa").attr("value") == "" && _formPesquisa.find("#idUsuarioAprovadorPesquisa").attr("value") == "" &&
				_formPesquisa.find("#dataInicioPesquisa").attr("value") == "" && _formPesquisa.find("#dataPublicacaoPesquisa").attr("value") == "" && _formPesquisa.find("#termoPesquisaNota").attr("value") == "") {
				alert(i18n_message("baseConhecimentoView.informacoesInsuficientesRealizarPesquisa"));
				
				return false;
			}
			
			if ($("#formBaseConhecimentoViewPesquisa #nomeUsuarioAutor").attr("value") == "") {
				$("#formBaseConhecimentoViewPesquisa #idUsuarioAutorPesquisa").attr("value", "0");
			}
			if ($("#formBaseConhecimentoViewPesquisa #nomeUsuarioAprovador").attr("value") == "") {
				$("#formBaseConhecimentoViewPesquisa #idUsuarioAprovadorPesquisa").attr("value", "0");
			}
			
			$("#base-conhecimento-search-body").html("");
			
			document.formBaseConhecimentoViewPesquisa.fireEvent('pesquisaBaseConhecimento');
			
			BaseConhecimento.Search.Loading.open();
			
			_baseConhecimentoContentWrapper.fadeOut(function() {
				_baseConhecimentoSearchWrapper.fadeIn();
			});
		},
		clear : function() {
			$("#formBaseConhecimentoViewPesquisa").find('input:text, input:hidden, input:password, input:file, select, textarea').val("");
			$("#formBaseConhecimentoViewPesquisa").find('input:radio, input:checkbox').removeAttr('checked').removeAttr('selected');
		},
		openItem : function(_idBaseConhecimento, _idPasta) {
			$("#formBaseConhecimentoViewContent #idBaseConhecimento").attr("value", _idBaseConhecimento);
			$("#formBaseConhecimentoViewContent #idPasta").attr("value", _idPasta);
			
			document.formBaseConhecimentoViewContent.fireEvent('restore');
			
			BaseConhecimento.Content.Loading.open();
			
			_baseConhecimentoSearchWrapper.fadeOut(function() {
				_baseConhecimentoContentWrapper.fadeIn();
			});
		},
		openModal : function(_id) {
			$("#formBaseConhecimentoViewPesquisa #lookupType").attr("value", _id);
			Modal.open("modal-usuarios");
		},
		close : function() {
			_baseConhecimentoSearchWrapper.fadeOut();
		},
		Loading : {
			open : function() {
				_baseConhecimentoSearchWrapper.find(".widget-body").append("<div class=\"carregando\"></div>");
			},
			close : function() {
				_baseConhecimentoSearchWrapper.find(".carregando").remove();
			}
		}
	},
	Iframe : {
		open : function(_idBaseConhecimento, _idPasta) {
			$("#formBaseConhecimentoViewContent #idBaseConhecimento").attr("value", _idBaseConhecimento);
			$("#formBaseConhecimentoViewContent #idPasta").attr("value", _idPasta);
			
			BaseConhecimento.Content.Loading.open();
			
			_baseConhecimentoSearchWrapper.fadeOut(function() {
				_baseConhecimentoContentWrapper.fadeIn();
			});
		}
	}
}

/**
 * Métodos para controle do modal.
 */

var Modal = {
	init : function(_id, header, body, footer) {
		$("#" + _id).find('.title').html(header);
		$("#" + _id).find('.modal-body').html(body);
		$("#" + _id).find('.modal-footer').html(footer);
	},
	open : function(_id) {
		$("#" + _id).modal('show');
	},
	close : function(_id) {
		$("#" + _id).closest(".modal").modal("hide");
	},
	clear : function(_id) {
		$("#" + _id).find('.title').html("");
		$("#" + _id).find('.modal-body').html("");
		$("#" + _id).find('.modal-footer').html("");
	}
}

/**
 * Event Handlers e funções diversas para a tela.
 */

$("#resize-window").on("click", function() {
	if ($("#resize-window").hasClass("resize_full")) {
		$("#resize-window").removeClass("resize_full").addClass("resize_small");
		$("#footer, .navbar.main").fadeOut(100, function() {
			$("#content").addClass('p0');
		});
	} else {
		$("#resize-window").removeClass("resize_small").addClass("resize_full");
		$("#content").removeClass('p0');
		$("#footer, .navbar.main").fadeIn();
	}
});

$(".rating.enabled .star").on("click", function() {
	var _parent = $(this).parent();
	var _number = $(this).attr("data-number");
	
	$("#formModalEnviarComentario #nota").attr("value", _number);
	
	_parent.find(".star").text("star_border");
	for (var i = _number; i >= 1; i--) {
		_parent.find(".star[data-number='" + i + "']").text("star");
	}
});

$("#formBaseConhecimentoViewPesquisa").find('input:text, textarea').keyup(function(event){
	if(event.keyCode == 13){
		$("#btnPesquisar").trigger("click");
	}
});

function LOOKUP_USUARIO_select(id, desc) {
	var _lookupType = $("#formBaseConhecimentoViewPesquisa #lookupType").attr("value");
	
	if (_lookupType == "nomeUsuarioAutor") {
		$("#formBaseConhecimentoViewPesquisa #idUsuarioAutorPesquisa").attr("value", id);
		$("#formBaseConhecimentoViewPesquisa #nomeUsuarioAutor").attr("value", desc);
	} else if (_lookupType == "nomeUsuarioAprovador") {
		$("#formBaseConhecimentoViewPesquisa #idUsuarioAprovadorPesquisa").attr("value", id);
		$("#formBaseConhecimentoViewPesquisa #nomeUsuarioAprovador").attr("value", desc);
	}

	Modal.close("modal-usuarios");
}

function clickListarICs(){
	document.getElementById('framePesquisaItemConfiguracao').src = URL_SISTEMA+'pages/pesquisaItemConfiguracao/pesquisaItemConfiguracao.load?iframe=true';
	Modal.open("modal_pesquisaItemConfiguracao");
}

function selectedItemConfiguracao(idItemConfiguracao) {
	if (confirm(i18n_message("solicitacaoServico.desejaVincularItemConfiguracaoSolicitante"))) {
		$("#formBaseConhecimentoViewContent #idItemConfiguracao").attr("value", idItemConfiguracao);
		document.formBaseConhecimentoViewContent.fireInsert("vincularItemConfiguracao");
		Modal.close("modal_pesquisaItemConfiguracao");
	}
}

function desvincularIcConhecimento(idItemConfiguracao){
	if(confirm(i18n_message('gerenciamentoItemConfiguracao.confirmaDesvinculacaoBaseConhecimento'))){
		$("#formBaseConhecimentoViewContent #idItemConfiguracao").attr("value", idItemConfiguracao);
		document.formBaseConhecimentoViewContent.fireDelete('deletarConhecimentoIc');
	}
	deletarConhecimentoIc
}

function desvincularConhecimentoIc(idItemConfiguracao){
	if(confirm(i18n_message('baseConhecimentoView.confirmaDesvinculacaoItemConfiguracao'))){
		$("#formBaseConhecimentoViewContent #idItemConfiguracao").attr("value", idItemConfiguracao);
		document.formGerenciamentoItemConfiguracao.fireDelete('deletarConhecimentoIc');
	}
}

function clickListarEventos(){
	Modal.open("modal-categoria-ocorrencia-eventos");
}

