
var LABEL_FINAL_VALIDACAO = i18n_message('gerenciaportfolio.campoObrigatorio'); 

aguarde = function() {
	JANELA_AGUARDE_MENU.show();
};

fechar_aguarde = function() {
	JANELA_AGUARDE_MENU.hide();
};

/**
 * Funções e Event Handlers diversos para a tela.
 */

$("#resize-window").on("click", function() {
	if ($("#resize-window").hasClass("resize_full")) {
		$("#resize-window").removeClass("resize_full").addClass("resize_small");
		$("#footer, .navbar.main").fadeOut(100, function() {
			$("#content").addClass('p0');
		});
	} else {
		$("#resize-window").removeClass("resize_small").addClass("resize_full");
		$("#content").removeClass('p0');
		$("#footer, .navbar.main").fadeIn();
	}
});

/** XXX ------------ CONTROLAR LOOKUP'S DO FORMULARIO ---------------- * */

LOOKUP_APLICACOES_RESTORE_select = function(id, desc) {
	limparAplicacao();

	$("#tab-cadastro-aplication").click();

	aguarde();

	document.formCadastroAplicacao.restore({ 
		idAplicacao : id 
	});
}

LOOKUP_EMPREGADO_select = function(id, desc) {
	document.formCadastroAplicacao.idResponsavel.value = id;
	document.formCadastroAplicacao.nomeResponsavel.value = desc;

	Modal.close('modal-aplicacao-responsavel');
};

LOOKUP_CLIENTE_APLICACAO_select = function(id, desc) {
	document.formPesquisaClienteAplicacao.idCliente.value = id;
	document.formPesquisaClienteAplicacao.nomeCliente.value = desc;

	Modal.close('modal-aplicacao-cliente');

	inserirClienteDaAplicacao();
};

/** XXX ------------ CONTROLAR MODAIS DO FORMULARIO ---------------- * */

abrirModalResponsavel = function() {
	Modal.open('modal-aplicacao-responsavel');
};

abrirModalAplicacaoRequisito = function() {
	limparFormulario('formAplicacaoRequisito');
	Modal.open('modal-aplicacao-requisitos');
};

abrirModalAplicacaoCliente = function() {
	limparFormulario('formPesquisaClienteAplicacao');
	Modal.open('modal-aplicacao-cliente');
};
/** XXX---------------------- CLIENTES DA APLICACAO -----------------------* */

inserirClienteDaAplicacao = function() {
	var cliente = new CIT_AplicacaoClienteDTO();
	cliente = aplicacaoClienteItem();
	
	var colunas = [ "nomeCliente", "" ]
	var funcoes = [ exibeIconesTabelaClientes ];

	adicionaLinhaEmTable('tblClienteAplicacao', cliente, colunas, funcoes, document.formPesquisaClienteAplicacao);

	var objsCriterios = HTMLUtils.getObjectsByTableId('tblClienteAplicacao');
	document.formCadastroAplicacao.colItens_Clientes_Serialize.value = ObjectUtils.serializeObjects(objsCriterios);

	limparFormulario('formPesquisaClienteAplicacao');
};

aplicacaoClienteItem = function() {
	var cliente = new CIT_AplicacaoClienteDTO();

	cliente.idCliente = document.formPesquisaClienteAplicacao.idCliente.value != null ? document.formPesquisaClienteAplicacao.idCliente.value : '';
	cliente.nomeCliente = document.formPesquisaClienteAplicacao.nomeCliente.value;
	cliente.idAplicacao = document.formCadastroAplicacao.idAplicacao.value;

	return cliente;
};

exibeIconesTabelaClientes = function(row, obj) {
	var linkExcluir = '<a title="' + i18n_message("citcorpore.comum.excluir") + '" onclick="controlarDelecaoLinhaTabelaClienteAplicacao(this.parentNode.parentNode.rowIndex);" class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a>';

	row.cells[1].innerHTML = linkExcluir;
};

controlarDelecaoLinhaTabelaClienteAplicacao = function(index) {
	var lista = ObjectUtils.deserializeCollectionFromString(document.formCadastroAplicacao.colItens_Clientes_Serialize.value);
	for (var i = 0; i < lista.length; i++) {
		if (index == i + 1) {
			var cliente = new CIT_AplicacaoClienteDTO();
			cliente = lista[i];
			if (cliente.idCliente != null && cliente.idCliente != '') {
				document.getElementById('colItens_Delecao_Cliente').value += cliente.idCliente + ",";
				break;
			}
		}
	}

	removeLinhaTabela('formCadastroAplicacao', 'colItens_Clientes_Serialize', 'tblClienteAplicacao', index);
};

/** XXX---------------------- REQUISITOS DA APLICACAO -----------------------* */

inserirRequisitoDaAplicacao = function() {
	var requisito = new CIT_AplicacaoRequisitoDTO();
	requisito = aplicacaoRequisitoItem();

	if (requisito.nomeRequisito == null || requisito.nomeRequisito == '') {
		var labelInicioValidacao = i18n_message("portfolio.aplicacao.requisito.nome");
		alert(labelInicioValidacao.concat(' ').concat(LABEL_FINAL_VALIDACAO));
		return false;
	}

	var index = document.getElementById('rowIndexRequisito').value;
	var itemJaExisteNaLista = registroExistenteEmTabela(index);
	var colunas = [ "nomeRequisito", "statusRequisito", "" ]
	var funcoes = [ exibeIconesTabelaRequisitos, internacionalizaStatusDoRequisito ];

	if (itemJaExisteNaLista) {
		atualizarLinhaEmTabela('tblRequisitoAplicacao', requisito, colunas, funcoes, document.formAplicacaoRequisito, index);
	} else {
		adicionaLinhaEmTable('tblRequisitoAplicacao', requisito, colunas, funcoes, document.formAplicacaoRequisito);
	}

	var objsCriterios = HTMLUtils.getObjectsByTableId('tblRequisitoAplicacao');
	document.formCadastroAplicacao.colItens_Requisitos_Serialize.value = ObjectUtils.serializeObjects(objsCriterios);
	limparFormulario('formAplicacaoRequisito');
	document.getElementById('rowIndexRequisito').value = '';

	Modal.close('modal-aplicacao-requisitos');
};

aplicacaoRequisitoItem = function() {
	var requisito = new CIT_AplicacaoRequisitoDTO();

	requisito.idRequisitoAplicacao = document.getElementById('idRequisitoAplicacao').value != null ? document.getElementById('idRequisitoAplicacao').value : '';
	requisito.idAplicacao = document.getElementById('idAplicacao').value;
	requisito.nomeRequisito = document.getElementById('nomeRequisito').value;
	requisito.detalhesRequisito = document.getElementById('detalhesRequisito').value;
	requisito.statusRequisito = document.getElementById('statusRequisito').value;

	return requisito;
};

exibeIconesTabelaRequisitos = function(row, obj) {
	var linkAlterar = '<a title="' + i18n_message("citcorpore.comum.editar") + '" onclick="editarModalRequisitoAplicacao(this.parentNode.parentNode.rowIndex);" class=\"btn-action glyphicons pencil btn-success\"><i></i></a>';
	var espaco = "&nbsp;"
	var linkExcluir = '<a title="' + i18n_message("citcorpore.comum.excluir") + '" onclick="controlarDelecaoLinhaTabelaRequisitoAplicacao(this.parentNode.parentNode.rowIndex);" class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a>';

	row.cells[2].innerHTML = linkAlterar.concat(espaco).concat(linkExcluir);
};

internacionalizaStatusDoRequisito = function(row, obj) {
	row.cells[1].innerHTML = i18n_message(row.cells[1].innerHTML);
};

editarModalRequisitoAplicacao = function(index) {
	var lista = ObjectUtils.deserializeCollectionFromString(document.formCadastroAplicacao.colItens_Requisitos_Serialize.value);
	document.getElementById('rowIndexRequisito').value = index;

	for (var i = 0; i < lista.length; i++) {
		if (index == i + 1) {
			var requisito = new CIT_AplicacaoRequisitoDTO();
			requisito = lista[i];
			
			document.getElementById('idRequisitoAplicacao').value = requisito.idRequisitoAplicacao;
			document.getElementById('idAplicacao').value = requisito.idAplicacao;
			document.getElementById('nomeRequisito').value = requisito.nomeRequisito;
			document.getElementById('detalhesRequisito').value = requisito.detalhesRequisito;
			document.getElementById('statusRequisito').value = requisito.statusRequisito;
			break;
		}
	}
	Modal.open('modal-aplicacao-requisitos');
};

controlarDelecaoLinhaTabelaRequisitoAplicacao = function(index) {
	var lista = ObjectUtils.deserializeCollectionFromString(document.formCadastroAplicacao.colItens_Requisitos_Serialize.value);
	for (var i = 0; i < lista.length; i++) {
		if (index == i + 1) {
			var requisito = new CIT_AplicacaoRequisitoDTO();
			requisito = lista[i];
			if (requisito.idRequisitoAplicacao != null && requisito.idRequisitoAplicacao != '') {
				document.getElementById('colItens_Delecao_Requisito').value += requisito.idRequisitoAplicacao + ",";
				break;
			}
		}
	}

	removeLinhaTabela('formCadastroAplicacao', 'colItens_Requisitos_Serialize', 'tblRequisitoAplicacao', index);
};

/** XXX ----------- TRATAMENTO DE TABELAS ------------------* */

removeLinhaTabela = function(formulario, idElemento, idTabela, index) {
	if (index > 0 && confirm(i18n_message("citcorpore.comum.deleta"))) {
		HTMLUtils.deleteRow(idTabela, index);
		var objsCriterios = HTMLUtils.getObjectsByTableId(idTabela);
		eval('document.' + formulario + '.' + idElemento + '.value = '
				+ ObjectUtils.serializeObjects(objsCriterios) + ';');
	}
};

registroExistenteEmTabela = function(index) {
	if (index == null || index == undefined || index < 1) {
		return false;
	} else {
		return true;
	}
};

adicionaDadosTable = function(idTabela, objetoTable, colunas, funcaoParaExibirIcons) {
	HTMLUtils.addRowsByCollection(idTabela, null, '', objetoTable, colunas, false, '', funcaoParaExibirIcons, null, null, false);
};

adicionaLinhaEmTable = function(idTabela, objetoTable, colunas, funcaoParaExibirIcons, objForm) {
	HTMLUtils.addRow(idTabela, objForm, null, objetoTable, colunas, colunas, '', funcaoParaExibirIcons, null, null, false);
};

atualizarLinhaEmTabela = function(idTabela, objetoTable, colunas, funcaoParaExibirIcons, objForm, index) {
	HTMLUtils.updateRow(idTabela, objForm, null, objetoTable, colunas, null, '', funcaoParaExibirIcons, null, null, index, false);
};

/** XXX AÇÕES----------------------------------------------------- */

limparFormulario = function(formulario) {
	eval('document.' + formulario + '.clear()');
};

limparAplicacao = function() {
	document.formCadastroAplicacao.clear();

	limparFormulario('formAplicacaoRequisito');
	HTMLUtils.deleteAllRows('tblRequisitoAplicacao');

	limparFormulario('formPesquisaClienteAplicacao');
	HTMLUtils.deleteAllRows('tblClienteAplicacao');
};

gravarAplicacao = function() {
	if(validarCamposAplicacoesPrincipal()){
		document.formCadastroAplicacao.save();
	}
};

excluirAplicacao = function() {
	aguarde();
	if (document.formCadastroAplicacao.idAplicacao.value > ""
			&& confirm(i18n_message("citcorpore.comum.deleta"))) {
		document.formCadastroAplicacao.fireDelete("excluir");
	} else {
		fechar_aguarde();
	}
};

validarCamposAplicacoesPrincipal = function() {	
	return true;
}

