abrirModalMatrizContrato = function() {
	limparFormulario('formMatrizContrato');
	Modal.open('modal-popup-matriz-contrato');
};

fechaModalPopupMatrizContrato = function(){
	Modal.close('modal-popup-matriz-contrato');
};

/**
 * XXX ------------ ABA MATRIZ COMUNICACAO DO CONTRATO -----------*
 */

inserirMatrizComunicacaoContrato = function() {
	var ans = new CIT_MatrizContratoDTO();
	ans = matrizComunicacaoItem();
	// Validando campos obrigatorios.
	if (!validarCamposObrigadoriosMatrizComunicacao()) {
		return;
	}

	var index = document.getElementById('rowIndexMatriz').value;
	var itemJaExisteNaLista = registroExistenteEmTabela(index);
	var colunas = [ "nomeGrupoEnvolvido", "responsabilidades",
			"descTipoRegistro", "descFrequencia", "formaContato", "" ];
	var funcaoExibirIcons = [ exibeIconesTabelaMatriz ];

	if (itemJaExisteNaLista) {
		atualizarLinhaEmTabela('tblMatrizContrato', ans, colunas,
				funcaoExibirIcons, document.formCadastroContrato, index);
	} else {
		adicionaLinhaEmTable('tblMatrizContrato', ans, colunas,
				funcaoExibirIcons, document.formCadastroContrato);
	}

	var objsCriterios = HTMLUtils.getObjectsByTableId('tblMatrizContrato');
	document.formCadastroContrato.colItens_Matriz_Serialize.value = ObjectUtils
			.serializeObjects(objsCriterios);
	limparFormulario('formMatrizContrato');
	document.getElementById('rowIndexMatriz').value = '';

	fechaModalPopupMatrizContrato();
};

validarCamposObrigadoriosMatrizComunicacao = function() {
	var nomeGrupoEnvolvido = document.getElementById('nomeGrupoEnvolvido').value;
	var responsabilidades = document.getElementById('responsabilidades').value;

	if (nomeGrupoEnvolvido == null || nomeGrupoEnvolvido == '') {
		var labelInicioValidacao = i18n_message("gerenciaportfolio.matrizComunicacao.grupoEnvolvido");
		alert(labelInicioValidacao.concat(' ').concat(LABEL_FINAL_VALIDACAO));
		return false;
	}

	if (responsabilidades == null || responsabilidades == '') {
		var labelInicioValidacao = i18n_message("gerenciaportfolio.matrizComunicacao.responsabilidades");
		alert(labelInicioValidacao.concat(' ').concat(LABEL_FINAL_VALIDACAO));
		return false;
	}

	return true;
};

matrizComunicacaoItem = function() {
	var ans = new CIT_MatrizContratoDTO();

	ans.idContrato = document.getElementById('idContrato').value != null ? document
			.getElementById('idContrato').value
			: '';
	ans.idMatrizComunicacao = document.getElementById('idMatrizComunicacao').value;
	ans.grupoEnvolvido = document.getElementById('idGrupoEnvolvido').value;
	ans.responsabilidades = document.getElementById('responsabilidades').value;
	ans.idTipoRegistro = document.getElementById('idTipoRegistro').value;
	ans.idFrequencia = document.getElementById('idFrequencia').value;
	ans.idFormaContato = document.getElementById('idFormaContato').value;
	ans.nomeGrupoEnvolvido = document.getElementById('nomeGrupoEnvolvido').value;
	ans.descTipoRegistro = document.getElementById('descTipoRegistro').value;
	ans.descFrequencia = document.getElementById('descFrequencia').value;
	ans.formaContato = document.getElementById('formaContato').value;
	ans.deleted = null;
	return ans;
};

exibeIconesTabelaMatriz = function(row, obj) {
	var linkAlterar ='';
	var linkExcluir ='';
	if(permissaoGravar == true){
		linkAlterar = '<a title="'
			+ i18n_message("citcorpore.comum.editar")
			+ '" onclick="editarModalMatriz(this.parentNode.parentNode.rowIndex);" class=\"btn-action glyphicons pencil btn-success\"><i></i></a>';
	}
	var espaco = "&nbsp;"
	if(permissaoDelete == true){
		linkExcluir = '<a title="'
			+ i18n_message("citcorpore.comum.excluir")
			+ '" onclick="controlarDelecaoLinhaTabelaMatrizComunicacao(this.parentNode.parentNode.rowIndex);" class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a>';
	}
	row.cells[5].innerHTML = linkAlterar.concat(espaco).concat(linkExcluir);
};

editarModalMatriz = function(index) {
	var lista = ObjectUtils
			.deserializeCollectionFromString(document.formCadastroContrato.colItens_Matriz_Serialize.value);
	document.getElementById('rowIndexMatriz').value = index;

	for (var i = 0; i < lista.length; i++) {
		if (index == i + 1) {
			var ans = new CIT_MatrizContratoDTO();
			ans = lista[i];
			document.getElementById('idContrato').value = ans.idContrato;
			document.getElementById('idMatrizComunicacao').value = ans.idMatrizComunicacao;
			document.getElementById('idGrupoEnvolvido').value = ans.grupoEnvolvido;
			document.getElementById('responsabilidades').value = ans.responsabilidades;
			document.getElementById('idTipoRegistro').value = ans.idTipoRegistro;
			document.getElementById('idFrequencia').value = ans.idFrequencia;
			document.getElementById('idFormaContato').value = ans.idFormaContato;
			document.getElementById('nomeGrupoEnvolvido').value = ans.nomeGrupoEnvolvido;

			break;
		}
	}
	Modal.open('modal-popup-matriz-contrato');
};

controlarDelecaoLinhaTabelaMatrizComunicacao = function(index) {
	var lista = ObjectUtils
			.deserializeCollectionFromString(document.formCadastroContrato.colItens_Matriz_Serialize.value);
	for (var i = 0; i < lista.length; i++) {
		if (index == i + 1) {
			var ans = new CIT_MatrizContratoDTO();
			ans = lista[i];
			if (ans.idMatrizComunicacao != null
					&& ans.idMatrizComunicacao != '') {
				document.getElementById('colItens_Delecao_Matriz_Comunicacao').value += ans.idMatrizComunicacao
						+ ",";
				break;
			}
		}
	}

	removeLinhaTabela('formCadastroContrato', 'colItens_Matriz_Serialize',
			'tblMatrizContrato', index);
};
