
afterRestoreCadastroContrato = function() {
	$("span[href='#tabTabelaANSC']").trigger('click');
	$("#liAuditoriaContrato").removeClass("hidden");
};

abrirModalAcordoNivelServico = function() {
	limparModalAcordoNivelServico();
	Modal.open('modal-popup-acordo-nivel-servico');
};

/**
 * XXX------------- ACORDO DE NIVEL DE SERVICO CONTRATO ---------*
 */

inserirAcordoNivelServico = function() {
	// Validando campos obrigatorios.
	if (!validarCamposObrigadoriosAcordoNivelServico()) {
		return;
	}

	var colunas = [ "descricaoAcordo", "detalhamentoAcordo", "valorLimite",
			"unidadeValorLimite", "dataInicio", "dataFim", "descricaoGlosa", "" ];
	var funcaoExibirIcons = [ exibeIconesTabela ];
	var index = document.getElementById('rowIndex').value;

	var itemJaExisteNaLista = registroExistenteEmTabela(index);

	var ans = new CIT_AcordoNivelServicoContratoDTO();
	if (itemJaExisteNaLista) {
		var obj = HTMLUtils.getObjectByTableIndex('tblANSC', index);
		ans = acordoNivelServicoItem(obj);
		atualizarLinhaEmTabela('tblANSC', ans, colunas, funcaoExibirIcons,
				document.formCadastroContrato, index);
	} else {
		ans = acordoNivelServicoItem(ans);
		adicionaLinhaEmTable('tblANSC', ans, colunas, funcaoExibirIcons,
				document.formCadastroContrato);
	}

	var objsCriterios = HTMLUtils.getObjectsByTableId('tblANSC');
	document.formCadastroContrato.colItens_Serialize.value = ObjectUtils
			.serializeObjects(objsCriterios);
	limparModalAcordoNivelServico();
	document.getElementById('rowIndex').value = '';

	Modal.close('modal-popup-acordo-nivel-servico');
};

validarCamposObrigadoriosAcordoNivelServico = function() {
	// Validar Datas do Contrato
	var dataInicio = document.getElementById("dataInicioANSC").value;
	var dataFim = document.getElementById("dataFimANSC").value;

	if (campoVazioOuNulo('descricaoAcordo')) {
		return false;
	}

	if (!validaDataParametrizado(dataInicio, dataFim)) {
		return false;
	}

	if (campoVazioOuNulo('valorLimite')) {
		return false;
	}

	if (campoVazioOuNulo('unidadeValorLimite')) {
		return false;
	}

	return true;
};

acordoNivelServicoItem = function(ans) {
	ans.idContrato = document.getElementById('idContratoANS').value != null ? document
			.getElementById('idContratoANS').value
			: '';
	ans.descricaoAcordo = document.getElementById('descricaoAcordo').value;
	ans.detalhamentoAcordo = document.getElementById('detalhamentoAcordo').value;
	ans.valorLimite = document.getElementById('valorLimite').value;
	ans.unidadeValorLimite = document.getElementById('unidadeValorLimite').value;
	ans.dataInicio = document.getElementById('dataInicioANSC').value;
	ans.dataFim = document.getElementById('dataFimANSC').value;
	ans.descricaoGlosa = document.getElementById('descricaoGlosa').value;

	return ans;
};

exibeIconesTabela = function(row, obj) {
	var linkAlterar ='';
	var linkExcluir ='';
	if(permissaoGravar == true){
		linkAlterar = '<a title="'
			+ i18n_message("citcorpore.comum.editarAcordo")
			+ '" onclick="editarModalAcordoNivelServico(this.parentNode.parentNode.rowIndex);" class=\"btn-action glyphicons pencil btn-success\"><i></i></a>';
	}
	var espaco = "&nbsp;"
	if(permissaoDelete == true){
		linkExcluir = '<a title="'
			+ i18n_message("citcorpore.comum.excluir")
			+ '" onclick="controlarDelecaoLinhaTabelaAcordoNivelServico(this.parentNode.parentNode.rowIndex);" class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a>';
	}
	row.cells[7].innerHTML = linkAlterar.concat(espaco).concat(linkExcluir);
};

editarModalAcordoNivelServico = function(index) {
	var listaANS = ObjectUtils
			.deserializeCollectionFromString(document.formCadastroContrato.colItens_Serialize.value);
	document.getElementById('rowIndex').value = index;

	for (var i = 0; i < listaANS.length; i++) {
		if (index == i + 1) {
			var ans = new CIT_AcordoNivelServicoContratoDTO();
			ans = listaANS[i];
			document.getElementById('idContratoANS').value = ans.idContrato;
			document.getElementById('descricaoAcordo').value = ans.descricaoAcordo;
			document.getElementById('detalhamentoAcordo').value = ans.detalhamentoAcordo;
			document.getElementById('valorLimite').value = ans.valorLimite;
			document.getElementById('unidadeValorLimite').value = ans.unidadeValorLimite;
			document.getElementById('dataInicioANSC').value = ans.dataInicio;
			document.getElementById('dataFimANSC').value = ans.dataFim;
			document.getElementById('descricaoGlosa').value = ans.descricaoGlosa;
			break;
		}
	}

	Modal.open('modal-popup-acordo-nivel-servico');
};

controlarDelecaoLinhaTabelaAcordoNivelServico = function(index) {
	var listaANS = ObjectUtils
			.deserializeCollectionFromString(document.formCadastroContrato.colItens_Serialize.value);
	for (var i = 0; i < listaANS.length; i++) {
		if (index == i + 1) {
			var ans = new CIT_AcordoNivelServicoContratoDTO();
			ans = listaANS[i];
			if (ans.idAcordoNivelServicoContrato != null
					&& ans.idAcordoNivelServicoContrato != '') {
				document.getElementById('colItens_Delecao_Acordo').value += ans.idAcordoNivelServicoContrato
						+ ",";
				break;
			}
		}
	}

	removeLinhaTabela('formCadastroContrato', 'colItens_Serialize', 'tblANSC',
			index);
};