function clickAbrirPopupVincularColaborador() {
	Modal.open('modal-habilidade-vincular-colaborador');
}

function getListaIdUsuarioVinculado() {
	var listaIdUsuarioVinculado = document.formBusinessUser.listaIdUsuarioVinculado.value.split(";");
	listaIdUsuarioVinculado = listaIdUsuarioVinculado.slice(0, listaIdUsuarioVinculado.length-1);
	return listaIdUsuarioVinculado;
}

function fecharPopupVincularColaborador() {
	Modal.close('modal-habilidade-vincular-colaborador');
}

/**
 * Vincular Colaborador
 */
var Colaborador = {
	abrirModal: function(){
		limpar_LOOKUP_VINCULAR_COLABORADOR();
		
		// Lista dos ids de colaboradores vinculados
		var idsColaboradoresVinculados = this.getListaIdColaboradoresVinculados();
		
		// Se tiver algum colaborador vinculado acrescenta uma condição na lookup para que eles não sejam exibidos
		if(idsColaboradoresVinculados.length > 0) {
			document.formHabilidadeVincularColaborador.whereDinamico = "idempregado not in ("+ idsColaboradoresVinculados+")";
		} else {
			document.formHabilidadeVincularColaborador.whereDinamico = "";
		}
		
		Modal.open('modal-habilidade-vincular-colaborador');
	},
	
	fecharModal: function() {
		Modal.close('modal-habilidade-vincular-colaborador');
	},
	
	removerColaboradorFromTable : function(btClick){
		if (confirm(i18n_message("citcorpore.comum.deleta"))) {
			
			var trTable = btClick.closest('tr');
			var idColaborador = trTable.getAttribute('id');
			
			
			trTable.remove();
			var rowCount = $('.table tr').length;
			if(rowCount == 1){
				document.formCadastroHabilidade.fireEvent("zeraTabela");
			}
			
			// remove o colaborador da lista de lookup e salva
			document.formCadastroHabilidade.listaColaboradores.value = document.formCadastroHabilidade.listaColaboradores.value.replace(idColaborador+";", "");
			
			this.serializarListaIdsColaboradoresVinculados();
		}
	},
	
	atualizarListaIdsColaboradoresVinculadas: function() {
		document.formCadastroHabilidade.listaColaboradores.value = document.formCadastroHabilidade.listaColaboradores.value + document.formCadastroHabilidade.colAllLOOKUP_VINCULAR_COLABORADOR.value;
		this.serializarListaIdsColaboradoresVinculados();
	},	
	
	getListaIdColaboradoresVinculados: function() {
		var idsColaboradoresVinculados = document.formCadastroHabilidade.listaColaboradores.value.split(";");
		idsColaboradoresVinculados = idsColaboradoresVinculados.slice(0, idsColaboradoresVinculados.length-1);
		return idsColaboradoresVinculados;
	},
	
	montarTabelaColaboradores: function() {
		this.atualizarListaIdsColaboradoresVinculadas();
		document.formCadastroHabilidade.fireEvent("montarTabelaColaboradores");
	},
	
	serializarListaIdsColaboradoresVinculados: function(){
		var idsColaboradoresVinculados = this.getListaIdColaboradoresVinculados();
		var listaHabilidadeUsuarios = [];
		var vinculoHabilidadeColaboradorDTO = null;		

		for(var i = 0, len = idsColaboradoresVinculados.length; i < len; i++) {
			vinculoHabilidadeColaboradorDTO = new CIT_VinculoHabilidadeColaboradorDTO();
			vinculoHabilidadeColaboradorDTO.IdEmpregado = parseInt(idsColaboradoresVinculados[i]);
			listaHabilidadeUsuarios.push(vinculoHabilidadeColaboradorDTO);
		}
		
		document.formCadastroHabilidade.listaColaboradores_Serialize.value = ObjectUtils.serializeObjects(listaHabilidadeUsuarios);
        
        return true;
	}
}

function limparHabilidade(){
	document.formCadastroHabilidade.fireEvent("limparFormulario");
}

function salvarHabilidade(){
	if(document.formCadastroHabilidade.save()){
		JANELA_AGUARDE_MENU.show();
		document.formVincularHabilidade.fireEvent("preencheListaHabilidadeFiltro");
		Modal.close('modal-portfolio-cadastrar-habilidade');
	}
	
}

function excluirHabilidade(){
	if($("#idHabilidade").val() == ""){
		alert(i18n_message("MSG04"));
	}else if (confirm(i18n_message("citcorpore.comum.deleta"))) {
		JANELA_AGUARDE_MENU.show();
		document.formCadastroHabilidade.fireDelete("excluir");
	}
}
	
LOOKUP_CADASTRO_HABILIDADE_select = function(id, desc) {
	$('.tabsbar a[href="#tab1-3"]').tab('show');
	$("#idHabilidade").val(id);
	document.formCadastroHabilidade.fireEvent("restore");
};
