/**Autocomplete **/
var completeServico;
var completeSolicitante;
var completeUnidade;

$(document).ready(function() {
	
	$(".popup").on("click", function() {
		var popup = $(this).attr("data-popup");
		
		$("#" + popup).dialog("open");
	});
	
	$(document).on('onfocus','#servico', function(){
		montaParametrosAutocompleteServico();
	});
	
	completeSolicitante = $('#solicitante').autocomplete({ 
		serviceUrl:'pages/autoCompleteSolicitante/autoCompleteSolicitante.load',
		noCache: true,
		onSelect: function(value, data){
			$('#idSolicitante').val(data);
			$('#solicitante').val(value);
			
			document.form.fireEvent("restaurarSolicitante");
			document.form.fireEvent("carregaContratos");
		}
	});
	
	completeServico = $('#servico').autocomplete({
		serviceUrl:'pages/autoCompleteServico/autoCompleteServico.load',
		noCache: true,
		onSelect: function(value, data){
			$('#idServico').val(data);
			$('#servico').val(value);
			document.form.fireEvent('verificaImpactoUrgencia');
			document.form.fireEvent('verificaGrupoExecutor');
			calcularSLA();
			carregaFiltrosServico();
		}
	});
	
	completeServicoNegocioTecnico = $('#servicoNegocioTecnicoBusca').on("focus", function (event) {
		montaParametrosAutocompleteServicoNegocioTecnico();
        if (verificaSeContratoEstaVazio() || verificaSeCatalogoEstaVazio()) {
        	lancarErroContratoOuCatalogoSelecionados();
            event.preventDefault();
        }
    }).autocomplete({
		serviceUrl:'pages/autoCompleteServicoNegocioTecnico/autoCompleteServicoNegocioTecnico.load',
		noCache: true,
		onSelect: function(value, data){
			$('#idServicoNegocioTecBusc').val(data);
			$('#servicoNegocioTecnicoBusca').val(value);
		}
	});
	
});

/**Monta os parametros para a buscas do autocomplete**/
function montaParametrosAutocompleteSolicitante(){
	contrato =  $("#idContrato").val() ;
	completeSolicitante.setOptions({params: {contrato: contrato} });
}
function montaParametrosAutocompleteServico(){
	tipoDemanda = $("#idTipoDemandaServico").val();
 	contrato =  $("#idContrato").val() ;
 	categoria = $("#idCategoriaServico").val();
 	idServicoNegocioTecnico = $("#idServicoNegocioTecBusc").val();
 	completeServico.setOptions({params: {contrato: contrato, tipoDemanda: tipoDemanda, categoria : categoria, idServicoNegocioTecnico : idServicoNegocioTecnico} });
}

function habilitaAutoComplete(){
	completeUnidade = $('#unidadeDes').autocomplete({ 
		serviceUrl:'pages/autoCompleteUnidade/autoCompleteUnidade.load',
		noCache: true,
		onSelect: function(value, data){
			$('#idUnidade').val(data);
			$('#unidadeDes').val(value);
			JANELA_AGUARDE_MENU.show();
		}
	});
}

function limpar(){
	$("#idTipoCatalogoServicoSol").prop("disabled", false);
	
	$("#itensConfiguracaoSelecionados").html("<div class='nenhum-selecionado'>" + i18n_message("citcorpore.comum.nenhumaSelecao") + "</div><div class='clearfix'></div>");
	
	document.form.clear();
}

function valida(){
	if ((document.getElementById('nomeTemplate').value=='')){
		alert(i18n_message("citcorpore.comum.nome") +" : "+  i18n_message("citcorpore.comum.campo_obrigatorio"));
		return false;
	}
	if ((document.getElementById('idContrato').value=='')||(document.getElementById('idContrato').value=='0')){
		alert(i18n_message("contrato.contrato") +" : "+ i18n_message("citcorpore.comum.campo_obrigatorio"));
		return false;
	}
	if ((document.getElementById('idOrigem').value=='')||(document.getElementById('idOrigem').value=='0')){
		alert(i18n_message("citcorpore.comum.origemNovoLayout") +" : "+  i18n_message("citcorpore.comum.campo_obrigatorio"));
		return false;
	}
	if ((document.getElementById('idTipoDemandaServico').value=='')||(document.getElementById('idTipoDemandaServico').value=='0')){
		alert(i18n_message("solicitacaoServico.tipoSolicitacao") +" : "+  i18n_message("citcorpore.comum.campo_obrigatorio"));
		return false;
	}
	if ((document.getElementById('idServico').value=='')||(document.getElementById('idServico').value=='0')){
		alert(i18n_message("citcorpore.comum.servico") +" : "+  i18n_message("citcorpore.comum.campo_obrigatorio"));
		return false;
	}
	if ((document.getElementById('descricao').value=='')){
		alert(i18n_message("citcorpore.comum.descricao") +" : "+  i18n_message("citcorpore.comum.campo_obrigatorio"));
		return false;
	}

	return true;
}

function gravar(){
	if(valida()){
		document.form.urgencia.disabled = false;
		document.form.impacto.disabled = false;
		
		document.form.save();
	}
}

function excluir() {
	if (($("#idTemplateIncidenteRequisicao").val() != "") && ($("#idTemplateIncidenteRequisicao").val() != "0") && (confirm(i18n_message("citcorpore.comum.deleta")))) {
		document.form.fireDelete("excluir");
	}
}

function LOOKUP_TEMPLATE_INCIDENTE_REQUISICAO_select(idParam, desc) {
	$('.tabsbar a[href="#tab1-2"]').tab('show');
	document.form.restore({
		idTemplateIncidenteRequisicao : idParam
	});
}

function limparCampoServico() {
	document.form.idServico.value = "0";
	document.form.servico.value = "";
}

function limparCampoSolicitante() {
	document.form.idSolicitante.value = "0";
	document.form.solicitante.value = "";
	document.form.emailSolicitante.value = "";
}

function limparEscolhaServico(){
	limparCampoServico();
	$('#idTipoDemandaServico').val('');
	$('#idServicoNegocioTecBusc').val('');
	$('#servicoNegocioTecnicoBusca').val('');
}

function onChangeContrato(){
	limparEscolhaServico();
	
	montaParametrosAutocompleteServico();
	montaParametrosAutocompleteServicoNegocioTecnico();
	verificaTipoDeAcordoDoContrato();
	
	document.form.fireEvent("carregarComboUnidade");
}

//função que carrega todos as unidades relacionadas ao contrato selecionado em um json
function carregaUnidadesContrato(jsonStr){
    var dadosJson = JSON.parse(jsonStr);
    alert(jsonStr);
     $( "#unidadeDes" ).autocomplete({
    	 source: dadosJson,
         select: function(event, ui) {
        	 event.preventDefault();
        	 $(this).val(ui.item.label);
	         alert(ui.item.value);
         }
      });
}

function onkeypressUnidadeDes(){
	document.getElementById("idUnidade").value= "0";
}

function montaParametrosAutocompleteUnidade() {
	var idContratoStr = $("#idContrato").val();
	completeUnidade.setOptions({params: {idContrato: idContratoStr} });
}

function chamaFuncoesContrato(){
	document.getElementById("idUnidade").value= "0";
	if (document.getElementById("unidadeDes")!=null){
		document.getElementById("unidadeDes").value= "";
	}
}

function verificaTipoDeAcordoDoContrato() {
	document.form.fireEvent("verificaTipoDeAcordoDoContrato");
}

function buscarTodosServicosNegocioTecnico() {
	var pIdContrato = $("#idContrato").val();
	var pTipoServico = $("#idTipoCatalogoServicoSol").val();
	
	if (verificaSeContratoEstaVazio() || verificaSeCatalogoEstaVazio()) {
		lancarErroContratoOuCatalogoSelecionados();
    } else {
    	JANELA_AGUARDE_MENU.show();
		document.form.tipoServico.value = pTipoServico;
		document.form.idContrato.value = pIdContrato;
		
		$('#filtroTableServicosNegocioTecnico').val("");
		$('#filtroTableServicosNegocioTecnico').focus();
		document.form.fireEvent('listarServicosNegocioTecnico');
    }
}

function verificaSeContratoEstaVazio() {
	if ($("#idContrato").val() == '') {
		return true;
	}
	
	return false;
}

function verificaSeCatalogoEstaVazio() {
	if ($("#idTipoCatalogoServicoSol").val() == '') {
		return true;
	}
	
	return false;
}

function montaParametrosAutocompleteSol(idContrato){
	  completeSolicitante.setOptions({params: {contrato: idContrato} });
}

/**Monta os parametros para a buscas do autocomplete**/
function montaParametrosAutocompleteServicoNegocioTecnico(){
	var pContrato =  $("#idContrato").val();
	var pTipoServico = $("#idTipoCatalogoServicoSol").val();
	
	completeServicoNegocioTecnico.setOptions({params: {contrato: pContrato, tipoServico: pTipoServico} });
}

function lancarErroContratoOuCatalogoSelecionados(){
	notificacaoI18N("citcorpore.comum.impossivelRealizarConsulta", "citcorpore.comum.selecioneContrato");
}

function depoisListarServicos() {
	JANELA_AGUARDE_MENU.hide();
}

function limparServico(){
	$('#servicoBusca').val('');
	$("#idServico").val( '' );
}

function stopSLAPrevisto(){
	$('#tdResultadoSLAPrevisto').text('');
}

function selecionarServicoNegocioTecnico(row, obj){
	JANELA_AGUARDE_MENU.show();
	
	$('#idServicoNegocioTecBusc').val(obj.idServico);
	$('#servicoNegocioTecnicoBusca').val(obj.nomeServico);
	
	limparServico();
	stopSLAPrevisto();
	
	JANELA_AGUARDE_MENU.hide();
	
	$('#modal_infoServicosNegocioTecnico').modal('hide');
}

function carregaFiltrosServico() {
	document.form.fireEvent("definirFiltrosServico");
}

function selecionarServico(row, obj){
	JANELA_AGUARDE_MENU.show()
	$('#idServico').val(obj.idServico);
	$('#servicoBusca').val(obj.nomeServico);
	document.form.fireEvent('verificaImpactoUrgencia');
	document.form.fireEvent('verificaGrupoExecutor');
	calcularSLA();
	JANELA_AGUARDE_MENU.hide()
	$('#modal_infoServicos').modal('hide');
	document.form.idContrato.value =  $("#idContrato").val();
	carregaFiltrosServico();
}

function startLoading() {
	$('#tdResultadoSLAPrevisto').text('');
	var servicoBusca = document.form.servico.value;
	if(servicoBusca != ''){
		document.getElementById('divMini_loading').style.display = 'block';
	} else {
		document.getElementById('divMini_loading').style.display = 'none';
	}
}

function stopLoading() {
	document.getElementById('divMini_loading').style.display = 'none';
}

function calcularSLA() {
	startLoading();
	var temp = 'var statusDisabledUrgencia = document.form.urgencia.disabled;';
	temp += 'var statusDisabledImpacto = document.form.impacto.disabled;';
	temp += 'document.form.urgencia.disabled = false;';
	temp += 'document.form.impacto.disabled = false;';
	temp += 'document.form.fireEvent("calculaSLA");';
	temp += 'document.form.urgencia.disabled = statusDisabledUrgencia;';
	temp += 'document.form.impacto.disabled = statusDisabledImpacto;';
	temp += 'JANELA_AGUARDE_MENU.hide();';
	setTimeout(temp, 1500);
}

function exibeCalculoSLA(valor, cor) {
	stopLoading();
	$('#tdResultadoSLAPrevisto').text(valor);
	
	if (cor == '#e5e5e5') {
		$('#tdResultadoSLAPrevisto').css("background-color", "#e5e5e5");
		$('#tdResultadoSLAPrevisto').css("color", "black");
	} else {
		$('#tdResultadoSLAPrevisto').css("background-color", cor);
		$('#tdResultadoSLAPrevisto').css("color", "white");
		$('#tdResultadoSLAPrevisto').css("font-weight", "normal");
	}
}

function carregaCategoriaServico(){	
	if($("#utilizaCategoriaServico").is(":checked")){
		JANELA_AGUARDE_MENU.show();
		document.form.fireEvent("carregarComboCategoriaServico");
	} else {
		$("#idCategoriaServico").attr('disabled', true).addClass('disabled');
		$("#idCategoriaServico").empty();
	}
	
	limparServico();
}

function depoisCarregarComboCategoria() {
	JANELA_AGUARDE_MENU.hide();
	$("#idCategoriaServico").attr('disabled', false).removeClass('disabled');
}

function changeCatalogoServicoSolicitacao() {
	montaParametrosAutocompleteServicoNegocioTecnico();
	limparServicoNegocioTecnico();
	limparServico();
}

function limparServicoNegocioTecnico(){
	$("#idServicoNegocioTecBusc").val('');
	$("#servicoNegocioTecnicoBusca").val('');
	montaParametrosAutocompleteServico();
}

function limparServico(){
	$('#servico').val('');
	$("#idServico").val( '' );
}

function limparSolicitante() {
	$("#idSolicitante").val('');
	$("#solicitante").val('');
}

function setaIdTipoCatalogoServicoSoli(){
	$('#idTipoCatalogoServicoSoli').val($('#idTipoCatalogoServicoSol').val());
}

function changeCategoria(){
	$('#servico').val('');
	$('#idTipoDemandaServico').val(0);
}

function habilitaCheckCategoriaServico(){
	$( "#uniform-utilizaCategoriaServico span" ).addClass("checked");
	$( "#idCategoriaServico" ).removeClass("disabled");
}
function desabilitaCheckCategoriaServico(){
	$( "#uniform-utilizaCategoriaServico span" ).removeClass("checked");
	$("#idCategoriaServico").attr('disabled', true).addClass('disabled');
}

function abrirModalPesquisaItemConfiguracao(){
	document.getElementById('framePesquisaItemConfiguracao').src = URL_SISTEMA+'pages/pesquisaItemConfiguracao/pesquisaItemConfiguracao.load?iframe=true';
	$('#modal_pesquisaItemConfiguracao').modal('show');
}

function selectedItemConfiguracao(idItemCfg, identificacao) {
	$("#itensConfiguracaoSelecionados .nenhum-selecionado").remove();
	
	var idsItemConfiguracao = [];
	if ($("#idsItemConfiguracao").attr("value") != "") {
		idsItemConfiguracao = JSON.parse($("#idsItemConfiguracao").attr("value"));
		
		var index = idsItemConfiguracao.indexOf(parseInt(idItemCfg));
		if (index != -1) {
			$('#modal_pesquisaItemConfiguracao').modal('hide');
			return;
		}
		
		idsItemConfiguracao.push(idItemCfg);
	} else {
		idsItemConfiguracao.push(idItemCfg);
	}
	
	$("#idsItemConfiguracao").attr("value", JSON.stringify(idsItemConfiguracao));
	
	$('<div class="ic-item" data-ic="' + idItemCfg + '"><i class="material-icons md-14" onclick="removeItemConfiguracao(this)">cancel</i>' + identificacao + '</div>').insertBefore('#itensConfiguracaoSelecionados .clearfix');
	
	$('#modal_pesquisaItemConfiguracao').modal('hide');
}

function removeItemConfiguracao(_this) {
	var idItemConfiguracao = $(_this).parent(".ic-item").attr("data-ic");
	
	var idsItemConfiguracao = [];
	if ($("#idsItemConfiguracao").attr("value") != "") {
		idsItemConfiguracao = JSON.parse($("#idsItemConfiguracao").attr("value"));
	}
	
	var index = idsItemConfiguracao.indexOf(parseInt(idItemConfiguracao));
	if (index != -1) {
		idsItemConfiguracao.splice(index, 1);
	}
	
	$("#idsItemConfiguracao").attr("value", JSON.stringify(idsItemConfiguracao));
	
	if (idsItemConfiguracao.length <= 0) {
		$('<div class="nenhum-selecionado">' + i18n_message("citcorpore.comum.nenhumaSelecao") + '</div>').insertBefore('#itensConfiguracaoSelecionados .clearfix');
	}
	
	$(_this).parent(".ic-item").remove();
}