//br.com.centralit.citcorpore.util.Enumerados.TipoValorImportacaoCarga
var _TIPO_VALOR_EM_BRANCO = 0;
var _TIPO_VALOR_INFORMADO = 1;
var _TIPO_VALOR_DEFAULT = 2;

//br.com.centralit.citcorpore.util.Enumerados.FaseServico
var _FASE_SERVICO_ANALISAR = "AN";


var _TIPO_CATEGORIA_INCIDENTE_REQUISICAO = "I"; //br.com.centralit.citcorpore.util.Enumerados.TipoCategoria.CATEGORIA_INCIDENTE_REQUISICAO

$(function() {
	$('#cargaPortfolioServico .datepicker').datepicker();
	$("#qtdRegistros").mask("00000");
	
	document.getElementById('frameImportarCargaPortfolioServico').src = ctx + '/pages/importarCargaPortfolioServico/importarCargaPortfolioServico.load';
	
	CargaPortfolioServico.inicializar();
});

var CargaPortfolioServico = {
	inicializar: function() {
		window.LOOKUP_CATEGORIASERVICO_select = function(id, desc) {
			if ($("#modal-selecionar-servico-categoria").data("tipo") == 'N') {
				document.formCargaPortfolioServico.categoriaNegocioServicoCarga.value = desc.split("-")[0].trim();
			} else {
				document.formCargaPortfolioServico.categoriaServicoIncReqCarga.value = desc.split("-")[0].trim();
			}
			
			Modal.close('modal-selecionar-servico-categoria');
		};
		
		CargaPortfolioServico.servico.exibirEsconderDivClassificacao(false);
		CargaPortfolioServico.servico.addRemoverCamposClassificao(true);
		CargaPortfolioServico.servico.exibirEsconderAddRemoverCamposClassificao(false);
	},
	limpar: function() {
		document.formCargaPortfolioServico.clear();
		$("select[name='tipoValor']").each(function(i, el) {
			$(this).val($(this).find("option:first").val());
			$(this).trigger('change');
		});
		CargaPortfolioServico.servico.exibirEsconderDivClassificacao(false);
		CargaPortfolioServico.servico.addRemoverCamposClassificao(true);
		CargaPortfolioServico.servico.exibirEsconderAddRemoverCamposClassificao(false);
	},
	downloadModeloCargaXls: function() {
		document.getElementById('linkDownloadModeloCargaPortfolioXls').click();
	},
	downloadModeloCargaXlsx: function() {
		document.getElementById('linkDownloadModeloCargaPortfolioXlsx').click();
	},
	setDefaultDateValues: function() {
		$("#campoCargaServicoDataImplantacao .campoValorDefault").text(moment().format("DD/MM/YYYY"));
		$("#campoCargaIncidenteRequisicaoDataImplantacao .campoValorDefault").text(moment().format("DD/MM/YYYY"));
		$("#campoCargaContratoIncReqDataInicio .campoValorDefault").text(moment().format("DD/MM/YYYY"));
	},
	onChangeTipoValor: function(_this) {
		var classValidRequired = "Valid[Required]";
		var campoValorPreenchido = $(_this).closest('.divCampoCarga').find(".campoValorPreenchido");
		
		if(campoValorPreenchido[0]) {
			campoValorPreenchido[0].validacao = null;
		}
		
		if(_this.value == _TIPO_VALOR_INFORMADO) {
			if($(campoValorPreenchido).attr("class").indexOf("Date") > 0) {
				$(campoValorPreenchido).removeClass("Valid[Date]");
				classValidRequired = "Valid[Date,Required]";
			}
			
			$(campoValorPreenchido).addClass(classValidRequired);
		} else {
			if($(campoValorPreenchido).attr("class").indexOf("Date") > 0) {
				classValidRequired = "Valid[Date,Required]";
			}
			
			$(campoValorPreenchido).removeClass(classValidRequired);
		}
		
		this.exibirCampoValor(_this)
	},
	exibirCampoValor: function(_this) {
		var tipoValor = _this.value;
		var parentElement = $(_this).closest(".row-fluid");
		if(tipoValor == _TIPO_VALOR_EM_BRANCO) {
			$(parentElement).find(".campoValorPreenchido").hide();
			$(parentElement).find(".campoValorDefault").hide();
		} else if(tipoValor == _TIPO_VALOR_INFORMADO) {
			$(parentElement).find(".campoValorPreenchido").css("display", "block");
			$(parentElement).find(".campoValorDefault").hide();
		} else if(tipoValor == _TIPO_VALOR_DEFAULT) {
			$(parentElement).find(".campoValorPreenchido").hide();
			$(parentElement).find(".campoValorDefault").css("display", "block");
		}
	},
	gerarModelo: function() {
		var hasCampoInformado = false;
		var campos = [];
		$(".divCampoCarga:not(.divCampoCargaRemoved)").each(function(i, el) {
			var tipoValor = $(el).find("select[name='tipoValor']").val();
			var valor = null;
			var descValorDefault = null;
			
			 if(tipoValor == _TIPO_VALOR_INFORMADO) {
				 hasCampoInformado = true;
				valor = $(el).find(".campoValorPreenchido").val();
			} else if(tipoValor == _TIPO_VALOR_DEFAULT) {
				valor = $(el).find(".campoValorDefault").attr("data-valor");
				descValorDefault = $(el).find(".campoValorDefault").text();
			}
			
			campos.push({
				'nome': $(el).find(".campoCarga").text(),
				'tipoValor': tipoValor,
				'valor': valor,
				'descValorDefault': descValorDefault
			});
		});
		document.formCargaPortfolioServico.json.value = JSON.stringify(campos);
		
		if(hasCampoInformado) {
			Modal.open('modal-carga-portfolio-quantidade-registros');
			$("#modal-carga-portfolio-quantidade-registros").attr('data-tipo-arquivo', 'xls');
			return true;
		}
		
		return false;
	},
	gerarModeloCargaXls: function() {
		DEFINEALLPAGES_generateConfiguracaoCamposForm(document.formCargaPortfolioServico);
		if(!document.formCargaPortfolioServico.validate())
			return;
		
		var isToOpenModalQtdRegistros = this.gerarModelo();
		
		if(isToOpenModalQtdRegistros)
			return;
		
		this.gerarModeloXls();
	},
	gerarModeloCargaXlsx: function() {
		DEFINEALLPAGES_generateConfiguracaoCamposForm(document.formCargaPortfolioServico);
		if(!document.formCargaPortfolioServico.validate())
			return;
		
		var isToOpenModalQtdRegistros = this.gerarModelo();
		
		if(isToOpenModalQtdRegistros)
			return;
		
		this.gerarModeloXlsx();
	},
	gerarModeloModalQtdRegistros: function() {
		if (!$("#qtdRegistros").val()) {
			return;
		}
		
		this.fecharModalQtdRegistros();

		if($("#modal-carga-portfolio-quantidade-registros").attr('data-tipo-arquivo') == "xls") {
			this.gerarModeloXls();
		}
		if($("#modal-carga-portfolio-quantidade-registros").attr('data-tipo-arquivo') == "xlsx") {
			this.gerarModeloXlsx();
		}
	},
	fecharModalQtdRegistros: function() {
		document.formCargaPortfolioServico.quantidadeRegistros.value = $("#qtdRegistros").val();
		$("#qtdRegistros").val("");
		Modal.close('modal-carga-portfolio-quantidade-registros');
		
	},
	gerarModeloXls: function() {
		JANELA_AGUARDE_MENU.show();
		document.formCargaPortfolioServico.fireEvent("gerarModeloXls");
	},
	gerarModeloXlsx: function() {
		JANELA_AGUARDE_MENU.show();
		document.formCargaPortfolioServico.fireEvent("gerarModeloXlsx");
	},
	servico: {
		onClickCategoriaNegocio : function() {
			Modal.open('modal-selecionar-servico-categoria');
			$("#modal-selecionar-servico-categoria").data("tipo", "N");
			$("a[href=#tabPesquisaCategoria]").trigger('click');
			document.formCategoriaServico.fireEvent("setaCategoriaNegocio");
			document.formPesquisaCategoriaServico.pesqLockupLOOKUP_CATEGORIASERVICO_TIPOCATEGORIA.value = "'N'";
		},
		onChangeTipoValorFaseServico: function(_this) {
			CargaPortfolioServico.onChangeTipoValor(_this);
			$("#campoCargaServicoStatus select[name='tipoValor']").val(_this.value).trigger('change');
			
			$("#faseServicoCarga").val($("#faseServicoCarga").find("option:first").val());
			$("#faseServicoCarga").trigger('change');
			
			if(!$("#campoCargaServicoClassificacao").hasClass("divCampoCargaClassificaoRemoved")) {
				this.exibirEsconderDivClassificacao(false);
			}
			
			this.exibirEsconderAddRemoverCamposClassificao(_this.value == _TIPO_VALOR_EM_BRANCO);
				
		},
		onChangeFaseServico: function(_this) {
			document.formCargaPortfolioServico.fireEvent('carregaComboStatusServico');
			
			if(_this.value == _FASE_SERVICO_ANALISAR) {
				this.exibirEsconderDivClassificacao(true);
				this.exibirEsconderAddRemoverCamposClassificao(false);
			} else {
				this.exibirEsconderDivClassificacao(false);
			}
		},
		onChangeTipoValorStatusServico: function(_this) {
			var tipoValorFase = $("#campoCargaServicoFase select[name='tipoValor']").val();
			
			if (tipoValorFase == _TIPO_VALOR_EM_BRANCO) {// se fase servico for _TIPO_VALOR_EM_BRANCO status servico só poderá ser _TIPO_VALOR_EM_BRANCO
				if(_this.value != _TIPO_VALOR_EM_BRANCO) {
					$("#campoCargaServicoStatus select[name='tipoValor']").val(_TIPO_VALOR_EM_BRANCO);
					_this.value = _TIPO_VALOR_EM_BRANCO;
				}
			} else if(tipoValorFase == _TIPO_VALOR_INFORMADO){// se fase servico for _TIPO_VALOR_INFORMADO status servico não poderá ser _TIPO_VALOR_DEFAULT
				if(_this.value == _TIPO_VALOR_DEFAULT) {
					$("#campoCargaServicoStatus select[name='tipoValor']").val(_TIPO_VALOR_EM_BRANCO);
					_this.value = _TIPO_VALOR_EM_BRANCO;
				}
			}
			
			CargaPortfolioServico.onChangeTipoValor(_this);
		},
		exibirEsconderAddRemoverCamposClassificao: function(isShow) {
			if(isShow) {
				$("#addRemoverServicoClassificacao").show();
				// limpa antes de exibir novamente
				$("#addRemoverServicoClassificacao").attr('data-add', 0);
				$("#campoCargaServicoClassificacao select[name='tipoValor']").each(function(i, el) {
					$(this).val($(this).find("option:first").val());
					$(this).trigger('change');
				});
				this.addRemoverCamposClassificao();
			} else {
				$("#addRemoverServicoClassificacao").hide();
			}
		},
		addRemoverCamposClassificao: function(isInitialize) {
			if(isInitialize) {
				$("#addRemoverServicoClassificacao").attr('data-add', 1);
				$("#spanRemoverServicoClassificacao").hide();
				return;
			}
			
			if($("#addRemoverServicoClassificacao").attr('data-add') == 1) {
				$("#addRemoverServicoClassificacao").attr('data-add', 0);
				$("#spanRemoverServicoClassificacao").show();
				$("#spanAddServicoClassificacao").hide();
				this.exibirEsconderDivClassificacao(true);
			} else {
				$("#addRemoverServicoClassificacao").attr('data-add', 1);
				$("#spanRemoverServicoClassificacao").hide();
				$("#spanAddServicoClassificacao").show();
				this.exibirEsconderDivClassificacao(false);
			}
		},
		exibirEsconderDivClassificacao: function(isShow) {
			if(isShow) {
				$("#campoCargaServicoClassificacao").show();
				$("#campoCargaServicoClassificacao").removeClass("divCampoCargaClassificaoRemoved");
				$("#campoCargaServicoClassificacao .divCampoCarga").removeClass("divCampoCargaRemoved");
			} else {
				$("#campoCargaServicoClassificacao").hide();
				$("#campoCargaServicoClassificacao").addClass("divCampoCargaClassificaoRemoved");
				$("#campoCargaServicoClassificacao .divCampoCarga").addClass("divCampoCargaRemoved");
			}
		}
	},
	servicoIncReq: {
		onClickCategoria : function() {
			Modal.open('modal-selecionar-servico-categoria');
			$("#modal-selecionar-servico-categoria").data("tipo", "");
			$("a[href=#tabPesquisaCategoria]").trigger('click');
			document.formCategoriaServico.fireEvent("setaCategoriaIncidenteRequisicao");
			document.formPesquisaCategoriaServico.pesqLockupLOOKUP_CATEGORIASERVICO_TIPOCATEGORIA.value = "'"+_TIPO_CATEGORIA_INCIDENTE_REQUISICAO+"'";
		}
	},
	contrato: {
		onClickContrato: function() {
			Modal.open('modal-carga-portfolio-add-contrato');
		},
		removeContrato: function() {
			$("#divContentCamposContrato").hide();
			$("#removeContratoCarga").hide();
			$("#addContratoCarga").show();

			$("#divContentCamposContrato .divCampoCarga").addClass("divCampoCargaRemoved");
		},
		addContrato: function() {
			$("#divContentCamposContrato").show();
			$("#removeContratoCarga").show();
			$("#addContratoCarga").hide();
			
			$("#divContentCamposContrato .divCampoCarga").removeClass("divCampoCargaRemoved");
		},
		removerCampo: function(_this) {
			$(_this).closest(".divCampoCarga").remove();
		},
		onClickFluxo: function() {
			Modal.open('modal-carga-portfolio-contrato-add-fluxo');
		},
		addFluxo: function() {
			document.formCargaPortfolioServico.fluxoContratoIncReqCarga.value = $("#comboTipoFluxoCarga :selected").text();
			Modal.close('modal-carga-portfolio-contrato-add-fluxo');
		}
	}
}