_TIPO_NEGOCIO = 'negocio';
_TIPO_APOIO = 'apoio';
_TIPO_INCIDENTE_REQUISICAO = 'incidente-requisicao';
_TIPO_ORDEM_SERVICO = 'ordem-servico';
_TIPO_PROCEDIMENTO = 'procedimento';

$(function() {
	document.formCategoriaServico.afterRestore = function() {
		$("li a[href='#tabCadastroCategoria']").trigger('click');
	}
	
	});

function LOOKUP_CATEGORIASERVICO_select(id, desc) {
	if(Modal.isOpen('modal-selecionar-servico-categoria')){
		if ($("#modal-selecionar-servico-categoria").data("tipo") == 'N') {
			selectCategoriaNegocio(id, desc);
		} else if ($("#modal-selecionar-servico-categoria").data("tipo") == 'A') {
			selectCategoriaApoio(id, desc);
		} else {
			selectCategoriaRequisicaoIncidente(id, desc);
		}
	} else {
		document.formCategoriaServico.restore({
			idcategoriaServico : id
		});
	}
}

function LOOKUP_CATEGORIASERVICO_NEGOCIO_select(id, desc) {
	funcaoSelectLookupPorTipo(id, desc, _TIPO_NEGOCIO);
}

function LOOKUP_CATEGORIASERVICO_APOIO_select(id, desc) {
	funcaoSelectLookupPorTipo(id, desc, _TIPO_APOIO);
}

function LOOKUP_CATEGORIASERVICO_INCIDENTE_REQUISICAO_select(id, desc) {
	funcaoSelectLookupPorTipo(id, desc, _TIPO_INCIDENTE_REQUISICAO);
}

function LOOKUP_CATEGORIASERVICO_ORDEMSERVICO_select(id, desc) {
	funcaoSelectLookupPorTipo(id, desc, _TIPO_ORDEM_SERVICO);
}

function funcaoSelectLookupPorTipo(id, desc, tipo) {
	document.formCategoriaServico.idCategoriaServicoPai.value = id;

	var valor = desc.split('-');
	var nomeConcatenado = "";
	for (var i = 0; i < valor.length; i++) {
		if (i == 0) {
			document.formCategoriaServico.nomeCategoriaServicoPai.value = valor[i];
		}
	}
	document.formCategoriaServico.fireEvent("verificaHierarquia");
	fecharPopup(tipo);
}

function gravarCategoria() {
	document.formCategoriaServico.save();
}

function limparCategoria() {
	document.formCategoriaServico.clear();
	document.formCategoriaServico.fireEvent("load");
}

function excluirCategoria() {
	var idCategoriaServico = document.getElementById("idCategoriaServico");

	if (idCategoriaServico != null && idCategoriaServico.value == 0) {
		alert(i18n_message("citcorpore.comum.necessarioSelecionarRegistro"));
		return false;
	}
	if (confirm(i18n_message("citcorpore.comum.deleta"))) {
		document.formCategoriaServico.fireEvent("excluir");
	}
}

function consultarCategoriaServicoSuperior() {
	var tipo = document.getElementById('tipoCategoria').value;

	var strTipo = '';
	if (tipo == 'N') {
		strTipo = _TIPO_NEGOCIO;
	} else if (tipo == 'A') {
		strTipo = _TIPO_APOIO;
	} else if (tipo == 'I') {
		strTipo = _TIPO_INCIDENTE_REQUISICAO;
	} else if (tipo == 'O') {
		strTipo = _TIPO_ORDEM_SERVICO; 
	} else if (tipo == 'P') {
		strTipo = _TIPO_PROCEDIMENTO; 
	} else {
		alert(i18n_message("categoriaServico.necessarioSelecionarTipoCategoria"));
		return;
	}
	
	Modal.open('modal-categoria-servico-'+strTipo)
}

function fecharPopup(tipo) {
	Modal.close('modal-categoria-servico-'+tipo)
}
