$(document).ready(function(){
	if(locale === "pt"){
		$('#cpfCnpj').attr("maxlength","18");
	}else{
		$('#cpfCnpj').attr("maxlength","255");
	}
});

LOOKUP_CLIENTE_select = function(id, desc) {
	aguarde();
	$('.tabsbar a[href="#tab1-3"]').tab('show');
		document.formCadastroCliente.restore({
			idCliente : id
	});
};

aguarde = function() {
	JANELA_AGUARDE_MENU.show();
};

$(function() {
	salvarCliente = function(){
		document.formCadastroCliente.save(); 
	}
});

limparCliente = function(){
	document.formCadastroCliente.clear();
	$('input[name=situacao][value=I]').attr('checked', false);
	$('input[name=tipoCliente][value=E]').attr('checked', false);
	$('input[name=situacao][value=A]').attr('checked', 'checked');
	$('input[name=tipoCliente][value=I]').attr('checked', 'checked');
}

excluirCliente = function(){
	
	if (document.formCadastroCliente.idCliente.value != "" && confirm(i18n_message("citcorpore.comum.deleta"))) {
		document.formCadastroCliente.fireEvent("excluir");
	}else{
		alert(i18n_message("citcorpore.comum.necessarioSelecionarRegistro") );
		return false;
	}
}

document.formCadastroCliente.onValidate = function() {
    return verificaCpfCnpj(document.form.cnpj);
};

//---------- MASCARAR CPF OU CNPJ -------------//
mascararCPFCNPJ = function(o,f){
    v_obj = o;
    v_fun = f;
    setTimeout('execmascara()', 1);
};
 
execmascara = function(){
	$('#cpfCnpj').unmask();
    v_obj.value = v_fun(v_obj.value);
};
 
formatarCpfCnpj = function(v){
	if(locale === "pt"){
	    //Remove tudo o que não é dígito
	    v=v.replace(/\D/g,"");
	    if (v.length <= 11) { //CPF
	        //Coloca um ponto entre o terceiro e o quarto dígitos
	        v=v.replace(/(\d{3})(\d)/,"$1.$2");
	        //Coloca um ponto entre o terceiro e o quarto dígitos
	        //de novo (para o segundo bloco de números)
	        v=v.replace(/(\d{3})(\d)/,"$1.$2");
	        //Coloca um hífen entre o terceiro e o quarto dígitos
	        v=v.replace(/(\d{3})(\d{1,2})$/,"$1-$2");
	    } else { //CNPJ
	        //Coloca ponto entre o segundo e o terceiro dígitos
	        v=v.replace(/^(\d{2})(\d)/,"$1.$2");
	        //Coloca ponto entre o quinto e o sexto dígitos
	        v=v.replace(/^(\d{2})\.(\d{3})(\d)/,"$1.$2.$3");
	        //Coloca uma barra entre o oitavo e o nono dígitos
	        v=v.replace(/\.(\d{3})(\d)/,".$1/$2");
	        //Coloca um hífen depois do bloco de quatro dígitos
	        v=v.replace(/(\d{4})(\d)/,"$1-$2");
	    }
	}
    return v;
};

//------- VALIDA CNPJ OU CPF DIGITADO -----------//
verificaCpfCnpj = function(cpfcnpj) {
	var valor = cpfcnpj.value;
	
	if (StringUtils.isBlank(cpfcnpj.value)){
        return true;
	}
	
	if(locale === "pt"){
		if (valor.length > 14) {
	       if (!ValidacaoUtils.validaCNPJSemMascara(cpfcnpj, 'CNPJ - ')){
				valor = "";
				return false;
	       }
		}else if (valor.length <= 14){
	       if (!ValidacaoUtils.validaCPF(cpfcnpj, 'CPF - ')){
	    	   valor = "";
	           return false;
	       }
		}
	}
	return true;
}


