_TIPO_EXIBICAO_NENHUM = 'N';
_TIPO_EXIBICAO_GERAL = 'G';
_TIPO_EXIBICAO_ESPECIFICO = 'E';

addEvent(window, "load", load, false);

var parametros;
var scriptExec;
var template;

function load() {
	document.form.afterRestore = function(){
		$("a[href=#tabCadastroConsulta]").trigger('click');
	};
	
	configuraButtonRadioTipoApresentacao();
	configuraSelectModuloApresentacao();
	
	parametros = CM.init(document.getElementById("parametros"), {lineNumbers: true, matchTags: {bothTags: true}, extraKeys: {"Ctrl-J": "toMatchingTag"}, mode: "application/xml"});
	scriptExec = CM.init(document.getElementById("scriptExec"), {lineNumbers: true, matchBrackets: true, mode: "text/x-java"});
	template = CM.init(document.getElementById("template"), {lineNumbers: true, matchTags: {bothTags: true}, extraKeys: {"Ctrl-J": "toMatchingTag"}, mode: "text/html"});
	
	var mac = CodeMirror.keyMap.default == CodeMirror.keyMap.macDefault;
	CodeMirror.keyMap.default[(mac ? "Cmd" : "Ctrl") + "-Space"] = "autocomplete";
}

var CM = {
	init : function(_element, _options) {
		return CodeMirror.fromTextArea(_element, _options);
	},
	update : function(_var, _value) {
		_var.setValue(_value);
		setTimeout(function() {
			_var.refresh();
		},1);
	}
};













































function LOOKUP_BICONSULTAS_select(id, desc) {
	document.form.restore({
		idConsulta : id
	});
}

exibeColuna = function(serializeColuna) {
	if (seqColuna != '') {
		if (!StringUtils.isBlank(serializeColuna)) {
			var colunaDto = new CIT_BIConsultaColunasDTO();
			colunaDto = ObjectUtils.deserializeObject(serializeColuna);
			eval('document.form.nomeColuna' + seqColuna + '.value = "'
					+ colunaDto.nomeColuna + '"');
			eval('document.form.ordem' + seqColuna + '.value = "'
					+ colunaDto.ordem + '"');
		}
	}
}

function tratarColunas() {
	document.form.colCriterios_Serialize.value = '';
	try {
		var count = GRID_COLUNAS.getMaxIndex();
		var contadorAux = 0;
		var objs = new Array();
		for (var i = 1; i <= count; i++) {
			var trObj = document.getElementById('GRID_COLUNAS_TD_'
					+ NumberUtil.zerosAEsquerda(i, 5));
			if (!trObj) {
				continue;
			}
			var biConsultaColunasDTO = getConsulta(i);
			if (StringUtils.isBlank(biConsultaColunasDTO.nomeColuna)) {
				alert(i18n_message('construtorconsultas.nomeColuna'));
				eval('document.form.nomeColuna'
						+ NumberUtil.zerosAEsquerda(i, 5) + '.focus()');
				return false;
			}
			if (StringUtils.isBlank(biConsultaColunasDTO.ordem)) {
				alert(i18n_message('construtorconsultas.ordem'));
				eval('document.form.ordem' + NumberUtil.zerosAEsquerda(i, 5)
						+ '.focus()');
				return false;
			}
			objs[contadorAux] = biConsultaColunasDTO;
			contadorAux = contadorAux + 1;
		}
		document.form.colCriterios_Serialize.value = ObjectUtils
				.serializeObjects(objs);
		return true;
	} catch (e) {
		alert('Ocorreu um erro ao processar a solicita��o de Grava��o. Tente novamente! '
				+ e.message);
		return false;
	}
}
getConsulta = function(seq) {
	var biConsultaColunasDTO = new CIT_BIConsultaColunasDTO();

	var seqCriterio = NumberUtil.zerosAEsquerda(seq, 5);
	biConsultaColunasDTO.nomeColuna = eval('document.form.nomeColuna'
			+ seqCriterio + '.value');
	biConsultaColunasDTO.ordem = eval('document.form.ordem' + seqCriterio
			+ '.value');
	return biConsultaColunasDTO;
}

var seqColuna = '';
incluirColuna = function() {
	GRID_COLUNAS.addRow();
	seqColuna = NumberUtil.zerosAEsquerda(GRID_COLUNAS.getMaxIndex(), 5);
	eval('document.form.nomeColuna' + seqColuna + '.focus()');
}

function gravar() {
	if (tratarColunas() && validarModuloExibicao()) {
		defineValueTipoExibicao();
		defineValueModuloExibicao();
		
		parametros.toTextArea();
		scriptExec.toTextArea();
		template.toTextArea();
		
		document.form.save();
	}
}
function exportar() {
	if (tratarColunas()) {
		document.form.fireEvent("exportar");
	}
}

importarReport = function() {
	if (!confirm(i18n_message("construtorconsultas.importaraQuestionario"))) {
		return;
	}

	JANELA_AGUARDE_MENU.setTitle('Aguarde... importando...');
	JANELA_AGUARDE_MENU.show();

	document.formImportar.setAttribute("enctype", "multipart/form-data");
	document.formImportar.setAttribute("encoding", "multipart/form-data");
	document.formImportar.submit();
}

function limpar() {
	GRID_COLUNAS.deleteAllRows();
	document.form.clear();
	//defineComportamentoCheckboxNaoAtualizBase(false);
	defineComportamentoRadioTipoExibicao(_TIPO_EXIBICAO_NENHUM);
}

function importar() {
	POPUP_IMPORTAR.show();
}

function defineValueTipoExibicao() {
	document.form.tipoExibicao.value = $(".radioTipoExibicao .active").val();
}

function validarModuloExibicao() {
	if ($("#slModuloExibicao").val() == null || $("#slModuloExibicao").val().length == 0) {
		if ($(".radioTipoExibicao .active").val() == _TIPO_EXIBICAO_GERAL) {
			notificacaoI18N("citcorpore.comum.camposObrigatorios", "construtorconsultas.moduloExibicao.selecioneUmOuMaisModulos");
			$("#slModuloExibicao").focus();
			return false;
		} else if ($(".radioTipoExibicao .active").val() == _TIPO_EXIBICAO_ESPECIFICO) { 
			notificacaoI18N("citcorpore.comum.camposObrigatorios", "construtorconsultas.moduloExibicao.selecioneUmModulo");
			$("#slModuloExibicao").focus();
			return false;
		} else if ($(".radioTipoExibicao .active").val() == _TIPO_EXIBICAO_NENHUM) {
			return true;
		}
	}
	
	return true;
}

function defineValueModuloExibicao() {
	if ($(".radioTipoExibicao .active").val() == _TIPO_EXIBICAO_NENHUM) {
		document.form.moduloExibicao.value = '';
	} else {
		var moduloExibicao = $("#slModuloExibicao").val();
		if (moduloExibicao != null) {
			document.form.moduloExibicao.value = moduloExibicao.toString();
		} else {
			document.form.moduloExibicao.value = "";
		}
	}
	document.form.tipoExibicao.value = $(".radioTipoExibicao .active").val();
}

function configuraButtonRadioTipoApresentacao() {
	$(".radioTipoExibicao button").on("click", function(ev){
		if (ev.currentTarget.value == _TIPO_EXIBICAO_ESPECIFICO) {
			$("#slModuloExibicao").data("placeholder", i18n_message("construtorconsultas.moduloExibicao.selecioneUmModulo"));
			$("#slModuloExibicao").select2();
			if ($("#slModuloExibicao").val() != null && $("#slModuloExibicao").val().length > 1) {
				$("#slModuloExibicao").select2("val", "");
			}
			$("#slModuloExibicao").prop("disabled", false);
		} else if (ev.currentTarget.value == _TIPO_EXIBICAO_GERAL){
			$("#slModuloExibicao").data("placeholder", i18n_message("construtorconsultas.moduloExibicao.selecioneUmOuMaisModulos"));
			$("#slModuloExibicao").select2();
			$("#slModuloExibicao").prop("disabled", false);
		} else {
			$("#slModuloExibicao").prop("disabled", true);
			$("#slModuloExibicao").data("placeholder", "");
			$("#slModuloExibicao").select2("val", "");
		}
	});
}

function configuraSelectModuloApresentacao() {
	addEvent(window, "mousedown", click, false);
	$("#slModuloExibicao").select2();
	$("#slModuloExibicao").on("select2-open", function() { 
	    $(this).data("open", true);
	});
	$("#slModuloExibicao").on("select2-close", function() { 
	    $(this).data("open", false);
	});
	$("#slModuloExibicao").on("select2-selecting", function() { 
		if ($(".radioTipoExibicao .active").val() == _TIPO_EXIBICAO_ESPECIFICO) {
			if ($("#slModuloExibicao").val() != null && $("#slModuloExibicao").val().length > 0 ) {
				$("#slModuloExibicao").select2("val", "");
			}
		}
	});
}

function click() {
	if ($("#slModuloExibicao").data("open")) {
		$("#slModuloExibicao").select2("close");
	}
}

function defineComportamentoRadioTipoExibicao(valor) {
	$(".radioTipoExibicao button[value='" + valor + "']").trigger("click");
}

function defineComportamentoSelectModuloExibicao(valor) {
	var valor = valor.split(",");
	$("#slModuloExibicao").select2("val", valor);
}