/**
 * @author thyen.chang
 */

$(function() {
	$("#POPUP_FORMULA").dialog({
		autoOpen : false,
		width : 600,
		height : 400,
		modal : true
	});
	
	$("#nomeFormula").click(function() {
		$("#POPUP_FORMULA").dialog("open");
	});
	
	$("#ignorarIcsInventariados").change(function() {
		if (this.checked) {
			$(".evm-configuracao-ignorar-maquinas-inventariadas").removeClass("hide");
		} else {
			$(".evm-configuracao-ignorar-maquinas-inventariadas").addClass("hide");
		}
});
});

function LOOKUP_FORMULA_select(id, desc) {
	document.getElementById("nomeFormula").value = desc;
	document.form.idFormula.value = id;
	fecharPopupFormula();
}

function LOOKUP_EVM_INVENTORY_CONFIGURACAO_select(id, desc) {
	
	JANELA_AGUARDE_MENU.show();

	$('.tabsbar a[href="#tabs-1"]').tab('show');
	document.form.restore({
		idConfiguracao : id
	});
}

function fecharPopupFormula() {
	$("#POPUP_FORMULA").dialog("close");
}

function validaCampos(){
	/**
	 * Valida faixa de ip
	 */
	var listIP = document.getElementById("faixaIp").value.split(";");
	for(ip = 0; ip < listIP.length; ip++){
		var faixaIP = listIP[ip].trim();
		if(faixaIP != ""){
			if(!isIpRange(faixaIP.split("-")) && !isCIDR(faixaIP.split("."))){
				alert(i18n_message("evm.inventory.configuracao.faixainvalida"));
				document.getElementById("faixaIp").focus();
				return;
			}
		}
	}
	/**
	 * Valid ip
	 */
	var ipServidor = document.getElementById("ipServidor").value;
	var portaSNMP = document.getElementById("portaSNMP").value;
	var timeout = document.getElementById("timeout").value;
	var numTentativas = document.getElementById("numeroTentativas").value;
	
	if(isValid(ipServidor) && !isIp(ipServidor.split("."))){
		alert(i18n_message("evm.inventory.configuracao.ipinvalido"));
		document.getElementById("ipServidor").focus();
		return;
	}
	if(isValid(portaSNMP) && !isInt(portaSNMP)){
		alert(i18n_message("evm.inventory.configuracao.portaSnmpInvalida"));
		document.getElementById("portaSNMP").focus();
		return;
	}
	if ($("#ignorarIcsInventariados").prop("checked") && $("#tempoIgnorarIcs").attr("value") == "") {
		alert(i18n_message("citcorpore.comum.campo_obrigatorio") + ": " + i18n_message("evm.inventory.configuracao.tempoIgnorarMaquinasInventariadas"));
		return;
	}
	
	JANELA_AGUARDE_MENU.show();
	document.form.save();
}

function excluir() {
	if (document.getElementById("idConfiguracao").value == "") {
		alert(i18n_message("citcorpore.comum.necessarioSelecionarRegistro"));
	}else if(document.getElementById("idConfiguracao").value != ""){
		if (confirm(i18n_message("citcorpore.comum.deleta"))) {
			JANELA_AGUARDE_MENU.show();
			document.form.fireDelete("delete");
		}
	}
}

function limpar(){
	$('#h4InfoAudit').hide();
	
	$('#divCriador').hide();
	$('#criadopor').text("");
	$('#datahoracriacao').text("");
	
	$('#divModificador').hide();
	$('#alteradopor').text("");
	$('#datahoraalteracao').text("");
	
	document.form.clear();
}

function isCIDR(faixa){
	if(faixa.length != 4)
		return false;
	for(i = 0; i < faixa.length; i++){
		if(i != 3){
			if(!isIntIp(faixa[i]))
				return false;
		} else {
			var aux = faixa[i].split("/");
			if(aux.length != 2)
				return false;
			for(j = 0; j < aux.length; j++)
				if(!isIntIp(aux[j]))
					return false;
		}
	}
	return true;
}

function isIp(ip){
	if(ip.length != 4)
		return false;
	for(i = 0; i < ip.length; i++)
		if(!isIntIp(ip[i]))
			return false;
	return true;
}

function isIpRange(range){
	if(range.length != 2)
		return false;
	for(k = 0; k < range.length; k++)
		if(!isIp(range[k].trim().split(".")))
			return false;
	return true;
}

function isInt(num){
	return (num % 1 === 0) && isValid(num);
}

function isIntIp(num){
	return (num % 1 === 0) && (num <= 255) && (num >= 0) && isValid(num);
}

function isValid(val){
	return (val !== null) && (val !== undefined) && (val !== "");
}

function onlyNumbers(evt) {
	var theEvent = evt || window.event;
	var key = theEvent.keyCode || theEvent.which;
	key = String.fromCharCode(key);
	var regex = /[0-9]/;
	if (!regex.test(key)) {
		theEvent.returnValue = false;
		if (theEvent.preventDefault)
			theEvent.preventDefault();
	}
}