// jQuery Gantt Chart
// ==================
// Basic usage:
//      $(".selector").gantt({
//          source: "ajax/data.json",
//          scale: "weeks",
//          minScale: "weeks",
//          maxScale: "months",
//          onItemClick: function(data) {
//              alert("Item clicked - show some details");
//          },
//          onAddClick: function(dt, rowId) {
//              alert("Empty space clicked - add an item!");
//          },
//          onRender: function() {
//              console.log("chart rendered");
//          }
//      });
//
/*jshint shadow:true, laxbreak:true, jquery:true, strict:true, trailing:true */(function(a,b){"use strict",a.fn.gantt=function(c){function g(a,b){for(var c=1;;c++){var d=new Date(a);d.setHours(a.getHours()+b*c);if(d.getTime()!==a.getTime())return d}}var d="jquery.fn.gantt",e=["hours","days","weeks","months"],f={source:[],itemsPerPage:7,months:["January","February","March","April","May","June","July","August","September","October","November","December"],dow:["S","M","T","W","T","F","S"],navigate:"buttons",scale:"days",useCookie:!1,maxScale:"months",minScale:"hours",waitText:"Please wait...",onItemClick:function(a){return},onAddClick:function(a){return},onRender:function(){return},scrollToToday:!0};c&&a.extend(f,c),f.useCookie=f.useCookie&&a.isFunction(a.cookie),a.extend(a.expr[":"],{findday:function(b,c,d){var e=new Date(parseInt(d[3],10)),f=a(b).attr("id");f=f?f:"";var g=f.indexOf("-")+1,h=new Date(parseInt(f.substring(g,f.length),10));return e=new Date(e.getFullYear(),e.getMonth(),e.getDate()),h=new Date(h.getFullYear(),h.getMonth(),h.getDate()),e.getTime()===h.getTime()}}),a.extend(a.expr[":"],{findweek:function(b,c,d){var e=new Date(parseInt(d[3],10)),f=a(b).attr("id");f=f?f:"";var g=f.indexOf("-")+1;e=e.getFullYear()+"-"+e.getDayForWeek().getWeekOfYear();var h=f.substring(g,f.length);return e===h}}),a.extend(a.expr[":"],{findmonth:function(b,c,d){var e=new Date(parseInt(d[3],10));e=e.getFullYear()+"-"+e.getMonth();var f=a(b).attr("id");f=f?f:"";var g=f.indexOf("-")+1,h=f.substring(g,f.length);return e===h}}),Date.prototype.getWeekId=function(){var a=this.getFullYear(),b=this.getDayForWeek().getWeekOfYear(),c=this.getMonth();return c===11&&b===1&&a++,"dh-"+a+"-"+b},Date.prototype.getRepDate=function(){switch(f.scale){case"hours":return this.getTime();case"weeks":return this.getDayForWeek().getTime();case"months":return(new Date(this.getFullYear(),this.getMonth(),1)).getTime();default:return this.getTime()}},Date.prototype.getDayOfYear=function(){var a=new Date(this.getFullYear(),0,0),b=new Date(this.getFullYear(),this.getMonth(),this.getDate());return Math.ceil((b-a)/864e5)},Date.prototype.getWeekOfYear=function(){var a=new Date(this.getFullYear(),0,1),b=new Date(this.getFullYear(),this.getMonth(),this.getDate());a.getDay()>3&&(a=new Date(b.getFullYear(),0,7-a.getDay()));var c=b.getDayOfYear()-a.getDayOfYear();return Math.ceil(c/7)},Date.prototype.getDaysInMonth=function(){return 32-(new Date(this.getFullYear(),this.getMonth(),32)).getDate()},Date.prototype.hasWeek=function(){var a=new Date(this.valueOf());a.setDate(a.getDate()-a.getDay());var b=new Date(this.valueOf());return b.setDate(b.getDate()+(6-b.getDay())),a.getMonth()===b.getMonth()?!0:a.getMonth()===this.getMonth()&&b.getDate()<4||a.getMonth()!==this.getMonth()&&b.getDate()>=4},Date.prototype.getDayForWeek=function(){var a=new Date(this.valueOf());a.setDate(a.getDate()-a.getDay());var b=new Date(this.valueOf());return b.setDate(b.getDate()+(6-b.getDay())),a.getMonth()===b.getMonth()||a.getMonth()!==b.getMonth()&&b.getDate()>=4?new Date(b.setDate(b.getDate()-3)):new Date(a.setDate(a.getDate()+3))};var h={elementFromPoint:function(){return document.compatMode==="CSS1Compat"?function(a,b){return a-=window.pageXOffset,b-=window.pageYOffset,document.elementFromPoint(a,b)}:function(b,c){return b-=a(document).scrollLeft(),c-=a(document).scrollTop(),document.elementFromPoint(b,c)}}(),create:function(b){typeof f.source!="string"?(b.data=f.source,h.init(b)):a.getJSON(f.source,function(a){b.data=a,h.init(b)})},init:function(a){a.rowsNum=a.data.length,a.pageCount=Math.ceil(a.rowsNum/f.itemsPerPage),a.rowsOnLastPage=a.rowsNum-Math.floor(a.rowsNum/f.itemsPerPage)*f.itemsPerPage,a.dateStart=i.getMinDate(a),a.dateEnd=i.getMaxDate(a),h.waitToggle(a,!0,function(){h.render(a)})},render:function(b){var c=a('<div class="fn-content"/>'),d=h.leftPanel(b);c.append(d);var e=h.rightPanel(b,d),g,i;c.append(e),c.append(h.navigation(b));var j=e.find(".dataPanel");b.gantt=a('<div class="fn-gantt" />').append(c),a(b).empty().append(b.gantt),b.scrollNavigation.panelMargin=parseInt(j.css("margin-left").replace("px",""),10),b.scrollNavigation.panelMaxPos=j.width()-e.width(),b.scrollNavigation.canScroll=j.width()>e.width(),h.markNow(b),h.fillData(b,j,d);if(f.useCookie){var k=a.cookie(this.cookieKey+"ScrollPos");k&&(b.hPosition=k)}f.scrollToToday?(h.navigateTo(b,"now"),h.scrollPanel(b,0)):(b.hPosition!==0&&(b.scaleOldWidth?(g=j.width()-e.width(),i=g*b.hPosition/b.scaleOldWidth,i=i>0?0:i,j.css({"margin-left":i+"px"}),b.scrollNavigation.panelMargin=i,b.hPosition=i,b.scaleOldWidth=null):(j.css({"margin-left":b.hPosition+"px"}),b.scrollNavigation.panelMargin=b.hPosition)),h.repositionLabel(b)),j.css({height:d.height()}),h.waitToggle(b,!1),f.onRender()},leftPanel:function(b){var c=a('<div class="leftPanel"/>').append(a('<div class="row spacer"/>').css("height",i.getCellSize()*b.headerRows+"px").css("width","100%")),d=[];return a.each(b.data,function(a,c){a>=b.pageNum*f.itemsPerPage&&a<b.pageNum*f.itemsPerPage+f.itemsPerPage&&(d.push('<div class="row name row'+a+(c.desc?"":" fn-wide")+'" id="rowheader'+a+'" offset="'+a%f.itemsPerPage*i.getCellSize()+'">'),d.push('<span class="fn-label'+(c.cssClass?" "+c.cssClass:"")+'">'+(c.name||"")+"</span>"),d.push("</div>"),c.desc&&(d.push('<div class="row desc row'+a+' " id="RowdId_'+a+'" data-id="'+c.id+'">'),d.push('<span class="fn-label'+(c.cssClass?" "+c.cssClass:"")+'">'+c.desc+"</span>"),d.push("</div>")))}),c.append(d.join("")),c},dataPanel:function(c,d){var e=a('<div class="dataPanel" style="width: '+d+'px;"/>'),g="onwheel"in c?"wheel":document.onmousewheel!==b?"mousewheel":"DOMMouseScroll";return a(c).on(g,function(a){h.wheelScroll(c,a)}),e.click(function(b){b.stopPropagation();var d,e,g=a(c).find(".fn-gantt .leftPanel"),j=a(c).find(".fn-gantt .dataPanel");switch(f.scale){case"weeks":e=i.getCellSize()*2;break;case"months":e=i.getCellSize();break;case"hours":e=i.getCellSize()*4;break;case"days":e=i.getCellSize()*3;break;default:e=i.getCellSize()*2}var k=h.elementFromPoint(b.pageX,j.offset().top+e);k.className==="fn-label"?k=a(k.parentNode):k=a(k);var l=k.attr("repdate"),m=h.elementFromPoint(g.offset().left+g.width()-10,b.pageY);m.className.indexOf("fn-label")===0?m=a(m.parentNode):m=a(m);var n=m.data().id;f.onAddClick(l,n)}),e},rightPanel:function(b,c){var d=null,e=["sn","wd","wd","wd","wd","wd","sa"],j=['<div class="row"/>'],k=0,l=['<div class="row"/>'],m=0,n=[],o=0,p=[],q=[],r=new Date;r=new Date(r.getFullYear(),r.getMonth(),r.getDate());switch(f.scale){case"hours":d=i.parseTimeRange(b.dateStart,b.dateEnd,b.scaleStep);var s=d[0].getFullYear(),t=d[0].getMonth(),u=d[0];for(var v=0,w=d.length;v<w;v++){var x=d[v],y=x.getFullYear();y!==s&&(j.push('<div class="row header year" style="width: '+i.getCellSize()*k+'px;"><div class="fn-label">'+s+"</div></div>"),s=y,k=0),k++;var z=x.getMonth();z!==t&&(l.push('<div class="row header month" style="width: '+i.getCellSize()*m+'px"><div class="fn-label">'+f.months[t]+"</div></div>"),t=z,m=0),m++;var A=x.getDay(),B=u.getDay(),C=e[A];i.isHoliday(x)&&(C="holiday");if(A!==B){var D=r-u===0?"today":i.isHoliday(u.getTime())?"holiday":e[B];n.push('<div class="row date '+D+'" '+' style="width: '+i.getCellSize()*o+'px;"> '+' <div class="fn-label">'+u.getDate()+"</div></div>"),p.push('<div class="row day '+D+'" '+' style="width: '+i.getCellSize()*o+'px;"> '+' <div class="fn-label">'+f.dow[B]+"</div></div>"),u=x,o=0}o++,q.push('<div class="row day '+C+'" id="dh-'+x.getTime()+'"  offset="'+v*i.getCellSize()+'" repdate="'+x.getRepDate()+'"><div class="fn-label">'+x.getHours()+"</div></div>")}j.push('<div class="row header year" style="width: '+i.getCellSize()*k+'px;"><div class="fn-label">'+s+"</div></div>"),l.push('<div class="row header month" style="width: '+i.getCellSize()*m+'px"><div class="fn-label">'+f.months[t]+"</div></div>");var C=e[u.getDay()];i.isHoliday(u)&&(C="holiday"),n.push('<div class="row date '+C+'" '+' style="width: '+i.getCellSize()*o+'px;"> '+' <div class="fn-label">'+u.getDate()+"</div></div>"),p.push('<div class="row day '+C+'" '+' style="width: '+i.getCellSize()*o+'px;"> '+' <div class="fn-label">'+f.dow[u.getDay()]+"</div></div>");var E=h.dataPanel(b,d.length*i.getCellSize());E.append(j.join("")),E.append(l.join("")),E.append(a('<div class="row"/>').html(n.join(""))),E.append(a('<div class="row"/>').html(p.join(""))),E.append(a('<div class="row"/>').html(q.join("")));break;case"weeks":d=i.parseWeeksRange(b.dateStart,b.dateEnd),j=['<div class="row"/>'],l=['<div class="row"/>'];var s=d[0].getFullYear(),t=d[0].getMonth(),u=d[0];for(var v=0,w=d.length;v<w;v++){var x=d[v];x.getFullYear()!==s&&(j.push('<div class="row header year" style="width: '+i.getCellSize()*k+'px;"><div class="fn-label">'+s+"</div></div>"),s=x.getFullYear(),k=0),k++,x.getMonth()!==t&&(l.push('<div class="row header month" style="width:'+i.getCellSize()*m+'px;"><div class="fn-label">'+f.months[t]+"</div></div>"),t=x.getMonth(),m=0),m++,n.push('<div class="row day wd"  id="'+x.getWeekId()+'" offset="'+v*i.getCellSize()+'" repdate="'+x.getRepDate()+'"> '+' <div class="fn-label">'+x.getWeekOfYear()+"</div></div>")}j.push('<div class="row header year" style="width: '+i.getCellSize()*k+'px;"><div class="fn-label">'+s+"</div></div>"),l.push('<div class="row header month" style="width: '+i.getCellSize()*m+'px"><div class="fn-label">'+f.months[t]+"</div></div>");var E=h.dataPanel(b,d.length*i.getCellSize());E.append(j.join("")+l.join("")+n.join("")+p.join(""));break;case"months":d=i.parseMonthsRange(b.dateStart,b.dateEnd);var s=d[0].getFullYear(),t=d[0].getMonth(),u=d[0];for(var v=0,w=d.length;v<w;v++){var x=d[v];x.getFullYear()!==s&&(j.push('<div class="row header year" style="width: '+i.getCellSize()*k+'px;"><div class="fn-label">'+s+"</div></div>"),s=x.getFullYear(),k=0),k++,l.push('<div class="row day wd" id="dh-'+i.genId(x.getTime())+'" offset="'+v*i.getCellSize()+'" repdate="'+x.getRepDate()+'">'+(1+x.getMonth())+"</div>")}j.push('<div class="row header year" style="width: '+i.getCellSize()*k+'px;"><div class="fn-label">'+s+"</div></div>"),l.push('<div class="row header month" style="width: '+i.getCellSize()*m+'px"><div class="fn-label">'+f.months[t]+"</div></div>");var E=h.dataPanel(b,d.length*i.getCellSize());E.append(j.join("")),E.append(l.join("")),E.append(a('<div class="row"/>').html(n.join(""))),E.append(a('<div class="row"/>').html(p.join("")));break;default:d=i.parseDateRange(b.dateStart,b.dateEnd);var F=g(d[0],-1),s=F.getFullYear(),t=F.getMonth(),u=F;for(var v=0,w=d.length;v<w;v++){var x=d[v];x.getFullYear()!==s&&(j.push('<div class="row header year" style="width:'+i.getCellSize()*k+'px;"><div class="fn-label">'+s+"</div></div>"),s=x.getFullYear(),k=0),k++,x.getMonth()!==t&&(l.push('<div class="row header month" style="width:'+i.getCellSize()*m+'px;"><div class="fn-label">'+f.months[t]+"</div></div>"),t=x.getMonth(),m=0),m++;var B=x.getDay(),C=e[B];i.isHoliday(x)&&(C="holiday"),n.push('<div class="row date '+C+'" '+' id="dh-'+i.genId(x.getTime())+'" offset="'+v*i.getCellSize()+'" repdate="'+x.getRepDate()+'"> '+' <div class="fn-label">'+x.getDate()+"</div></div>"),p.push('<div class="row day '+C+'" '+' id="dw-'+i.genId(x.getTime())+'"  repdate="'+x.getRepDate()+'"> '+' <div class="fn-label">'+f.dow[B]+"</div></div>")}j.push('<div class="row header year" style="width: '+i.getCellSize()*k+'px;"><div class="fn-label">'+s+"</div></div>"),l.push('<div class="row header month" style="width: '+i.getCellSize()*m+'px"><div class="fn-label">'+f.months[t]+"</div></div>");var E=h.dataPanel(b,d.length*i.getCellSize());E.append(j.join("")),E.append(l.join("")),E.append(a('<div class="row" style="margin-left: 0;" />').html(n.join(""))),E.append(a('<div class="row" style="margin-left: 0;" />').html(p.join("")))}return a('<div class="rightPanel"></div>').append(E)},navigation:function(b){var c=null;return f.navigate==="scroll"?(c=a('<div class="navigate" />').append(a('<div class="nav-slider" />').append(a('<div class="nav-slider-left" />').append(a('<button type="button" class="nav-link nav-page-back"/>').html("&lt;").click(function(){h.navigatePage(b,-1)})).append(a('<div class="page-number"/>').append(a("<span/>").html(b.pageNum+1+" / "+b.pageCount))).append(a('<button type="button" class="nav-link nav-page-next"/>').html("&gt;").click(function(){h.navigatePage(b,1)})).append(a('<button type="button" class="nav-link nav-now"/>').html("&#9679;").click(function(){h.navigateTo(b,"now")})).append(a('<button type="button" class="nav-link nav-prev-week"/>').html("&lt;&lt;").click(function(){f.scale==="hours"?h.navigateTo(b,i.getCellSize()*8):f.scale==="days"?h.navigateTo(b,i.getCellSize()*30):f.scale==="weeks"?h.navigateTo(b,i.getCellSize()*12):f.scale==="months"&&h.navigateTo(b,i.getCellSize()*6)})).append(a('<button type="button" class="nav-link nav-prev-day"/>').html("&lt;").click(function(){f.scale==="hours"?h.navigateTo(b,i.getCellSize()*4):f.scale==="days"?h.navigateTo(b,i.getCellSize()*7):f.scale==="weeks"?h.navigateTo(b,i.getCellSize()*4):f.scale==="months"&&h.navigateTo(b,i.getCellSize()*3)}))).append(a('<div class="nav-slider-content" />').append(a('<div class="nav-slider-bar" />').append(a('<a class="nav-slider-button" />')).mousedown(function(a){a.preventDefault(),b.scrollNavigation.scrollerMouseDown=!0,h.sliderScroll(b,a)}).mousemove(function(a){b.scrollNavigation.scrollerMouseDown&&h.sliderScroll(b,a)}))).append(a('<div class="nav-slider-right" />').append(a('<button type="button" class="nav-link nav-next-day"/>').html("&gt;").click(function(){f.scale==="hours"?h.navigateTo(b,i.getCellSize()*-4):f.scale==="days"?h.navigateTo(b,i.getCellSize()*-7):f.scale==="weeks"?h.navigateTo(b,i.getCellSize()*-4):f.scale==="months"&&h.navigateTo(b,i.getCellSize()*-3)})).append(a('<button type="button" class="nav-link nav-next-week"/>').html("&gt;&gt;").click(function(){f.scale==="hours"?h.navigateTo(b,i.getCellSize()*-8):f.scale==="days"?h.navigateTo(b,i.getCellSize()*-30):f.scale==="weeks"?h.navigateTo(b,i.getCellSize()*-12):f.scale==="months"&&h.navigateTo(b,i.getCellSize()*-6)})).append(a('<button type="button" class="nav-link nav-zoomIn"/>').html("&#43;").click(function(){h.zoomInOut(b,-1)})).append(a('<button type="button" class="nav-link nav-zoomOut"/>').html("&#45;").click(function(){h.zoomInOut(b,1)})))),a(document).mouseup(function(){b.scrollNavigation.scrollerMouseDown=!1})):c=a('<div class="navigate" />').append(a('<button type="button" class="nav-link nav-page-back"/>').html("&lt;").click(function(){h.navigatePage(b,-1)})).append(a('<div class="page-number"/>').append(a("<span/>").html(b.pageNum+1+" of "+b.pageCount))).append(a('<button type="button" class="nav-link nav-page-next"/>').html("&gt;").click(function(){h.navigatePage(b,1)})).append(a('<button type="button" class="nav-link nav-begin"/>').html("&#124;&lt;").click(function(){h.navigateTo(b,"begin")})).append(a('<button type="button" class="nav-link nav-prev-week"/>').html("&lt;&lt;").click(function(){h.navigateTo(b,i.getCellSize()*7)})).append(a('<button type="button" class="nav-link nav-prev-day"/>').html("&lt;").click(function(){h.navigateTo(b,i.getCellSize())})).append(a('<button type="button" class="nav-link nav-now"/>').html("&#9679;").click(function(){h.navigateTo(b,"now")})).append(a('<button type="button" class="nav-link nav-next-day"/>').html("&gt;").click(function(){h.navigateTo(b,i.getCellSize()*-1)})).append(a('<button type="button" class="nav-link nav-next-week"/>').html("&gt;&gt;").click(function(){h.navigateTo(b,i.getCellSize()*-7)})).append(a('<button type="button" class="nav-link nav-end"/>').html("&gt;&#124;").click(function(){h.navigateTo(b,"end")})).append(a('<button type="button" class="nav-link nav-zoomIn"/>').html("&#43;").click(function(){h.zoomInOut(b,-1)})).append(a('<button type="button" class="nav-link nav-zoomOut"/>').html("&#45;").click(function(){h.zoomInOut(b,1)})),a('<div class="bottom"/>').append(c)},createProgressBar:function(b,c,d,e,g){var h=i.getCellSize(),j=i.getProgressBarMargin()||0,k=a('<div class="bar"><div class="fn-label">'+e+"</div></div>").addClass(c).css({width:h*b-j+2}).data("dataObj",g);return d&&k.mouseover(function(b){var c=a('<div class="fn-gantt-hint" />').html(d);a("body").append(c),c.css("left",b.pageX),c.css("top",b.pageY),c.show()}).mouseout(function(){a(".fn-gantt-hint").remove()}).mousemove(function(b){a(".fn-gantt-hint").css("left",b.pageX),a(".fn-gantt-hint").css("top",b.pageY+15)}),k.click(function(b){b.stopPropagation(),f.onItemClick(a(this).data("dataObj"))}),k},markNow:function(b){switch(f.scale){case"weeks":var c=Date.parse(new Date);c=Math.floor(c/364e5)*364e5,a(b).find(':findweek("'+c+'")').removeClass("wd").addClass("today");break;case"months":a(b).find(':findmonth("'+(new Date).getTime()+'")').removeClass("wd").addClass("today");break;default:var c=Date.parse(new Date);c=Math.floor(c/364e5)*364e5,a(b).find(':findday("'+c+'")').removeClass("wd").addClass("today")}},fillData:function(b,c,d){var e=function(a){try{a=a.replace("rgb(","").replace(")","");var b=a.split(","),c=parseInt(b[0],10),d=parseInt(b[1],10),e=parseInt(b[2],10),f=Math.round((255-(.299*c+.587*d+.114*e))*.9);return"rgb("+f+", "+f+", "+f+")"}catch(g){return""}};a.each(b.data,function(d,g){d>=b.pageNum*f.itemsPerPage&&d<b.pageNum*f.itemsPerPage+f.itemsPerPage&&a.each(g.values,function(g,j){var k=null;switch(f.scale){case"hours":var l=i.genId(i.dateDeserialize(j.from).getTime(),b.scaleStep),m=a(b).find("#dh-"+l),n=i.genId(i.dateDeserialize(j.to).getTime(),b.scaleStep),o=a(b).find("#dh-"+n),p=m.attr("offset"),q=o.attr("offset"),r=Math.floor((q-p)/i.getCellSize())+1;k=h.createProgressBar(r,j.customClass?j.customClass:"",j.desc?j.desc:"",j.label?j.label:"",j.dataObj?j.dataObj:null);var s=a(b).find("#rowheader"+d),t=i.getCellSize()*5+2+parseInt(s.attr("offset"),10);k.css({top:t,left:Math.floor(p)}),c.append(k);break;case"weeks":var u=i.dateDeserialize(j.from),v=i.dateDeserialize(j.to);u.getDate()<=3&&u.getMonth()===0&&u.setDate(u.getDate()+4),u.getDate()<=3&&u.getMonth()===0&&u.setDate(u.getDate()+4),v.getDate()<=3&&v.getMonth()===0&&v.setDate(v.getDate()+4);var m=a(b).find("#"+u.getWeekId()),p=m.attr("offset"),o=a(b).find("#"+v.getWeekId()),q=o.attr("offset"),r=Math.round((q-p)/i.getCellSize())+1;k=h.createProgressBar(r,j.customClass?j.customClass:"",j.desc?j.desc:"",j.label?j.label:"",j.dataObj?j.dataObj:null);var s=a(b).find("#rowheader"+d),t=i.getCellSize()*3+2+parseInt(s.attr("offset"),10);k.css({top:t,left:Math.floor(p)}),c.append(k);break;case"months":var u=i.dateDeserialize(j.from),v=i.dateDeserialize(j.to);u.getDate()<=3&&u.getMonth()===0&&u.setDate(u.getDate()+4),u.getDate()<=3&&u.getMonth()===0&&u.setDate(u.getDate()+4),v.getDate()<=3&&v.getMonth()===0&&v.setDate(v.getDate()+4);var m=a(b).find("#dh-"+i.genId(u.getTime())),p=m.attr("offset"),o=a(b).find("#dh-"+i.genId(v.getTime())),q=o.attr("offset"),r=Math.round((q-p)/i.getCellSize())+1;k=h.createProgressBar(r,j.customClass?j.customClass:"",j.desc?j.desc:"",j.label?j.label:"",j.dataObj?j.dataObj:null);var s=a(b).find("#rowheader"+d),t=i.getCellSize()*2+2+parseInt(s.attr("offset"),10);k.css({top:t,left:Math.floor(p)}),c.append(k);break;default:var l=i.genId(i.dateDeserialize(j.from).getTime()),n=i.genId(i.dateDeserialize(j.to).getTime()),m=a(b).find("#dh-"+l),p=m.attr("offset"),r=Math.floor((n/1e3-l/1e3)/86400)+1;k=h.createProgressBar(r,j.customClass?j.customClass:"",j.desc?j.desc:"",j.label?j.label:"",j.dataObj?j.dataObj:null);var s=a(b).find("#rowheader"+d),t=i.getCellSize()*4+2+parseInt(s.attr("offset"),10);k.css({top:t,left:Math.floor(p)}),c.append(k)}var w=k.find(".fn-label");if(w&&k.length){var x=e(k[0].style.backgroundColor);w.css("color",x)}else w&&w.css("color","")})})},navigateTo:function(b,c){var d=a(b).find(".fn-gantt .rightPanel"),e=d.find(".dataPanel"),f=d.width(),g=e.width(),i=function(){h.repositionLabel(b)};switch(c){case"begin":e.animate({"margin-left":"0px"},"fast",i),b.scrollNavigation.panelMargin=0;break;case"end":var j=g-f;b.scrollNavigation.panelMargin=j*-1,e.animate({"margin-left":"-"+j+"px"},"fast",i);break;case"now":if(!b.scrollNavigation.canScroll||!e.find(".today").length)return!1;var k=(g-f)*-1,l=e.css("margin-left").replace("px",""),c=e.find(".today").offset().left-e.offset().left;c*=-1,c>0?c=0:c<k&&(c=k),e.animate({"margin-left":c+"px"},"fast",i),b.scrollNavigation.panelMargin=c;break;default:var k=(g-f)*-1,l=e.css("margin-left").replace("px",""),c=parseInt(l,10)+c;c<=0&&c>=k&&e.animate({"margin-left":c+"px"},"fast",i),b.scrollNavigation.panelMargin=c}h.synchronizeScroller(b)},navigatePage:function(b,c){b.pageNum+c>=0&&b.pageNum+c<Math.ceil(b.rowsNum/f.itemsPerPage)&&h.waitToggle(b,!0,function(){b.pageNum+=c,b.hPosition=a(".fn-gantt .dataPanel").css("margin-left").replace("px",""),b.scaleOldWidth=!1,h.init(b)})},zoomInOut:function(b,c){h.waitToggle(b,!0,function(){var d=c<0,g=b.scaleStep+c*3;g=g<=1?1:g===4?3:g;var i=f.scale,j=b.headerRows;f.scale==="hours"&&g>=13?(i="days",j=4,g=13):f.scale==="days"&&d?(i="hours",j=5,g=12):f.scale==="days"&&!d?(i="weeks",j=3,g=13):f.scale==="weeks"&&!d?(i="months",j=2,g=14):f.scale==="weeks"&&d?(i="days",j=4,g=13):f.scale==="months"&&d&&(i="weeks",j=3,g=13);if(d&&a.inArray(i,e)<a.inArray(f.minScale,e)||!d&&a.inArray(i,e)>a.inArray(f.maxScale,e)){h.init(b);return}b.scaleStep=g,f.scale=i,b.headerRows=j;var k=a(b).find(".fn-gantt .rightPanel"),l=k.find(".dataPanel");b.hPosition=l.css("margin-left").replace("px",""),b.scaleOldWidth=l.width()-k.width(),f.useCookie&&(a.cookie(this.cookieKey+"CurrentScale",f.scale),a.cookie(this.cookieKey+"ScrollPos",null)),h.init(b)})},mouseScroll:function(b,c){var d=a(b).find(".fn-gantt .dataPanel");d.css("cursor","move");var e=d.offset(),f=b.scrollNavigation.mouseX===null?c.pageX:b.scrollNavigation.mouseX,g=c.pageX-f;b.scrollNavigation.mouseX=c.pageX,h.scrollPanel(b,g),clearTimeout(b.scrollNavigation.repositionDelay),b.scrollNavigation.repositionDelay=setTimeout(h.repositionLabel,50,b)},wheelScroll:function(a,b){b.preventDefault();var c="detail"in b?b.detail:"wheelDelta"in b.originalEvent?-1/120*b.originalEvent.wheelDelta:b.originalEvent.deltaY?b.originalEvent.deltaY/Math.abs(b.originalEvent.deltaY):b.originalEvent.detail;h.scrollPanel(a,-50*c),clearTimeout(a.scrollNavigation.repositionDelay),a.scrollNavigation.repositionDelay=setTimeout(h.repositionLabel,50,a)},sliderScroll:function(b,c){var d=a(b).find(".nav-slider-bar"),e=d.find(".nav-slider-button"),f=a(b).find(".fn-gantt .rightPanel"),g=f.find(".dataPanel"),i=d.offset(),j=d.width(),k=e.width(),l,m;if(c.pageX>=i.left&&c.pageX<=i.left+j){l=c.pageX-i.left,l-=k/2,e.css("left",l),m=g.width()-f.width();var n=l*m/j*-1;n>=0?(g.css("margin-left","0px"),b.scrollNavigation.panelMargin=0):l>=j-k*1?(g.css("margin-left",m*-1+"px"),b.scrollNavigation.panelMargin=m*-1):(g.css("margin-left",n+"px"),b.scrollNavigation.panelMargin=n),clearTimeout(b.scrollNavigation.repositionDelay),b.scrollNavigation.repositionDelay=setTimeout(h.repositionLabel,5,b)}},scrollPanel:function(b,c){if(!b.scrollNavigation.canScroll)return!1;var d=parseInt(b.scrollNavigation.panelMargin,10)+c;d>0?(b.scrollNavigation.panelMargin=0,a(b).find(".fn-gantt .dataPanel").css("margin-left",b.scrollNavigation.panelMargin+"px")):d<b.scrollNavigation.panelMaxPos*-1?(b.scrollNavigation.panelMargin=b.scrollNavigation.panelMaxPos*-1,a(b).find(".fn-gantt .dataPanel").css("margin-left",b.scrollNavigation.panelMargin+"px")):(b.scrollNavigation.panelMargin=d,a(b).find(".fn-gantt .dataPanel").css("margin-left",b.scrollNavigation.panelMargin+"px")),h.synchronizeScroller(b)},synchronizeScroller:function(b){if(f.navigate==="scroll"){var c=a(b).find(".fn-gantt .rightPanel"),d=c.find(".dataPanel"),e=a(b).find(".nav-slider-bar"),g=e.find(".nav-slider-button"),h=e.width(),i=g.width(),j=d.width()-c.width(),k=0;d.css("margin-left")&&(k=d.css("margin-left").replace("px",""));var l=k*h/j-g.width()*.25;l=l>0?0:l*-1>=h-i*.75?(h-i*1.25)*-1:l,g.css("left",l*-1)}},repositionLabel:function(b){setTimeout(function(){var c;if(!b)c=a(".fn-gantt .rightPanel .dataPanel");else{var d=a(b).find(".fn-gantt .rightPanel");c=d.find(".dataPanel")}f.useCookie&&a.cookie(this.cookieKey+"ScrollPos",c.css("margin-left").replace("px",""))},500)},waitToggle:function(b,c,d){if(c){var e=a(b).offset(),g=a(b).outerWidth(),h=a(b).outerHeight();b.loader||(b.loader=a('<div class="fn-gantt-loader"><div class="fn-gantt-loader-spinner"><span>'+f.waitText+"</span></div></div>")),a(b).append(b.loader),setTimeout(d,500)}else b.loader&&b.loader.detach()}},i={getMaxDate:function(b){var c=null;a.each(b.data,function(b,d){a.each(d.values,function(a,b){c=c<i.dateDeserialize(b.to)?i.dateDeserialize(b.to):c})}),c=c||new Date;switch(f.scale){case"hours":c.setHours(Math.ceil(c.getHours()/b.scaleStep)*b.scaleStep),c.setHours(c.getHours()+b.scaleStep*3);break;case"weeks":var d=new Date(c.getTime()),d=new Date(d.setDate(d.getDate()+21)),e=Math.floor(d.getDate()/7)*7;c=new Date(d.getFullYear(),d.getMonth(),e===0?4:e-3);break;case"months":var d=new Date(c.getFullYear(),c.getMonth(),1);d.setMonth(d.getMonth()+2),c=new Date(d.getFullYear(),d.getMonth(),1);break;default:c.setHours(0),c.setDate(c.getDate()+3)}return c},getMinDate:function(b){var c=null;a.each(b.data,function(b,d){a.each(d.values,function(a,b){c=c>i.dateDeserialize(b.from)||c===null?i.dateDeserialize(b.from):c})}),c=c||new Date;switch(f.scale){case"hours":c.setHours(Math.floor(c.getHours()/b.scaleStep)*b.scaleStep),c.setHours(c.getHours()-b.scaleStep*3);break;case"weeks":var d=new Date(c.getTime()),d=new Date(d.setDate(d.getDate()-21)),e=Math.floor(d.getDate()/7)*7;c=new Date(d.getFullYear(),d.getMonth(),e===0?4:e-3);break;case"months":var d=new Date(c.getFullYear(),c.getMonth(),1);d.setMonth(d.getMonth()-3),c=new Date(d.getFullYear(),d.getMonth(),1);break;default:c.setHours(0),c.setDate(c.getDate()-3)}return c},parseDateRange:function(a,b){var c=new Date(a.getTime()),d=new Date(b.getTime()),e=[],f=0;do e[f++]=new Date(c.getTime()),c.setDate(c.getDate()+1);while(c.getTime()<=b.getTime());return e},parseTimeRange:function(a,b,c){var d=new Date(a),e=new Date(b);d.setMilliseconds(0),d.setSeconds(0),d.setMinutes(0),d.setHours(0),e.setMilliseconds(0),e.setSeconds(0);if(e.getMinutes()>0||e.getHours()>0)e.setMinutes(0),e.setHours(0),e.setTime(e.getTime()+864e5);var f=[],h=0;for(;;){var i=new Date(d);i.setHours(Math.floor(d.getHours()/c)*c),f[h]&&i.getDay()!==f[h].getDay()&&i.setHours(0),f[h]=i;if(d.getTime()>b.getTime())break;d=g(i,c),h++}return f},parseWeeksRange:function(a,b){var c=new Date(a),d=new Date(b),e=[],f=0;do c.getDay()===0&&(e[f++]=c.getDayForWeek()),c.setDate(c.getDate()+1);while(c.getTime()<=b.getTime());return e},parseMonthsRange:function(a,b){var c=new Date(a),d=new Date(b),e=[],f=0;do e[f++]=new Date(c.getFullYear(),c.getMonth(),1),c.setMonth(c.getMonth()+1);while(c.getTime()<=b.getTime());return e},dateDeserialize:function(b){return typeof b=="string"&&(b=b.replace(/\/Date\((.*)\)\//,"$1"),b=a.isNumeric(b)?parseInt(b,10):a.trim(b)),new Date(b)},genId:function(a){var b=new Date(a);switch(f.scale){case"hours":var c=b.getHours();return arguments.length>=2&&(c=Math.floor(b.getHours()/arguments[1])*arguments[1]),(new Date(b.getFullYear(),b.getMonth(),b.getDate(),c)).getTime();case"weeks":var d=b.getFullYear(),e=b.getDayForWeek().getWeekOfYear(),g=b.getMonth();return g===11&&e===1&&d++,d+"-"+e;case"months":return b.getFullYear()+"-"+b.getMonth();default:return(new Date(b.getFullYear(),b.getMonth(),b.getDate())).getTime()}},_datesToDays:function(a){var b={};for(var c=0,d=a.length,e;c<d;c++)e=i.dateDeserialize(a[c]),b[e.setHours(0,0,0,0)]=!0;return b},isHoliday:function(){if(!f.holidays)return function(){return!1};var b=!1;return function(c){return b||(b=i._datesToDays(f.holidays)),!!b[a.isNumeric(c)?c:(new Date(c.getFullYear(),c.getMonth(),c.getDate())).getTime()]}}(),_getCellSize:null,getCellSize:function(){return i._getCellSize||(a("body").append(a('<div style="display: none; position: absolute;" class="fn-gantt" id="measureCellWidth"><div class="row"></div></div>')),i._getCellSize=a("#measureCellWidth .row").height(),a("#measureCellWidth").empty().remove()),i._getCellSize},getRightPanelSize:function(){a("body").append(a('<div style="display: none; position: absolute;" class="fn-gantt" id="measureCellWidth"><div class="rightPanel"></div></div>'));var b=a("#measureCellWidth .rightPanel").height();return a("#measureCellWidth").empty().remove(),b},getPageHeight:function(a){return a.pageNum+1===a.pageCount?a.rowsOnLastPage*i.getCellSize():f.itemsPerPage*i.getCellSize()},_getProgressBarMargin:null,getProgressBarMargin:function(){return!i._getProgressBarMargin&&i._getProgressBarMargin!==0&&(a("body").append(a('<div style="display: none; position: absolute;" id="measureBarWidth" ><div class="fn-gantt"><div class="rightPanel"><div class="dataPanel"><div class="row day"><div class="bar" /></div></div></div></div></div>')),i._getProgressBarMargin=parseInt(a("#measureBarWidth .fn-gantt .rightPanel .day .bar").css("margin-left").replace("px",""),10),i._getProgressBarMargin+=parseInt(a("#measureBarWidth .fn-gantt .rightPanel .day .bar").css("margin-right").replace("px",""),10),a("#measureBarWidth").empty().remove()),i._getProgressBarMargin}};this.each(function(){this.data=null,this.pageNum=0,this.pageCount=0,this.rowsOnLastPage=0,this.rowsNum=0,this.hPosition=0,this.dateStart=null,this.dateEnd=null,this.scrollClicked=!1,this.scaleOldWidth=null,this.headerRows=null;if(f.useCookie){var b=a.cookie(this.cookieKey+"CurrentScale");b?f.scale=a.cookie(this.cookieKey+"CurrentScale"):a.cookie(this.cookieKey+"CurrentScale",f.scale)}switch(f.scale){case"hours":this.headerRows=5,this.scaleStep=1;break;case"weeks":this.headerRows=3,this.scaleStep=13;break;case"months":this.headerRows=2,this.scaleStep=14;break;default:this.headerRows=4,this.scaleStep=13}this.scrollNavigation={panelMouseDown:!1,scrollerMouseDown:!1,mouseX:null,panelMargin:0,repositionDelay:0,panelMaxPos:0,canScroll:!0},this.gantt=null,this.loader=null,h.create(this)})}})(jQuery);