var _inventoryContainer = $("#inventory-container");
var _inventoryWrapper = $("#inventory-container #inventory-wrapper");
var _inventoryMessage = $("#inventory-container #inventory-message");
var _itemConfiguracaoContainer = $("#ic-container");
var _itemConfiguracaoViewContainer = $("#ic-container .ic-view");
var _itemConfiguracaoControllerContainer = $("#ic-container .ic-controller");
var _filtersContainer = $("#filters-container");
var _actionsContainer = $("#actions-container");
var _breadcrumb = $(".breadcrumb");
var _inventoryItensLoading = false;
var _inventoryItensDone = false;

var _inventoryAcessoGravar = false;
var _inventoryAcessoDeletar = false;

var _statusInventoryWrapper = $("#status-inventory-wrapper");
var _statusInventoryMessage = $("#status-inventory-message");
var _statusInventoryItensLoading = false;
var _statusInventoryPreviousScroll = 0;

(function(window, document, undefined) {
	$('#grupoCorFundoPicker').farbtastic('#grupoCorFundo');
	$('#grupoCorTextoPicker').farbtastic('#grupoCorTexto');
	$('.mask-moeda').mask("#.##0,00", {reverse: true});
})(this, document);

$(document).ready(function() {
	$('#informacoesAdicionais').keyup(function(){
		if($(this).val().length > 4000){
			$(this).val($(this).val().substr(0, 4000));
		}
	});
	
	setTimeout(function() {
		$(".tabs-view li[data-ref='inventory']").attr("onclick", "StatusInventory.Monitoring.stop();");
		$(".tabs-view li[data-ref='status']").attr("onclick", "StatusInventory.load();");
		
		$(".tabs-view li").on("click", function() {
			if (!$(this).hasClass("active")) {
				var _ref = $(this).attr("data-ref");
				
				$(".tabs-view li").removeClass("active");
				$(this).addClass("active");
				
				$("div.tab-view.open").fadeOut(100, function() {
					$("div.tab-view").removeClass("open");
					
					$("div[data-view='" + _ref + "']").addClass("open");
					$("div[data-view='" + _ref + "']").fadeIn();
				});
			}
		});
	}, 1000);
});

/**
 * Métodos para controle do inventário.
 */
var Inventory = {
	Widget : {
		// TODO Método de teste para adicionar elementos do inventário, melhorar
		// código e fazer carregamento por demanda (conforme faz scroll carrega
		// mais itens) de itens para ficar mais leve
		add : function(data, replace) {
			if (data.hasOwnProperty("widgets") && data.widgets.length > 0) {
				if (replace == true) {
					_inventoryWrapper.html($("<div class='row-fluid'></div>"));
				}
				
				var quantidade = 0;
				for ( var widgetKey in data.widgets) {
					if (data.widgets.hasOwnProperty(widgetKey)) {
						var template = $("#inventory-widget-template").html();

						if (_inventoryWrapper.children(".row-fluid").last().children(".inventory-widget").size() == 6) {
							_inventoryWrapper.append($("<div class='separator'></div><div class='row-fluid'></div>"));
						}

						for ( var widgetElementKey in data.widgets[widgetKey]) {
							template = template.replace(new RegExp("{{" + widgetElementKey + "}}", 'g'), data.widgets[widgetKey][widgetElementKey]);
						}
						
						//TODO Se encontrou alguma chave que não substituida, remove. (Melhorar).
						template = template.replace(new RegExp("{{nome}}|{{id}}|{{tipo}}|{{icone}}|{{quantidadeRelacionados}}|{{extra}}", 'g'), "");
						
						_inventoryWrapper.children(".row-fluid").last().append(template);
						
						if (data.widgets[widgetKey].hasOwnProperty("id")) {
							var _theWidget = $(".inventory-widget a.widget-stats[data-id='" + data.widgets[widgetKey]["id"] + "']");
							
							if (data.widgets[widgetKey].hasOwnProperty("corFundo")) {
								_theWidget.css({ "background-color" : "" + data.widgets[widgetKey]["corFundo"] + "" });
								_theWidget.css({ "background-image" : "initial" });
							}
							
							if (data.widgets[widgetKey].hasOwnProperty("corTexto")) {
								_theWidget.children(".material-icons").css({ "color" : "" + data.widgets[widgetKey]["corTexto"] + "" });
								_theWidget.children(".txt").css({ "color" : "" + data.widgets[widgetKey]["corTexto"] + "" });
							}
						}
						
						if (data.widgets[widgetKey].hasOwnProperty("tipo")) {
							if (data.widgets[widgetKey]["tipo"] == "IC") {
								quantidade++;
							}
						}
					}
				}
				
				var _elementQuantidade = $("#formGerenciamentoItemConfiguracao #controllerQuantidadeItemConfiguracaoInventario");
				_elementQuantidade.attr("value", parseInt(_elementQuantidade.attr("value")) + quantidade);
				
				_inventoryMessage.fadeOut("fast", function() {
					_inventoryWrapper.fadeIn("fast");
				});
			} else {
				if (replace == true) {
					_inventoryMessage.fadeOut("fast", function() {
							_inventoryMessage.html(i18n_message("gerenciamentoitemconfiguracao.nenhumitemencontrado"));
							_inventoryMessage.fadeIn("fast");
					});
				}
			}

		},
		next : function(_element) {
			$('#formGerenciamentoItemConfiguracao #controllerIdGrupo').attr("value", _element.attr("data-id"));
			$('#formGerenciamentoItemConfiguracao #controllerQuantidadeItemConfiguracaoInventario').attr("value", "0");
			_inventoryItensDone = false;

			_inventoryWrapper.fadeOut(function() {
				_inventoryMessage.html("<div class=\"carregando\"></div>");
				_inventoryMessage.fadeIn();

				_breadcrumb.children(".breadcrumb-item").addClass("clickable").removeClass("active");
				_breadcrumb.append("<li class='divider'></li><li class='breadcrumb-item active' data-id='" + _element.attr("data-id") + "'>" + _element.children(".txt").text() + "</li>");

				document.formGerenciamentoItemConfiguracao.fireEvent('inventoryNavigate');
			});
			
			return false;
		},
		previous : function(_element) {
			if (_element == undefined || _element == "") {
				_breadcrumb.find(".breadcrumb-item.clickable").last().trigger("click");
			} else {
				$('#formGerenciamentoItemConfiguracao #controllerIdGrupo').attr("value", _element.attr("data-id"));
				$('#formGerenciamentoItemConfiguracao #controllerQuantidadeItemConfiguracaoInventario').attr("value", "0");
				_inventoryItensDone = false;

				_inventoryWrapper.fadeOut("fast", function() {
					_inventoryMessage.html("<div class=\"carregando\"></div>");
					_inventoryMessage.fadeIn("fast");

					_element.nextAll().remove();
					_element.addClass("active").removeClass("clickable");

					if (_element.attr("data-id") == "") {
						document.formGerenciamentoItemConfiguracao.fireEvent('inventoryStart');
					} else {
						document.formGerenciamentoItemConfiguracao.fireEvent('inventoryNavigate');
					}
				});
			}

			return false;
		},
		search : function(){
			_inventoryWrapper.fadeOut("fast", function() {
				_inventoryMessage.html("<div class=\"carregando\"></div>");
				_inventoryMessage.fadeIn("fast");
				
				if($('#filtroHierarquia').attr('checked') !== 'checked') {
					_breadcrumb.html('<li class="breadcrumb-item active" data-id="">Início</li>');
					$('#formGerenciamentoItemConfiguracao #controllerIdGrupo').attr("value", "");
				}
				
				if (_inventoryContainer.filter(".widget").attr("data-collapse-closed") == "true") {
					_inventoryContainer.find(".widget-body").collapse("show");
				}

				$('#formGerenciamentoItemConfiguracao #controllerQuantidadeItemConfiguracaoInventario').attr("value", "0");
				_inventoryItensDone = false;
				
				document.formGerenciamentoItemConfiguracao.fireEvent('filtraListagem');
			});
		},
		refresh : function(){
			_inventoryWrapper.fadeOut(function() {
				_inventoryMessage.html("<div class=\"carregando\"></div>");
				_inventoryMessage.fadeIn();
				
				$('#formGerenciamentoItemConfiguracao #controllerQuantidadeItemConfiguracaoInventario').attr("value", "0");

				if ($('#formGerenciamentoItemConfiguracao #controllerIdGrupo').attr("value") == "") {
					document.formGerenciamentoItemConfiguracao.fireEvent('inventoryStart');
				} else {
					document.formGerenciamentoItemConfiguracao.fireEvent('inventoryNavigate');
				}
			});
		}
	}
}

/**
 * Métodos para controle do status do inventário.
 */
var monitoringTimeout;
var monitoringTime = 10000;

var StatusInventory = {
	Widget : {
		add : function(data, replace) {
			if (data.hasOwnProperty("widgets") && data.widgets.length > 0) {
				if (replace == true) {
					_statusInventoryWrapper.html($("<div class='row-fluid'></div>"));
				}
				
				var quantidade = 0;
				for ( var widgetKey in data.widgets) {
					if (data.widgets.hasOwnProperty(widgetKey)) {
						var template = $("#status-inventory-widget-template").html();

						if (_statusInventoryWrapper.children(".row-fluid").last().children(".status-inventory-widget").size() == 6) {
							_statusInventoryWrapper.append($("<div class='separator'></div><div class='row-fluid'></div>"));
						}

						for ( var widgetElementKey in data.widgets[widgetKey]) {
							template = template.replace(new RegExp("{{" + widgetElementKey + "}}", 'g'), data.widgets[widgetKey][widgetElementKey]);
						}
						
						//TODO Se encontrou alguma chave que não substituida, remove. (Melhorar).
						template = template.replace(new RegExp("{{nome}}|{{id}}|{{tipo}}|{{icone}}|{{quantidadeRelacionados}}|{{extra}}", 'g'), "");
						
						_statusInventoryWrapper.children(".row-fluid").last().append(template);
						
						quantidade++;
					}
				}
				
				var _elementQuantidade = $("#formGerenciamentoItemConfiguracao #controllerQuantidadeItemConfiguracaoStatusInventario");
				_elementQuantidade.attr("value", quantidade);

				_statusInventoryMessage.fadeOut("fast", function() {
					_statusInventoryWrapper.fadeIn("fast");
				});
			} else {
				if (replace == true) {
					_statusInventoryWrapper.fadeOut("fast", function() {
						_statusInventoryMessage.html(i18n_message("gerenciamentoitemconfiguracao.nenhumitemencontrado"));
						_statusInventoryMessage.fadeIn("fast");
					});
				}
			}
		}
	},
	Monitoring : {
		begin : function() {
			monitoringTimeout = setTimeout(StatusInventory.Monitoring.run, monitoringTime);
		},
		run : function() {
			document.formGerenciamentoItemConfiguracao.fireEvent('monitoringStatusInventory');
		},
		stop : function() {
			clearTimeout(monitoringTimeout);
		}
	},
	load : function() {
		$("#formGerenciamentoItemConfiguracao #controllerQuantidadeItemConfiguracaoStatusInventario").attr("value", 0);
		
		document.formGerenciamentoItemConfiguracao.fireEvent('loadStatusInventory');
	},
	filter : function() {
		_statusInventoryWrapper.fadeOut(function() {
			$("#formGerenciamentoItemConfiguracao #controllerQuantidadeItemConfiguracaoStatusInventario").attr("value", 0);

			_statusInventoryMessage.html("<div class=\"carregando\"></div>");
			_statusInventoryMessage.fadeIn();
			
			document.formGerenciamentoItemConfiguracao.fireEvent('filterStatusInventory');
		});
	},
	clear : function() {
		$("#filtroStatusInventarioConfiguracaoInventory").prop("selectedIndex", 0);
		$("#filtroStatusInventarioIdentificacao").attr("value", "");
		$("#filtroStatusInventarioIP").attr("value", "");
		$("#filtroStatusInventarioStatus").prop("selectedIndex", 0);
		
		StatusInventory.filter();
	},
	force : {
		run : function(_this) {
			var _widget = $(_this).parents(".status-inventory-widget");
			var idStatusInventario = _widget.attr("data-id");
			
			StatusInventory.Monitoring.stop();
			
			if (!_widget.find(".status").hasClass("label-primary")) {
				_widget.find(".status").addClass("label-primary")
			}
			_widget.find(".status").html(i18n_message("citcorpore.comum.emExecucao"));
			
			_widget.find(".btn-force-inventory").fadeOut(100, function() {
				$(this).html("<div class=\"carregando-infinito\"></div>");
				
				_widget.find(".btn-force-inventory").fadeIn();
				
				$("#idStatusInventario").attr("value", idStatusInventario);
				document.formGerenciamentoItemConfiguracao.fireEvent('forcaInventario');
			});
			
		},
		callback : function(idStatusInventario, idStatus) {
			var _widget = $(".status-inventory-widget[data-id='" + idStatusInventario + "']");
			
			if (idStatus == 1 || idStatus == 4) {
				if (!_widget.find(".status").hasClass("label-primary")) {
					_widget.find(".status").addClass("label-primary");
				}
			} else {
				_widget.find(".status").removeClass("label-primary");
			}
			
			var status = "";
			switch (idStatus) {
			case 1:
				status = i18n_message("inventario.status.inventariada")
				break;
			case 2:
				status = i18n_message("inventario.status.ignorada")
				break;
			case 3:
				status = i18n_message("inventario.status.inacessivel")
				break;
			case 4:
				status = i18n_message("citcorpore.comum.emExecucao")
				break;
			default:
				break;
			}
			
			_widget.find(".status").html(status);
			
			_widget.find(".btn-force-inventory").fadeOut(100, function() {
				$(this).html("<span class='label pointer' onclick='StatusInventory.force.run(this); return false;'>" + i18n_message("evm.statusinventory.inventariarAgora") + "</span>");
				_widget.find(".btn-force-inventory").fadeIn();
			});
			
			StatusInventory.Monitoring.begin();
		}
	},
	view : function(idItemConfiguracao) {
		_itemConfiguracaoContainer.attr("data-reference", idItemConfiguracao);
		$('#formGerenciamentoItemConfiguracao #idItemConfiguracao').attr("value", idItemConfiguracao);
		
		_itemConfiguracaoViewContainer.find("#ic-identificacao").attr("value", "");
		_itemConfiguracaoViewContainer.find("#ic-destaque-caracteristicas-1").html("");
		_itemConfiguracaoViewContainer.find("#ic-destaque-caracteristicas-2").html("");
		_itemConfiguracaoViewContainer.find("#ic-destaque-caracteristicas-3").html("");
		_itemConfiguracaoViewContainer.find("#ic-destaque-caracteristicas-4").html("");
		_itemConfiguracaoViewContainer.find("#ic-destaque-caracteristicas-5").html("");
		_itemConfiguracaoViewContainer.find("#ic-destaque-caracteristicas-6").html("");
		
		_itemConfiguracaoViewContainer.find(".ic-tabs .tab-content .tab-pane[data-load='true']").html("");
		_itemConfiguracaoViewContainer.find(".ic-tabs .tab-content .tab-pane[data-load='true']").attr("data-loaded", "false");
		
		_itemConfiguracaoViewContainer.find(".ic-tabs li [href='#tab-informacoes-gerais']").trigger("click"); //Carrega a aba de informações gerais.
		
		if (_filtersContainer.filter(".widget").attr("data-collapse-closed") == "false") {
			_filtersContainer.find(".widget-body").collapse("hide");
		}
		
		if (_actionsContainer.filter(".widget").attr("data-collapse-closed") == "false") {
			_actionsContainer.find(".widget-body").collapse("hide");
		}
		
		$("#eventos-content").html("");
		$("#financeiro-content").html("");
		
		try {
			document.formGerenciamentoItemConfiguracao.fireEvent('preencheTabelaIndicadoresCapacidadeIC');
			document.formGerenciamentoItemConfiguracao.fireEvent('preencheTabelaAtributoDemandaIC');
			document.formGerenciamentoItemConfiguracao.fireEvent('restauraAcordoNivelServicoIC');
			document.formGerenciamentoItemConfiguracao.fireEvent('restauraCalendarioIC');
			document.formGerenciamentoItemConfiguracao.fireEvent('itemConfiguracaoAbrir');
		} catch (e) {
			// TODO: handle exception
		}
		
		$(".tabs-view li[data-ref='inventory']").trigger("click");
	}
}

/**
 * Métodos para controle do item de configuração. (visualização, criação, edição)
 */
var ItemConfiguracao = {
	View : {
		open : function(_element) {
			if (_element != undefined && _element != null) {
				if (_element.attr("data-id") != undefined && _element.attr("data-id") != "") {
					_itemConfiguracaoContainer.attr("data-reference", _element.attr("data-id"));
					$('#formGerenciamentoItemConfiguracao #idItemConfiguracao').attr("value", _element.attr("data-id"));
					
					ItemConfiguracao.View.Loading.open(_element);
				} else if (_element.attr("data-relation") != undefined && _element.attr("data-relation") != "") {
					_itemConfiguracaoContainer.attr("data-reference", _element.attr("data-relation"));
					$('#formGerenciamentoItemConfiguracao #idItemConfiguracao').attr("value", _element.attr("data-relation"));
				}
			}
			
			_itemConfiguracaoViewContainer.find("#ic-identificacao").attr("value", "");
			_itemConfiguracaoViewContainer.find("#ic-destaque-caracteristicas-1").html("");
			_itemConfiguracaoViewContainer.find("#ic-destaque-caracteristicas-2").html("");
			_itemConfiguracaoViewContainer.find("#ic-destaque-caracteristicas-3").html("");
			_itemConfiguracaoViewContainer.find("#ic-destaque-caracteristicas-4").html("");
			_itemConfiguracaoViewContainer.find("#ic-destaque-caracteristicas-5").html("");
			_itemConfiguracaoViewContainer.find("#ic-destaque-caracteristicas-6").html("");
			
			_itemConfiguracaoViewContainer.find(".ic-tabs .tab-content .tab-pane[data-load='true']").html("");
			_itemConfiguracaoViewContainer.find(".ic-tabs .tab-content .tab-pane[data-load='true']").attr("data-loaded", "false");
			
			_itemConfiguracaoViewContainer.find(".ic-tabs li [href='#tab-informacoes-gerais']").trigger("click"); //Carrega a aba de informações gerais.
			
			if (_filtersContainer.filter(".widget").attr("data-collapse-closed") == "false") {
				_filtersContainer.find(".widget-body").collapse("hide");
			}
			
			if (_actionsContainer.filter(".widget").attr("data-collapse-closed") == "false") {
				_actionsContainer.find(".widget-body").collapse("hide");
			}
			
			$("#eventos-content").html("");
			$("#financeiro-content").html("");
			
			try {
				document.formGerenciamentoItemConfiguracao.fireEvent('preencheTabelaIndicadoresCapacidadeIC');
				document.formGerenciamentoItemConfiguracao.fireEvent('preencheTabelaAtributoDemandaIC');
				document.formGerenciamentoItemConfiguracao.fireEvent('restauraAcordoNivelServicoIC');
				document.formGerenciamentoItemConfiguracao.fireEvent('restauraCalendarioIC');
				document.formGerenciamentoItemConfiguracao.fireEvent('itemConfiguracaoAbrir');
			} catch (e) {
				// TODO: handle exception
			}
		},
		close : function() {
			_inventoryWrapper.find(".inventory-widget a").removeClass("primary");
			_itemConfiguracaoContainer.fadeOut(function() {
				_itemConfiguracaoContainer.attr("data-reference", "");
				$('#formGerenciamentoItemConfiguracao #idItemConfiguracao').attr("value", "");
				$('#formGerenciamentoItemConfiguracao #idItemConfiguracaoPai').attr("value", "");
				
				if (_inventoryContainer.filter(".widget").attr("data-collapse-closed") == "true") {
					_inventoryContainer.find(".widget-body").collapse("show");
				}
			});
		},
		refresh : function() {
			var _element = _inventoryContainer.find(".inventory-widget a.primary");
			if (_element != undefined && _element != "") {
				ItemConfiguracao.View.open(_element);
			} else {
				ItemConfiguracao.View.close();
			}
		},
		create : function() {
			if (_itemConfiguracaoContainer.attr("data-reference") != undefined && _itemConfiguracaoContainer.attr("data-reference") != "") {
				_inventoryWrapper.find(".inventory-widget a[data-id='" + _itemConfiguracaoContainer.attr("data-reference") + "']").removeClass("primary");
			}
			
			_itemConfiguracaoContainer.fadeOut(function() {
				_itemConfiguracaoContainer.attr("data-reference", "");
				$('#formGerenciamentoItemConfiguracao #idItemConfiguracao').attr("value", "");
				
				if (_filtersContainer.filter(".widget").attr("data-collapse-closed") == "false") {
					_filtersContainer.find(".widget-body").collapse("hide");
				}
				
				if (_actionsContainer.filter(".widget").attr("data-collapse-closed") == "false") {
					_actionsContainer.find(".widget-body").collapse("hide");
				}
				
				ItemConfiguracao.Controller.open();
			});
		},
		edit : function() {
			ItemConfiguracao.Controller.Loading.open($(".ic-controller"));
			
			_itemConfiguracaoViewContainer.fadeOut("fast", function() {
				_itemConfiguracaoControllerContainer.find(".ic-tabs li [href='#tab-controller-informacoes-gerais']").trigger("click"); //Carrega a aba de informações gerais.
				_itemConfiguracaoControllerContainer.fadeIn("fast");
			});
			
			document.formGerenciamentoItemConfiguracao.fireEvent('itemConfiguracaoController');
		},
		execute : function() {
			Modal.open($("#modal-script"));
		},
		Loading : {
			open : function(_element) {
				_inventoryWrapper.find(".inventory-widget a").removeClass("primary");
				_element.addClass("primary");
				_element.append("<div class=\"carregando\"></div>");
			},
			close : function() {
				if (_inventoryContainer.filter(".widget").attr("data-collapse-closed") == "false") {
					_inventoryContainer.find(".widget-body").collapse("hide");
				}
				
				_itemConfiguracaoControllerContainer.fadeOut("fast", function() {
					_itemConfiguracaoViewContainer.fadeIn("fast", function() {
						_itemConfiguracaoContainer.fadeIn("fast", function() {
							$(".inventory-widget a").children(".carregando").fadeOut(function() {
								$(this).remove();
							});
						});
					});
				});
			}
		},
		Tab : {
			open : function(_element) {
				$('#formGerenciamentoItemConfiguracao #controllerTab').attr("value", _element.attr("data-reference"));
				
				_tab = $("#" + _element.attr("data-reference"));
				
				if (_tab.attr("data-load") == "true" && _tab.attr("data-loaded") == "false") {
					ItemConfiguracao.View.Tab.Loading.open(_tab);
					
					try {
						document.formGerenciamentoItemConfiguracao.fireEvent('loadTab');
						if($("#btnAddDemanda").is(":disabled")){
							$("#btnAddConhecimento").attr("disabled", "disabled");
						}
					} catch (e) {
						// TODO: handle exception
					}
				}
			},
			Loading : {
				open : function(_element) {
					_element.html("<div class=\"carregando\"></div>");
				},
				close : function(_element) {
					_element.attr("data-loaded", "true");
					_element.children(".carregando").fadeOut("fast", function() {
						$(this).remove();
					});
				}
			},
			ItensRelacionados : {
				toggleCaracteristicas : function(element) {
					var id = $(element).attr("data-id");
					
					_itemConfiguracaoViewContainer.find(".ic-relacionado-caracteristicas[data-reference='" + id + "']").toggle();
				}
			},
			Impactos : {
				openServiceDesign : function(idServico) {
					//$("#iframeMapaDesenhoServico").attr("src", ctx + "/pages/mapaDesenhoServico/mapaDesenhoServico.load?iframe=true&idServico=" + idServico);

					if(document.formMapaDesenhoApoio.idServicoApoio){
						document.formMapaDesenhoApoio.idServicoApoio.value = idServico;

						var idStr = idServico.toString();

						document.formMapaDesenhoApoio.afterRestore = function() {
							ItemConfiguracao.View.Tab.Impactos.openModalMapaApoio();
						}
						
						document.formMapaDesenhoApoio.restore({
							idServicoApoio : idStr
						});

					}
				},
				openModalHierarquiaServicoApoio : function(idServicoImpactado){
					$('#divServicosImpactadosHierarquia').html("<div class='carregando'></div>");
					Modal.open($('#modal-impacto-servico-hierarquia-mapa'), function() {
						document.formGerenciamentoItemConfiguracao.idServicoImpactado.value = idServicoImpactado;
						document.formGerenciamentoItemConfiguracao.fireEvent('exibirHierarquiaServicoApoio');
					});
				},
				exibirHierarquiaServicoApoio : function(jsonNode){
					$('#divServicosImpactadosHierarquia').html("");
					new Treant( {
						chart: {
							container: "#divServicosImpactadosHierarquia",
					        rootOrientation: "SOUTH",
					        connectors: {
					            type: "straight"
					        }
						},
						
						nodeStructure: jsonNode
					} );
				},
				openModalMapaApoio : function(){
					criaDialog('G', 'class-modal-impacto-servico-mapa', '');
					$("#modal-impacto-servico-mapa").dialog("open");
				},
				openServiceDesignForBusinessService : function(idServico){
					if(document.formMapaDesenhoNegocio.idServicoNegocio){
						document.formMapaDesenhoNegocio.idServicoNegocio.value = idServico;

						var idStr = idServico.toString();

						document.formMapaDesenhoNegocio.afterRestore = function() {
							ItemConfiguracao.View.Tab.Impactos.openModalMapaServicoNegocio();
						}
						
						document.formMapaDesenhoNegocio.restore({
							idServicoNegocio : idStr
						});

					}
				},
				openModalMapaServicoNegocio : function(){
					criaDialog('G', 'class-modal-impacto-servico-negocio-mapa', '');
					$("#modal-impacto-servico-negocio-mapa").dialog("open");
				}
			},
			Historico : {
				Baseline : {
					restore : function(idHistoricoItemConfiguracao) {
						if(confirm(i18n_message("gerenciamentoItemConfiguracao.Mensagem.ConfirmacaoHistorico"))) {
							$("#tab-historico").html("<div class=\"carregando\"></div>");
							
							$("#controllerIdHistoricoItemConfiguracao").attr("value", idHistoricoItemConfiguracao);
							
							document.formGerenciamentoItemConfiguracao.fireEvent('restoreBaseline');
							if($("#btnAddDemanda").is(":disabled")){
								$("#btnAddConhecimento").attr("disabled", "disabled");
							}
						}
					},
					generate : function() {
						$("#tab-historico").html("<div class=\"carregando\"></div>");
						
						document.formGerenciamentoItemConfiguracao.fireEvent("generateRestorePoint");
					}
				}
			}
		}
	},
	Controller : {
		open : function() {
			ItemConfiguracao.Controller.clear();
			
			_itemConfiguracaoViewContainer.fadeOut("fast", function() {
				_itemConfiguracaoControllerContainer.find(".ic-tabs li [href='#tab-controller-informacoes-gerais']").trigger("click"); //Carrega a aba de informações gerais.
				_itemConfiguracaoControllerContainer.fadeIn("fast", function() {
					if (_inventoryContainer.filter(".widget").attr("data-collapse-closed") == "false") {
						_inventoryContainer.find(".widget-body").collapse("hide");
					}
					
					_itemConfiguracaoContainer.fadeIn();
				});
			});
			
			document.formGerenciamentoItemConfiguracao.fireEvent('itemConfiguracaoController');
		},
		save : function() {
			ItemConfiguracao.Controller.Loading.open($(".ic-controller"));
			
			var r = document.formGerenciamentoItemConfiguracao.save();
			
			if (!r) {
				ItemConfiguracao.Controller.Loading.close($(".ic-controller"));
			}
		},
		clear : function() {
			_itemConfiguracaoControllerContainer.find("#identificacao").prop("value", "");
			_itemConfiguracaoControllerContainer.find("#nome").prop("value", "");
			_itemConfiguracaoControllerContainer.find("#idContrato option:selected").prop("selected", false);
			_itemConfiguracaoControllerContainer.find("#familia").prop("value", "");
			_itemConfiguracaoControllerContainer.find("#classe").prop("value", "");
			_itemConfiguracaoControllerContainer.find("#versao").prop("value", "");
			_itemConfiguracaoControllerContainer.find("#numeroSerie").prop("value", "");
			_itemConfiguracaoControllerContainer.find("#localidade").prop("value", "");
			_itemConfiguracaoControllerContainer.find("#dataExpiracao").prop("value", "");
			_itemConfiguracaoControllerContainer.find("#idMidiaSoftware").prop("value", "");
			_itemConfiguracaoControllerContainer.find("#idMudanca").prop("value", "");
			_itemConfiguracaoControllerContainer.find("#numeroMudanca").prop("value", "");
			_itemConfiguracaoControllerContainer.find("#idTipoItemConfiguracao").prop("value", "");
			_itemConfiguracaoControllerContainer.find("#tipoItemConfiguracao").prop("value", "");
			_itemConfiguracaoControllerContainer.find("#status").prop("value", "");
			_itemConfiguracaoControllerContainer.find("#ativoFixo").prop("value", "");
			_itemConfiguracaoControllerContainer.find("#criticidade option:selected").prop("selected", false);
			_itemConfiguracaoControllerContainer.find("#impacto option:selected").prop("selected", false);
			_itemConfiguracaoControllerContainer.find("#urgencia option:selected").prop("selected", false);
			_itemConfiguracaoControllerContainer.find("#idProprietario").prop("value", "");
			_itemConfiguracaoControllerContainer.find("#nomeColaborador").prop("value", "");
			_itemConfiguracaoControllerContainer.find("#idGrupoItemConfiguracao").prop("value", "");
			_itemConfiguracaoControllerContainer.find("#nomeGrupoItemConfiguracao").prop("value", "");
			_itemConfiguracaoControllerContainer.find("#tipoResponsavel option:selected").prop("selected", false);
			_itemConfiguracaoControllerContainer.find("#idResponsavel").prop("value", "");
			_itemConfiguracaoControllerContainer.find("#idGrupoResponsavel").prop("value", "");
			_itemConfiguracaoControllerContainer.find("#nomeResponsavel").prop("value", "");
			_itemConfiguracaoControllerContainer.find("#informacoesAdicionais").prop("value", "");
			_itemConfiguracaoControllerContainer.find("#custoDiario").prop("value", "");
		},
		setItemConfiguracao : function(idItemConfiguracao) {
			$("#formGerenciamentoItemConfiguracao #idItemConfiguracao").attr("value", idItemConfiguracao);
			_itemConfiguracaoContainer.attr("data-reference", idItemConfiguracao);
		},
		close : function () {
			Inventory.Widget.refresh();
			
			if (_itemConfiguracaoContainer.attr("data-reference") == undefined || _itemConfiguracaoContainer.attr("data-reference") == "") {
				ItemConfiguracao.View.close();
				ItemConfiguracao.Controller.clear();
				
				$("#formGerenciamentoItemConfiguracao").find("#idItemConfiguracaoPai").prop("value", "");
			} else {
				var _element = _inventoryContainer.find(".inventory-widget a.primary");
				if (_element != undefined && _element != "") {
					ItemConfiguracao.View.open(_element);
				} else {
					ItemConfiguracao.View.close();
				}
				
				ItemConfiguracao.Controller.clear();
			}
		},
		Lookup : {
			clear : function(_id, _description) {
				$("#" + _id).attr("value", "");
				$("#" + _description).attr("value", "");
			}
		},
		Loading : {
			open : function(_element) {
				_element.append("<div class=\"carregando\"></div>");
			},
			close : function(_element) {
				_element.children(".carregando").fadeOut("fast", function() {
					$(this).remove();
				});
			}
		}
	}
}

/**
 * Métodos para controle do modal.
 */
var Modal = {
	init : function(_element, header, body, footer) {
		_element.find('.title').html(header);
		_element.find('.modal-body').html(body);
		_element.find('.modal-footer').html(footer);
	},
	open : function(_element, callback) {
		try {
			_element.modal('show');
		} catch (e) {
			$("#" + _element).modal('show');
		}
		
		if (ValidacaoUtils.isFunction(callback)) {
			_element.one('shown', callback);
		}
	},
	onClose : function(_element, fn) {
		if (ValidacaoUtils.isFunction(fn)) {
			_element.one('hidden', fn);
		}
	},
	close : function(_element) {
		_element.modal('hide');
	},
	clear : function(_element) {
		_element.find('.title').html("");
		_element.find('.modal-body').html("");
		_element.find('.modal-footer').html("");
	}
}

/**
 * Event Handlers e funções para o inventário.
 */
_inventoryContainer.on("click", ".inventory-widget a", function(e) {
	e.preventDefault();
	
	var _this = $(this);
	
	if (_this.attr("data-loading") != "true") {
		_this.attr("data-loading", "true");
		
		if (_this.attr("data-tipo") == "GRUPO") {
			Inventory.Widget.next(_this);
		} else {
			ItemConfiguracao.View.open(_this);
			_this.attr("data-loading", "false");
		}
	}
});

$("#inventory-container .widget-body").scroll(function() {
	if (_inventoryItensLoading == false && _inventoryItensDone == false) {
		if($("#inventory-container .widget-body").scrollTop() + $("#inventory-container .widget-body").height() > $("#inventory-wrapper").height() - 200) {
			_inventoryItensLoading = true;
			document.formGerenciamentoItemConfiguracao.fireEvent('inventoryLoad');
		}
	}
});

$("#status-inventory-container .widget-body").scroll(function() {
	if (_statusInventoryItensLoading == false) {
		//Realiza a requisição somente se for scroll down.
		if ($("#status-inventory-container .widget-body").scrollTop() > _statusInventoryPreviousScroll) {
			if($("#status-inventory-container .widget-body").scrollTop() + $("#status-inventory-container .widget-body").height() > $("#status-inventory-wrapper").height() - 200) {
				_statusInventoryItensLoading = true;
				document.formGerenciamentoItemConfiguracao.fireEvent('loadMoreStatusInventory');
			}
		}
		
		_statusInventoryPreviousScroll = $("#status-inventory-container .widget-body").scrollTop();
	}
});

/**
 * Event Handlers e funções para a view do item de configuração.
 */
_itemConfiguracaoViewContainer.on("click", ".ic-acoes ul li a", function(e) {
	e.preventDefault();
	
	var action = $(this).attr("data-action");
	
	if (action == "EDIT") {
		if (_inventoryAcessoGravar) {
			ItemConfiguracao.View.edit();
		} else {
			alert(i18n_message("baseConhecimento.usuarioSemPermissao") + ".");
			return false;
		}
	} else if (action == "REMOVE") {
		if (_inventoryAcessoDeletar) {
			if (confirm(i18n_message("gerenciamentoitemconfiguracao.mensagemexcluir"))) {
				ItemConfiguracao.View.remove();
			}
		} else {
			alert(i18n_message("baseConhecimento.usuarioSemPermissao") + ".");
			return false;
		}
	} else if (action == "CREATE_RELATED") {
		if (_inventoryAcessoGravar) {
			$("#formGerenciamentoItemConfiguracao #idItemConfiguracaoPai").attr("value", $("#formGerenciamentoItemConfiguracao #idItemConfiguracao").attr("value"));
			
			ItemConfiguracao.View.create();
		} else {
			alert(i18n_message("baseConhecimento.usuarioSemPermissao") + ".");
			return false;
		}
	} else if (action == "EXECUTE") {
		ItemConfiguracao.View.execute();
	} else if (action == "BACK") {
		$('#formGerenciamentoItemConfiguracao #idItemConfiguracao').attr("value", $("#formGerenciamentoItemConfiguracao #idItemConfiguracaoPai").attr("value"));
		$("#formGerenciamentoItemConfiguracao #idItemConfiguracaoPai").attr("value", "");
		
		ItemConfiguracao.View.open();
	} else if (action == "CLOSE") {
		ItemConfiguracao.View.close();
	}
});

$("#ic-container .ic-view .ic-tabs .widget .widget-head").on("click", "ul li a", function(e) {
	ItemConfiguracao.View.Tab.open($(this));
});

$("#ic-container .ic-view #tab-auditoria").on("click", "#pesquisar-auditoria", function(e) {
	var dataInicio = document.getElementById("dataInicioAuditoria").value;
	var dataFim	= document.getElementById("dataFimAuditoria").value;
	if(validaData(dataInicio, dataFim)){
	$("#auditoria-content").html("<div class=\"carregando\"></div>");
	
	document.formGerenciamentoItemConfiguracao.fireEvent('loadAuditoria');
	}
});

$("#ic-container .ic-view #tab-auditoria").on("click", "#limpar-auditoria", function(e) {
	$("#ic-container .ic-view #tab-auditoria #dataInicioAuditoria").attr("value", "");
	$("#ic-container .ic-view #tab-auditoria #dataFimAuditoria").attr("value", "");
	$("#ic-container .ic-view #tab-auditoria #auditoria-content").html("");
});

function validaData(dataInicio, dataFim){

	if (typeof(locale) === "undefined") locale = '';

	var dtInicio = new Date();
	var dtFim = new Date();

	var dtInicioConvert = '';
	var dtFimConvert = '';
	var dtInicioSplit = dataInicio.split("/");
	var dtFimSplit = dataFim.split("/");

	if (locale == 'en') {
		dtInicioConvert = dtInicioSplit[2] + "/" + dtInicioSplit[0] + "/" + dtInicioSplit[1];
		dtFimConvert = dtFimSplit[2] + "/" + dtFimSplit[0] + "/" + dtFimSplit[1];
	} else {
		dtInicioConvert = dtInicioSplit[2] + "/" + dtInicioSplit[1] + "/" + dtInicioSplit[0];
		dtFimConvert = dtFimSplit[2] + "/" + dtFimSplit[1] + "/" + dtFimSplit[0];
	}

	dtInicio.setTime(Date.parse(dtInicioConvert)).setFullYear;
	dtFim.setTime(Date.parse(dtFimConvert)).setFullYear;

	if (dataInicio.trim() == ""){
		alert(i18n_message("citcorpore.comum.validacao.datainicio"));
		return false;
	} else if(DateTimeUtil.isValidDate(dataInicio) == false){
		alert(i18n_message("citcorpore.comum.datainvalida"));
		document.getElementById("dataInicio").value = '';
		return false;
	}

	if (dataFim.trim() == ""){
		alert(i18n_message("citcorpore.comum.validacao.datafim"));
		return false;
	} else if(DateTimeUtil.isValidDate(dataFim) == false){
		alert(i18n_message("citcorpore.comum.dataFinalInvalida"));
		document.getElementById("dataFim").value = '';
		return false;
	}

	if (dtInicio > dtFim){
		alert(i18n_message("citcorpore.comum.dataInicioMenorFinal"));
		return false;
	}
	return true;
}

function gravarValorItemConfiguracao(){
	if($("#dataInicioValorIC").attr("value") != "" && $("#valorItemConfiguracao").attr("value") != ""){
		var valida_dataFimValorIC = validaDataFimValorIC();
		if( valida_dataFimValorIC ){
			$("#paginacaoFinanceiro").attr("value", 0);
			$("#financeiro-content").html("");
			document.formGerenciamentoItemConfiguracao.fireEvent("gravarValorItemConfiguracao");
		}
	} else {
		alert(i18n_message("citcorpore.comum.camposObrigatorios"));
		$("#financeiro-wrapper").find(".carregando").remove();
	}
}


function validaDataFimValorIC() {
	var dataFimValorICOK = true;
	var dataFimValorIC = $("#dataFimValorIC").val();
	var dataInicioValorIC = $("#dataInicioValorIC").val();
	
	if ((dataFimValorIC !== null && dataFimValorIC !== undefined && dataFimValorIC !== "") && (DateTimeUtil.isValidDate(dataFimValorIC) === false)) {
		dataFimValorICOK = false;
		alert(i18n_message("MSG03"));
		$("#dataFimValorIC").focus();
		$("#financeiro-wrapper").find(".carregando").remove();
		
	}else if((dataInicioValorIC !== null && dataInicioValorIC !== undefined && dataInicioValorIC !== "") && (DateTimeUtil.isValidDate(dataInicioValorIC) === false)){
		dataFimValorICOK = false;
		alert(i18n_message("MSG03"));
		$("#dataInicioValorIC").focus();
		$("#financeiro-wrapper").find(".carregando").remove();
		
	}else {
		defineLocale();
		var dtCriacao = new Date();
		var dtExpiracao = new Date();
		var dtCriacaoConvert = dataInicioValorIC.split("/");
		var dtExpiracaoConvert = dataFimValorIC.split("/");

		if (locale === 'en') {
			dtCriacaoConvert = dtCriacaoConvert[2] + "/"
					+ dtCriacaoConvert[0] + "/" + dtCriacaoConvert[1];
			dtExpiracaoConvert = dtExpiracaoConvert[2] + "/"
					+ dtExpiracaoConvert[0] + "/" + dtExpiracaoConvert[1];
		} else {
			dtCriacaoConvert = dtCriacaoConvert[2] + "/"
					+ dtCriacaoConvert[1] + "/" + dtCriacaoConvert[0];
			dtExpiracaoConvert = dtExpiracaoConvert[2] + "/"
					+ dtExpiracaoConvert[1] + "/" + dtExpiracaoConvert[0];
		}

		dtCriacao.setTime(Date.parse(dtCriacaoConvert)).setFullYear;
		dtExpiracao.setTime(Date.parse(dtExpiracaoConvert)).setFullYear;

		if (dtExpiracao < dtCriacao) {
			dataFimValorICOK = false;
			alert(i18n_message("gerenciamentoItemConfiguracao.itemConfiguracao.financeiro.dataInicioMaioQueDataInicio"));
			$("#dataFimValorIC").focus();
			$("#financeiro-wrapper").find(".carregando").remove();
		}
	}
	
	return dataFimValorICOK;
}


function limparValorItemConfiguracao(){
	$("#ic-container .ic-view #tab-financeiro #dataInicioValorIC").attr("value", "");
	$("#ic-container .ic-view #tab-financeiro #dataFimValorIC").attr("value", "");
	$("#ic-container .ic-view #tab-financeiro #valorItemConfiguracao").attr("value", "");
	$("#idItemConfiguracaoValor").attr("value", "");
}

$("#ic-container .ic-view #tab-financeiro").on("click", "#limpar-financeiro", limparValorItemConfiguracao);

function preencheTabelaFinanceiro(pagina){
	$('#paginacaoFinanceiro').val(pagina);
	$("#financeiro-content").html("");
	document.formGerenciamentoItemConfiguracao.fireEvent("montaHTMLValorItemConfiguracao");
}

function editarValorIC(idValorIC){
	$("#idItemConfiguracaoValor").attr("value", idValorIC);
	document.formGerenciamentoItemConfiguracao.fireEvent("restoreItemConfiguracaoValor");
}

function deletarValorIC(idValorIC){
	if(confirm(i18n_message('gerenciamentoitemconfiguracao.mensagemexcluir'))){
		$("#idItemConfiguracaoValor").attr("value", idValorIC);
		document.formGerenciamentoItemConfiguracao.fireEvent("deletaValorItemConfiguracao");
	}
}

$("#aba-financeiro").click(function(){preencheTabelaFinanceiro(1);});

$("#ic-container .ic-view #tab-eventos").on("click", "#limpar-eventos", function(e) {
	$("#ic-container .ic-view #tab-eventos #idEvmConexaoEventMonitor option").prop("selected", false);
	$("#ic-container .ic-view #tab-eventos #classificacao option").prop("selected", false);
	$("#ic-container .ic-view #tab-eventos #dataInicioPesquisaOcorrencia").attr("value", "");
	$("#ic-container .ic-view #tab-eventos #dataFimPesquisaOcorrencia").attr("value", "");
	$("#eventos-content").html("");
	
});

$("#btnExecutarScript").on("click", function() {
	$("#controllerScript").attr("value", $("#modal-script #scriptRhino").attr("value"));
	
	document.formGerenciamentoItemConfiguracao.fireEvent('executeScript');
});

/**
 * Event Handlers e funções para o controller do item de configuração.
 */
$("#ic-container .ic-controller .ic-tabs .widget .widget-head").on("click", "ul li a", function(e) {
	e.preventDefault();
});

$("#btnGravarItemConfiguracao").on("click", function(e) {
	e.preventDefault();
	
	ItemConfiguracao.Controller.save();
});

$("#btnCancelarItemConfiguracao").on("click", function(e) {
	e.preventDefault();
	
	if (confirm(i18n_message("gerenciamentoitemconfiguracao.confirmafecharedicao"))) {
		ItemConfiguracao.Controller.close();
	}
});

$("#nomeColaborador").on("click", function() {
	Modal.open($("#modal-empregado"));
});

$("#nomeResponsavel").on("click", function() {
	if ($("#tipoResponsavel").attr("value") == "") {
		alert(i18n_message("gerenciamentoitemconfiguracao.selecioneresponsavel"));
	} else {
		if ($("#tipoResponsavel").attr("value") == "U") {
			Modal.open($("#modal-responsavel"));
		} else if ($("#tipoResponsavel").attr("value") == "G") {
			Modal.open($("#modal-responsavel-grupo"));
		}
	}
});

$("#tipoResponsavel").on("change", function() {
	$("#idResponsavel").attr("value", "");
	$("#idGrupoResponsavel").attr("value", "");
	$("#nomeResponsavel").attr("value", "");
});

$("#nomeGrupoItemConfiguracao").on("click", function() {
	Modal.open($("#modal-grupo-item-configuracao"));
});

$("#tipoItemConfiguracao").on("click", function() {
	Modal.open($("#modal-tipo-item-configuracao"));
});

$("#nomeMidia").on("click", function() {
	Modal.open($("#modal-midia"));
});

$("#numeroMudanca").on("click", function() {
	Modal.open($("#modal-mudanca"));
});

$("#nomeItemConfiguracaoPai").on("click", function() {
	Modal.open($("#modal-pesquisa-item-configuracao"));
});

function selectedItemConfiguracao(idItemConfiguracao, identificacao) {
	$("#idItemConfiguracaoPai").attr("value", idItemConfiguracao);
	$("#nomeItemConfiguracaoPai").attr("value", identificacao);
	
	Modal.close($("#modal-pesquisa-item-configuracao"));
}

function LOOKUP_EMPREGADO_select(id, desc){
	$("#idProprietario").attr("value", id);
	$("#nomeColaborador").attr("value", desc);

	Modal.close($("#modal-empregado"));
}

function LOOKUP_RESPONSAVEL_select(id, desc){
	$("#idResponsavel").attr("value", id);
	$("#nomeResponsavel").attr("value", desc);

	Modal.close($("#modal-responsavel"));
}

function LOOKUP_RESPONSAVEL_GRUPO_select(id, desc){
	$("#idGrupoResponsavel").attr("value", id);
	$("#nomeResponsavel").attr("value", desc);

	Modal.close($("#modal-responsavel-grupo"));
}

function LOOKUP_GRUPOITEMCONFIGURACAO_select(id,desc){
	$("#idGrupoItemConfiguracao").attr("value", id);
	$("#nomeGrupoItemConfiguracao").attr("value", desc);

	Modal.close($("#modal-grupo-item-configuracao"));
}

function LOOKUP_TIPOITEMCONFIGURACAO_select(idTipo, desc) {
	var valor = desc.split('-');
	var nome = "";

	for(var i = 0 ; i < (valor.length-1); i++){
		if(i < (valor.length - 2)){
			nome += valor[i];
		}
		if(i < (valor.length - 3) && valor.length > 2){
			nome += "-";
		}
	}
	
	$("#idTipoItemConfiguracao").attr("value", idTipo);
	$("#tipoItemConfiguracao").attr("value", nome);
	
	Modal.close($("#modal-tipo-item-configuracao"));
	
	document.formGerenciamentoItemConfiguracao.fireEvent('itemConfiguracaoControllerChange');
}

function LOOKUP_MIDIASOFTWARE_select(id, desc) {
	$("#idMidiaSoftware").attr("value", id);
	$("#nomeMidia").attr("value", desc);

	Modal.close($("#modal-midia"));
}

function LOOKUP_MUDANCA_select(id, desc){
	$("#idMudanca").attr("value", id);
	$("#numeroMudanca").attr("value", desc);
	
	Modal.close($("#modal-mudanca"));
}

/**
 * Event Handlers e funções diversas para a tela.
 */

_breadcrumb.on("click", ".breadcrumb-item.clickable", function(e) {
	Inventory.Widget.previous($(this));
});

$("#filters-container").find('input:text, textarea').keyup(function(event){
	if(event.keyCode == 13) {
		filtraListagem();
	}
});

$("#resize-window").on("click", function() {
	if ($("#resize-window").hasClass("resize_full")) {
		$("#resize-window").removeClass("resize_full").addClass("resize_small");
		$("#footer, .navbar.main").fadeOut(100, function() {
			$("#content").addClass('p0');
		});
	} else {
		$("#resize-window").removeClass("resize_small").addClass("resize_full");
		$("#content").removeClass('p0');
		$("#footer, .navbar.main").fadeIn();
	}
});	

$( "#identificacao" ).focusout(function() {
  $( "#nome" ).val( $( "#identificacao" ).val() );
});

function filtraListagem(){
	Inventory.Widget.search();
}

function limpaFiltro(){
	$('#filtroStatus').val(-1);
	$('#filtroCriticidade').val(-1);
	$('#filtroIdentificacao').val('');
	
	$('#filtroHierarquia').removeAttr('checked');
	$('#filtroHierarquia').parent().css("left", "-50%");
	
	$('#filtroFilhos').removeAttr('checked');
	$('#filtroFilhos').parent().css("left", "-50%");
	
	$('#formGerenciamentoItemConfiguracao #controllerIdGrupo').attr("value", "");
	Inventory.Widget.search();
}

function editarGrupo(){
	document.formGerenciamentoItemConfiguracao.fireEvent('carregaNomeGrupoModal');
	
	$('#modal-controller-grupo #buttonGrupoModal').attr("onclick", "salvarGrupo(false);");
	
	Modal.open($('#modal-controller-grupo'));
}

function criarGrupo(){
	document.formGerenciamentoItemConfiguracao.fireEvent('loadModalGrupo');

	$("#modal-controller-grupo #modalNome").val("");
	$("#modal-controller-grupo #grupopai").val("");
	$(".group-images input[type='radio']").attr("checked", false);
	$("#modal-controller-grupo #grupoCorFundo").val("#f4f4f4");
	$("#modal-controller-grupo #grupoCorTexto").val("#999999");
	
	$("#controllerNomeGrupoItemConfiguracao").val("");
	$("#controllerGrupoPaiItemConfiguracao").val("");
	$("#controllerGrupoImagem").val("");
	$("#controllerGrupoCorFundo").val("");
	$("#controllerGrupoCorTexto").val("");
	
	$("#modal-controller-grupo #grupoCorFundo").keyup();
	$("#modal-controller-grupo #grupoCorTexto").keyup();
	
	$("#modal-controller-grupo #buttonGrupoModal").attr("onclick", "salvarGrupo(true);");
	
	Modal.open($("#modal-controller-grupo"));
}

function salvarGrupo(isNew){
	if ($("#modal-controller-grupo #modalNome").val() == "") {
		alert(i18n_message("gerenciamentoitemconfiguracao.preenchanomegrupo"));
		return false;
	} else {
		$("#controllerNomeGrupoItemConfiguracao").val($("#modal-controller-grupo #modalNome").val());
		$("#controllerGrupoPaiItemConfiguracao").val($("#modal-controller-grupo #grupopai").val());
		$("#controllerGrupoImagem").val($("#modal-controller-grupo input[name='grupoImagem']:checked").val());
		$("#controllerGrupoCorFundo").val($("#modal-controller-grupo #grupoCorFundo").val());
		$("#controllerGrupoCorTexto").val($("#modal-controller-grupo #grupoCorTexto").val());
		
		if(isNew) {
			document.formGerenciamentoItemConfiguracao.fireEvent('adicionaGrupo');
		} else {
			document.formGerenciamentoItemConfiguracao.fireEvent('editaGrupo');
		}
	}
}

function chamarModalExcluirGrupo(){
	Modal.open($('#modal-controller-grupo-excluir'));
}

function excluirGrupo(){
	document.formGerenciamentoItemConfiguracao.fireEvent('excluirGrupoItemConfiguracao');
}

function setValoresDashboard(qtdIncidente, qtdMudanca, qtdProblema, qtdLiberacao){
	$('#quantitativoIncidente').html(qtdIncidente);
	$('#quantitativoMudanca').html(qtdMudanca);
	$('#quantitativoProblema').html(qtdProblema);
	$('#quantitativoLiberacao').html(qtdLiberacao);
}

function filtrarIncidente(){
	$('#widgetIncidente').attr('class', 'widget-stats widget-dashboard primary');
	$('#widgetIncidente').attr('onclick', 'limparDashboard("#widgetIncidente", "filtrarIncidente();", "incidente;"); return  false;');
	$('#filtroDashboard').val($('#filtroDashboard').val() + 'incidente;');
	filtraListagem();
}
function filtrarMudanca(){
	$('#widgetMudanca').attr('class', 'widget-stats widget-dashboard primary');
	$('#widgetMudanca').attr('onclick', 'limparDashboard("#widgetMudanca", "filtrarMudanca();", "mudanca;"); return  false;');
	$('#filtroDashboard').val($('#filtroDashboard').val() + 'mudanca;');
	filtraListagem();
}
function filtrarProblema(){
	$('#widgetProblema').attr('class', 'widget-stats widget-dashboard primary');
	$('#widgetProblema').attr('onclick', 'limparDashboard("#widgetProblema", "filtrarProblema();", "problema;"); return  false;');
	$('#filtroDashboard').val($('#filtroDashboard').val() + 'problema;');
	filtraListagem();
}
function filtrarLiberacao(){
	$('#widgetLiberacao').attr('class', 'widget-stats widget-dashboard primary');
	$('#widgetLiberacao').attr('onclick', 'limparDashboard("#widgetLiberacao", "filtrarLiberacao();", "liberacao;"); return  false;');
	$('#filtroDashboard').val($('#filtroDashboard').val() + 'liberacao;');
	filtraListagem();
}

function limparDashboard(nomeWidget, nomeFuncao, value){
	$(nomeWidget).attr('class', 'widget-stats widget-dashboard');
	$(nomeWidget).attr('onclick', nomeFuncao + 'return  false;');
	$('#filtroDashboard').val($('#filtroDashboard').val().replace(value, ''));
	filtraListagem();
}

function openReport(tipoConsulta, idConsulta, tipo, idEspecifico) {
	var path = "";
	
	if (tipo == 'E') {
		path = getPathReportEspecificoByTipoConsultaAndIdConsulta(tipoConsulta, idConsulta, idEspecifico);
	} else {
		path = getPathReportByTipoConsultaAndIdConsulta(tipoConsulta, idConsulta);
	}
	
	$("#iframeRelatorios").attr("src", path);
	
	$("#modal-relatorios .modal-body").append("<div class=\"carregando\"></div>");
	
	Modal.open($('#modal-relatorios'));
}

function closeReports() { 
	$("#iframeRelatorios").attr("src", "");
}

$("#iframeRelatorios").load(function() {
	$("#modal-relatorios .modal-body").find(".carregando").remove();
});

function initReports(data, tipo) {
	if (tipo == 'G') {
		$("#ic-relatorios").attr("data-content", data);
	} else if (tipo == 'E') {
		var idEspecifico = "${idespecifico}";
		var dataEspecifico = data;
		while(dataEspecifico.indexOf(idEspecifico) > -1) {
			dataEspecifico = dataEspecifico.replace(idEspecifico, $("#ic-relatorios-especificos").attr("data-idespecifico"));
		}
		$("#ic-relatorios-especificos").attr("data-content", dataEspecifico);
	}
}

function carregaComboConexaoFerramenta() {
	document.formGerenciamentoItemConfiguracao.fireEvent("carregaComboConexaoFerramenta");
}

$(".ic-acoes .leadcontainer .dropdown-lead").on("click", function(e) {
	$(".ic-acoes").addClass("open");
	e.stopPropagation();
});

function exportarCMDB(){
	JANELA_AGUARDE_MENU.show();
	document.formGerenciamentoItemConfiguracao.fireEvent('exportarCMDB');
}

function getFile(pathFile, fileName){
	window.open(ctx + '/' + pathFile, '_blank');
}

function enableExportButton(){
	$('#btnExportCMDB').prop('disabled', '');
	$('#btnExportCMDB').on("click", "exportarCMDB()");
}

function disableExportButton(){
	$('#btnExportCMDB').prop('disabled', 'disabled');
	$('#btnExportCMDB').on("click", "");
}

function alteraClasseMudancaObrigatorio(){
	$("#labelMudancaItemConfig").addClass("campoObrigatorio");
}

/*---------------------- CAPACIDADE ----------------------*/
function clickListarIndicadoresCapacidade(){
	criaDialog('G', 'dialogAdicionarIndicadoresCapacidade', '');
	$("#POPUP_ADICIONAR_INDICADORES_CAPACIDADE").dialog("open");
	document.formImportarIndicadoresCapacidade.idItemConfiguracao.value = document.formGerenciamentoItemConfiguracao.idItemConfiguracao.value;
	document.formImportarIndicadoresCapacidade.fireEvent("carregarIndicadoresCapacidade");
}

function carregarIndicadoresCapacidadeIC(){
	document.formGerenciamentoItemConfiguracao.fireEvent("preencheTabelaIndicadoresCapacidadeIC");
}

function limpaTabelaIndicadoresCapacidade(){
	$('#tabelaIndicadoresCapacidade').empty();
}

function limpaTabelaIndicadoresCapacidadeIc(){
	$('#tabelaIndicadoresCapacidadeIc').empty();
}

function clickAdicionaIndicadoresCapacidade(){
	document.formImportarIndicadoresCapacidade.fireInsert("adicionarIndicadoresCapacidade");
}

function desvincularIndicadorCapacidade(idIndicadorCapacidadeIc){
	if(confirm(i18n_message('gerenciamentoportfolio.indicadorescapacidade.confirmadesvinculo'))){
		$('#idIndicadorCapacidadeIc').val(idIndicadorCapacidadeIc);
		document.formGerenciamentoItemConfiguracao.fireDelete('desvincularIndicadorCapacidade');
	}
}

function atualizaTelaIndicadorCapacidadeIc(){
	atualizaTelaPaginadaIndicadorCapacidadeIc(1);
}

function atualizaTelaPaginadaIndicadorCapacidadeIc(pagina){
	$('#paginaSelecionadaIndicadorCapacidadeIc').val(pagina);
	carregarIndicadoresCapacidadeIC();
}
/*-------------------------------------------------------*/

/*---------------------- DEMANDA ----------------------*/

function clickListarAtributoDemanda(){
	criaDialog('G', 'dialogAdicionarAtributoDemanda', '');
	$("#POPUP_ADICIONAR_ATRIBUTO_DEMANDA").dialog("open");
	document.formImportarAtributoDemanda.idItemConfiguracao.value = document.formGerenciamentoItemConfiguracao.idItemConfiguracao.value;
	document.formImportarAtributoDemanda.fireEvent("carregarAtributoDemanda");
}

function carregarAtributoDemandaIC(){
	document.formGerenciamentoItemConfiguracao.fireEvent("preencheTabelaAtributoDemandaIC");
}

function limpaTabelaAtributoDemanda(){
	$('#tabelaAtributoDemanda').empty();
}

function limpaTabelaAtributoDemandaIc(){
	$('#tabelaAtributoDemandaIc').empty();
}

function clickAdicionaAtributoDemanda(){
	document.formImportarAtributoDemanda.fireInsert("adicionarAtributoDemanda");
}

function desvincularAtributoDemanda(idAtributoDemandaIc){
	if(confirm(i18n_message('gerenciamentoportfolio.atributodemanda.confirmadesvinculo'))){
		$('#idAtributoDemandaIc').val(idAtributoDemandaIc);
		document.formGerenciamentoItemConfiguracao.fireDelete('desvincularAtributoDemanda');
	}
}

function atualizaTelaAtributoDemandaIc(){
	atualizaTelaPaginadaIndicadorCapacidadeIc(1);
}

function atualizaTelaPaginadaAtributoDemandaIc(pagina){
	$('#paginaSelecionadaAtributoDemandaIc').val(pagina);
	carregarAtributoDemandaIC();
}
/*-----------------------------------------------------*/

/*--------------- BASE DE CONHECIMENTO -----------------*/

function clickListarConhecimentos(){
	Modal.open($('#modal-base-conhecimento'));
}

function LOOKUP_BASECONHECIMENTO_select(id, desc){
	$("#idBaseConhecimento").val(id);
	document.formGerenciamentoItemConfiguracao.fireInsert('vincularConhecimento');
	Modal.close($("#modal-base-conhecimento"));
}

function desvincularConhecimentoIc(idBaseConhecimento){
	if(confirm(i18n_message('gerenciamentoItemConfiguracao.itemConfiguracao.desvincularConhecimentoIC'))){
		$('#idBaseConhecimento').val(idBaseConhecimento);
		document.formGerenciamentoItemConfiguracao.fireDelete('deletarConhecimentoIc');
	}
}

/*-----------------------------------------------------*/

function chamarModalCalendario(){
	document.formGerenciamentoItemConfiguracao.idCalendarioGrupo.value = '';
	document.formGerenciamentoItemConfiguracao.fireEvent('restauraCalendarioGrupo');
	Modal.open($('#modal-grupo-calendario'));
}

function LOOKUP_CALENDARIO_GRUPO_select(id, desc){
	Modal.close($('#modal-grupo-calendario-lookup'));
	preencheDadosCalendarioGrupo(id, desc);
}

function preencheDadosCalendarioGrupo(idCalendario, nomeCalendario){
	document.formGerenciamentoItemConfiguracao.idCalendarioGrupo.value = idCalendario;
	$('#formCalendarioGrupo #nomeCalendarioGrupo').val(nomeCalendario);
}

function clickGravarCalendarioGrupo(){
	var idCalendario = document.formGerenciamentoItemConfiguracao.idCalendarioGrupo.value;
	if(idCalendario !== undefined && idCalendario !== null && idCalendario !== ''){
		document.formGerenciamentoItemConfiguracao.fireInsert('gravarCalendarioGrupo');
	} else {
		notificacaoErro('gerenciamentoItemConfiguracao.necessarioSelecionarCalendario');
	}
}

function chamarModalANS(){
	document.formGerenciamentoItemConfiguracao.idAcordoNivelServicoGrupo.value = '';
	document.formGerenciamentoItemConfiguracao.fireEvent('restauraAcordoNivelServicoGrupo');
	Modal.open($('#modal-grupo-ans'));
}

function LOOKUP_ACORDONIVELSERVICO_DISPONIBILIDADE_GRUPO_select(id, desc){
	Modal.close($('#modal-grupo-ans-lookup'));
	preencheDadosAcordoNivelServicoGrupo(id, desc);
}

function preencheDadosAcordoNivelServicoGrupo(idAcordoNivelServico, nomeAcordoNivelServico){
	document.formGerenciamentoItemConfiguracao.idAcordoNivelServicoGrupo.value = idAcordoNivelServico;
	$('#formANSGrupo #nomeANS').val(nomeAcordoNivelServico);
}

function clickGravarANSGrupo(){
	var idAcordoNivelServico = document.formGerenciamentoItemConfiguracao.idAcordoNivelServicoGrupo.value;
	if(idAcordoNivelServico !== undefined && idAcordoNivelServico !== null && idAcordoNivelServico !== ''){
		document.formGerenciamentoItemConfiguracao.fireInsert('gravarAcordoNivelServicoGrupo');
	} else {
		notificacaoErro('gerenciamentoItemConfiguracao.necessarioSelecionarAcordoNivelServico');
	}
}

function LOOKUP_CALENDARIO_IC_select(id, desc){
	Modal.close($('#modal-ic-calendario-lookup'));
	preencheDadosCalendarioIC(id, desc);
}

function preencheDadosCalendarioIC(idCalendario, nomeCalendario){
	document.formGerenciamentoItemConfiguracao.idCalendarioIC.value = idCalendario;
	$('#nomeCalendarioIC').val(nomeCalendario);
}

function clickGravarCalendarioIC(){
	var idCalendario = document.formGerenciamentoItemConfiguracao.idCalendarioIC.value;
	if(idCalendario !== undefined && idCalendario !== null && idCalendario !== ''){
		document.formGerenciamentoItemConfiguracao.fireInsert('gravarCalendarioIC');
	} else {
		notificacaoErro('gerenciamentoItemConfiguracao.necessarioSelecionarCalendario');
	}
}

function LOOKUP_ACORDONIVELSERVICO_DISPONIBILIDADE_IC_select(id, desc){
	Modal.close($('#modal-ic-ans-lookup'));
	preencheDadosAcordoNivelServicoIC(id, desc);
}

function preencheDadosAcordoNivelServicoIC(idAcordoNivelServico, nomeAcordoNivelServico){
	document.formGerenciamentoItemConfiguracao.idAcordoNivelServicoIC.value = idAcordoNivelServico;
	$('#nomeANSIC').val(nomeAcordoNivelServico);
}

function clickGravarANSIC(){
	var idAcordoNivelServico = document.formGerenciamentoItemConfiguracao.idAcordoNivelServicoIC.value;
	if(idAcordoNivelServico !== undefined && idAcordoNivelServico !== null && idAcordoNivelServico !== ''){
		document.formGerenciamentoItemConfiguracao.fireInsert('gravarAcordoNivelServicoIC');
	} else {
		notificacaoErro('gerenciamentoItemConfiguracao.necessarioSelecionarAcordoNivelServico');
	}
}

function chamarModalValorIndisponibilidadeGrupo(){
	document.formValorIndispGrupo.valorIndispHoraGrupo.value = '';
	document.formGerenciamentoItemConfiguracao.fireEvent('restauraValorIndisponibilidadeGrupo');
	Modal.open($('#modal-grupo-valor-indisp'));
}

function serValorIndiponibilidadeGrupo(valor){
	$('#formValorIndispGrupo #valorIndispHoraGrupo').val(valor);
}

function clickGravarValorIndisponibilidadeGrupo(){
	document.formGerenciamentoItemConfiguracao.valorHoraIndisponibilidadeGrupo.value = document.formValorIndispGrupo.valorIndispHoraGrupo.value;
	document.formGerenciamentoItemConfiguracao.fireInsert('adicionaValorIndisiponibilidadeGrupo');

}

function fecharModalValorIndisponibilidadeGrupo(){
	Modal.close($('#modal-grupo-valor-indisp'));
}

function desabilitaBotoesPortal(){
	$("#gravar-financeiro").attr("disabled", true);
	$("#btnAddCapacidade").attr("disabled", true);
	$("#btnAddDemanda").attr("disabled", true);
	$("#btnAddConhecimento").attr("disabled", true);
	$("#btnGravarCalendarioIC").attr("disabled", true);
	$("#btnGravarANS").attr("disabled", true);
	$(".btn-mini btn-block btn-default").attr("disabled", true);
	$(".btn btn-block btn-default").attr("disabled", true);
	$("#btnAddConhecimento").attr("disabled", "disabled");
	$("#pesquisar-eventos").attr("disabled", "disabled");
	$("#pesquisar-auditoria").attr("disabled", "disabled");
	$("#nomeCalendarioIC").attr("disabled", "disabled");
	$("#nomeANSIC").attr("disabled", "disabled");
}

function setIframe(){
	$("#isIframe").val("true");
}