var popup2 = new PopupManager(1084, 1084, ctx + "/pages/");
popup2.titulo = i18n_message('citcorpore.comum.pesquisarapida');

var popup;
popup = new PopupManager(1000, 900, ctx + "/pages/");

$(document).ready(function () {
	Modal.onHidden('modal-cadastrar-liberacao', redimensionaModalLiberacaoOnHidden);
	Modal.onShown('modal-cadastrar-liberacao', redimensionaModalLiberacaoOnShown);
	
	$('[data-toggle="popover"]').popover();
	
	$("#resize-window").on("click", function() {
		if ($("#resize-window").hasClass("resize_full")) {
			$("#resize-window").removeClass("resize_full").addClass("resize_small");
			$("#footer, .navbar.main").fadeOut(100, function() {
				$("#content").addClass('p0');
			});
		} else {
			$("#resize-window").removeClass("resize_small").addClass("resize_full");
			$("#content").removeClass('p0');
			$("#footer, .navbar.main").fadeIn();
		}
	});
	
	$( "#POPUP_BUSCA" ).dialog({
		title: i18n_message("citcorpore.comum.buscarapida"),
		width: 250,
		height: 300,
		modal: false,
		autoOpen: false,
		resizable: false
	}); 
	
	if(idRequisicao)	{
		visualizarSolicitacao(idRequisicao);
	} else	{
		document.getElementById('fraRequisicaoLiberacao').src = "about:blank";
	}
});

function GrupoQtde() {
	this.id = '';
	this.qtde = 0;
}

abrePopupPesquisa = function() {
	document.getElementById('frameCadastroRapido').src = ctx + "/pages/pesquisaRequisicaoLiberacao/pesquisaRequisicaoLiberacao.load?iframe=true";
	Modal.open('modal-pesquisar-liberacao');
	Modal.onHidden('modal-pesquisar-liberacao', function() {
		document.form.fireEvent('onClosePopUp');
	});
}

function aprovarLiberacao(idRequisicao) {
	if (!confirm(i18n_message("requisicaoLiberacao.confirmaAprovacao")))
		return;
	JANELA_AGUARDE_MENU.show();
	document.form.idRequisicao.value = idRequisicao;
	document.form.fireEvent('aprovarLiberacao');
}

var dadosGrafico;
var dadosGrafico2;
var dadosGerais;
exibirGraficos = function(json_tarefas) {
	var qtdeAtrasadas = 0;
	var qtdeSuspensas = 0;
	var qtdeEmAndamento = 0;
	var qtdePri1 = 0;
	var qtdePri2 = 0;
	var qtdePri3 = 0;
	var qtdePri4 = 0;
	var qtdePri5 = 0;
	var qtdeItens = 0;
	var colGrupoSol = new HashMap();
	scriptTemposSLA = "";

	arrayTarefas = ObjectUtils
			.deserializeCollectionFromStringSemQuebraEnter(json_tarefas);
	for (var i = 0; i < arrayTarefas.length; i++) {
		var tarefaDto = arrayTarefas[i];
		tarefaDto.solicitacaoDto = ObjectUtils
				.deserializeObject(tarefaDto.solicitacao_serialize);
		tarefaDto.elementoFluxoDto = ObjectUtils
				.deserializeObject(tarefaDto.elementoFluxo_serialize);
	}

	var strTableTemposSLA = '';
	strTableTemposSLA += "<img width='20' height='20' ";
	strTableTemposSLA += "alt='" + i18n_message('ativaotemporizador')
			+ "' id='imgAtivaTimer' style='opacity:0.5;display:none' ";
	strTableTemposSLA += "title='"
			+ i18n_message('citcorpore.comum.ativadestemporizador') + "' ";
	strTableTemposSLA += "src='" + ctx
			+ "/template_new/images/cronometro.png'/>";
	strTableTemposSLA += "<table class=\"table\" cellpadding=\"0\" cellspacing=\"0\">";
	strTableTemposSLA = strTableTemposSLA + "<tr><td><b>"
			+ i18n_message('gerenciaservico.slasandamento')
			+ "</b></td></tr>";

	for (var i = 0; i < arrayTarefas.length; i++) {
		var idRequisicao = "";
		var solicitante = "";
		var prioridade = "";
		var situacao = "";
		var prazo = "";
		var dataHoraSolicitacao = "";
		var dataHoraLimite = "";
		var nomeGrupoAtual = "";

		var tarefaDto = arrayTarefas[i];
		var solicitacaoDto = tarefaDto.solicitacaoDto;
		if (solicitacaoDto != null) {
			if (solicitacaoDto.prioridade == '1') {
				qtdePri1++;
			}
			if (solicitacaoDto.prioridade == '2') {
				qtdePri2++;
			}
			if (solicitacaoDto.prioridade == '3') {
				qtdePri3++;
			}
			if (solicitacaoDto.prioridade == '4') {
				qtdePri4++;
			}
			if (solicitacaoDto.prioridade == '5') {
				qtdePri5++;
			}
			var grupoNome = solicitacaoDto.nomeGrupoAtual;
			if (grupoNome == null) {
				grupoNome = ' --'
						+ i18n_message("citcorpore.comum.aclassificar")
						+ '--';
			}
			var auxGrp = colGrupoSol.get(grupoNome);
			if (auxGrp != undefined) {
				auxGrp.qtde++;
			} else {
				var grupoQtde = new GrupoQtde();
				grupoQtde.id = grupoNome;
				grupoQtde.qtde = 1;
				colGrupoSol.set(grupoNome, grupoQtde);
			}

			idRequisicao = "" + solicitacaoDto.idRequisicaoLiberacao;
			solicitante = "" + solicitacaoDto.nomeSolicitante;
			if (solicitacaoDto.prazoHH < 10)
				prazo = "0";
			prazo += solicitacaoDto.prazoHH + ":";
			if (solicitacaoDto.prazoMM < 10)
				prazo += "0";
			prazo += solicitacaoDto.prazoMM;
			prioridade = "" + solicitacaoDto.prioridade;
			dataHoraSolicitacao = solicitacaoDto.dataHoraInicioStr;
			if (solicitacaoDto.idStatus != 7) {
				dataHoraLimite = solicitacaoDto.dataHoraTerminoStr;
			}
			nomeGrupoAtual = solicitacaoDto.nomeGrupoAtual;

			if (parseFloat(solicitacaoDto.atraso) > 0
					&& solicitacaoDto.idStatus != 7) {
				qtdeAtrasadas++;
			} else if (solicitacaoDto.idStatus == 7
					&& tarefaDto.reativar == 'S') {
				qtdeSuspensas++;
			} else {
				qtdeEmAndamento++;
				if (qtdeItens < 15) {
					strTableTemposSLA = strTableTemposSLA
							+ "<tr><td>N.o <b>"
							+ solicitacaoDto.idRequisicaoLiberacao
							+ "</b>: <label id='tempoRestante"
							+ solicitacaoDto.idRequisicaoLiberacao
							+ "'></label>";
					strTableTemposSLA = strTableTemposSLA
							+ "<div id='barraProgresso"
							+ solicitacaoDto.idRequisicaoLiberacao
							+ "'></div></td></tr>";
				}
				qtdeItens++;
			}
		}
	}
	strTableTemposSLA = strTableTemposSLA + '</table>';
	if (qtdeAtrasadas > 0 || qtdeSuspensas > 0 || qtdeEmAndamento > 0) {
		reativarSolicitacao
		var info = '';
		if (qtdeAtrasadas > 0) {
			info += ' <font color="red"><b>'
					+ qtdeAtrasadas
					+ ' </b>'
					+ i18n_message("requisicaoLiberacao.requisicoes_liberacao_atrasado")
					+ '</font><br>';
		}
		if (qtdeSuspensas > 0) {
			info += ' <b>'
					+ qtdeSuspensas
					+ ' </b>'
					+ i18n_message("requisicaoLiberacao.requisicoes_liberacao_suspenso");
		}
		if (document.getElementById('fraRequisicaoLiberacao').src == "about:blank") {
			dadosGrafico = [{label: i18n_message('gerenciaservico.emandamento'), data: qtdeEmAndamento}, {label: i18n_message('gerenciaservico.suspensas'), data: qtdeSuspensas},{label:  i18n_message('gerenciaservico.atrasadas'), data: qtdeAtrasadas}];
			dadosGrafico2 = [{label: '1', data: qtdePri1}, {label: '2', data: qtdePri2}, {label: '3', data: qtdePri3}, {label: '4', data: qtdePri4}, {label: '5', data: qtdePri5}];
			window.setTimeout(atualizaGrafico, 1000);
			window.setTimeout(atualizaGrafico2, 1000);

			var colArray = colGrupoSol.toArray();
			dadosGerais = new Array();
			if (colArray) {
				for (var iAux = 0; iAux < colArray.length; iAux++) {
					dadosGerais[iAux] = {label: colArray[iAux].id, data: colArray[iAux].qtde};
				}
			}
			window.setTimeout(atualizaGrafico3, 1000);
		}
	}
	$('.gl-relatorios-especificos').popover({placement: 'right', animation: true, trigger: 'click', html: true});
};

capturarTarefa = function(responsavelAtual, idTarefa, idRequisicao) {
	var msg = "";
	if (responsavelAtual == '') {
		msg = i18n_message("gerencia.confirm.atribuicaotarefa") + " " + login + "?";
	} else {
		msg = i18n_message("gerencia.confirm.atribuicaotarefa_1") + " "
				+ responsavelAtual + " "
				+ i18n_message("gerencia.confirm.atribuicaotarefa_2") + " "
				+ login
				+ i18n_message("gerencia.confirm.atribuicaotarefa_3");
	}

	if (!confirm(msg)) {
		return;
	}
	
	JANELA_AGUARDE_MENU.show();
	document.form.idTarefa.value = idTarefa;
	document.form.idRequisicao.value = idRequisicao;
	document.form.fireEvent('capturaTarefa');
};

function atualizaGrafico() {
	UtilCharts.pieChart.data = dadosGrafico;
	UtilCharts.pieChart.init("divGrafico");
}
function atualizaGrafico2() {
	UtilCharts.pieChart.data = dadosGrafico2;
	UtilCharts.pieChart.init("divGrafico2");
}
function atualizaGrafico3() {
	UtilCharts.pieChart.data = dadosGerais;
	UtilCharts.pieChart.init("divGrafico3");
}

voltar = function() {
	JANELA_AGUARDE_MENU.show();
	if (document.getElementById('fraRequisicaoLiberacao').src == "about:blank") {
		window.location = ctx + '/pages/index/index.load';
	} else {
		window.location = ctx
				+ '/pages/gerenciamentoLiberacao/gerenciamentoLiberacao.load';
	}
};

editarSolicitacao = function(idRequisicao) {
	document.getElementById('fraRequisicaoLiberacao').src = "about:blank";
	document.getElementById('fraRequisicaoLiberacao').src = ctx + PAGE_CADASTRO
			+ idRequisicao + "&escalar=S&alterarSituacao=N";
};

function visualizarSolicitacao(idRequisicao) {
	document.getElementById('fraLiberacao').src = "about:blank";
	document.getElementById('fraLiberacao').src = ctx + PAGE_CADASTRO
			+ "?idRequisicaoLiberacao=" + idRequisicao
			+ "&escalar=N&alterarSituacao=N&editar=RO";
	JANELA_AGUARDE_MENU.show();
	
	Modal.open('modal-cadastrar-liberacao');
	$('#modal-cadastrar-liberacao h3').text(i18n_message('citcorpore.comum.visualizar'));
}

reclassificarSolicitacao = function(idRequisicao) {
	document.getElementById('fraRequisicaoLiberacao').src = "about:blank";
	document.getElementById('fraRequisicaoLiberacao').src = ctx + PAGE_CADASTRO
			+ "?idRequisicaoLiberacao=" + idRequisicao + "&reclassificar=S";
};

prepararSuspensao = function(idRequisicao) {
	document.getElementById('fraVisao').src = "about:blank";
	document.getElementById('fraVisao').src = ctx
			+ "/pages/suspensaoLiberacao/suspensaoLiberacao.load?idRequisicaoLiberacao="
			+ idRequisicao;
	
	Modal.open('modal-liberacao-visao');
	$('#modal-liberacao-visao h3').text(i18n_message("gerenciamentoLiberacao.suspenderLiberacao"));
};

reativarSolicitacao = function(idRequisicao) {
	if (!confirm(i18n_message("requisicaoLiberacao.confirmaReativacaoLiberacao")))
		return;
	JANELA_AGUARDE_MENU.show();
	document.form.idRequisicao.value = idRequisicao;
	document.form.fireEvent('reativaRequisicao');
};

	
	agendaAtividade = function(idRequisicao) {
	JANELA_AGUARDE_MENU.show();
	document.getElementById('fraVisao').src = "about:blank";
	document.getElementById('fraVisao').src = ctx
			+ "/pages/agendarAtividadeRequisicaoLiberacao/agendarAtividadeRequisicaoLiberacao.load?idRequisicaoLiberacao="
			+ idRequisicao;
	
	Modal.open('modal-liberacao-visao');
	$('#modal-liberacao-visao h3').text(i18n_message("gerenciaservico.agendaratividade"));
};

prepararExecucaoTarefa = function(idTarefa, idRequisicao, acao) {
	document.getElementById('fraRequisicaoLiberacao').src = "about:blank";
	document.form.idTarefa.value = idTarefa;
	document.form.acaoFluxo.value = acao;
	JANELA_AGUARDE_MENU.show();
	document.form.fireEvent('preparaExecucaoTarefa');
};

prepararLiberacaoSLA = function(idTarefa, idRequisicao) {
	document.getElementById('fraVisao').src = "about:blank";
	document.getElementById('fraVisao').src = ctx
			+ "/pages/mudarSLA/mudarSLA.load?idRequisicaoLiberacao="
			+ idRequisicao;
	
	Modal.open('modal-liberacao-visao');
	$('#modal-liberacao-visao h3').text(i18n_message("gerenciaservico.mudarsla"));
};

exibirDelegacaoTarefa = function(idTarefa, idRequisicao, nomeTarefa) {
	document.getElementById('fraVisao').src = "about:blank";
	document.getElementById('fraVisao').src = ctx
			+ "/pages/delegacaoLiberacao/delegacaoLiberacao.load?idRequisicaoLiberacao="
			+ idRequisicao + "&idTarefa=" + idTarefa + "&nomeTarefa="
			+ nomeTarefa;
	
	Modal.open('modal-liberacao-visao');
	$('#modal-liberacao-visao h3').text(i18n_message("gerenciaservico.delegarcompartilhartarefa"));
};

exibirVisao = function(titulo, idVisao, idFluxo, idTarefa, acao) {
	document.getElementById('fraRequisicaoLiberacao').src = "about:blank";
	document.getElementById('fraRequisicaoLiberacao').src = ctx
			+ "/pages/dinamicViews/dinamicViews.load?modoExibicao=J&idVisao="
			+ idVisao + "&idFluxo=" + idFluxo + "&idTarefa=" + idTarefa
			+ "&acaoFluxo=" + acao;
};

fecharVisao = function() {
	Modal.close('modal-liberacao-visao');
	document.getElementById('fraRequisicaoLiberacao').src = "about:blank";
	document.form.fireEvent('exibeTarefas');
	JANELA_AGUARDE_MENU.hide();
	Modal.close('modal-cadastrar-liberacao');
};

abrirSolicitacao = function() {
	document.getElementById('fraLiberacao').src = "about:blank";
	document.getElementById('fraLiberacao').src = ctx + PAGE_CADASTRO;
	JANELA_AGUARDE_MENU.show();

	Modal.open('modal-cadastrar-liberacao');
	$('#modal-cadastrar-liberacao h3').text(i18n_message('liberacao.cadastro'));
};

exibirUrl = function(titulo, url) {
	url = ObjectUtils.decodificaEnter(url);
	document.getElementById('fraLiberacao').src = "about:blank";
	document.getElementById('fraLiberacao').src = ctx + "/" + url;
	
	Modal.open('modal-cadastrar-liberacao');
	$('#modal-cadastrar-liberacao h3').text(titulo);
};

fecharLiberacao = function() {
	document.getElementById('fraRequisicaoLiberacao').src = "about:blank";
	document.form.fireEvent('exibeTarefas');
	Modal.close('modal-cadastrar-liberacao');
};

atualizarListaTarefas = function() {
	$("#divConteudoLista").append("<div class='carregando'></div>");
	document.form.idRequisicaoSel.value = document.formPesquisa.idRequisicaoSel.value;
	document.form.atribuidaCompartilhada.value = document.formPesquisa.atribuidaCompartilhada.value;
	document.form.fireEvent('exibeTarefas');
}

abrePopup = function(obj, func) {
	popup.abrePopup('usuario', '()');
}

function resize_iframe() {
	var height = window.innerWidth;// Firefox
	if (document.body.clientHeight) {
		height = document.body.clientHeight;// IE
	}
	document.getElementById("fraRequisicaoLiberacao").style.height = parseInt(height
			- document.getElementById("fraRequisicaoLiberacao").offsetTop - 135)
			+ "px";
}
	function controleArea(tdName, areaName) {
	if (document.getElementById(tdName).style.backgroundColor == 'white') {
		document.getElementById(tdName).style.backgroundColor = 'lightgray';
	} else {
		document.getElementById(tdName).style.backgroundColor = 'white';
	}
}

function janelaAguarde() {
	JANELA_AGUARDE_MENU.show();
}

function fechaJanelaAguarde() {
	JANELA_AGUARDE_MENU.hide();
}

function disableEnterKey(e) {
	var key;

	if (window.event)
		key = window.event.keyCode; // IE
	else
		key = e.which; // firefox

	if (key == 13)
		return false;
	else
		return true;
}

function atualizaPagina() {
	if (document.getElementById('chkAtualiza').checked) {
		atualizarListaTarefas();
	}
}

function initReports(data, tipo) {
	if (tipo == 'E') {
		$(".gl-relatorios-especificos").each(function() {
			var idEspecifico = "${idespecifico}";
			var dataEspecifico = data;
			while(dataEspecifico.indexOf(idEspecifico) > -1) {
				dataEspecifico = dataEspecifico.replace(idEspecifico, $(this).data("idespecifico"));
			}
			
			$(this).attr("data-content", dataEspecifico);
		});
		
		$(".gl-relatorios-especificos").popover();
	} else {
		document.getElementById('gl-relatorios').style.visibility = "visible";
		$("#gl-relatorios").attr("data-content", data);
	}
}

function openReport(tipoConsulta, idConsulta, nomeConsulta, tipo, idEspecifico) {
	var src = "";
	document.getElementById('fraLiberacao').src = "";
	
	if (tipo == 'E') {
		src = getPathReportEspecificoByTipoConsultaAndIdConsulta(tipoConsulta, idConsulta, idEspecifico);
	} else {
		src = getPathReportByTipoConsultaAndIdConsulta(tipoConsulta, idConsulta);
	}
	
	document.getElementById('fraLiberacao').src = src;
	
	Modal.open('modal-cadastrar-liberacao');
	$('#modal-cadastrar-liberacao h3').text(nomeConsulta);
}

/* Agendador de atualizacao. */
window.setInterval(atualizaPagina, 30000);

function redimensionaModalLiberacao(obj) {
	if ($(obj).hasClass("resize_full")) {
		$(obj).removeClass("resize_full").addClass("resize_small");
		ajustarModalLiberacaoMaior();
	} else {
		$(obj).removeClass("resize_small").addClass("resize_full");
		ajustarModalLiberacaoPadrao();
	}
}

function redimensionaModalLiberacaoOnShown() {
	$(this).attr('primary-height', $(this).css('height'));
	redimensionaModalLiberacaoOnEvent(this);
}

function redimensionaModalLiberacaoOnHidden() {
	redimensionaModalLiberacaoOnEvent(this);
	
	$('#modal-cadastrar-liberacao').css({ 'display': '' });
}

function redimensionaModalLiberacaoOnEvent(that) {
	var elRedimensionar = $(that).find('.redimensionar');
	
	if ($(elRedimensionar).hasClass("resize_full")) {
		$(elRedimensionar).removeClass("resize_full").addClass("resize_small");
	}
	
	ajustarModalLiberacaoMaior();
}

function ajustarModalLiberacaoPadrao(){
	var height = $('#modal-cadastrar-liberacao').attr('primary-height');
	var marginTop = 'auto';
	
	if(height != null) {
		height = height.replace(/[^0-9\.]+/g, "");
		
		if(height != "") {
			height = parseInt(height);
			height = -height/2;
			marginTop = height+"px !important;";
		}
	}
	
	$('#modal-cadastrar-liberacao').attr('style', 'display: block; top: 50%; max-width: 80%; margin-top: '+marginTop);
	
	$('#modal-cadastrar-liberacao .modal-body').css({
		'max-height': '500px',
		'height': '500px'
	});
	
	$('#modal-cadastrar-liberacao').removeClass('modal-size-full');
}

function ajustarModalLiberacaoMaior(){
	$('#modal-cadastrar-liberacao').css({
		'top': '0',
		'bottom': '0',
		'max-height': '95%',
		'max-width': '95%',
		'margin-top': ''
	});

	$('#modal-cadastrar-liberacao .modal-body').css({
		'max-height': '95%',
		'height': '95%'
	});
	
	$('#modal-cadastrar-liberacao').addClass('modal-size-full');
}