/*
 * Atributos globais
 */

var _tipoAcordo = $(".tipo-acordo");
var _tipoAcordoCliente = $("#tipo-acordo-cliente");
var _tipoAcordoServico = $("#tipo-acordo-servico");
var _tipoAcordoMultinivel = $("#tipo-acordo-multi-nivel");
var _ansWrapper = $("#ans-wrapper");
var _ansContent = $(".ans-content");
var _ansCliente = $("#ans-cliente");
var _ansServico = $("#ans-servico");
var _ansMultinivel = $("#ans-multi-nivel");

/*
 * Self executing function
 */

(function(window, document, undefined) {
	var bWizardTabClass = '';
	$('.wizard').each(function() {
		bWizardTabClass = 'bwizard-steps';

		var wiz = $(this);
		
		$(this).bootstrapWizard({
			onNext: function(tab, navigation, index) {
				/*if(index==1)
				{
					if(!wiz.find('#inputTitle').val()) {
						alert('You must enter the product title');
						wiz.find('#inputTitle').focus();
						return false;
					}
				}*/
			}, 
			onLast: function(tab, navigation, index) {
				/*if(!wiz.find('#inputTitle').val()) {
					alert('You must enter the product title');
					wiz.find('#inputTitle').focus();
					return false;
				}*/
			}, 
			onTabClick: function(tab, navigation, index) {
				/*if(!wiz.find('#inputTitle').val()) {
					alert('You must enter the product title');
					wiz.find('#inputTitle').focus();
					return false;
				}*/
			},
			onTabShow: function(tab, navigation, index) {
				var $total = navigation.find('li:not(.status)').length;
				var $current = index+1;
				
				// update status
				if (wiz.find('.step-current').length) wiz.find('.step-current').html($current);
				if (wiz.find('.steps-total').length) wiz.find('.steps-total').html($total);
				if (wiz.find('.steps-complete').length) wiz.find('.steps-complete').html(($current-1));
				
				// mark all previous tabs as complete
				navigation.find('li:not(.status)').removeClass('primary');
				navigation.find('li:not(.status):lt('+($current-1)+')').addClass('primary');
	
				// If it's the last tab then hide the last button and show the finish instead
				if($current >= $total) {
					wiz.find('.pagination .finish').show();
					wiz.find('.pagination .finish').removeClass('disabled');
				} else {
					wiz.find('.pagination .next').show();
					wiz.find('.pagination .finish').hide();
				}
			},
			tabClass: bWizardTabClass,
			nextSelector: '.next', 
			previousSelector: '.previous'
		});

		wiz.find('.finish').click(function() {
			//alert('Finished!, Starting over!');
			//wiz.find("a[data-toggle*='tab']:first").trigger('click');
		});
	});
})(this, document);

/**
 * Métodos para controle dos tipos de acordo.
 */

var NivelServico = {
	Cliente : {
		criar : function() {
			if (!_tipoAcordoCliente.hasClass("primary")) {
				NivelServico.Cliente.Load.start(function() {
					Controller.set("Cliente", "NivelServico.Cliente.Load.done();");
					document.formGerenciamentoNivelServico.fireEvent("render");
				});
			}
		},
		editar : function() {
			NivelServico.Cliente.Load.start(function() {
				Controller.set("Cliente", "NivelServico.Cliente.Load.done();");
				document.formGerenciamentoNivelServico.fireEvent("restore");
			});
		},
		Load : {
			start : function(callback) {
				_tipoAcordo.removeClass("primary");
				_tipoAcordoCliente.addClass("primary");

				_ansWrapper.fadeOut("fast", function() {
					_ansContent.hide();
					_ansWrapper.append("<div class=\"carregando\"></div>");
					_ansWrapper.fadeIn("fast");

					if (callback != undefined && callback != "") {
						callback();
					}
				});
			},
			done : function() {
				_ansWrapper.children(".carregando").fadeOut(function() {
					$(this).remove();
					_ansCliente.fadeIn("fast");
				});

				Controller.clear();
			}
		}
	},
	Servico : {
		criar : function() {
			if (!_tipoAcordoServico.hasClass("primary")) {
				NivelServico.Servico.Load.start(function() {
					Controller.set("Servico", "NivelServico.Servico.Load.done();");
					document.formGerenciamentoNivelServico.fireEvent("render");
				});
			}
		},
		editar : function() {
			NivelServico.Servico.Load.start(function() {
				Controller.set("Servico", "NivelServico.Servico.Load.done();");
				document.formGerenciamentoNivelServico.fireEvent("restore");
			});
		},
		Load : {
			start : function(callback) {
				_tipoAcordo.removeClass("primary");
				_tipoAcordoServico.addClass("primary");

				_ansWrapper.fadeOut("fast", function() {
					_ansContent.hide();
					_ansWrapper.append("<div class=\"carregando\"></div>");
					_ansWrapper.fadeIn("fast");

					if (callback != undefined && callback != "") {
						callback();
					}
				});
			},
			done : function() {
				_ansWrapper.children(".carregando").fadeOut(function() {
					$(this).remove();
					_ansServico.fadeIn("fast");
				});

				Collapse.refresh();
				Controller.clear();
			}
		}
	},
	Multinivel : {
		criar : function() {
			if (!_tipoAcordoMultinivel.hasClass("primary")) {
				NivelServico.Multinivel.Load.start(function() {
					Controller.set("Multinivel", "NivelServico.Multinivel.Load.done();");
					document.formGerenciamentoNivelServico.fireEvent("render");
				});
			}
		},
		editar : function() {
			NivelServico.Multinivel.Load.start(function() {
				Controller.set("Multinivel", "NivelServico.Multinivel.Load.done();");
				document.formGerenciamentoNivelServico.fireEvent("restore");
			});
		},
		Niveis : {
			Cliente : {
				add : function() {
					$("#multinivel-cliente-nivel-acordo-list-ans").slideUp(function() {
						$("#multinivel-cliente-nivel-acordo-ans").slideDown();
					});
				},
				save : function() {
					$("#multinivel-cliente-nivel-acordo-ans").slideUp(function() {
						$("#multinivel-cliente-nivel-acordo-list-ans").slideDown();
					});
				},
				cancel : function() {
					$("#multinivel-cliente-nivel-acordo-ans").slideUp(function() {
						$("#multinivel-cliente-nivel-acordo-list-ans").slideDown();
					});
				}
			},
			Servico : {
				add : function() {
					$("#multinivel-servico-nivel-acordo-list-ans").slideUp(function() {
						$("#multinivel-servico-nivel-acordo-ans").slideDown();
					});
				},
				save : function() {
					$("#multinivel-servico-nivel-acordo-ans").slideUp(function() {
						$("#multinivel-servico-nivel-acordo-list-ans").slideDown();
					});
				},
				cancel : function() {
					$("#multinivel-servico-nivel-acordo-ans").slideUp(function() {
						$("#multinivel-servico-nivel-acordo-list-ans").slideDown();
					});
				}
			}
		},
		Load : {
			start : function(callback) {
				_tipoAcordo.removeClass("primary");
				_tipoAcordoMultinivel.addClass("primary");

				_ansWrapper.fadeOut("fast", function() {
					_ansContent.hide();
					_ansWrapper.append("<div class=\"carregando\"></div>");
					_ansWrapper.fadeIn("fast");

					if (callback != undefined && callback != "") {
						callback();
					}
				});
			},
			done : function() {
				_ansWrapper.children(".carregando").fadeOut(function() {
					$(this).remove();
					_ansMultinivel.fadeIn("fast");
				});

				Collapse.refresh();
				Controller.clear();
			}
		}
	}
}

/*
 * Métodos para o controle dos tempos de atendimento de um ANS.
 */

var TempoAtendimento = {
	criar : function() {
		document.formModalTempoAtendimento.clear();
		$("#modal-tempo-atendimento-lista-servicos").html('');
		Modal.open('modal-tempo-atendimento');
	},
	editar : function() {
		document.formModalTempoAtendimento.clear();
		$("#modal-tempo-atendimento-lista-servicos").html('');
		document.formModalTempoAtendimento.restore({listaServicos: ""});
		Modal.open('modal-tempo-atendimento');
	},
	remover: function() {
		alert('Remover tempo de atendimento');
	},
	ListaServicos : {
		adicionar : function (){
			Modal.open('modal-tempo-atendimento-seleciona-servicos');

			//document.formLookupServicosTempoAtendimento.whereDinamico = " serv.idservico NOT IN (SELECT idservico FROM servicocontrato WHERE idservico = serv.idservico and idcontrato = "+idContrato+" and (upper(deleted) = 'N' OR deleted is null) ) ";
			document.formLookupServicosTempoAtendimento.pesqLockupLOOKUP_SERVICOS_TEMPO_ATENDIMENTO_serv_idPortfolioServico.value = 1;
			//document.formLookupServicosTempoAtendimento.pesqLockupLOOKUP_SERVICOS_TEMPO_ATENDIMENTO_serv_tipoServico.value = "'R'";
			document.formLookupServicosTempoAtendimento.pesqLockupLOOKUP_SERVICOS_TEMPO_ATENDIMENTO_auto_idServicoRelacionado.value = "'5436'";
		},
		remover : function(obj){
			var listaServicosSerializados = document.formModalTempoAtendimento.listaServicos.value;
			
			if(listaServicosSerializados){
				var listaServicos = ObjectUtils.deserializeCollectionFromString(listaServicosSerializados);
				
				if(listaServicos){
					var linhaTabela = obj.closest('tr');
					
					var indiceSelecionado = (linhaTabela.rowIndex-1);
					
					listaServicos.splice(indiceSelecionado, 1);
					
					document.formModalTempoAtendimento.listaServicos.value = ObjectUtils.serializeObjects(listaServicos);
					
					if(listaServicos.length>0){
						linhaTabela.remove();
					}else{
						$('#modal-tempo-atendimento-lista-servicos').html('');
					}
				}
			}
		}
	}
}

/**
 * Métodos para controle das requisições.
 */

var Controller = {
	set : function(owner, callback) {
		$("#owner").attr("value", owner);
		$("#callback").attr("value", callback);
	},
	clear : function() {
		$("#owner").attr("value", "");
		$("#callback").attr("value", "");
	}
}

/**
 * Métodos para controle dos collapses.
 */

var Collapse = {
	refresh : function() {
		$('.widget-collapse[data-toggle="collapse-widget"] .widget-body')
		.on('show', function(){
			$(this).parents('.widget:first').attr('data-collapse-closed', "false");
		})
		.on('shown', function(){
			setTimeout(function(){ $(window).resize(); }, 500);
		})
		.on('hidden', function(){
			$(this).parents('.widget:first').attr('data-collapse-closed', "true");
		});

		$('.widget-collapse[data-toggle="collapse-widget"]').each(function() {
			if ($(this).children('.widget-head').children('.collapse-toggle').length <= 0) {
				$(this).children('.widget-head').append('<span class="collapse-toggle"></span>');
			}
			
			if (!$(this).children('.widget-body').hasClass('collapse')) {
				$(this).children('.widget-body').addClass('collapse');
			}

			if ($(this).attr('data-collapse-closed') !== "true") $(this).children('.widget-body').addClass('in');
			
			$(this).children('.widget-head').on('click', ".collapse-toggle", function(){
				$(this).parents('.widget:first').children('.widget-body').collapse('toggle');
			});
		});
	}
}

/**
 * Métodos para controle do modal.
 */

var Modal = {
	init : function(_id, header, body, footer) {
		$("#" + _id).find('.title').html(header);
		$("#" + _id).find('.modal-body').html(body);
		$("#" + _id).find('.modal-footer').html(footer);
	},
	open : function(_id) {
		$("#" + _id).modal('show');
	},
	close : function(_id) {
		$("#" + _id).closest(".modal").modal("hide");
	},
	clear : function(_id) {
		$("#" + _id).find('.title').html("");
		$("#" + _id).find('.modal-body').html("");
		$("#" + _id).find('.modal-footer').html("");
	}
}

/**
 * Funções e Event Handlers diversos para a tela.
 */

$("#resize-window").on("click", function() {
	if ($("#resize-window").hasClass("resize_full")) {
		$("#resize-window").removeClass("resize_full").addClass("resize_small");
		$("#footer, .navbar.main").fadeOut(100, function() {
			$("#content").addClass('p0');
		});
	} else {
		$("#resize-window").removeClass("resize_small").addClass("resize_full");
		$("#content").removeClass('p0');
		$("#footer, .navbar.main").fadeIn();
	}
});

function LOOKUP_PORTFOLIO_SERVICO_select(id, desc) {
	$("input[name='idPortfolio']").attr("value", id);
	$("input[name='nomePortfolio']").attr("value", desc);

	Modal.close("modal-portfolio");
}