_TECLA_ENTER = 13;
_OCORRENCIA_SERVICO_ACAO_ALTERAR = "A";

$(function() {
	$("#inputFiltroAplicacao").keyup(function(event) {
		if (event.which == _TECLA_ENTER) {
			changeFiltroAplicacao($(event.currentTarget).val());
		}
	});
	
	document.formAplicacoes.idServico.value = document.form.idServicoNegocioAtual.value;
	document.formAplicacoes.fireEvent("load");
});


function clickNovoCadastroAplicacao(isEditar){
	Modal.open('modal-portfolio-cadastrar-aplicacao');
	Modal.oneHidden('modal-portfolio-cadastrar-aplicacao', limparAplicacao);
	$("#modal-portfolio-cadastrar-aplicacao button[name='btnUpDate']").css("display", "none");
	document.formCadastroAplicacao.clear();
	
	document.formCadastroAplicacao.afterSave = function() {
		if(isEditar) {
			document.formAplicacoes.acaoAplicacoesOcorrenciaServico.value = _OCORRENCIA_SERVICO_ACAO_ALTERAR;
			document.formAplicacoes.idsAplicacoesOcorrenciaServico.value = document.formCadastroAplicacao.idAplicacao.value;
			document.formAplicacoes.fireEvent("salvarOcorrenciaServicoAplicacao");
			document.formAplicacoes.fireEvent("carregaTabelaAplicacao");
		}else{
			document.formAplicacoes.idAplicacaoVincular.value = document.formCadastroAplicacao.idAplicacao.value;
			document.formAplicacoes.fireEvent("vincularAplicacaoAoServico");
		}
		
		Modal.close('modal-portfolio-cadastrar-aplicacao');
		$("#modal-portfolio-cadastrar-aplicacao button[name='btnUpDate']").css("display", "block");
	}
}

function editarAplicacao(idAplicacao){
	clickNovoCadastroAplicacao(true);

	//JANELA_AGUARDE_MENU.show();

	restoreAplicacao(idAplicacao);
	
	document.formAplicacoes.afterRestore = function() {
		JANELA_AGUARDE_MENU.hide();
	}
}

//Função que faz o restore a partir da tela de cadastro de aplicacao
function restoreAplicacao(idAplicacao){
	//Função disponível na tela de cadastro de aplicacao
	limparAplicacao();
	
	var idStr = idAplicacao.toString();
	//Restore na tela de cadastro de aplicacao
	document.formCadastroAplicacao.restore({
		idAplicacao : idStr
	});
}

function desvincularAplicacao(idAplicacao){
	if(permissaoGravar){
		if (idAplicacao > "" && confirm(i18n_message("gerenciaportfolio.desejaDesvincularAplicacao"))) {
			document.formAplicacoes.idAplicacao.value = idAplicacao;
			document.formAplicacoes.fireEvent("desvincularAplicacaoServico");
		}
	}else{
		notificacaoErro('citcorpore.comum.permissaoFuncionalidade','');
	}
}

function vincularAplicacao(){
	document.formPesquisaAplicacao.whereDinamico = "idAplicacao not in (select idAplicacao from AplicacaoServico where idservico = " + getServicoRelacionado() + ")";
	Modal.open('modal-portfolio-vincular-aplicacao');
}

function LOOKUP_APLICACOES_select(id, desc) {
	document.formAplicacoes.idAplicacaoVincular.value = id;
	Modal.close('modal-portfolio-vincular-aplicacao');
	document.formAplicacoes.fireEvent("vincularAplicacaoAoServico");
}

function limpaFiltroAplicacao() {
	$("#inputFiltroAplicacao").val("");
	changeFiltroAplicacao("");
}

function pesquisaFiltroAplicacao() {
	changeFiltroAplicacao($("#inputFiltroAplicacao").val());
}

function changeFiltroAplicacao(filtroAplicacao) {
	JANELA_AGUARDE_MENU.show();
	document.formAplicacoes.paginaSelecionadaAplicacao.value = 0;
	document.formAplicacoes.filtroAplicacao.value = filtroAplicacao;
	document.formAplicacoes.fireEvent("carregaTabelaAplicacao");
}

function paginarAplicacoes(paginaSelecionadaAplicacao) {
	$('#divDinamicoTabelaAplicacoes').hide("blind", "fast",	function(){
		JANELA_AGUARDE_MENU.show();
		document.formAplicacoes.paginaSelecionadaAplicacao.value = paginaSelecionadaAplicacao;
		document.formAplicacoes.fireEvent("carregaTabelaAplicacao");
	});
}

function depoisCarregarTabelaAplicacoes(){
	JANELA_AGUARDE_MENU.hide();
	$('#divDinamicoTabelaAplicacao').show("blind", "fast",	function(){
		$("span[href='#tabTabelaANSC']").trigger('click');
	});
}

function salvarOcorrenciaServicoAplicacao() {
	document.formAplicacoes.fireEvent("salvarOcorrenciaServicoAplicacao");
}