$(function() {
	document.formAtributosFinanceiro.afterRestore = function() {
		JANELA_AGUARDE_MENU.hide();
	}
	
	document.formAtributosFinanceiro.afterSave = function() {
		JANELA_AGUARDE_MENU.hide();
	}
	
	document.formAtributosFinanceiro.idServico.value = document.form.idServicoNegocioAtual.value;
	document.formAtributosFinanceiro.fireEvent("load");
});

aguarde = function() {
	JANELA_AGUARDE_MENU.show();
};

escondeJanelaAguarde = function() {
	JANELA_AGUARDE_MENU.hide();
};

function clickAdicionaFinanceiro(){
	document.formAtributosFinanceiro.save();
}

function limpaTabela(){
	$('#tabelaFinanceiro').empty();
}

function vinculaPerfil(){
	document.formAtributosFinanceiro.fireEvent("listaTipos");
}

function fechaModalPopupCadastroTipoFinanceiro(){
	Modal.close('modal-popup-cadastro-tipo-financeiro');
}

function clickNovoTipoFinanceiro(){
	document.formCadastroTipoFinanceiro.fireEvent("load");
	Modal.open('modal-popup-cadastro-tipo-financeiro');
}

function clickEditarTipoFinanceiro(){
	Modal.open('modal-lookup-pesquisa-tipo-financeiro');
}

function limpaValor(){
	$("#valor").val('');
}
function excluirAtributofinanceiro(idFinanceiroServico, idTipo, perfil, valor, classificacao){
	$("#idFinanceiroServico").val(idFinanceiroServico);
	$("#perfilFinanceiro").val(perfil);
	$("#idTipoSelect").val(idTipo);
	$("#valor").val(valor);
	$("#idClassificacao").val(classificacao);
	aguarde();
	if (confirm(i18n_message("citcorpore.comum.confirmaExclusao"))){
		document.formAtributosFinanceiro.fireDelete('excluir');
		$("#idFinanceiroServico").val('');
		$("#idTipoSelect").val('');
		$("#valor").val('');
		escondeEditar();
	}else{
		escondeJanelaAguarde();
		$("#idFinanceiroServico").val('');
		$("#idTipoSelect").val('');
		$("#valor").val('');
		escondeEditar();
	}
}

function editarAtributofinanceiro(idFinanceiroServico, idTipo, perfil, valor, classificacao){
	$("#idFinanceiroServico").val(idFinanceiroServico);
	$("#perfilFinanceiro").val(perfil);
	$("#idTipoSelect").val(idTipo);
	document.formAtributosFinanceiro.fireEvent('iniciaComboTipoEditar');
	valor = valor.replace(".", ",");
	$("#valor").val(valor);
	$("#btnEditarFinanceiro").show();
	selecionaClassificacao(classificacao);
	atualizaClassificacao(atualizaClassificacao);
}

function escondeEditar(){
	$("#btnEditarFinanceiro").hide();
}

function clickSalvarEditar(){
	if(document.formAtributosFinanceiro.validate()){
		document.formAtributosFinanceiro.fireUpdate("save");
		$("#idFinanceiroServico").val('');
		return;
	}else{
		$("#idFinanceiroServico").val('');
		return;
	}
}

function atualizaCategoria(){
	atualizaClassificacao();
	document.formAtributosFinanceiro.fireEvent('atualizaComboTipoEditar');
}

function atualizaClassificacao(){
	var perfilFinanceiro = $('#perfilFinanceiro').val();
	if(perfilFinanceiro === 'C')
		$('#divClassificacao').show();
	else
		$('#divClassificacao').hide();
}

function atualizaTela(){
	atualizaTelaPaginada(1);
}

function atualizaTelaPaginada(pagina){
	$('#paginaSelecionada').val(pagina);
	document.formAtributosFinanceiro.fireEvent("atualizaTelaFinanceiro");
}

function selecionaClassificacaoPadrao(){
	if($('#idTipo').val() >  0){
		document.formAtributosFinanceiro.fireEvent("selecionaClassificacaoPadrao");
	}else{
		$('#idClassificacao').val(-1);
	}
}

function selecionaClassificacao(value){
	if(value === null || value === undefined)
		value = -1;
	$('#idClassificacao option[value="' + value + '"]').attr("selected", "selected");
}

function abrirModalImportar(){
	var idServico = $('#idServico').val();
	document.getElementById('frameImportarAtributos').src = URL_SISTEMA
			+ 'pages/importarAtributosFinanceiros/importarAtributosFinanceiros.load?iframe=true&idServico='+idServico;
	$("#modal_importarAtributos").modal("show");
}

function fecharModalImportar(){
	$("#modal_importarAtributos").modal("hide");
	document.getElementById('frameImportarAtributos').src = "";
	atualizaTela();
}

function enviarArquivoAtributoFinanceiro(){
	aguarde();
	document.formImportarAtributos.setAttribute("method","post");
	document.formImportarAtributos.setAttribute("enctype","multipart/form-data");
	document.formImportarAtributos.setAttribute("encoding","multipart/form-data");
	document.formImportarAtributos.fireEvent("processarArquivo");
}
