$(function() {
	document.formCadastroPortfolio.fireEvent("load");
});

function limparPortfolio(){
	document.formCadastroPortfolio.clear();
	$('.portal-content').hide();
}

function gravarPortfolio(){
	if ($("[name='formCadastroPortfolio'] #disponivelPortal").attr("value") == 'S') {
		if ($("[name='formCadastroPortfolio'] #nomePortal").attr("value") == "") {
			notificacaoErro("", i18n_message("citcorpore.comum.campo_obrigatorio") + ": " + i18n_message("citcorpore.comum.nome"));
			return false;
		}
		if ($("[name='formCadastroPortfolio'] #imagemPortal").attr("value") == "") {
			notificacaoErro("", i18n_message("citcorpore.comum.campo_obrigatorio") + ": " + i18n_message("citcorpore.comum.imagem"));
			return false;
		}
	}
	
	document.formCadastroPortfolio.save();
}

function excluirPortfolio() {
	if (document.formCadastroPortfolio.idPortfolioServico.value > "" && confirm(i18n_message("citcorpore.comum.deleta"))) {
		document.formCadastroPortfolio.fireDelete("excluir");
	}
	
	Modal.close("modal-portfolio-cadastro");
}

function clickNovoPortfolio(){
	limparPortfolio();
	
	Modal.oneHidden('modal-portfolio-cadastro', beforeClosePopupPortfolio);
	Modal.open("modal-portfolio-cadastro");
}

function editarPortfolio(idPortfolio){
	JANELA_AGUARDE_MENU.show();
	limparPortfolio();
	
	var idStr = idPortfolio.toString();
	document.formCadastroPortfolio.restore({ idPortfolioServico : idStr });
	
	Modal.oneHidden('modal-portfolio-cadastro', beforeClosePopupPortfolio);
	Modal.open("modal-portfolio-cadastro");
}

function beforeClosePopupPortfolio(){
	limparPortfolio();
	document.formCadastroPortfolio.fireEvent("carregaTabelaPortfolios");
}

